/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.function.BiFunction;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.UnorderedPair;

public class AddDoorsForRoomEdges
extends AMerlinOp
implements IEventObserver {
    public static final boolean ENABLED = System.getProperty("preview") != null;
    public static final UIHook UI_HOOK = new UIHook(new AddDoorsForRoomEdges(), Intl.intl("Create Doors for All Room Edges"));

    public AddDoorsForRoomEdges() {
        SelectionObserver.add(this, EgressRoom.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(ENABLED && !MerlinApp.getApp().getData().selection.flatten(EgressRoom.class).isEmpty());
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        TaskProgress progress = new TaskProgress();
        try {
            record EdgeResult(Map<Composite<?>, List<EgressDoor>> newDoors, List<Runnable> insertions) {
            }
            EdgeResult result = this.execLongReadTaskNoThrow(app.getMainFrame(), md, Intl.intl("Creating Doors"), progress, () -> {
                LinkedIdentityHashMap newDoors = new LinkedIdentityHashMap();
                ArrayList<Runnable> insertions = new ArrayList<Runnable>();
                HashSet closedEdges = new HashSet();
                BiFunction<Point3d, Point3d, Boolean> addEdge = (p1, p2) -> {
                    Point3d rp2;
                    Point3d rp1 = Util3D.round(p1, 6);
                    if (rp1.epsilonEquals(rp2 = Util3D.round(p2, 6), 1.0E-6)) {
                        System.out.println("bad edge");
                        return false;
                    }
                    return closedEdges.add(new UnorderedPair<Point3d, Point3d>(rp1, rp2));
                };
                for (EgressDoor door : md.floors.flatten(EgressDoor.class)) {
                    EgressDoor.DoorGeom dg = door.getDoorGeom();
                    addEdge.apply(dg.d_boundary[0], dg.d_boundary[1]);
                    if (dg.d_boundary.length != 4) continue;
                    addEdge.apply(dg.d_boundary[2], dg.d_boundary[3]);
                }
                ArrayList<EgressRoom> rooms = new ArrayList<EgressRoom>(md.selection.flatten(EgressRoom.class));
                progress.reset(rooms.size());
                for (EgressRoom room : rooms) {
                    progress.incrementAndCheck();
                    Composite parent = (Composite)md.hierarchy.getParent(room);
                    ArrayList<EgressDoor> roomDoors = new ArrayList<EgressDoor>();
                    Model model = room.getModel();
                    int ix = 1;
                    for (Edge edge : model.getEdges()) {
                        if (edge.faces.size() != 1 || edge.faces.get(0).isInternalEdge(edge) || !addEdge.apply(edge.v1.loc, edge.v2.loc).booleanValue()) continue;
                        String name = String.format("%s_door%d", room.getName(), ix++);
                        LineSeg ls = new LineSeg(edge.v1.loc, edge.v2.loc);
                        EgressDoor door = new EgressDoor(name, false, null, null, new EgressDoor.DoorGeom(null, null, ls, ls, new Point3d[]{ls.p1, ls.p2}, null, true));
                        roomDoors.add(door);
                        newDoors.computeIfAbsent(parent, p -> new ArrayList()).add(door);
                    }
                    insertions.add(() -> {
                        int roomIx = parent.indexOf(room);
                        assert (roomIx != -1);
                        parent.insert(roomDoors, roomIx + 1);
                    });
                }
                return new EdgeResult(newDoors, insertions);
            });
            try (MerlinData.WriteLock lock = md.lockWrite();){
                Undo.begin(Intl.intl("Create Doors"));
                result.insertions.forEach(i -> i.run());
                for (Map.Entry<Composite<?>, List<EgressDoor>> entry : result.newDoors.entrySet()) {
                    Undo.insertUndoEntry_delete(md, entry.getKey(), (Collection)entry.getValue());
                }
                Undo.end(md);
            }
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }
}

