/*
 * Decompiled with CFR 0.152.
 */
package merlin;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import merlin.ErrorAnalysis;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.INameGenerator;
import merlin.data.MerlinData;
import merlin.treeview.TVEntryPoint;

public class EntryPoint<T> {
    public final Class<T> clazz;
    public final TVEntryPoint<T> tvEntryPoint;
    private final Getter<T, T> getConflict;
    private final Action<T, Boolean, Object> delete;
    private final Getter<T, Exception> canDelete;
    private final Getter<T, Boolean> isAutoDeleteGroup;
    private final Getter<T, Boolean> isDelUndoable;
    private final Getter<T, Boolean> isVisible;
    private final Setter<T, Boolean> setVisible;
    private final Supplier<T, Composite<? extends ICompElement>> getRootComposite;
    private final Getter<T, INameGenerator> getNameGenerator;
    private final Getter<T, Predicate<String>> getNameFormatAllowed;
    private final Getter<T, INameGroup> getUniqueNameGroup;
    private final Getter<T, Boolean> isIndexed;
    private final Getter<T, Boolean> isMovable;
    private final Getter<T, Boolean> showBounds;
    private final Getter<T, String> typeString;
    private final Getter<T, String> categoryName;
    private final Getter<T, Class<? super T>> getDomainRequiredType;
    private final Getter<T, Boolean> showInReferencingLists;
    private final Getter<T, Collection<? extends ErrorAnalysis.IErrorGenerator<? super T>>> errorGenerators;

    public EntryPoint(Class<T> clazz, TVEntryPoint<T> tvEntryPoint, Getter<T, Exception> canDelete, Getter<T, T> getConflict, Action<T, Boolean, Object> delete, Getter<T, Boolean> isAutoDeleteGroup, Getter<T, Boolean> isDelUndoable, Getter<T, Boolean> isVisible, Setter<T, Boolean> setVisible, Supplier<T, Composite<? extends ICompElement>> getRootComposite, Getter<T, Predicate<String>> getNameFormat, Getter<T, INameGenerator> getNameGenerator, Getter<T, INameGroup> getUniqueNameGroup, Getter<T, Boolean> isIndexed, Getter<T, Boolean> isMovable, Getter<T, Boolean> showBounds, Getter<T, String> typeString, Getter<T, String> categoryName, Getter<T, Class<? super T>> getDomainRequiredType, Getter<T, Boolean> showInReferencingLists, Getter<T, Collection<? extends ErrorAnalysis.IErrorGenerator<? super T>>> errorGenerators) {
        this.clazz = clazz;
        this.tvEntryPoint = tvEntryPoint;
        this.canDelete = canDelete;
        this.getConflict = getConflict;
        this.getNameFormatAllowed = getNameFormat;
        this.delete = delete;
        this.isAutoDeleteGroup = isAutoDeleteGroup;
        this.isDelUndoable = isDelUndoable;
        this.isVisible = isVisible;
        this.setVisible = setVisible;
        this.getRootComposite = getRootComposite;
        this.getNameGenerator = getNameGenerator;
        this.getUniqueNameGroup = getUniqueNameGroup;
        this.isIndexed = isIndexed;
        this.isMovable = isMovable;
        this.showBounds = showBounds;
        this.typeString = typeString;
        this.categoryName = categoryName;
        this.getDomainRequiredType = getDomainRequiredType;
        this.showInReferencingLists = showInReferencingLists;
        this.errorGenerators = errorGenerators;
    }

    public Collection<? extends ErrorAnalysis.IErrorGenerator<? super T>> getErrorGenerators(MerlinData md, T obj) {
        return this.errorGenerators.get(md, obj);
    }

    public void testDelete(MerlinData md, T obj) throws Exception {
        Exception exp = this.canDelete.get(md, obj);
        if (exp != null) {
            throw exp;
        }
    }

    public boolean canDelete(MerlinData md, T obj) {
        return this.canDelete.get(md, obj) == null;
    }

    public Exception getDeletionErr(MerlinData md, T obj) {
        return this.canDelete.get(md, obj);
    }

    public boolean isDeleteUndoable(MerlinData md, T obj) {
        return this.isDelUndoable.get(md, obj);
    }

    public T getConflict(MerlinData md, T comparable) {
        return this.getConflict.get(md, comparable);
    }

    public boolean delete(MerlinData md, T obj) {
        return this.delete.perform(md, obj, null);
    }

    public boolean isAutoDeleteGroup(MerlinData md, T obj) {
        return this.isAutoDeleteGroup.get(md, obj);
    }

    public Class<? super T> getDomainRequiredType(MerlinData md, T obj) {
        return this.getDomainRequiredType.get(md, obj);
    }

    public boolean isIndexed(MerlinData md, T obj) {
        return this.isIndexed.get(md, obj);
    }

    public boolean isMovable(MerlinData md, T obj) {
        return this.isMovable.get(md, obj);
    }

    public boolean getShowBounds(MerlinData md, T obj) {
        return this.showBounds.get(md, obj);
    }

    public String getTypeString(MerlinData md, T obj) {
        return this.typeString.get(md, obj);
    }

    public String getCategoryName(MerlinData md, T obj) {
        return this.categoryName.get(md, obj);
    }

    public Predicate<String> getNameValidator(MerlinData md, T obj) {
        return this.getNameFormatAllowed.get(md, obj);
    }

    public boolean isVisible(MerlinData md, T obj) {
        return this.isVisible.get(md, obj);
    }

    public void setVisible(MerlinData md, T obj, boolean visible) {
        this.setVisible.set(md, obj, visible);
    }

    public Composite<? extends ICompElement> getRootComposite(MerlinData md) {
        return this.getRootComposite.get(md);
    }

    public INameGenerator getNameGenerator(MerlinData md, T obj) {
        return this.getNameGenerator.get(md, obj);
    }

    public INameGroup getUniqueNameGroup(MerlinData md, T obj) {
        return this.getUniqueNameGroup.get(md, obj);
    }

    public boolean canShowInReferencingLists(MerlinData md, T obj) {
        return this.showInReferencingLists.get(md, obj);
    }

    public static interface Getter<T, ReturnT>
    extends Func<T> {
        public ReturnT get(MerlinData var1, T var2);
    }

    public static interface Action<T, ReturnT, ArgT>
    extends Func<T> {
        public ReturnT perform(MerlinData var1, T var2, ArgT var3);
    }

    public static interface Setter<T, ArgT>
    extends Func<T> {
        public void set(MerlinData var1, T var2, ArgT var3);
    }

    public static interface Supplier<T, ReturnT>
    extends Func<T> {
        public ReturnT get(MerlinData var1);
    }

    public static interface INameGroup {
        public Collection<?> get(MerlinData var1);
    }

    public static interface AsyncGetter<T, ReturnT>
    extends Func<T> {
        public ReturnT get(MerlinData var1, T var2, Consumer<ReturnT> var3);
    }

    public static interface Func<T> {
    }
}

