/*
 * Decompiled with CFR 0.152.
 */
package inferno.test;

import inferno.parse2.SimpleParser;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.Param;
import inferno.sim.profiling.TimeAccum;
import inferno.test.EnvUtil;
import inferno.test.ParsePth;
import inferno.test.ParseTxt;
import inferno.test.TestPrefs;
import inferno.test.Tweaks;
import inferno.test.tests.IFinalTest;
import inferno.test.tests.IIntervalTest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import merlin.MerlinApp;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.EmptyTaskProgress;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.theUtil;

public class Prob
implements Runnable {
    public static final String INPUT_FILE_ROOT = System.getenv("EXTLIBS") + "\\pth-nightly-test-input-files";
    public static final int STATUS_PASS = 0;
    public static final int STATUS_FAILINTERVALTEST = 1;
    public static final int STATUS_FAILFINALTEST = 2;
    public static final int STATUS_NOSTART = 3;
    public static final int STATUS_FAIL_RUNTIME = 4;
    public static final int STATUS_FAILINT = 5;
    public static final int STATUS_FAIL_SIMTIME = 6;
    private static final Logger LOGGER = Logger.getLogger(Prob.class.getName());
    private final String d_name;
    private TeciProps d_prefs;
    private String d_inputFile;
    private String d_expl;
    private long d_timeLimit;
    private int d_status;
    private IIntervalTest d_lastIntervalTest;
    private IFinalTest d_lastFinalTest;
    private long d_runTime;
    private double d_simTime;
    private Tweaks.ITweak d_tweaks;
    private IIntervalTest[] d_intervalTests;
    private IFinalTest[] d_finalTests;

    public Prob(String inputFile, long timeLimitSeconds, Tweaks.ITweak tweaks) {
        this(Prob.getNameFromFile(inputFile), inputFile, timeLimitSeconds, tweaks);
    }

    public Prob(String name, String inputFile, long timeLimitSeconds, Tweaks.ITweak tweaks) {
        this.d_name = Prob.getName(name, tweaks);
        try {
            this.d_prefs = MerlinApp.loadAppPreferences();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Application preferences not found, using defaults.");
            this.d_prefs = new TeciProps();
        }
        this.d_inputFile = inputFile;
        this.d_timeLimit = timeLimitSeconds;
        this.d_status = -1;
        this.d_lastIntervalTest = null;
        this.d_lastFinalTest = null;
        this.d_intervalTests = new IIntervalTest[0];
        this.d_finalTests = new IFinalTest[0];
        this.d_tweaks = tweaks;
        this.setExpl("");
    }

    public long getTimeLimit() {
        return this.d_timeLimit;
    }

    public TeciProps getPrefs() {
        return this.d_prefs;
    }

    public String getName() {
        return this.d_name;
    }

    private static String getNameFromFile(String inputFile) {
        return FilenameManager.splitFilename(inputFile)[0];
    }

    private static String getName(String name, Tweaks.ITweak tweaks) {
        if (!((String)name).endsWith(" ")) {
            name = (String)name + "_";
        }
        return (String)name + tweaks.toString();
    }

    public void setPrefs(TeciProps prefs) {
        this.d_prefs = prefs;
    }

    public int getStatus() {
        return this.d_status;
    }

    private IIntervalTest getLastIntervalTest() {
        return this.d_lastIntervalTest;
    }

    private IFinalTest getLastFinalTest() {
        return this.d_lastFinalTest;
    }

    public Prob setIntervalTests(IIntervalTest ... tests) {
        this.d_intervalTests = tests;
        return this;
    }

    public Prob setFinalTests(IFinalTest ... tests) {
        this.d_finalTests = tests;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean uncaughtExceptionHandlerSet = false;
        AtomicReference<Throwable> caughtException = new AtomicReference<Throwable>();
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            uncaughtExceptionHandlerSet = true;
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> caughtException.compareAndSet(null, e));
        }
        try {
            LOGGER.info(String.format("running %s", this.d_name));
            this.runImpl(caughtException);
        }
        catch (Throwable e2) {
            LOGGER.log(Level.SEVERE, e2.toString(), e2);
            this.d_status = 5;
            this.setExpl(String.format("exception thrown - %s: %s", e2.getClass().getSimpleName(), e2.getLocalizedMessage()));
        }
        finally {
            if (uncaughtExceptionHandlerSet) {
                Thread.setDefaultUncaughtExceptionHandler(null);
            }
            this.updateExplanation();
            this.printStatus();
            this.cleanup();
        }
    }

    private void printStatus() {
        String testStatus = this.d_status == 0 ? "SUCCESS" : "FAILURE";
        LOGGER.log(Level.INFO, String.format("%s -- %s", testStatus, this.getName()));
        if (this.d_status != 0) {
            LOGGER.log(Level.INFO, String.format("\t%s", this.getExpl()));
        }
    }

    private void updateExplanation() {
        switch (this.getStatus()) {
            case 0: {
                this.setExpl("");
                break;
            }
            case 3: {
                this.setExpl("[Unable to start test] " + this.getExpl());
                break;
            }
            case 4: {
                this.setExpl("Run time exceeded");
                break;
            }
            case 6: {
                this.setExpl("Sim time exceeded");
                break;
            }
            case 1: {
                this.setExpl(this.getLastIntervalTest().explain());
                break;
            }
            case 2: {
                this.setExpl(this.getLastFinalTest().explain());
                break;
            }
            case 5: {
                this.setExpl("[Test interrupted] " + this.getExpl());
                break;
            }
            default: {
                this.setExpl("Unknown error");
            }
        }
    }

    private void cleanup() {
        this.d_intervalTests = new IIntervalTest[0];
        this.d_lastFinalTest = null;
        this.d_finalTests = new IFinalTest[0];
        this.d_lastFinalTest = null;
    }

    private URL getInputFileURL() {
        String srcProp = System.getenv().getOrDefault(TestPrefs.SOURCE_DIR.key, "");
        if (srcProp.isEmpty()) {
            File f = new File(INPUT_FILE_ROOT + File.separator + this.d_inputFile);
            try {
                return f.toURI().toURL();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
                throw new RuntimeException(new FileNotFoundException(f.getPath()));
            }
        }
        File srcDir = EnvUtil.getDir(TestPrefs.SOURCE_DIR);
        File inputFile = new File(srcDir, this.d_inputFile);
        try {
            return inputFile.toURI().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(new FileNotFoundException(inputFile.getAbsolutePath()));
        }
    }

    private void runImpl(AtomicReference<Throwable> caughtException) throws Throwable {
        Engine e;
        KB kb;
        URL urlInputFile = this.getInputFileURL();
        try {
            kb = Prob.loadKB(urlInputFile, this.d_tweaks, this.d_name);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "error loading: " + this.d_inputFile);
            LOGGER.log(Level.SEVERE, t.toString(), t);
            this.d_status = 3;
            this.setExpl("error loading " + this.d_inputFile + " - " + t.getMessage());
            return;
        }
        Param p = kb.getParams();
        if (p.show_vis) {
            System.loadLibrary("FreeImage");
            System.loadLibrary("Pathfinder_jni");
        }
        try {
            e = new Engine(kb, p, new TimeAccum());
        }
        catch (FileNotFoundException ee) {
            LOGGER.log(Level.SEVERE, ee.toString(), ee);
            this.d_status = 3;
            this.setExpl("error loading " + this.d_inputFile + " - " + ee.getClass().getName() + ": " + ee.getMessage());
            return;
        }
        final AtomicBoolean intervalTestFail = new AtomicBoolean(false);
        e.setTimedCallback(0.1, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (!e.isFinished() && !Prob.this.runIntervalTests(kb, Prob.this.d_intervalTests)) {
                        e.cancel();
                        intervalTestFail.set(true);
                    }
                }
            }
        });
        e.run(this.d_prefs);
        long tStart = System.currentTimeMillis();
        long tMax = tStart + this.d_timeLimit * 1000L;
        while (!e.isFinished() && System.currentTimeMillis() < tMax) {
            if (caughtException.get() != null) {
                e.cancel();
                throw caughtException.get();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ee) {
                LOGGER.log(Level.SEVERE, ee.toString(), ee);
            }
        }
        e.throwCaughtExceptionIfPresent();
        if (intervalTestFail.get()) {
            return;
        }
        this.d_runTime = System.currentTimeMillis() - tStart;
        if (!e.isFinished() || !theUtil.le(kb.getCurrentSimTime(), kb.getParams().max_time, 1.0E-6 + kb.getParams().dt_init) && kb.getParams().max_time != 0.0) {
            if (kb.getCurrentSimTime() < kb.getParams().max_time) {
                e.cancel();
                this.d_status = 4;
                return;
            }
            e.cancel();
            this.d_status = 6;
            return;
        }
        this.d_simTime = kb.getCurrentSimTime();
        if (this.runIntervalTests(kb, this.d_intervalTests) && this.runFinalTests(kb, this.d_finalTests)) {
            this.d_status = 0;
        }
    }

    private static KB loadKB(URL urlInputFile, Tweaks.ITweak tweaks, String outName) throws Throwable {
        LOGGER.fine(String.format("loadKB() urlInputFile=%s tweaks=%s outName=%s", urlInputFile, tweaks, outName));
        String fileType = FilenameManager.splitFilename(urlInputFile.getFile())[1].trim();
        if (fileType.equals("zip")) {
            try (ZipFile zfile = new ZipFile(Paths.get(urlInputFile.toURI()).toFile());){
                KB kB;
                block19: {
                    if (zfile.size() != 1) {
                        throw new IOException(String.format("Expected \"%s\" to have exactly one entry; found %d entries.", urlInputFile.toString(), zfile.size()));
                    }
                    ZipEntry entry = zfile.entries().nextElement();
                    InputStream in = zfile.getInputStream(entry);
                    try {
                        kB = Prob.loadKB(in, urlInputFile, entry.getName(), outName, tweaks);
                        if (in == null) break block19;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    in.close();
                }
                return kB;
            }
        }
        try (InputStream in = urlInputFile.openStream();){
            KB kB = Prob.loadKB(in, urlInputFile, urlInputFile.getPath(), outName, tweaks);
            return kB;
        }
    }

    private static KB loadKB(InputStream inStream, URL urlInputFile, String inName, String outName, Tweaks.ITweak tweaks) throws Throwable {
        String fileType;
        switch (fileType = FilenameManager.splitFilename(inName)[1].trim()) {
            case "txt": {
                SimpleParser parser = null;
                try {
                    parser = new ParseTxt(urlInputFile.openStream(), new File(urlInputFile.getPath()).getParentFile(), inName, tweaks);
                    parser.run();
                    return parser.getKB();
                }
                catch (Throwable t) {
                    if (parser != null) {
                        throw new IOException("parse error [line " + parser.getLastLineN() + "]: " + parser.getLastLine());
                    }
                    throw t;
                }
            }
            case "pth": {
                File parentDir;
                File outDir = EnvUtil.getDir(TestPrefs.STORE_LOCATION);
                String resultsName = "results";
                if (EnvUtil.get(TestPrefs.STORE_INCLUDE_VERSION).booleanValue()) {
                    resultsName = "2025.1.0728";
                }
                outDir = new File(outDir, resultsName);
                Path path = Paths.get(urlInputFile.toURI());
                if (EnvUtil.get(TestPrefs.COPY_INPUT_FILE).booleanValue() && (parentDir = new File(outDir, outName).getParentFile()) != null) {
                    parentDir.mkdirs();
                    try {
                        Path srcPath = path;
                        Path dstPath = parentDir.toPath().resolve(srcPath.getFileName());
                        Files.copy(srcPath, dstPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                }
                int options = 2;
                if (EnvUtil.get(TestPrefs.MAKE_VIS_FILES).booleanValue()) {
                    options |= 1;
                }
                KB kb = ParsePth.load(inStream, outDir, outName, null, tweaks, options);
                kb.init(EmptyTaskProgress.INSTANCE);
                return kb;
            }
        }
        return null;
    }

    private boolean runIntervalTests(KB kb, IIntervalTest[] tests) {
        IIntervalTest[] iIntervalTestArray = tests;
        int n = iIntervalTestArray.length;
        for (int i = 0; i < n; ++i) {
            IIntervalTest test;
            this.d_lastIntervalTest = test = iIntervalTestArray[i];
            if (test.evalInterval(kb)) continue;
            this.d_status = 1;
            return false;
        }
        return true;
    }

    private boolean runFinalTests(KB kb, IFinalTest[] tests) {
        IFinalTest[] iFinalTestArray = tests;
        int n = iFinalTestArray.length;
        for (int i = 0; i < n; ++i) {
            IFinalTest test;
            this.d_lastFinalTest = test = iFinalTestArray[i];
            if (test.evalFinal(kb)) continue;
            this.d_status = 2;
            return false;
        }
        return true;
    }

    public void setExpl(String d_expl) {
        this.d_expl = d_expl;
    }

    public String getExpl() {
        return this.d_expl;
    }

    public double getSimTime() {
        return this.d_simTime;
    }

    public double getRunTime() {
        if (this.d_status == 4) {
            return this.d_timeLimit;
        }
        return (double)this.d_runTime / 1000.0;
    }

    public String toString() {
        return String.format("Prob[name=%s]", this.getName());
    }
}

