/*
 * Decompiled with CFR 0.152.
 */
package inferno.test;

import inferno.sim.KB;
import inferno.sim.Param;
import inferno.test.Tweaks;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import merlin.actions.InfernoUtil;
import merlin.actions.WriteMesh;
import merlin.data.MerlinData;
import merlin.data.egress.SimError;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioUtil;
import merlin.data.scenario.SimOutputDir;
import merlin.io.MerlinOIS;
import thunderheadeng.util.EmptyTaskProgress;
import thunderheadeng.util.ITaskProgress;

public class ParsePth {
    public static final int OPT_PREPARE_VIS = 1;
    public static final int OPT_UPGRADE_DEFAULTS = 2;
    public static final int OPT_CONVERT_TO_SOCIAL_DISTANCE = 4;

    public static KB load(String inFile, File pthFileDir, String outName, Tweaks.ITweak tweaks, int options) {
        KB kB;
        FileInputStream fis = new FileInputStream(inFile);
        try {
            kB = ParsePth.load(fis, pthFileDir, outName, null, tweaks, options);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }
        fis.close();
        return kB;
    }

    public static KB load(InputStream inStream, File pthFileDir, String outName, File simulationsFile, Tweaks.ITweak tweaks, int options) throws Throwable {
        Path pthFile = pthFileDir.toPath().resolve(outName);
        MerlinData md = new MerlinData(false);
        BufferedInputStream bis = new BufferedInputStream(inStream);
        MerlinOIS ois = new MerlinOIS(bis, false, pthFile.toString(), (tp, task) -> {});
        MerlinOIS.DecisionMaker decisions = new MerlinOIS.DecisionMaker();
        decisions.pre104UseNewDefaults = () -> ParsePth.test(options, 2);
        decisions.pre139ConvertToSocialDistance = () -> ParsePth.test(options, 4);
        MerlinData mdTemp = ois.readModel(decisions);
        md.loadFrom(mdTemp);
        if (tweaks != null) {
            tweaks.tweak(md);
        }
        SimOutputDir outputDir = ScenarioUtil.getOutputDir(pthFile.toString(), md.scenarios.getActive().getName(), md.scenarios.flatten(Scenario.class).size(), 0, 1);
        outputDir.current.outputDir().toFile().mkdirs();
        String rootFn = InfernoUtil.rootFn(pthFile.getFileName().toString());
        boolean debug = System.getProperty("debug-vis") != null;
        Param p = InfernoUtil.mkInfernoParam(null, md, outputDir.current.outputDir().toFile(), rootFn, simulationsFile, debug);
        ArrayList<SimError> errors = new ArrayList<SimError>();
        InfernoUtil.KBInfo kbi = InfernoUtil.mkInfernoKB(md, p, errors, EmptyTaskProgress.INSTANCE);
        if (tweaks != null) {
            tweaks.tweak(kbi.kb);
        }
        try {
            WriteMesh.writeInputFile(md, outputDir.current.outputDir().toFile(), rootFn, kbi, p, (ITaskProgress)EmptyTaskProgress.INSTANCE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return kbi.kb;
    }

    private static boolean test(int options, int option) {
        return (options & option) == option;
    }
}

