/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import common.geom.Trig;
import inferno.data2.OccPriority;
import inferno.data2.PolygonShape;
import inferno.data2.QPath;
import inferno.geom.Inter;
import inferno.sim.KB;
import inferno.sim.KnownFuncs;
import inferno.sim.OccAgent;
import inferno.sim.steering.inverse.IdleSeparation;
import inferno.sim.steering.inverse.InvSteerMeta;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.Senses;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class AvoidOccs
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final double IGNORE_IF_DOMINANT = theUtil.getSystemDouble("AvoidOccs.IGNORE_IF_DOMINANT", Double.NaN);
    public static final boolean POWER_LAW = System.getProperty("AvoidOccs.POWER_LAW") != null;
    public static final double POWER_LAW_T_H = theUtil.getSystemDouble("AvoidOccs.POWER_LAW", 4.0);
    public static final boolean DISABLE_AUTO_FREEPASS = theUtil.testSystemProp("AvoidOccs.DISABLE_AUTO_FREEPASS");
    public static final int FILTERID = -1348979970;
    private static final boolean USE_INACCURATE_COST = true;
    private final boolean d_highestPriorityForSeek;
    private boolean d_reportCost;
    private boolean isVehicle;

    public AvoidOccs(KB kb, OccInfo oi, Senses senses, SeekInfo seekInfo, double sepDist, boolean reportCost, boolean isSocialDistancing) {
        this.d_reportCost = reportCost;
        boolean highestPriorityForSeek = false;
        this.isVehicle = oi.oa.hasVehicle();
        if (seekInfo.seekDir != null && !isSocialDistancing) {
            Vector3d preferredDir = seekInfo.seekDir;
            highestPriorityForSeek = true;
            Vector3d occDir = new Vector3d();
            for (OccAgent nearOcc : senses.getNearOccs(-1348979970, oi)) {
                double comfortDist;
                double gap;
                occDir.sub(nearOcc.getPos(), oi.oa.getPos());
                if (!(occDir.dot(preferredDir) > 0.0) || InvSteerUtil.compare(kb, oi, nearOcc) < 0 || !((gap = Inter.getOccGap(oi.shapeAgents, nearOcc.getCollisionShape())) < (comfortDist = IdleSeparation.getSepDist(kb, oi, seekInfo, nearOcc, sepDist)))) continue;
                highestPriorityForSeek = false;
                break;
            }
        }
        this.d_highestPriorityForSeek = highestPriorityForSeek;
    }

    public static double getSensingRadius(KB kb, OccInfo oi, double sepDist) {
        double vel = oi.cache.currVel;
        double minHitDist = oi.shapeAgents.getEnclosingRadius() + AvoidOccs.getMinHitDist(kb, oi.oa, vel, true, sepDist);
        double maxVel = OccAgent.getTotalMaxVel(kb, oi.oa.getOcc());
        double maxHitDist = minHitDist + AvoidOccs.getMaxHitDist(kb, oi.oa, vel, maxVel);
        return maxHitDist;
    }

    private static double getMinHitDist(KB kb, OccAgent oa, double vel, boolean separate, double sepDist) {
        double minHitDist = separate ? sepDist : 0.0;
        return minHitDist += OccAgent.calcStopDist(vel, oa.getMaxStopAccel(kb));
    }

    private static double getMaxHitDist(KB kb, OccAgent oa, double vel, double maxVel) {
        return Math.max(OccAgent.calcStopDist(maxVel, oa.getMaxStopAccel(kb)), vel * (double)oa.getOcc().collisionResponseTime);
    }

    public double[] getCost(KB kb, OccInfo oi, Senses senses, SeekInfo seekInfo, Vector3d dir, Predicate<OccAgent> enableSeparation, double sepDist, Consumer<OccAgent> highCostHits) {
        if (this.d_highestPriorityForSeek && seekInfo.isNoProgressDir(dir)) {
            double maxSpeed;
            double d = maxSpeed = dir == null ? 0.0 : oi.cache.maxVel;
            if (this.isVehicle) {
                return new double[]{0.75, 0.0};
            }
            return new double[]{1.0, maxSpeed};
        }
        if (this.isVehicle && !this.d_highestPriorityForSeek && (dir == null || Inter.angleAbs(oi.oa.getDirFacing(), dir) != Math.PI) && this.findRotationCollision(kb, oi, dir, 0.0, 5.0)) {
            return new double[]{1.0, 0.0};
        }
        ArrayList<Pair<OccAgent, Double>> occHits = new ArrayList<Pair<OccAgent, Double>>(2);
        List<Pair<OccAgent, Double>> stationaryHits = null;
        senses.senseNearestOccHits(kb, -1348979970, oi, dir, occHits, stationaryHits);
        double[] tcost = this.getTransientCost(kb, oi, seekInfo, senses, dir, occHits, enableSeparation, sepDist, highCostHits);
        double[] scost = new double[]{0.0, oi.cache.maxVel};
        return new double[]{tcost[0] + scost[0], Math.min(tcost[1], scost[1])};
    }

    private static double[] getCost(KB kb, OccInfo oi, SeekInfo seekInfo, OccAgent otherOcc, double maxVel) {
        double cost = InvSteerUtil.clampCost(1.0 - otherOcc.getOcc().vel.length() / maxVel);
        return new double[]{cost, oi.cache.maxVel};
    }

    private double[] getTransientCost(KB kb, OccInfo oi, SeekInfo seekInfo, Senses senses, Vector3d dir, List<Pair<OccAgent, Double>> occHits, Predicate<OccAgent> enableSeparation, double sepDist, Consumer<OccAgent> highCostHits) {
        boolean uniformSep;
        if (!Double.isNaN(IGNORE_IF_DOMINANT) && seekInfo.seekDir != null) {
            occHits = new ArrayList<Pair>(theUtil.filter(occHits, hit -> {
                Senses.Flow flow = senses.getFlow(kb, oi.oa, seekInfo, (OccAgent)hit.v1, Senses.getSeekDir((OccAgent)hit.v1));
                if (flow != Senses.Flow.CROSS) {
                    return true;
                }
                return !AvoidOccs.getFreePass((KB)kb, (OccAgent)oi.oa, (Senses)senses, (OccAgent[])new OccAgent[]{(OccAgent)hit.v1}, (SeekInfo)seekInfo, (boolean)false).freePass;
            }));
        }
        if (occHits.isEmpty()) {
            return new double[]{0.0, oi.cache.maxVel};
        }
        Pair<OccAgent, Double> firstHit = occHits.get(0);
        double firstHitDist = AvoidOccs.getHitDist(kb, oi, dir, (OccAgent)firstHit.v1, (Double)firstHit.v2);
        Vector3d preferredDir = seekInfo.seekCurve.getTangent(0.0);
        double maxVel = OccAgent.getMaxVel(kb, oi.oa.getOcc(), 0.0, dir);
        double[] firstCost = AvoidOccs.getCost(kb, oi, seekInfo, (OccAgent)firstHit.v1, firstHitDist, enableSeparation.test((OccAgent)firstHit.v1), sepDist, maxVel);
        if (this.d_highestPriorityForSeek && preferredDir.dot(dir) < 0.0) {
            return new double[]{1.0, firstCost[1]};
        }
        if (theUtil.eq0(firstCost[0], 1.0E-6)) {
            return firstCost;
        }
        boolean bl = uniformSep = Predicates.alwaysTrue(enableSeparation) || Predicates.alwaysFalse(enableSeparation);
        if (highCostHits != null) {
            highCostHits.accept((OccAgent)firstHit.v1);
            if (firstCost[0] >= 1.0 || !uniformSep) {
                for (int m = 1; m < occHits.size(); ++m) {
                    Pair<OccAgent, Double> hit2 = occHits.get(m);
                    double hitDist = AvoidOccs.getHitDist(kb, oi, dir, (OccAgent)hit2.v1, (Double)hit2.v2);
                    double[] cost = AvoidOccs.getCost(kb, oi, seekInfo, (OccAgent)hit2.v1, hitDist, enableSeparation.test((OccAgent)hit2.v1), sepDist, maxVel);
                    if (cost[0] >= 1.0) {
                        highCostHits.accept((OccAgent)hit2.v1);
                        continue;
                    }
                    if (uniformSep) break;
                }
            }
        }
        if (!this.d_reportCost) {
            return null;
        }
        return firstCost;
    }

    public static double[] getCost(KB kb, OccInfo oi, SeekInfo seekInfo, OccAgent occ2, double hitDist, boolean enableSeparation, double sepDist, double maxVel) {
        if (POWER_LAW) {
            return AvoidOccs.getCostPowerLaw(kb, oi, seekInfo, occ2, hitDist, enableSeparation, sepDist, maxVel);
        }
        return AvoidOccs.getCostInaccurate(kb, oi, seekInfo, occ2, hitDist, enableSeparation, sepDist, maxVel);
    }

    public static boolean getSeparateEnabled(KB kb, OccInfo oi, OccAgent occ2) {
        int comp = InvSteerUtil.compare(kb, oi, occ2);
        if (comp > 0) {
            return true;
        }
        if (comp < 0) {
            return false;
        }
        return oi.oa.isWaiting(kb) || !occ2.isWaiting(kb) || !InvSteerUtil.isInGoalSpace(kb, oi.oa, occ2);
    }

    public static double[] getCostPowerLaw(KB kb, OccInfo oi, SeekInfo seekInfo, OccAgent occ2, double hitDist, boolean enableSeparation, double sepDist, double maxVel) {
        boolean separate;
        if (theUtil.eq0(hitDist, 1.0E-6)) {
            return new double[]{1.0, 0.0};
        }
        boolean bl = separate = enableSeparation && AvoidOccs.getSeparateEnabled(kb, oi, occ2);
        if (separate) {
            sepDist = IdleSeparation.getSepDist(kb, oi, seekInfo, occ2, sepDist);
        }
        double dcut = AvoidOccs.getMinHitDist(kb, oi.oa, maxVel, separate, sepDist);
        double travelDist = Math.max(0.0, hitDist - sepDist);
        double speed = InvSteerUtil.getMaxVelToStop(kb, oi, travelDist);
        if (hitDist <= dcut) {
            return new double[]{1.0, 0.0};
        }
        double dcr = POWER_LAW_T_H * maxVel;
        double denom = hitDist * (dcr - dcut);
        if (theUtil.eq0(denom, 1.0E-9)) {
            return new double[]{1.0, 0.0};
        }
        double cost = (dcr - hitDist) * dcut / denom;
        cost = InvSteerUtil.clampCost(cost);
        return new double[]{cost, speed};
    }

    private static double[] getCostInaccurate(KB kb, OccInfo oi, SeekInfo seekInfo, OccAgent occ2, double hitDist, boolean enableSeparation, double sepDist, double maxVel) {
        if (theUtil.eq0(hitDist, 1.0E-6)) {
            return new double[]{1.0, 0.0};
        }
        boolean separate = enableSeparation && AvoidOccs.getSeparateEnabled(kb, oi, occ2);
        double vel = oi.cache.currVel;
        if (separate) {
            sepDist = IdleSeparation.getSepDist(kb, oi, seekInfo, occ2, sepDist);
            double minHitDist = AvoidOccs.getMinHitDist(kb, oi.oa, vel, separate, sepDist);
            double maxHitDist = minHitDist + AvoidOccs.getMaxHitDist(kb, oi.oa, vel, maxVel);
            double cost = InvSteerUtil.clampCost(KnownFuncs.linInterp(minHitDist, 1.0, maxHitDist, 0.0, hitDist));
            double travelDist = Math.max(0.0, hitDist - minHitDist);
            double speed = InvSteerUtil.getMaxVelToStop(kb, oi, travelDist);
            return new double[]{cost, speed};
        }
        vel = Math.max(1.0E-6, oi.cache.currVel);
        double stopDist = OccAgent.calcStopDist(vel, oi.oa.getMaxStopAccel(kb));
        double speed = InvSteerUtil.getMaxVelToStop(kb, oi, hitDist);
        return new double[]{InvSteerUtil.clampCost(stopDist / hitDist), speed};
    }

    private static double[] getCostAccurate(KB kb, OccInfo oi, SeekInfo seekInfo, OccAgent occ2, double hitDist, boolean enableSeparation, double sepDist, double maxVel) {
        boolean separate;
        if (theUtil.eq0(hitDist, 1.0E-6)) {
            return new double[]{1.0, 0.0};
        }
        boolean bl = separate = enableSeparation && AvoidOccs.getSeparateEnabled(kb, oi, occ2);
        if (separate) {
            sepDist = IdleSeparation.getSepDist(kb, oi, seekInfo, occ2, sepDist);
            hitDist = Math.max(0.0, hitDist - sepDist);
        }
        return InvSteerUtil.getCost(kb, oi, hitDist);
    }

    public static double getHitDist(KB kb, OccInfo oi, Vector3d dir, OccAgent otherOcc, double hitT) {
        if (hitT <= 0.0) {
            return 0.0;
        }
        if (dir == null) {
            return Double.POSITIVE_INFINITY;
        }
        return Math.max(0.0, oi.cache.maxVel * hitT);
    }

    public static FreePassResult getFreePass(KB kb, OccAgent occ1, Senses senses1, OccAgent[] occsInTheWay, SeekInfo seekInfo, boolean isLaneLeader) {
        if (!DISABLE_AUTO_FREEPASS && isLaneLeader && !occ1.getOcc().reEnteredDoorQueue && occ1.getOcc().nodeSqueezeFactor > 0.0f) {
            return FreePassResult.pass();
        }
        if (occsInTheWay.length == 0) {
            return FreePassResult.pass();
        }
        double priority1 = occ1.getOcc().priority;
        Predicate<OccAgent> rpFilter1 = InvSteerUtil.getRaisedPriorityFilter(occ1);
        for (int m = 0; m < occsInTheWay.length; ++m) {
            int compare;
            OccAgent occ2 = occsInTheWay[m];
            int comp = OccPriority.compare(occ1, priority1, rpFilter1, occ2, occ2.getPriority(kb), InvSteerUtil.getRaisedPriorityFilter(occ2));
            if (comp > 0) {
                if (AvoidOccs.passTightSpace(occ1, occ2, kb) < 0) continue;
                return FreePassResult.noPass(occ2);
            }
            if (comp < 0 || (compare = AvoidOccs.compare(kb, occ1, senses1, isLaneLeader, seekInfo, occ2)) < 0) continue;
            return FreePassResult.noPass(occ2);
        }
        return FreePassResult.pass();
    }

    private static int passTightSpace(OccAgent occ1, OccAgent occ2, KB kb) {
        boolean tightSpace2 = InvSteerUtil.isInTightSpace(kb, occ1, occ2);
        boolean tightSpace1 = InvSteerUtil.isInTightSpace(kb, occ2, occ1);
        if (tightSpace1 != tightSpace2) {
            return tightSpace1 ? -1 : 1;
        }
        return 0;
    }

    private static int compare(KB kb, OccAgent occ1, Senses senses1, boolean occ1LaneLeader, SeekInfo seek1, OccAgent occ2) {
        int qcomp;
        InvSteerMeta meta2;
        int passTightSpace = AvoidOccs.passTightSpace(occ1, occ2, kb);
        if (passTightSpace != 0) {
            return passTightSpace;
        }
        if (occ1.getOcc().isGroupLeader && occ1.getOcc().occupantGroup != null && !occ2.getOcc().isGroupLeader && occ2.getOcc().occupantGroup != null) {
            return -1;
        }
        if (DISABLE_AUTO_FREEPASS && (meta2 = InvSteerUtil.getSteerMeta(occ2)) != null) {
            if (occ1LaneLeader && !meta2.isLaneLeader) {
                return -1;
            }
            if (!occ1LaneLeader && meta2.isLaneLeader) {
                return 1;
            }
        }
        QPath qpath1 = occ1.getOcc().qpath;
        QPath qpath2 = occ2.getOcc().qpath;
        if (qpath1 != null && qpath2 == null) {
            return -1;
        }
        if (qpath1 == null && qpath2 != null) {
            return 1;
        }
        if (qpath1 != null && qpath2 == qpath1 && (qcomp = qpath1.compare(occ1, occ2)) != 0) {
            return qcomp;
        }
        if (occ1.isWaiting(kb)) {
            if (!occ2.isWaiting(kb)) {
                return InvSteerUtil.getYieldToIdler(kb, occ2, occ1) ? -1 : 1;
            }
            return 1;
        }
        if (occ2.isWaiting(kb)) {
            return InvSteerUtil.getYieldToIdler(kb, occ1, occ2) ? 1 : -1;
        }
        if (occ1.getOcc().formationLeader != null && occ1.getOcc().formationLeader.formationInLimitedNode()) {
            return -1;
        }
        int result = AvoidOccs.compareSeekingOccs(kb, occ1, senses1, seek1, occ2);
        return result == 0 ? OccPriority.compareStrict(occ1.getPriority(kb), occ2.getPriority(kb)) : result;
    }

    private static int compareSeekingOccs(KB kb, OccAgent occ1, Senses senses1, SeekInfo seek1, OccAgent occ2) {
        boolean leavingSpace1 = InvSteerUtil.isLeavingGoalSpace(kb, occ1, occ2);
        boolean leavingSpace2 = InvSteerUtil.isLeavingGoalSpace(kb, occ2, occ1);
        if (leavingSpace1 && !leavingSpace2) {
            return 1;
        }
        if (leavingSpace2 && !leavingSpace1) {
            return -1;
        }
        Vector3d dir1 = seek1.seekDir;
        Vector3d dir2 = Senses.getSeekDir(occ2);
        if (dir1 == null && dir2 == null) {
            return 0;
        }
        if (dir1 == null) {
            return 1;
        }
        if (dir2 == null) {
            return -1;
        }
        InvSteerMeta meta2 = InvSteerUtil.getSteerMeta(occ2);
        boolean occ2Cooldown = meta2.tRaisedPriorityBegin > kb.getCurrentSimTime();
        Senses.Flow flow = senses1.getFlow(kb, occ1, seek1, occ2, dir2);
        double speed1Sq = 0.0;
        double speed2Sq = 0.0;
        if (flow == Senses.Flow.COUNTER) {
            if (occ2Cooldown) {
                return -1;
            }
            speed1Sq = occ1.getVel().lengthSquared();
            speed2Sq = occ2.getVel().lengthSquared();
            boolean moving1 = theUtil.gt0(speed1Sq, 1.0E-12);
            boolean moving2 = theUtil.gt0(speed2Sq, 1.0E-12);
            if (moving1 && !moving2) {
                return -1;
            }
            if (!moving1 && moving2) {
                return 1;
            }
            if (!moving1 && !moving2) {
                return -1;
            }
        }
        Vector3d isectVec1 = dir1;
        Vector3d isectVec2 = dir2;
        double[] isect = Inter3D.lineLineProximityT(occ1.getPos(), isectVec1, occ2.getPos(), isectVec2, 1.0E-6);
        if (isect != null && isect[0] > 0.0 && isect[1] > 0.0) {
            Vector3d occDir;
            double dot2;
            if (occ2Cooldown) {
                return -1;
            }
            if (flow == Senses.Flow.CROSS) {
                Vector3d occDir2 = Util3D.vectorN(occ1.getPos(), occ2.getPos());
                double dot1 = occDir2.dot(dir1);
                if (dot1 > 0.0 && occ2.getAverageSpeedAlongPath(kb, 0.5) > 0.0) {
                    return 1;
                }
            } else if (flow == Senses.Flow.MERGE && (dot2 = -(occDir = Util3D.vectorN(occ1.getPos(), occ2.getPos())).dot(dir2)) > 0.0 && occ1.getAverageSpeedAlongPath(kb, 0.5) > 0.0) {
                return -1;
            }
            return Double.compare(isect[0], isect[1]);
        }
        boolean counterflow = flow == Senses.Flow.COUNTER || flow == Senses.Flow.CROSS;
        Vector3d occDir = Util3D.vectorN(occ1.getPos(), occ2.getPos());
        if (!counterflow) {
            double dot1 = occDir.dot(dir1);
            double dot2 = -occDir.dot(dir2);
            if (dot1 > 0.0 && dot2 > 0.0) {
                return Double.compare(dot1, dot2);
            }
            return (int)Math.signum(dot1);
        }
        if (occ2Cooldown) {
            return -1;
        }
        double dot1 = occDir.dot(isectVec1);
        if (dot1 > 0.0) {
            double dot2 = -occDir.dot(isectVec2);
            return Double.compare(dot1, dot2);
        }
        return -1;
    }

    private boolean findRotationCollision(KB kb, OccInfo oi, Vector3d dir, double speed, double maxT) {
        OccAgent agent = oi.oa;
        Vector3d ref = new Vector3d(agent.getDirFacing());
        if (ref == null || dir == null) {
            return false;
        }
        double angle = Trig.angle(ref, dir);
        PolygonShape testShape = agent.getVehicle().rotateShape(ref);
        double rotAngle = 0.15707963267948966;
        rotAngle = angle > 0.0 ? rotAngle : -rotAngle;
        Vector3d shiftDir = new Vector3d(dir);
        shiftDir.scale(speed);
        double dist = 0.0;
        while (Math.abs(angle) > Math.abs(rotAngle) && dist < maxT) {
            Predicate<OccAgent> filter;
            Point3d newCenter = new Point3d(testShape.getCenter());
            newCenter.add(shiftDir);
            dist += newCenter.distance(testShape.getCenter());
            testShape = testShape.translateToAndRotate(newCenter, rotAngle);
            ref = testShape.getDir();
            angle = Math.atan2(ref.x * dir.y - ref.y * dir.x, ref.x * dir.x + ref.y * dir.y);
            Predicate<OccAgent> predicate = filter = agent.getVehicle().getFreePass() ? oi.raisedPriorityFilter : oi.collisionFilter;
            if (!testShape.testCollisionOccs(kb, testShape.getEnclosingRadius() / 10.0, filter, oi.oa)) continue;
            return true;
        }
        return false;
    }

    public static class FreePassResult {
        public final boolean freePass;
        public final OccAgent avoidOcc;

        private FreePassResult(boolean freePass, OccAgent avoidOcc) {
            this.freePass = freePass;
            this.avoidOcc = avoidOcc;
        }

        public static FreePassResult noPass(OccAgent avoidOcc) {
            return new FreePassResult(false, avoidOcc);
        }

        public static FreePassResult pass() {
            return new FreePassResult(true, null);
        }
    }
}

