/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering;

import inferno.data2.TriPoint;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ITpSource;
import java.util.function.Supplier;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Predicates;

public class LookAtUtil {
    public static Vector3d orientToTargetIfVisible(KB kb, ITpSource tp, OccAgent agent, Supplier<Vector3d> fallbackOrient) {
        if (tp == null) {
            return fallbackOrient.get();
        }
        if (agent.hasVehicle()) {
            return fallbackOrient.get();
        }
        TriPoint target = tp.getTriPoint();
        if (kb.getMesh().isPathObstructed(agent.getLoc(), target, 0.0, Predicates.alwaysTrue())) {
            return fallbackOrient.get();
        }
        Vector3d dir = Util3D.vector(agent.getPos(), target.p);
        if (Util3D.safeNormalize(dir, 1.0E-6) > 0.0) {
            return dir;
        }
        return fallbackOrient.get();
    }
}

