/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering;

import inferno.data2.AttractorSim;
import inferno.data2.Mesh;
import inferno.data2.TriPoint;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.PathFilters;
import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util3D;

public interface ITpSource {
    public boolean isStatic();

    public TriPoint getTriPoint();

    public boolean isEqual(ITpSource var1);

    public static class BackupTpSource
    implements ITpSource,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final ITpSource desired;
        public final ITpSource backup;

        public BackupTpSource(ITpSource desired, ITpSource backup) {
            this.desired = desired;
            this.backup = backup;
        }

        @Override
        public boolean isEqual(ITpSource src) {
            if (src == this) {
                return true;
            }
            if (src == null || !src.getClass().equals(this.getClass())) {
                return false;
            }
            BackupTpSource asrc = (BackupTpSource)src;
            return asrc.desired.isEqual(this.desired) && asrc.backup.isEqual(this.backup);
        }

        @Override
        public boolean isStatic() {
            return this.desired.isStatic() && this.backup.isStatic();
        }

        @Override
        public TriPoint getTriPoint() {
            TriPoint tp = this.desired.getTriPoint();
            if (tp.tri == null) {
                return this.backup.getTriPoint();
            }
            return tp;
        }
    }

    public static class OffsetTpSource
    extends AgentTpSource {
        private static final long serialVersionUID = 1L;
        private Mesh d_mesh;
        private OccAgent d_follower;
        private double d_distOffLeader;

        public OffsetTpSource(OccAgent leader, Mesh m, OccAgent follower, double distOffLeader) {
            super(leader);
            this.d_mesh = m;
            this.d_follower = follower;
            this.d_distOffLeader = distOffLeader;
        }

        @Override
        public boolean isEqual(ITpSource src) {
            if (src == this) {
                return true;
            }
            if (src == null || !src.getClass().equals(this.getClass())) {
                return false;
            }
            OffsetTpSource asrc = (OffsetTpSource)src;
            return asrc.d_follower == this.d_follower && asrc.d_distOffLeader == this.d_distOffLeader;
        }

        @Override
        public TriPoint getTriPoint() {
            TriPoint ptLeader = super.getTriPoint();
            Vector3d v = Util3D.vector(ptLeader.p, this.d_follower.getPos());
            v.normalize();
            v.scale(this.d_distOffLeader);
            Point3d ptOff = new Point3d(ptLeader.p);
            ptOff.add(v);
            if (ptLeader.tri.containsExact(ptOff)) {
                return new TriPoint(ptLeader.tri, ptOff);
            }
            try {
                Mesh.EdgeCrossing ecross = this.d_mesh.getCrossedEdges(ptLeader.tri, ptLeader.p, v, PathFilters.filterEdges(EdgeFilters.rejectAllExits()), 1.0);
                if (ecross != null) {
                    return new TriPoint(ecross.enterLoc.tri, ecross.destPt);
                }
                return ptLeader;
            }
            catch (Mesh.CrossedEdgesException e) {
                return this.d_follower.getLoc();
            }
        }
    }

    public static class AttractorSource
    implements ITpSource,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final AttractorSim attractor;

        public AttractorSource(AttractorSim attractor) {
            this.attractor = attractor;
        }

        @Override
        public boolean isEqual(ITpSource src) {
            if (src == this) {
                return true;
            }
            if (src == null || !src.getClass().equals(this.getClass())) {
                return false;
            }
            AttractorSource asrc = (AttractorSource)src;
            return asrc.attractor == this.attractor;
        }

        @Override
        public boolean isStatic() {
            return !this.attractor.trackCreator;
        }

        @Override
        public TriPoint getTriPoint() {
            return this.attractor.getLocation();
        }

        public String toString() {
            return this.attractor.name;
        }
    }

    public static class AgentTpSource
    implements ITpSource,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final OccAgent d_agent;

        public AgentTpSource(OccAgent agent) {
            this.d_agent = agent;
        }

        @Override
        public boolean isEqual(ITpSource src) {
            if (src == this) {
                return true;
            }
            if (src == null || !src.getClass().equals(this.getClass())) {
                return false;
            }
            AgentTpSource asrc = (AgentTpSource)src;
            return asrc.d_agent == this.d_agent;
        }

        public final OccAgent getAgent() {
            return this.d_agent;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public TriPoint getTriPoint() {
            return this.d_agent.getLoc();
        }

        public String toString() {
            return this.d_agent.toString();
        }
    }
}

