/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.elevator.Elevator;
import java.io.ObjectStreamException;
import java.util.function.Predicate;
import thunderheadeng.util.APredicate;
import thunderheadeng.util.Predicates;

public class NodeFilters
extends Predicates {
    public static Predicate<ANode> rejectElevators() {
        return RejectElevators.INSTANCE;
    }

    public static Predicate<ANode> rejectElevators(Predicate<Elevator> elevators) {
        return NodeFilters.acceptElevators(elevators.negate());
    }

    public static Predicate<ANode> acceptElevators() {
        return AcceptAllElevators.INSTANCE;
    }

    public static Predicate<ANode> acceptElevators(Predicate<Elevator> elevators) {
        if (Predicates.alwaysTrue(elevators)) {
            return NodeFilters.acceptElevators();
        }
        return new AcceptElevators(elevators);
    }

    public static Predicate<ANode> acceptElevatorDoors(Predicate<Elevator> elevators) {
        if (Predicates.alwaysTrue(elevators)) {
            return NodeFilters.acceptElevatorDoors();
        }
        return new AcceptElevatorDoors(elevators);
    }

    public static Predicate<ANode> acceptElevatorDoors() {
        return AcceptAllElevatorDoors.INSTANCE;
    }

    private static class RejectElevators
    extends APredicate<ANode> {
        static final long serialVersionUID = 1L;
        public static RejectElevators INSTANCE = new RejectElevators();

        private RejectElevators() {
        }

        @Override
        public boolean test(ANode t) {
            return t.getElevatorLevel() == null;
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static class AcceptAllElevators
    extends APredicate<ANode> {
        static final long serialVersionUID = 1L;
        public static AcceptAllElevators INSTANCE = new AcceptAllElevators();

        private AcceptAllElevators() {
        }

        @Override
        public boolean test(ANode t) {
            return t.getElevatorLevel() != null;
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static class AcceptElevators
    extends APredicate<ANode> {
        private static final long serialVersionUID = 1L;
        public final Predicate<Elevator> elevators;

        public AcceptElevators(Predicate<Elevator> elevators) {
            this.elevators = elevators;
        }

        public int hashCode() {
            return 0xAF9832 ^ this.elevators.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            AcceptElevators ae = (AcceptElevators)obj;
            return ae.elevators.equals(this.elevators);
        }

        @Override
        public boolean test(ANode t) {
            return t.getElevatorLevel() != null && this.elevators.test(t.getElevatorLevel().getElevator());
        }
    }

    private static class AcceptElevatorDoors
    extends APredicate<ANode> {
        private static final long serialVersionUID = 1L;
        public final Predicate<Elevator> elevators;

        public AcceptElevatorDoors(Predicate<Elevator> elevators) {
            this.elevators = elevators;
        }

        public int hashCode() {
            return 0xAF9832 ^ this.elevators.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            AcceptElevatorDoors ae = (AcceptElevatorDoors)obj;
            return ae.elevators.equals(this.elevators);
        }

        @Override
        public boolean test(ANode t) {
            return t.isElevatorDoor() && t.getConnectedElevatorLevel().map(l -> this.elevators.test(l.getElevator())).orElse(false) != false;
        }
    }

    private static class AcceptAllElevatorDoors
    extends APredicate<ANode> {
        private static final long serialVersionUID = 1L;
        private static final AcceptAllElevatorDoors INSTANCE = new AcceptAllElevatorDoors();

        private AcceptAllElevatorDoors() {
        }

        @Override
        public boolean test(ANode t) {
            return t.isElevatorDoor();
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

