/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import thunderheadeng.util.filters.EQBiquadFilter;
import thunderheadeng.util.filters.ISignalFilter;
import thunderheadeng.util.theUtil;

public class DoorQueueEstimate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final ANode door;
    public final OccQueue posQueue;
    public final OccQueue negQueue;

    public DoorQueueEstimate(KB kb, ANode door) {
        this.door = door;
        this.posQueue = new OccQueue(kb, door, DoorDir.POSITIVE);
        this.negQueue = new OccQueue(kb, door, DoorDir.NEGATIVE);
    }

    public OccQueue getQueue(DoorDir dir) {
        switch (dir) {
            case POSITIVE: {
                return this.posQueue;
            }
            case NEGATIVE: {
                return this.negQueue;
            }
        }
        assert (false);
        return null;
    }

    public void reset(KB kb) {
        this.posQueue.reset(kb);
        this.negQueue.reset(kb);
    }

    public void finish(KB kb) {
        this.posQueue.finish(kb, this.door);
        this.negQueue.finish(kb, this.door);
    }

    public static class OccQueue
    implements Serializable {
        private static final long serialVersionUID = 2347127239847234234L;
        public final ANode door;
        public final DoorDir dir;
        private DoorFlowrate d_flowrate;
        private List<OccDist> d_occs;
        private Map<OccAgent, Integer> d_positions;
        private int d_queueBegin;
        private boolean doorOpen;

        public OccQueue(KB kb, ANode door, DoorDir dir) {
            this.door = door;
            this.dir = dir;
            this.doorOpen = !door.isPhysicallyClosed();
            this.d_flowrate = this.createFlowrate(kb, door, dir);
            this.reset(kb);
        }

        private DoorFlowrate createFlowrate(KB kb, ANode door, DoorDir dir) {
            double f0 = kb.getParams().door_flowrate_f0;
            double Q = kb.getParams().door_flowrate_Q;
            return new DoorFlowrate(kb, door, dir, f0, Q);
        }

        public DoorFlowrate newFilteredFlowrate(KB kb, double f0, double Q) {
            return new DoorFlowrate(kb, this.door, this.dir, f0, Q);
        }

        public DoorFlowrate getFlowrate() {
            return this.d_flowrate;
        }

        public int getQueueBegin() {
            return this.d_queueBegin;
        }

        public OccDist get(int ix) {
            return this.d_occs.get(ix);
        }

        public int size() {
            return this.d_occs.size();
        }

        public int getQueuePosition(OccAgent agent, double distToDoor) {
            int ipos;
            int cachedPos;
            DoorQueue.QueuePosition qpos = this.door.doorQueue.getPosition(agent);
            if (qpos != null && qpos.dir == this.dir) {
                return qpos.pos;
            }
            int pos = this.find(new OccDist(agent, distToDoor, -1));
            if (pos < 0 && (cachedPos = this.indexOf(agent)) >= 0 && cachedPos < (ipos = -pos - 1)) {
                ++pos;
            }
            return pos;
        }

        private int indexOf(OccAgent agent) {
            Integer ix = this.d_positions.get(agent);
            return ix == null ? -1 : ix;
        }

        private int find(OccDist dist) {
            return Collections.binarySearch(this.d_occs, dist, OccDistComparator.INSTANCE);
        }

        public void reset(KB kb) {
            if (this.d_occs == null || !this.d_occs.isEmpty() || this.d_occs == Collections.EMPTY_LIST) {
                this.d_queueBegin = -1;
                this.d_occs = new ArrayList<OccDist>();
                this.d_positions = Collections.emptyMap();
            }
            if (this.door.isPhysicallyClosed() == this.doorOpen) {
                boolean bl = this.doorOpen = !this.door.isPhysicallyClosed();
                if (this.doorOpen) {
                    this.d_flowrate = this.createFlowrate(kb, this.door, this.dir);
                }
            }
        }

        protected void add(OccAgent agent, double dist) {
            DoorQueue.QueuePosition qpos = this.door.doorQueue.getPosition(agent);
            int qposLoc = -1;
            if (qpos != null && qpos.dir == this.dir) {
                qposLoc = qpos.pos;
                dist = 0.0;
            }
            this.d_occs.add(new OccDist(agent, dist, qposLoc));
        }

        protected void finish(KB kb, ANode door) {
            int begin;
            Collections.sort(this.d_occs, OccDistComparator.INSTANCE);
            this.d_positions = !this.d_occs.isEmpty() ? new IdentityHashMap(this.d_occs.size()) : Collections.emptyMap();
            int ix = 0;
            for (OccDist od : this.d_occs) {
                this.d_positions.put(od.occ, ix++);
            }
            if (this.d_occs.isEmpty()) {
                this.d_occs = Collections.emptyList();
            }
            if ((begin = OccQueue.findFirstNonMoving(kb, this.d_occs, 0, this.d_occs.size(), 1, door)) == this.d_occs.size()) {
                begin = -1;
            }
            this.d_queueBegin = begin;
            this.d_flowrate.record(kb, this.d_queueBegin != -1);
        }

        private static int findFirstNonMoving(KB kb, List<OccDist> occs, int beginIx, int endIx, int dir, ANode door) {
            for (int m = beginIx; m != endIx; m += dir) {
                OccDist od = occs.get(m);
                if (!OccQueue.isQueuing(kb, od.occ, door)) continue;
                return m;
            }
            return endIx;
        }

        public boolean occsCloserThan(double dist) {
            if (this.d_occs.isEmpty()) {
                return false;
            }
            return this.d_occs.get((int)0).dist <= dist;
        }

        public static boolean isQueuing(KB kb, OccAgent agent, ANode door) {
            return OccQueue.isQueuing(kb, agent, 0.0, 0.1, 2.0, door);
        }

        public static boolean isQueuing(KB kb, OccAgent agent, double tCurrQueueChosen, double tVelScale, double tVAvg, ANode door) {
            if (kb.getParams().handle_collisions && agent.getAvoidOcc() == null && door != null && !door.isClosed(kb, agent)) {
                return false;
            }
            double tSpeedup = OccAgent.calcSpeedupTime(-agent.getOcc().maxVel, agent.getOcc().maxVel, agent.getMaxStartAccel(kb));
            double tCurr = kb.getCurrentSimTime();
            if (tCurr - tCurrQueueChosen < tSpeedup + tVAvg) {
                return false;
            }
            double speed = agent.getAverageSpeedAlongPath(kb, tVAvg);
            return theUtil.le(speed, tVelScale * (double)agent.getOcc().maxVel, 1.0E-6);
        }
    }

    protected static class QueueFlowrate
    implements Serializable {
        static final long serialVersionUID = 1L;
        private final double d_defFlowrate;
        private final ISignalFilter d_filter;
        private double d_flowrate;

        public QueueFlowrate(double f0, double Q, double dt, double defFlowrate, double initFlowrate) {
            this.d_filter = EQBiquadFilter.lfp(f0, 1.0 / dt, Q, initFlowrate);
            this.d_defFlowrate = defFlowrate;
            this.d_flowrate = initFlowrate;
        }

        public double record(double flowrate, boolean queueExists) {
            if (!queueExists) {
                flowrate = Math.max(flowrate, this.d_defFlowrate);
            }
            this.d_flowrate = this.d_filter.filter(flowrate);
            return this.d_flowrate;
        }

        public double get() {
            return this.d_flowrate;
        }
    }

    public static class DoorFlowrate
    implements Serializable {
        private static final long serialVersionUID = 2347127239847234234L;
        public final ANode door;
        public final DoorDir dir;
        private final double d_dt;
        private double d_lastRecordTime;
        private double d_lastUsage;
        private final double d_nominalFlowrate;
        private final QueueFlowrate d_optimisticFlowrate;
        private final QueueFlowrate d_actualFlowrate;

        public DoorFlowrate(KB kb, ANode door, DoorDir dir, double f0, double Q) {
            this.door = door;
            this.dir = dir;
            this.d_dt = kb.getParams().door_queue_update_interval;
            this.d_lastUsage = door.doorQueue.getUsage(dir).get();
            this.d_lastRecordTime = kb.getCurrentSimTime();
            this.d_nominalFlowrate = door.doorQueue.getNominalFlowrate(kb, dir);
            this.d_optimisticFlowrate = new QueueFlowrate(f0, Q, this.d_dt, this.d_nominalFlowrate, this.d_nominalFlowrate);
            this.d_actualFlowrate = new QueueFlowrate(f0, Q, this.d_dt, 0.0, 0.0);
        }

        public double getNominal() {
            return this.d_nominalFlowrate;
        }

        public double getActual() {
            return this.d_actualFlowrate.get();
        }

        public double getOptimistic() {
            return this.d_optimisticFlowrate.get();
        }

        public void record(KB kb, boolean queueExists) {
            double timeElapsed = kb.getCurrentSimTime() - this.d_lastRecordTime;
            double numDt = timeElapsed / this.d_dt;
            numDt = theUtil.eq(numDt, Math.ceil(numDt), 1.0E-6) ? Math.ceil(numDt) : Math.floor(numDt);
            if (numDt > 0.0) {
                double newUsage = (double)this.door.doorQueue.getUsage(this.dir).get() - this.d_lastUsage;
                double flowrate = newUsage / timeElapsed;
                for (int m = 0; m < (int)numDt; ++m) {
                    this.d_actualFlowrate.record(flowrate, queueExists);
                    this.d_optimisticFlowrate.record(flowrate, queueExists);
                }
                double adjustedTimeElapsed = this.d_dt * numDt;
                this.d_lastRecordTime += adjustedTimeElapsed;
                this.d_lastUsage += adjustedTimeElapsed * flowrate;
            }
        }
    }

    private static class OccDistComparator
    implements Comparator<OccDist> {
        public static final OccDistComparator INSTANCE = new OccDistComparator();

        private OccDistComparator() {
        }

        @Override
        public int compare(OccDist o1, OccDist o2) {
            double r2;
            double prec;
            double r1;
            int comp;
            if (o1.doorQueuePos != -1 && o2.doorQueuePos != -1) {
                if (o1.doorQueuePos != o2.doorQueuePos) {
                    return Integer.compare(o1.doorQueuePos, o2.doorQueuePos);
                }
                assert (false);
            } else {
                if (o1.doorQueuePos != -1) {
                    return -1;
                }
                if (o2.doorQueuePos != -1) {
                    return 1;
                }
            }
            return (comp = theUtil.compare(r1 = (double)Math.round(o1.dist * (prec = 100000.0)) / prec, r2 = (double)Math.round(o2.dist * prec) / prec, 1.0E-6)) == 0 ? Integer.compare(o1.occ.getOcc().id, o2.occ.getOcc().id) : comp;
        }
    }

    public static class OccDist
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final OccAgent occ;
        public final double dist;
        public final int doorQueuePos;

        public OccDist(OccAgent occ, double dist, int doorQueuePos) {
            this.occ = occ;
            this.dist = dist;
            this.doorQueuePos = doorQueuePos;
        }
    }
}

