/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output.json;

import inferno.data2.PredefTag;
import inferno.data2.Tag;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccStats;
import inferno.sim.Param;
import inferno.sim.output.OccDataCumulativeWriter;
import inferno.sim.output.json.AJsonInfoWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.function.Supplier;
import thunderheadeng.util.theUtil;

public class OccDataCumulativeWriterJson
extends AJsonInfoWriter {
    public static boolean isWriterEnabled(KB kb) {
        return true;
    }

    public OccDataCumulativeWriterJson(KB kb) {
        super(kb, false);
    }

    @Override
    public void open(double t, Param params) throws IOException {
        this.getWriter().open(t, new File(params.out_occ_cummulative_json));
    }

    @Override
    public void writeFrame(double t) {
        LinkedHashMap finalData = new LinkedHashMap();
        ArrayList<OccDataCumulativeWriter.TagSummary> tagSummaries = new ArrayList<OccDataCumulativeWriter.TagSummary>();
        for (Tag tag : this.getKb().getTags()) {
            if (tag.isPredefined()) continue;
            boolean everTagged = tag.getAnyWereEverTagged();
            boolean everUntagged = tag.getAnyWereEverUntagged();
            if (!everTagged && !everUntagged) continue;
            tagSummaries.add(new OccDataCumulativeWriter.TagSummary(tag, everTagged, everUntagged));
        }
        OccStats stats = this.getKb().getOccStats();
        Tag exitTag = this.getKb().getPredefTag(PredefTag.EXITED);
        for (OccAgent oa : stats.getAllAgentsEver(this.getKb())) {
            String occId = String.valueOf(oa.getId());
            theUtil.mapPutSubObject(finalData, occId, Keys.ID.get(), String.valueOf(oa.getId()));
            theUtil.mapPutSubObject(finalData, occId, Keys.NAME.get(), oa.getOcc().name);
            theUtil.mapPutSubObject(finalData, occId, Keys.EXIT_TIME.get(), OccDataCumulativeWriterJson.formatDouble(exitTag.getInfo((OccAgent)oa).tLastTagged, 3));
            theUtil.mapPutSubObject(finalData, occId, Keys.ACTIVE_TIME.get(), OccDataCumulativeWriterJson.formatDouble(stats.getActiveTime(oa), 3));
            theUtil.mapPutSubObject(finalData, occId, Keys.CONGESTION_TIME_TOTAL.get(), OccDataCumulativeWriterJson.formatDouble(stats.getSlowTimeTotal(oa), 3));
            theUtil.mapPutSubObject(finalData, occId, Keys.CONGESTION_TIME_MAX_CONT.get(), OccDataCumulativeWriterJson.formatDouble(stats.getSlowTimeMc(oa), 3));
            theUtil.mapPutSubObject(finalData, occId, Keys.CONGESTION_TIME_LEVEL.get(), OccDataCumulativeWriterJson.formatDouble(stats.getOpenSlowTimeTotal(oa), 3));
            theUtil.mapPutSubObject(finalData, occId, Keys.CONGESTION_TIME_STAIR.get(), OccDataCumulativeWriterJson.formatDouble(stats.getStairsSlowTimeTotal(oa), 3));
            theUtil.mapPutSubObject(finalData, occId, Keys.CONGESTION_TIME_RAMP.get(), OccDataCumulativeWriterJson.formatDouble(stats.getRampsSlowTimeTotal(oa), 3));
            theUtil.mapPutSubObject(finalData, occId, Keys.START_TIME.get(), OccDataCumulativeWriterJson.formatDouble(stats.getStartTime(oa), 3));
            theUtil.mapPutSubObject(finalData, occId, Keys.FINISH_TIME.get(), OccDataCumulativeWriterJson.formatDouble(stats.getFinishTime(oa), 3));
            theUtil.mapPutSubObject(finalData, occId, Keys.DISTANCE.get(), OccDataCumulativeWriterJson.formatDouble(stats.getTravelDistance(oa), 3));
            theUtil.mapPutSubObject(finalData, occId, Keys.TRIGGER_USAGE.get(), stats.getNumAttractorsUsed(oa));
            theUtil.mapPutSubObject(finalData, occId, Keys.TRIGGER_TIME.get(), OccDataCumulativeWriterJson.formatDouble(stats.getTotalAttractorTime(oa), 3));
            theUtil.mapPutSubObject(finalData, occId, Keys.TARGETS_USAGE.get(), stats.getNumOccTargetsUsed(oa));
            theUtil.mapPutSubObject(finalData, occId, Keys.TARGETS_TIME.get(), OccDataCumulativeWriterJson.formatDouble(stats.getTotalOccTargetTime(oa), 3));
            LinkedHashMap tags = new LinkedHashMap();
            for (OccDataCumulativeWriter.TagSummary tag : tagSummaries) {
                String name = theUtil.toCamelCase(tag.tag.name);
                Tag.Info tagInfo = tag.tag.getInfo(oa);
                if (tag.tagged && tag.untagged) {
                    theUtil.mapPutSubObject(tags, tag.tag.name, Keys.TAG_TOTAL_USAGE.get(), OccDataCumulativeWriterJson.formatDouble(tagInfo.getTAccum(t), 2));
                    theUtil.mapPutSubObject(tags, tag.tag.name, Keys.TAG_ADDED_TIME.get(), OccDataCumulativeWriterJson.formatDouble(tagInfo.tLastTagged, 2));
                    theUtil.mapPutSubObject(tags, tag.tag.name, Keys.TAG_REMOVED_TIME.get(), OccDataCumulativeWriterJson.formatDouble(tagInfo.tLastUntagged, 2));
                    continue;
                }
                if (tag.tagged) {
                    theUtil.mapPutSubObject(tags, tag.tag.name, Keys.TAG_ADDED_TIME.get(), OccDataCumulativeWriterJson.formatDouble(tagInfo.tLastTagged, 2));
                    continue;
                }
                if (!tag.untagged) continue;
                theUtil.mapPutSubObject(tags, tag.tag.name, Keys.TAG_REMOVED_TIME.get(), OccDataCumulativeWriterJson.formatDouble(tagInfo.tLastUntagged, 2));
            }
            theUtil.mapPutSubObject(finalData, occId, Keys.TAGS.get(), tags);
        }
        this.getWriter().add(finalData);
    }

    @Override
    public void consolidate() {
    }

    private static enum Keys implements Supplier<String>
    {
        ID("id"),
        NAME("name"),
        EXIT_TIME("exitTime"),
        ACTIVE_TIME("activeTime"),
        CONGESTION_TIME_TOTAL("congestionTimeTotal"),
        CONGESTION_TIME_MAX_CONT("congestionTimeMaxContinuous"),
        CONGESTION_TIME_LEVEL("congestionTimeLevel"),
        CONGESTION_TIME_STAIR("congestionTimeStair"),
        CONGESTION_TIME_RAMP("congestionTimeRamp"),
        START_TIME("startTime"),
        FINISH_TIME("finishTime"),
        DISTANCE("distance"),
        TAGS("tags"),
        TAG_TOTAL_USAGE("usageTime"),
        TAG_ADDED_TIME("lastAdded"),
        TAG_REMOVED_TIME("lastRemoved"),
        TRIGGER_USAGE("numTriggersUsed"),
        TRIGGER_TIME("triggerTime"),
        TARGETS_USAGE("numTargetsUsed"),
        TARGETS_TIME("targetTime");

        private final String d_val;

        private Keys(String val) {
            this.d_val = val;
        }

        public String toString() {
            return this.d_val.toString();
        }

        @Override
        public String get() {
            return this.d_val;
        }
    }
}

