/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output.json;

import inferno.sim.KB;
import inferno.sim.OccGroup;
import inferno.sim.Param;
import inferno.sim.output.json.AJsonInfoWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class GroupInfoWriterJson
extends AJsonInfoWriter {
    public static boolean isWriterEnabled(KB kb) {
        return true;
    }

    public GroupInfoWriterJson(KB kb) {
        super(kb, true);
    }

    @Override
    public void open(double t, Param params) throws IOException {
        this.getWriter().open(t, new File(params.out_groups_json));
    }

    @Override
    public void writeFrame(double t) {
        LinkedHashMap<String, Serializable> groupFrame = new LinkedHashMap<String, Serializable>();
        ArrayList currentGroups = new ArrayList();
        for (OccGroup group : this.getKb().getOccupantGroups()) {
            if (!group.isReady()) continue;
            LinkedHashMap<String, Object> groupInfo = new LinkedHashMap<String, Object>();
            List groupMemberIDs = group.getMembers().stream().map(agent -> Integer.toString(agent.getOcc().getId())).collect(Collectors.toList());
            groupInfo.put(Keys.GROUP_ID.get(), String.valueOf(group.getID()));
            groupInfo.put(Keys.MEMBER_IDS.get(), groupMemberIDs);
            groupInfo.put(Keys.GROUP_NAME.get(), group.groupName);
            if (group.type != null) {
                groupInfo.put(Keys.GROUP_TYPE.get(), group.type.groupTypeName);
            }
            currentGroups.add(groupInfo);
        }
        groupFrame.put(Keys.TIME.get(), Double.valueOf(t));
        groupFrame.put(Keys.GROUPS.get(), currentGroups);
        this.getWriter().add(groupFrame);
    }

    @Override
    public void consolidate() {
        LinkedHashMap<String, LinkedHashMap> finalData = new LinkedHashMap<String, LinkedHashMap>();
        ArrayList<Map<String, Object>> groupData = this.getWriter().readTempJsonData();
        for (Map<String, Object> frame : groupData) {
            double time = (Double)frame.get(Keys.TIME.get());
            ArrayList groups = (ArrayList)frame.get(Keys.GROUPS.get());
            for (Map group : groups) {
                String id = (String)group.get(Keys.GROUP_ID.get());
                ArrayList members = (ArrayList)group.get(Keys.MEMBER_IDS.get());
                String name = (String)group.get(Keys.GROUP_NAME.get());
                String template = (String)group.get(Keys.GROUP_TYPE.get());
                LinkedHashMap data = new LinkedHashMap();
                if (finalData.containsKey(id)) {
                    data = (LinkedHashMap)finalData.get(id);
                    memberData = (LinkedHashMap<Double, ArrayList>)data.get(Keys.MEMBER_IDS.get());
                    memberData.put(time, members);
                    data.put(Keys.MEMBER_IDS.get(), memberData);
                } else {
                    data.put(Keys.GROUP_ID.get(), id);
                    data.put(Keys.GROUP_NAME.get(), name);
                    if (template != null) {
                        data.put(Keys.GROUP_TYPE.get(), template);
                    }
                    memberData = new LinkedHashMap<Double, ArrayList>();
                    memberData.put(time, members);
                    data.put(Keys.MEMBER_IDS.get(), memberData);
                }
                finalData.put(id, data);
            }
        }
        this.getWriter().add(finalData);
    }

    private static enum Keys implements Supplier<String>
    {
        GROUP_ID("id"),
        GROUPS("groups"),
        GROUP_NAME("name"),
        GROUP_TYPE("template"),
        MEMBER_IDS("members"),
        TIME("time");

        private final String d_val;

        private Keys(String val) {
            this.d_val = val;
        }

        public String toString() {
            return this.d_val.toString();
        }

        @Override
        public String get() {
            return this.d_val;
        }
    }
}

