/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.InfernoPrefs;
import inferno.data2.ANode;
import inferno.data2.AttractorSim;
import inferno.data2.OccTarget;
import inferno.data2.Tag;
import inferno.sim.BehaviorSim;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccProfileSim;
import inferno.sim.OccStats;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.output.TsvOutput;
import inferno.sim.profiling.TimeAccum;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import merlin.Intl;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.SystemProps;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;

public class SummaryWriter {
    private static final Logger LOGGER = Logger.getLogger(SummaryWriter.class.getName());
    private static final Function<BehaviorSim, String> FMT_BEHAVIORSIM = obj -> obj.name;
    private static final Function<OccProfileSim, String> FMT_OCCPROFILESIM = obj -> obj.getName();
    private static final NumberFormat formatter = new DecimalFormat("#0.00");

    public static void printSummary(KB kb, TimeAccum timeAccum) throws FileNotFoundException {
        try (PrintStream stream = Output.openTxtStream(kb.getParams().out_summary);){
            SummaryWriter.printSummary(stream, kb, true, timeAccum);
        }
    }

    public static void logSummary(Logger logger, KB kb, TimeAccum timeAccum) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            String charset = "UTF-8";
            PrintStream pstream = new PrintStream((OutputStream)stream, false, charset);
            SummaryWriter.printSummary(pstream, kb, false, timeAccum);
            pstream.flush();
            LOGGER.info(new String(stream.toByteArray(), charset));
        }
    }

    public static void printSummary(PrintStream strm, KB kb, boolean longform, TimeAccum timeAccum) {
        int usage;
        OccStats stats = kb.getOccStats();
        Function<OccAgent, String> printAgent = a -> a != null ? "\"" + a.getName() + "\"" : "";
        strm.println();
        strm.println((Object)Headers.SUMMARY);
        strm.println();
        strm.printf(Intl.intl("Simulation:         %s%n"), SummaryWriter.getBaseName(kb));
        strm.printf(Intl.intl("Scenario:           %s%n"), SummaryWriter.getScenarioName(kb));
        strm.printf(Intl.intl("Version:            %s%n"), "2025.1.0728");
        strm.printf(Intl.intl("Mode:               %s%n"), SummaryWriter.getModeDesc(kb));
        strm.printf(Intl.intl("Total Occupants:    %d%n"), kb.getOccs().size());
        strm.println();
        Collection<Tag> completionTags = kb.getCompletionTags();
        List<OccAgent> completedAgents = theUtil.map(kb.getCompletedOccs(), p -> (OccAgent)p.v1);
        if (completedAgents.size() < kb.getAllAgentsEver().size()) {
            int completed = completedAgents.size();
            int didNotComplete = kb.getAllAgentsEver().size() - completed;
            strm.printf(Intl.intl("  Completed:          %d%n"), completed);
            strm.printf(Intl.intl("  Did not Complete:   %d (excluded from summary tables)%n"), didNotComplete);
        }
        strm.println();
        OccStats.ValueFunction<OccAgent> compTime = oa -> kb.getTagTime((OccAgent)oa, completionTags);
        OccStats.QuantityStats<OccAgent> compTimes = OccStats.QuantityStats.getStats(completedAgents, compTime);
        strm.printf("%s%n", new Object[]{Headers.COMPLETION_TIMES_ALL_OCCS});
        strm.printf(Intl.intl("  Min:              %5.1f %s%n"), compTimes.min, printAgent.apply((OccAgent)compTimes.minElement));
        strm.printf(Intl.intl("  Max:              %5.1f %s%n"), compTimes.max, printAgent.apply((OccAgent)compTimes.maxElement));
        strm.printf(Intl.intl("  Average:          %5.1f%n"), compTimes.avg);
        strm.printf(Intl.intl("  StdDev:           %5.1f%n"), compTimes.stddev);
        strm.println();
        Function groupByBehavior = oa -> Collections.singleton(oa.getOcc().behavior);
        Function groupByProfile = oa -> Collections.singleton(oa.getOcc().parentProfile);
        strm.println((Object)Headers.COMPLETION_TIMES_BY_BEHAVIOR);
        SummaryWriter.printTsvReport(strm, new GroupStatInfo<BehaviorSim>(Intl.intl("*all behaviors*"), completedAgents, groupByBehavior, FMT_BEHAVIORSIM, SummaryWriter.getCmpBehaviorSim(FMT_BEHAVIORSIM, kb), (oa, behavior) -> compTime.getValue((OccAgent)oa), compTime), Intl.intl("Behavior"));
        strm.println((Object)Headers.COMPLETION_TIMES_BY_PROFILE);
        SummaryWriter.printTsvReport(strm, new GroupStatInfo<OccProfileSim>(Intl.intl("*all profiles*"), completedAgents, groupByProfile, FMT_OCCPROFILESIM, SummaryWriter.getCmpOccProfileSim(FMT_OCCPROFILESIM, kb), (oa, behavior) -> compTime.getValue((OccAgent)oa), compTime), Intl.intl("Profile"));
        OccStats.QuantityStats<OccAgent> travelDistances = stats.getTravelDistanceStats(kb);
        strm.printf("%s%n", new Object[]{Headers.TRAVEL_DISTANCE_ALL_OCCS});
        strm.printf(Intl.intl("  Min:              %5.1f %s%n"), travelDistances.min, printAgent.apply((OccAgent)travelDistances.minElement));
        strm.printf(Intl.intl("  Max:              %5.1f %s%n"), travelDistances.max, printAgent.apply((OccAgent)travelDistances.maxElement));
        strm.printf(Intl.intl("  Average:          %5.1f%n"), travelDistances.avg);
        strm.printf(Intl.intl("  StdDev:           %5.1f%n"), travelDistances.stddev);
        strm.println();
        OccStats.ValueFunction<OccAgent> travelDist = oa -> oa.getOcc().totalDistanceMeters;
        strm.printf("%s%n", new Object[]{Headers.MOVEMENT_DISTANCE_BY_BEHAVIOR});
        SummaryWriter.printTsvReport(strm, new GroupStatInfo<BehaviorSim>(Intl.intl("*all behaviors*"), completedAgents, groupByBehavior, FMT_BEHAVIORSIM, SummaryWriter.getCmpBehaviorSim(FMT_BEHAVIORSIM, kb), (oa, profile) -> travelDist.getValue((OccAgent)oa), travelDist), Intl.intl("Behavior"));
        strm.printf("%s%n", new Object[]{Headers.MOVEMENT_DISTANCE_BY_PROFILE});
        SummaryWriter.printTsvReport(strm, new GroupStatInfo<OccProfileSim>(Intl.intl("*all profiles*"), completedAgents, groupByProfile, FMT_OCCPROFILESIM, SummaryWriter.getCmpOccProfileSim(FMT_OCCPROFILESIM, kb), (oa, profile) -> travelDist.getValue((OccAgent)oa), travelDist), Intl.intl("Profile"));
        if (!longform) {
            return;
        }
        double startup_time = timeAccum.getTime("STARTUP");
        double cpu_time = timeAccum.getTime("SIMULATION");
        strm.printf(Intl.intl("[Components] All:   %d%n"), kb.getNodes().size());
        strm.printf(Intl.intl("[Components] Doors: %d%n"), kb.getDoorNodes().size());
        strm.printf(Intl.intl("Triangles:          %d%n"), kb.getMesh().getTris().length);
        if (SystemProps.get(InfernoPrefs.INCLUDE_TOUT).booleanValue()) {
            strm.printf(Intl.intl("Startup Time:       %1.1fs%n"), startup_time);
            strm.printf(Intl.intl("CPU Time:           %1.1fs%n"), cpu_time);
        }
        strm.println();
        if (!kb.getRootAttractors().isEmpty()) {
            strm.println();
            strm.println((Object)Headers.ATTRACTOR_USAGE_TIME);
            SummaryWriter.printTsvReport(strm, SummaryWriter.getAttrGroupStatInfo(kb), Intl.intl("Trigger"));
            strm.println();
        }
        if (!kb.getOccTargets().getAll().isEmpty()) {
            strm.println();
            strm.println((Object)Headers.OCCUPANT_TARGET_ACTIVE_USAGE_TIMES);
            SummaryWriter.printTsvReport(strm, SummaryWriter.getActiveOccTargetGroupStats(kb), Intl.intl("Occupant Target"));
            strm.println();
            strm.println((Object)Headers.OCCUPANT_TARGET_RESERVED_TIMES);
            SummaryWriter.printTsvReport(strm, SummaryWriter.getReservedOccTargetGroupStats(kb), Intl.intl("Occupant Target"));
            strm.println();
        }
        strm.println((Object)Headers.DOOR_FLOW_RATES);
        TsvOutput doorFlowRates = new TsvOutput();
        doorFlowRates.addRow(new String[]{Intl.intl("Door"), Intl.intl("First_In"), Intl.intl("Last_Out"), Intl.intl("Last_Out_Name"), Intl.intl("Total_Use"), Intl.intl("Flow_Avg")});
        doorFlowRates.addRow(new String[]{"", "(s)", "(s)", "", "(pers)", "(pers/s)"});
        for (ANode n : kb.getDoorNodes()) {
            double tFirst = n.getTimeFirstPersonEntered();
            double tLast = n.getTimeLastPersonExited();
            String nLast = n.getNameLastPersonExited();
            usage = n.getTotalUsage();
            String flow = "         ";
            if (1.0 < tLast - tFirst) {
                flow = String.format("%9.2f", (double)usage / (tLast - tFirst));
            }
            doorFlowRates.addRow(new String[]{n.annotatedName, String.format("%.1f", tFirst), String.format("%.1f", tLast), nLast != null ? nLast : "     ", Integer.toString(usage), flow});
        }
        strm.println(doorFlowRates.toString());
        strm.println((Object)Headers.ROOM_USAGE);
        TsvOutput roomUsage = new TsvOutput();
        roomUsage.addRow(new String[]{Intl.intl("Room"), Intl.intl("First_In"), Intl.intl("Last_Out"), Intl.intl("Last_Out_Name"), Intl.intl("Total_Use")});
        roomUsage.addRow(new String[]{"", "(s)", "(s)", "", "(pers)"});
        for (ANode n : kb.getNodes()) {
            if (n.isDoor()) continue;
            double tFirst = n.getTimeFirstPersonEntered();
            double tLast = n.getTimeLastPersonExited();
            usage = n.getTotalUsage();
            String nLast = n.getNameLastPersonExited();
            roomUsage.addRow(new String[]{n.annotatedName, String.format("%.1f", tFirst), String.format("%.1f", tLast), nLast != null ? nLast : "     ", Integer.toString(usage)});
        }
        strm.println(roomUsage.toString());
    }

    public static <T> Comparator<T> getNullOrIdentComparator(Class<T> clazz) {
        return (a, b) -> {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return 1;
            }
            if (b == null) {
                return -1;
            }
            return 0;
        };
    }

    public static Comparator<OccProfileSim> getCmpOccProfileSim(Function<OccProfileSim, String> fmt, KB kb) {
        return SummaryWriter.getNullOrIdentComparator(OccProfileSim.class).thenComparing(fmt).thenComparing(obj -> kb.idOfFirstOccUsing((OccProfileSim)obj));
    }

    public static Comparator<BehaviorSim> getCmpBehaviorSim(Function<BehaviorSim, String> fmt, KB kb) {
        return SummaryWriter.getNullOrIdentComparator(BehaviorSim.class).thenComparing(fmt).thenComparing(obj -> kb.idOfFirstOccUsing((BehaviorSim)obj));
    }

    public static Comparator<AttractorSim> getCmpAttractorSim(Function<AttractorSim, String> fmt) {
        return SummaryWriter.getNullOrIdentComparator(AttractorSim.class).thenComparing(fmt).thenComparing(obj -> obj.getId());
    }

    public static Comparator<OccTarget> getCmpOccTarget(Function<OccTarget, String> fmt) {
        return SummaryWriter.getNullOrIdentComparator(OccTarget.class).thenComparing(fmt).thenComparing(obj -> obj.id);
    }

    private static <T> GroupStatInfo<T> getGroupStatInfoFromTimeMap(KB kb, String allStr, String noneStr, Function<OccStats.PerAgentData, Map<T, Double>> getMap, Function<T, String> getName, Comparator<T> cmpFunc) {
        return new GroupStatInfo<Object>(allStr, kb.getAllAgentsEver(), oa -> ((Map)getMap.apply(oa.getStats())).isEmpty() ? Collections.singleton(null) : ((Map)getMap.apply(oa.getStats())).keySet(), attr -> attr != null ? (String)getName.apply(attr) : noneStr, cmpFunc, (oa, attr) -> attr != null ? ((Map)getMap.apply(oa.getStats())).getOrDefault(attr, 0.0).doubleValue() : kb.getOccStats().getExistanceTime(kb, (OccAgent)oa), oa -> SummaryWriter.getTotalTime((Map)getMap.apply(oa.getStats())));
    }

    private static double getTotalTime(Map<?, Double> timeMap) {
        return timeMap.values().stream().mapToDouble(d -> d).sum();
    }

    private static GroupStatInfo<AttractorSim> getAttrGroupStatInfo(KB kb) {
        Function<AttractorSim, String> fmt = obj -> obj.name;
        return SummaryWriter.getGroupStatInfoFromTimeMap(kb, Intl.intl("*all used triggers*"), Intl.intl("*no triggers*"), stats -> stats.attractorTime, fmt, SummaryWriter.getCmpAttractorSim(fmt));
    }

    private static GroupStatInfo<OccTarget> getActiveOccTargetGroupStats(KB kb) {
        return SummaryWriter.getOccTargetGroupStats(kb, stats -> stats.occTargetTimeActive);
    }

    private static GroupStatInfo<OccTarget> getReservedOccTargetGroupStats(KB kb) {
        return SummaryWriter.getOccTargetGroupStats(kb, stats -> stats.occTargetTimeReserved);
    }

    private static GroupStatInfo<OccTarget> getOccTargetGroupStats(KB kb, Function<OccStats.PerAgentData, Map<OccTarget, Double>> getMap) {
        Function<OccTarget, String> fmt = obj -> obj.name;
        return SummaryWriter.getGroupStatInfoFromTimeMap(kb, Intl.intl("*all used occupant targets*"), Intl.intl("*no occupant targets*"), getMap, fmt, SummaryWriter.getCmpOccTarget(fmt));
    }

    private static <GroupT> void printTsvReport(PrintStream strm, GroupStatInfo<GroupT> gi, String typeName) {
        Function<OccAgent, String> quoteAgent = a -> a != null ? "\"" + a.getName() + "\"" : "";
        String[] statCols = new String[]{typeName, Intl.intl("Count"), Intl.intl("Min"), Intl.intl("Min_Name"), Intl.intl("Max"), Intl.intl("Max_Name"), Intl.intl("Avg"), Intl.intl("StdDev")};
        Map groups = SummaryWriter.getReportingGroups(gi.agents, gi.groupFunc, gi.groupFormatter, gi.groupComparator);
        TsvOutput tsv = new TsvOutput();
        tsv.addRow(statCols);
        TriConsumer<String, Collection, OccStats.QuantityStats> addStats = (groupName, groupAgents, result) -> {
            tsv.addRow(new String[]{groupName, Integer.toString(groupAgents.size()), String.format("%.1f", result.min), (String)quoteAgent.apply((OccAgent)result.minElement), String.format("%.1f", result.max), (String)quoteAgent.apply((OccAgent)result.maxElement), String.format("%.1f", result.avg), String.format("%.1f", result.stddev)});
            if (result.min == 0.0) {
                LOGGER.log(Level.INFO, "...");
            }
        };
        for (Map.Entry entry : groups.entrySet()) {
            Object group = entry.getKey();
            OccStats.QuantityStats<OccAgent> result2 = OccStats.QuantityStats.getStats(entry.getValue(), oa -> gi.valueFunc.apply((OccAgent)oa, group));
            addStats.accept(gi.groupFormatter.apply(group), entry.getValue(), result2);
        }
        addStats.accept(gi.allName, gi.agents, OccStats.QuantityStats.getStats(gi.agents, gi.getAllStats));
        strm.println(tsv.toString());
    }

    public static void printSummaryJson(KB kb, TimeAccum timeAccum) throws FileNotFoundException {
        try (PrintStream strmSummary = Output.openTxtStream(kb.getParams().out_summary_json);){
            JSONObject obj = SummaryWriter.getSummaryAsJson(kb, timeAccum);
            strmSummary.println(obj.toJSONString());
        }
    }

    private static String printAgent(OccAgent a) {
        return a != null ? a.getName() : "";
    }

    public static JSONObject getSummaryAsJson(KB kb, TimeAccum timeAccum) {
        int usage;
        JSONObject obj = new JSONObject();
        obj.put("simulation", SummaryWriter.getBaseName(kb));
        obj.put("scenario", SummaryWriter.getScenarioName(kb));
        obj.put("version", "2025.1.0728");
        obj.put("mode", SummaryWriter.getModeDesc(kb));
        obj.put("total_occupants", kb.getOccs().size());
        obj.put("components_all", kb.getNodes().size());
        obj.put("components_doors", kb.getDoorNodes().size());
        obj.put("triangles", kb.getMesh().getTris().length);
        if (SystemProps.get(InfernoPrefs.INCLUDE_TOUT).booleanValue()) {
            obj.put("startup_time", String.format("%1.1f", timeAccum.getTime("STARTUP")));
            obj.put("cpu_time", String.format("%1.1f", timeAccum.getTime("SIMULATION")));
        }
        Collection<Tag> completionTags = kb.getCompletionTags();
        List<OccAgent> completedAgents = theUtil.map(kb.getCompletedOccs(), p -> (OccAgent)p.v1);
        if (completedAgents.size() < kb.getAllAgentsEver().size()) {
            int completed = completedAgents.size();
            int didNotComplete = kb.getAllAgentsEver().size() - completed;
            obj.put("Completed", completed);
            obj.put("Did not Complete", didNotComplete);
        }
        OccStats.ValueFunction<OccAgent> compTime = oa -> kb.getTagTime((OccAgent)oa, completionTags);
        SummaryWriter.addStatsReportJson(obj, kb, "completion_times_all", "time", OccStats.QuantityStats.getStats(completedAgents, compTime));
        Function groupByBehavior = oa -> Collections.singleton(oa.getOcc().behavior);
        SummaryWriter.addGroupStatsReportJson(obj, new StatsKeys("completion_times_behavior", "behavior", "time"), new GroupStatInfo<BehaviorSim>(Intl.intl("*all behaviors*"), completedAgents, groupByBehavior, FMT_BEHAVIORSIM, SummaryWriter.getCmpBehaviorSim(FMT_BEHAVIORSIM, kb), (oa, group) -> compTime.getValue((OccAgent)oa), compTime));
        Function groupByProfile = oa -> Collections.singleton(oa.getOcc().parentProfile);
        SummaryWriter.addGroupStatsReportJson(obj, new StatsKeys("completion_times_profile", "profile", "time"), new GroupStatInfo<OccProfileSim>(Intl.intl("*all profiles*"), completedAgents, groupByProfile, FMT_OCCPROFILESIM, SummaryWriter.getCmpOccProfileSim(FMT_OCCPROFILESIM, kb), (oa, group) -> compTime.getValue((OccAgent)oa), compTime));
        SummaryWriter.addStatsReportJson(obj, kb, "movement_distances_all", "distance", kb.getOccStats().getTravelDistanceStats(kb));
        OccStats.ValueFunction<OccAgent> travelDist = oa -> oa.getOcc().totalDistanceMeters;
        SummaryWriter.addGroupStatsReportJson(obj, new StatsKeys("movement_distances_behavior", "behavior", "distance"), new GroupStatInfo<BehaviorSim>(Intl.intl("*all behaviors*"), completedAgents, groupByBehavior, FMT_BEHAVIORSIM, SummaryWriter.getCmpBehaviorSim(FMT_BEHAVIORSIM, kb), (oa, group) -> travelDist.getValue((OccAgent)oa), travelDist));
        SummaryWriter.addGroupStatsReportJson(obj, new StatsKeys("movement_distance_profile", "profile", "distance"), new GroupStatInfo<OccProfileSim>(Intl.intl("*all profiles*"), completedAgents, groupByProfile, FMT_OCCPROFILESIM, SummaryWriter.getCmpOccProfileSim(FMT_OCCPROFILESIM, kb), (oa, group) -> travelDist.getValue((OccAgent)oa), travelDist));
        if (!kb.getRootAttractors().isEmpty()) {
            SummaryWriter.addGroupStatsReportJson(obj, new StatsKeys("trigger_usage_time", "trigger", "time"), SummaryWriter.getAttrGroupStatInfo(kb));
        }
        if (!kb.getOccTargets().getAll().isEmpty()) {
            SummaryWriter.addGroupStatsReportJson(obj, new StatsKeys("occupant_locations_active_usage_time", "occupant_location", "time"), SummaryWriter.getActiveOccTargetGroupStats(kb));
            SummaryWriter.addGroupStatsReportJson(obj, new StatsKeys("occupant_locations_reserved_time", "occupant_location", "time"), SummaryWriter.getReservedOccTargetGroupStats(kb));
        }
        JSONArray dfrArray = new JSONArray();
        for (ANode n : kb.getDoorNodes()) {
            double tFirst = n.getTimeFirstPersonEntered();
            double tLast = n.getTimeLastPersonExited();
            String nLast = n.getNameLastPersonExited();
            usage = n.getTotalUsage();
            String flow = "";
            if (1.0 < tLast - tFirst) {
                flow = formatter.format((double)usage / (tLast - tFirst));
            }
            JSONObject doorFlowRateItems = new JSONObject();
            doorFlowRateItems.put("door", n.annotatedName);
            doorFlowRateItems.put("first_in", formatter.format(tFirst));
            doorFlowRateItems.put("last_out", formatter.format(tLast));
            doorFlowRateItems.put("last_out_name", nLast != null ? nLast : "");
            doorFlowRateItems.put("total_use", usage);
            doorFlowRateItems.put("flow_avg", flow);
            dfrArray.add(doorFlowRateItems);
        }
        obj.put("door_flow_rates", dfrArray);
        JSONArray ruArray = new JSONArray();
        for (ANode n : kb.getNodes()) {
            if (n.isDoor()) continue;
            double tFirst = n.getTimeFirstPersonEntered();
            double tLast = n.getTimeLastPersonExited();
            usage = n.getTotalUsage();
            String nLast = n.getNameLastPersonExited();
            JSONObject roomUsageItems = new JSONObject();
            roomUsageItems.put("room", n.annotatedName);
            roomUsageItems.put("first_in", formatter.format(tFirst));
            roomUsageItems.put("last_out", formatter.format(tLast));
            roomUsageItems.put("last_out_name", nLast != null ? nLast : "     ");
            roomUsageItems.put("total_use", usage);
            ruArray.add(roomUsageItems);
        }
        obj.put("room_usage", ruArray);
        return obj;
    }

    private static void addStatsReportJson(JSONObject obj, KB kb, String statsName, String quantityName, OccStats.QuantityStats<OccAgent> travelDistances) {
        JSONObject moveDistance = new JSONObject();
        JSONObject moveDistanceItems = new JSONObject();
        JSONObject movemin = new JSONObject();
        JSONObject moveminItems = new JSONObject();
        moveminItems.put(quantityName, formatter.format(travelDistances.min));
        moveminItems.put("name", SummaryWriter.printAgent((OccAgent)travelDistances.minElement));
        movemin.put("min", moveminItems);
        moveDistanceItems.putAll(movemin);
        JSONObject movemax = new JSONObject();
        JSONObject movemaxItems = new JSONObject();
        movemaxItems.put(quantityName, formatter.format(travelDistances.max));
        movemaxItems.put("name", SummaryWriter.printAgent((OccAgent)travelDistances.maxElement));
        movemax.put("max", movemaxItems);
        moveDistanceItems.putAll(movemax);
        moveDistanceItems.put("average", formatter.format(travelDistances.avg));
        moveDistanceItems.put("stdDev", formatter.format(travelDistances.stddev));
        moveDistance.put(statsName, moveDistanceItems);
        obj.putAll(moveDistance);
    }

    private static <GroupT> void addGroupStatsReportJson(JSONObject obj, StatsKeys statsKeys, GroupStatInfo<GroupT> gi) {
        JSONArray groupArray = new JSONArray();
        Map groupsB = SummaryWriter.getReportingGroups(gi.agents, gi.groupFunc, gi.groupFormatter, gi.groupComparator);
        TriConsumer<String, Collection, OccStats.QuantityStats> addEntry = (groupName, groupAgents, gStats) -> {
            JSONObject minItems = new JSONObject();
            minItems.put(statsKeys.quantityName, formatter.format(gStats.min));
            minItems.put("name", SummaryWriter.printAgent((OccAgent)gStats.minElement));
            JSONObject maxItems = new JSONObject();
            maxItems.put(statsKeys.quantityName, formatter.format(gStats.max));
            maxItems.put("name", SummaryWriter.printAgent((OccAgent)gStats.maxElement));
            JSONObject completeTimeBehaviorItems = new JSONObject();
            completeTimeBehaviorItems.put(statsKeys.groupType, groupName);
            completeTimeBehaviorItems.put("count", groupAgents.size());
            completeTimeBehaviorItems.put("min", minItems);
            completeTimeBehaviorItems.put("max", maxItems);
            completeTimeBehaviorItems.put("avg", formatter.format(gStats.avg));
            completeTimeBehaviorItems.put("stdDev", formatter.format(gStats.stddev));
            groupArray.add(completeTimeBehaviorItems);
        };
        for (Map.Entry entry : groupsB.entrySet()) {
            Object group = entry.getKey();
            OccStats.QuantityStats<OccAgent> groupStats = OccStats.QuantityStats.getStats(entry.getValue(), oa -> gi.valueFunc.apply((OccAgent)oa, group));
            addEntry.accept(gi.groupFormatter.apply(group), entry.getValue(), groupStats);
        }
        addEntry.accept(gi.allName, gi.agents, OccStats.QuantityStats.getStats(gi.agents, gi.getAllStats));
        obj.put(statsKeys.category, groupArray);
    }

    private static <GroupT> Map<GroupT, Collection<OccAgent>> getReportingGroups(Collection<OccAgent> completedAgents, Function<OccAgent, Collection<GroupT>> groupFunc, Function<GroupT, String> groupFormatter, Comparator<GroupT> groupComparator) {
        IdentityHashMap<Object, List> groups = new IdentityHashMap<Object, List>();
        for (OccAgent oa : completedAgents) {
            Collection<GroupT> names = groupFunc.apply(oa);
            for (GroupT name : names) {
                groups.computeIfAbsent(name, key -> new ArrayList()).add(oa);
            }
        }
        ArrayList names = new ArrayList(groups.keySet());
        Collections.sort(names, groupComparator);
        LinkedIdentityHashMap sortedGroups = new LinkedIdentityHashMap();
        for (Object name : names) {
            sortedGroups.put(name, (Collection)groups.remove(name));
        }
        return sortedGroups;
    }

    private static String getBaseName(KB kb) {
        String name = kb.getParams().out_snapshot_base;
        name = name.substring(name.lastIndexOf(System.getProperty("file.separator")) + 1);
        return name;
    }

    private static String getScenarioName(KB kb) {
        return kb.getParams().scenario;
    }

    private static String getModeDesc(KB d_kb) {
        Param d_param = d_kb.getParams();
        if (d_param.reactive_steering) {
            if (d_kb.getQueuingDoors().size() == d_kb.getDoorNodes().size()) {
                return Intl.intl("Steering (Flow-limited)");
            }
            return Intl.intl("Steering");
        }
        return d_param.handle_collisions ? Intl.intl("SFPE (Prevent Collisions)") : Intl.intl("SFPE (Basic)");
    }

    public static enum Headers {
        ATTRACTOR_USAGE_TIME(Intl.intl("Trigger Usage Times (s):")),
        COMPLETION_TIMES_ALL_OCCS(Intl.intl("Completion Times for All Occupants (s):")),
        COMPLETION_TIMES_BY_BEHAVIOR(Intl.intl("Completion Times by Behavior (s):")),
        COMPLETION_TIMES_BY_PROFILE(Intl.intl("Completion Times by Profile (s):")),
        DISTANCE(Intl.intl("Distance (m)")),
        DOOR_FLOW_RATES(Intl.intl("Door Flow Rates:")),
        MOVEMENT_DISTANCE_BY_BEHAVIOR(Intl.intl("Movement Distance by Behavior (m):")),
        MOVEMENT_DISTANCE_BY_PROFILE(Intl.intl("Movement Distance by Profile (m):")),
        OCCUPANT_TARGET_ACTIVE_USAGE_TIMES(Intl.intl("Occupant Target Active Usage Times (s):")),
        OCCUPANT_TARGET_RESERVED_TIMES(Intl.intl("Occupant Target Reserved Times (s):")),
        ROOM_USAGE(Intl.intl("Room Usage:")),
        SUMMARY(Intl.intl("***SUMMARY***SUMMARY***SUMMARY***SUMMARY***SUMMARY***")),
        TIME(Intl.intl("Time (s)")),
        TRAVEL_DISTANCE_ALL_OCCS(Intl.intl("Travel Distances for All Occupants (m):"));

        private String text;

        private Headers(String txt) {
            this.text = txt;
        }

        public String toString() {
            return this.text;
        }
    }

    private static class GroupStatInfo<GroupT> {
        public final String allName;
        public final Collection<OccAgent> agents;
        public final Function<OccAgent, Collection<GroupT>> groupFunc;
        public final Function<GroupT, String> groupFormatter;
        public final Comparator<GroupT> groupComparator;
        public final BiFunction<OccAgent, ? super GroupT, Double> valueFunc;
        public final OccStats.ValueFunction<OccAgent> getAllStats;

        public GroupStatInfo(String allName, Collection<OccAgent> agents, Function<OccAgent, Collection<GroupT>> groupFunc, Function<GroupT, String> groupFormatter, Comparator<GroupT> groupComparator, BiFunction<OccAgent, ? super GroupT, Double> valueFunc, OccStats.ValueFunction<OccAgent> getAllStats) {
            this.allName = allName;
            this.agents = agents;
            this.groupFunc = groupFunc;
            this.groupFormatter = groupFormatter;
            this.groupComparator = groupComparator;
            this.valueFunc = valueFunc;
            this.getAllStats = getAllStats;
        }
    }

    private static class StatsKeys {
        public final String category;
        public final String groupType;
        public final String quantityName;

        public StatsKeys(String category, String groupType, String quantName) {
            this.category = category;
            this.groupType = groupType;
            this.quantityName = quantName;
        }
    }
}

