/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Output;
import inferno.sim.output.TsvOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Point3d;
import merlin.Intl;

public class StuckWriter {
    private static Logger LOGGER = Logger.getLogger(StuckWriter.class.getName());

    public static void deleteStuck(KB kb) {
        try {
            Files.deleteIfExists(Paths.get(kb.getParams().out_stuck, new String[0]));
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to delete stuck occupants summary: %s", e.getMessage());
        }
    }

    public static void printStuck(KB kb) {
        try (PrintStream stream = Output.openTxtStream(kb.getParams().out_stuck);){
            StuckWriter.printStuck(stream, kb);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static void printStuck(PrintStream strm, KB kb) {
        strm.println();
        strm.println(Intl.intl("***POTENTIALLY STUCK OCCUPANTS***"));
        strm.println();
        strm.printf(Intl.intl("Current Time (s):    %s%n"), kb.getCurrentSimTime());
        strm.printf(Intl.intl("Total Occupants:     %d%n"), kb.getOccs().size());
        strm.printf(Intl.intl("Remaining Occupants: %d%n"), kb.getActiveAgents().size());
        strm.println();
        strm.println(Intl.intl("Potentially Stuck Occupants:"));
        TsvOutput remainingOccupants = new TsvOutput();
        remainingOccupants.addRow(new String[]{Intl.intl("ID"), Intl.intl("Name"), Intl.intl("Room"), Intl.intl("X"), Intl.intl("Y"), Intl.intl("Z")});
        for (OccAgent agent : kb.getActiveAgents()) {
            Point3d displayPos = agent.getOcc().getDisplayLoc();
            remainingOccupants.addRow(new String[]{String.valueOf(agent.getId()), agent.getName(), agent.getOcc().curNode.name, String.format("%.2f", displayPos.x), String.format("%.2f", displayPos.y), String.format("%.2f", displayPos.z)});
        }
        strm.println(remainingOccupants.toString());
    }
}

