/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.data2.ANode;
import inferno.elevator.Elevator;
import inferno.elevator.ElevatorLevel;
import inferno.io.CSVWriter;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.output.HeaderWriterFiveRow;
import inferno.sim.output.WriterIntl;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import thunderheadeng.util.IdentityHashSet;

public class RoomUsageWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    private final List<IUsageElement> d_sortedNodes;
    private int d_initialOccupants;
    private KB d_kb;
    private final SerializedOutputStream d_roomUsageStream;
    private CSVWriter d_out;

    public RoomUsageWriter(KB kb) {
        this.d_kb = kb;
        ArrayList<IUsageElement> nodes = new ArrayList<IUsageElement>(kb.getNodes().size());
        IdentityHashSet<ANode> excludeNodes = new IdentityHashSet<ANode>(kb.getDoorNodes());
        excludeNodes.addAll(kb.getElevatorModel().getAllElevatorRooms());
        for (ANode node : kb.getNodes()) {
            if (excludeNodes.contains(node)) continue;
            nodes.add(new NodeUsage(node));
        }
        List<Elevator> elevators = kb.getElevatorModel().getElevators();
        for (Elevator elevator : elevators) {
            ANode dischargeNode = elevator.getTravelingNode();
            ArrayList<ANode> elevatorNodes = new ArrayList<ANode>(elevator.getLevels().size());
            for (ElevatorLevel level : elevator.getLevels()) {
                elevatorNodes.add(level.pickupNode);
            }
            CompositeNodeUsage usage = new CompositeNodeUsage(dischargeNode, elevatorNodes);
            nodes.add(usage);
        }
        Collections.sort(nodes, new Comparator<IUsageElement>(this){

            @Override
            public int compare(IUsageElement o1, IUsageElement o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.d_sortedNodes = nodes;
        this.d_initialOccupants = kb.getAgents().size();
        this.d_roomUsageStream = new SerializedOutputStream(kb.getParams().out_room_usage);
        this.d_out = new CSVWriter();
    }

    public void open(Param params) throws FileNotFoundException {
        this.d_out.open(Output.openTxtStream(this.d_roomUsageStream));
    }

    @Override
    public void close() throws IOException {
        this.d_out.close();
    }

    public void writeHeader() {
        HeaderWriterFiveRow headerWriter = new HeaderWriterFiveRow(this.d_sortedNodes.size() + 3);
        headerWriter.addCol(Header.VERSION);
        headerWriter.addCol(Header.TIME);
        headerWriter.addCol(Header.REMAINING_TOTAL);
        headerWriter.addCol(Header.EXITED_TOTAL);
        for (IUsageElement n : this.d_sortedNodes) {
            headerWriter.addCol(Header.OCCUPANT_COUNT, n.getResultsId(), n.getName());
        }
        headerWriter.flushTo(this.d_out);
        this.d_out.flush();
    }

    public void writeFrame(double t) {
        int exitCount = 0;
        for (IUsageElement n : this.d_sortedNodes) {
            exitCount += n.getExitedVia();
        }
        this.d_out.addEmpty();
        this.d_out.add(t, 2);
        this.d_out.add(this.d_kb.getAllAgentsEver().size() - exitCount);
        this.d_out.add(exitCount);
        for (IUsageElement n : this.d_sortedNodes) {
            this.d_out.add(n.getNumOccupants());
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    public static class NodeUsage
    implements IUsageElement,
    Serializable {
        static final long serialVersionUID = 1L;
        public final ANode node;

        public NodeUsage(ANode node) {
            this.node = node;
        }

        @Override
        public String getName() {
            return this.node.annotatedName;
        }

        @Override
        public Long getResultsId() {
            return this.node.getResultsID();
        }

        @Override
        public int getNumOccupants() {
            return this.node.getNumOccupants();
        }

        @Override
        public int getExitedVia() {
            return this.node.getExitedVia();
        }
    }

    public static class CompositeNodeUsage
    implements IUsageElement,
    Serializable {
        static final long serialVersionUID = 1L;
        public ANode primary;
        public List<ANode> nodes;

        public CompositeNodeUsage(ANode primary, Collection<ANode> nodes) {
            this.primary = primary;
            this.nodes = new ArrayList<ANode>(nodes);
        }

        @Override
        public String getName() {
            return this.nodes.get((int)0).annotatedName;
        }

        @Override
        public Long getResultsId() {
            return this.primary.getResultsID();
        }

        @Override
        public int getNumOccupants() {
            int count = 0;
            for (ANode node : this.nodes) {
                count += node.getNumOccupants();
            }
            return count;
        }

        @Override
        public int getExitedVia() {
            return this.primary.getExitedVia();
        }
    }

    public static enum Header implements WriterIntl.IColHeader
    {
        VERSION(WriterIntl.intl("TeciVersion=1")),
        TIME(WriterIntl.intl("Time"), WriterIntl.intl("Time"), WriterIntl.intl("s")),
        REMAINING_TOTAL(WriterIntl.intl("Remaining (Total)"), WriterIntl.intl("Occupants")),
        EXITED_TOTAL(WriterIntl.intl("Exited (Total)"), WriterIntl.intl("Occupants")),
        OCCUPANT_COUNT(WriterIntl.intl("Occupant Count"), WriterIntl.intl("Occupants"));

        public final WriterIntl.ColHeaderString desc;
        public final WriterIntl.ColHeaderString quantity;
        public final WriterIntl.ColHeaderString unit;

        private Header(WriterIntl.ColHeaderString desc) {
            this(desc, new WriterIntl.ColHeaderString(""), new WriterIntl.ColHeaderString(""));
        }

        private Header(WriterIntl.ColHeaderString desc, WriterIntl.ColHeaderString unitlessQuantity) {
            this(desc, unitlessQuantity, new WriterIntl.ColHeaderString(""));
        }

        private Header(WriterIntl.ColHeaderString desc, WriterIntl.ColHeaderString quantity, WriterIntl.ColHeaderString unit) {
            this.desc = desc;
            this.quantity = quantity;
            this.unit = unit;
        }

        public String toString() {
            return this.desc.toString();
        }

        @Override
        public final WriterIntl.ColHeaderString desc() {
            return this.desc;
        }

        @Override
        public WriterIntl.ColHeaderString quantity() {
            return this.quantity;
        }

        @Override
        public WriterIntl.ColHeaderString unit() {
            return this.unit;
        }
    }

    public static interface IUsageElement {
        public String getName();

        public Long getResultsId();

        public int getNumOccupants();

        public int getExitedVia();
    }
}

