/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.occsource;

import inferno.data2.value.IFunction1d;
import inferno.sim.KB;
import inferno.sim.occsource.IOccSourceFlowrate;
import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import org.json.simple.JSONObject;
import thunderheadeng.io.JsonUtil;

public class AUCOccSourceFlowrate
implements IOccSourceFlowrate,
Serializable {
    private static final long serialVersionUID = 1L;
    public final IFunction1d flowrateFunc;
    private int d_numReleasedOccs = 0;

    public AUCOccSourceFlowrate(IFunction1d flowrate) {
        this.flowrateFunc = flowrate;
    }

    @Override
    public int releaseOccs(KB kb, double dt) {
        double currentSimTime = kb.getCurrentSimTime();
        int toRelease = (int)Math.round(this.flowrateFunc.getAUC(0.0, currentSimTime + dt) - (double)this.d_numReleasedOccs);
        this.d_numReleasedOccs += toRelease;
        return toRelease;
    }

    @Override
    public int getMaxCount(double maxTime) {
        return (int)Math.round(this.flowrateFunc.getAUC(0.0, maxTime));
    }

    @Override
    public boolean isFlowing(KB kb) {
        return this.flowrateFunc.get(kb.getCurrentSimTime()) > 0.0;
    }

    @Override
    public double getEndTime(KB kb) {
        return this.flowrateFunc.getEndX();
    }

    @Override
    public void getFunctions(Consumer<? super IFunction1d> functions) {
        functions.accept(this.flowrateFunc);
    }

    @Override
    public JSONObject toJson(ToIntFunction<IFunction1d> distIndex) {
        JSONObject jobj = new JSONObject();
        jobj.put("type", "auc");
        jobj.put("function", distIndex.applyAsInt(this.flowrateFunc));
        return jobj;
    }

    public static AUCOccSourceFlowrate fromJson(JSONObject jobj, IntFunction<IFunction1d> functions) throws Exception {
        Object type = jobj.get("type");
        if (!type.equals("auc")) {
            throw new Exception();
        }
        IFunction1d func = functions.apply(JsonUtil.getInt(jobj, "function"));
        return new AUCOccSourceFlowrate(func);
    }
}

