/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import common.geom.Intersect;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Pair;

public class VehicleBody
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double PROTECT_ATTACHED_AGENTS_MARGIN = 0.2;
    public final String name;
    public final Point3d[] innerPoints;
    public final Point3d[] outerPoints;
    public final double width;
    public final double length;
    public final double outerWidth;
    public final double outerLength;
    public final double enclosingRadius;
    public final double enclosingOuterRadius;
    public final double distToFrontInner;
    public final double distToFrontOuter;
    public final double radiusUnattached;
    public final double radiusAttached;
    public final List<Point3d> staticAttachedAgentsPositions;
    public final double height;
    public final Set<String> occAnimTags;
    public final Point3d occAvatarOffset;
    public final String avatar;
    public final Point3d origin;
    public final int maxDistPoint;
    public final double area;
    public final boolean allowLateral;

    public VehicleBody(String name, Point3d origin, Point3d[] bodyShapePoints, double height, boolean allowLateral, List<Point3d> attachments, Set<String> occAnimTags, Point3d occAvatarOffset, String avatar) {
        Point3d pivot = GeomConstants.PNT3D_ORIGIN;
        this.name = name;
        this.occAnimTags = occAnimTags;
        this.avatar = avatar;
        this.allowLateral = allowLateral;
        Point3d removeNegZero = new Point3d(0.0, 0.0, 0.0);
        this.origin = origin.equals(removeNegZero) ? removeNegZero : origin;
        this.occAvatarOffset = occAvatarOffset;
        this.staticAttachedAgentsPositions = attachments;
        this.height = height;
        this.innerPoints = bodyShapePoints;
        this.radiusUnattached = VehicleBody.computeRadius(pivot, this.innerPoints);
        Pair<Double, Integer> radius = VehicleBody.calcEnclosingRadius(pivot, this.innerPoints);
        this.enclosingRadius = (Double)radius.v1;
        this.maxDistPoint = (Integer)radius.v2;
        this.outerPoints = VehicleBody.calcOuterPoints(this.innerPoints, this.staticAttachedAgentsPositions);
        this.radiusAttached = VehicleBody.computeRadius(pivot, this.outerPoints);
        this.enclosingOuterRadius = (Double)VehicleBody.calcEnclosingRadius((Point3d)pivot, (Point3d[])this.outerPoints).v1;
        AABox innerBounds = VehicleBody.calcBounds(this.innerPoints);
        this.length = innerBounds.getWidth();
        this.width = innerBounds.getDepth();
        AABox outerBounds = VehicleBody.calcBounds(this.outerPoints);
        this.outerLength = outerBounds.getWidth();
        this.outerWidth = outerBounds.getDepth();
        AABox innerBoundsPivot = new AABox(innerBounds);
        innerBoundsPivot.add(pivot);
        this.distToFrontInner = innerBoundsPivot.getMaxX();
        AABox outerBoundsPivot = new AABox(outerBounds);
        outerBoundsPivot.add(pivot);
        this.distToFrontOuter = outerBoundsPivot.getMaxX();
        this.area = Util3D.simplePolygonArea(Arrays.asList(bodyShapePoints));
    }

    private static AABox calcBounds(Point3d[] points) {
        AABox innerBounds = new AABox(points);
        return innerBounds;
    }

    public static double computeRadius(Point3d pivot, Point3d[] points) {
        double radius = 0.0;
        for (int i = 0; i < points.length; ++i) {
            Point3d p = points[i];
            double dist = Math.abs(p.y - pivot.y);
            if (!(dist > radius)) continue;
            radius = dist;
        }
        return radius;
    }

    public int getRequiredAttachedAgentsCount() {
        return this.staticAttachedAgentsPositions.size();
    }

    public double getRadius(boolean isAttached) {
        return isAttached ? this.radiusAttached : this.radiusUnattached;
    }

    public Point3d[] getStaticOuterPoints() {
        return this.outerPoints;
    }

    public Point3d[] getStaticInnerPoints() {
        return this.innerPoints;
    }

    public List<Point3d> getStaticAttachedAgentsPositions() {
        return this.staticAttachedAgentsPositions;
    }

    public static Point3d getCenter(Point3d[] points) {
        Point3d center = new Point3d(0.0, 0.0, 0.0);
        for (Point3d p : points) {
            center.add(p);
        }
        center.scale(1.0 / (double)points.length);
        return center;
    }

    public static Point3d[] calcOuterPoints(Point3d[] innerPoints, List<Point3d> staticAttachedAgentsPositions) {
        assert (innerPoints != null && staticAttachedAgentsPositions != null);
        Point3d bodyFrameOrigin = VehicleBody.getCenter(innerPoints);
        Point3d[] allPoints = new Point3d[innerPoints.length + staticAttachedAgentsPositions.size()];
        for (int i = 0; i < allPoints.length; ++i) {
            if (i < innerPoints.length) {
                allPoints[i] = innerPoints[i];
                continue;
            }
            Point3d p = staticAttachedAgentsPositions.get(i - innerPoints.length);
            Vector3d extend = new Vector3d(p);
            extend.sub(bodyFrameOrigin);
            extend.normalize();
            extend.scale(0.2);
            Point3d newP = new Point3d(p);
            newP.add(extend);
            allPoints[i] = newP;
        }
        return Intersect.findConvexHull(allPoints);
    }

    public static Pair<Double, Integer> calcEnclosingRadius(Point3d pivot, Point3d[] points) {
        double radius = 0.0;
        int ix = -1;
        for (int m = 0; m < points.length; ++m) {
            double dist = pivot.distance(points[m]);
            if (!(dist > radius)) continue;
            radius = dist;
            ix = m;
        }
        return new Pair<Double, Integer>(radius, ix);
    }
}

