/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import common.data.EscalatorPreference;
import inferno.data2.ANode;
import inferno.data2.AnimatedGeom;
import inferno.data2.AppearanceMod;
import inferno.data2.AttractorLocator;
import inferno.data2.AttractorSim;
import inferno.data2.Blockage;
import inferno.data2.Camera;
import inferno.data2.CylinderShape;
import inferno.data2.DoorDir;
import inferno.data2.IAgentBodyShape;
import inferno.data2.IAnimSrc;
import inferno.data2.IOccDbgProps;
import inferno.data2.IProps;
import inferno.data2.MeasurementRegion;
import inferno.data2.Mesh;
import inferno.data2.NullProps;
import inferno.data2.Obscuration;
import inferno.data2.OccLocator;
import inferno.data2.OccTarget;
import inferno.data2.OccTargets;
import inferno.data2.Occupant;
import inferno.data2.PolygonShape;
import inferno.data2.PredefTag;
import inferno.data2.QBaseQueue;
import inferno.data2.QMetaQueue;
import inferno.data2.SlopeSpeed;
import inferno.data2.Tag;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.data2.ai.AssistedEvacTeam;
import inferno.data2.ai.ControlledOccGoal;
import inferno.data2.ai.IGoal;
import inferno.data2.value.ConstFunction1d;
import inferno.elevator.ElevatorModel;
import inferno.geom.Inter;
import inferno.io.fdsout.DataFinder;
import inferno.io.fdsout.DataFinderSmvPlot3d;
import inferno.io.fdsout.DataInquisitor;
import inferno.io.fdsout.KbLink;
import inferno.sim.BehaviorSim;
import inferno.sim.CameraAgent;
import inferno.sim.CycleBreaker;
import inferno.sim.DoorQueue;
import inferno.sim.Engine;
import inferno.sim.EngineOp;
import inferno.sim.IDoorFlowrate;
import inferno.sim.KnownFuncs;
import inferno.sim.OccAdder;
import inferno.sim.OccAgent;
import inferno.sim.OccEnvData;
import inferno.sim.OccGroup;
import inferno.sim.OccGroupType;
import inferno.sim.OccProfileSim;
import inferno.sim.OccStats;
import inferno.sim.Param;
import inferno.sim.SimulationMode;
import inferno.sim.occsource.OccSource;
import inferno.sim.path.Estimate;
import inferno.sim.path.PathChange;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Cleaner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.io.IOUtil;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ITaskProgress;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.mtproc.MTListProcessorPool;
import thunderheadeng.util.theUtil;

public class KB
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final boolean DEBUG_PATHS = System.getProperty("DEBUG_PATHS") != null;
    public static final boolean DEBUG_STEERING = System.getProperty("DEBUG_STEERING") != null;
    private static final Logger LOGGER = Logger.getLogger(KB.class.getName());
    private static final KbExclusive I_AM_KB = new KbExclusive();
    private Random Q_SHUFFLER = new Random(1000L);
    private final Param d_param;
    private Estimate d_pathEstimates;
    private final List<ANode> d_nodes;
    private final List<ANode> d_stairNodes;
    private final List<ANode> d_doorNodes;
    private final List<DoorQueue> d_doors;
    private final Set<ANode> d_queuingDoors;
    private final List<Occupant> d_occs;
    private final List<OccAgent> d_agents;
    private final Map<Integer, OccAgent> d_allAgentsEver;
    private final OccLocator d_occFinder;
    private final ElevatorModel d_elevatorModel;
    private final List<Blockage> d_blockages;
    private final List<QBaseQueue> d_baseQueues;
    private final List<QMetaQueue> d_metaQueues;
    private final List<Obscuration> d_obscurations;
    private final BitSet d_obscurationIds;
    private final List<AppearanceMod> d_appearanceMods;
    private final BitSet d_appModIds;
    private final List<Camera> d_cameras;
    private final List<CameraAgent> d_camAgents;
    private final Map<Long, AnimatedGeom> d_animGeoms;
    private final CycleBreaker d_cycleBreaker;
    private final List<MeasurementRegion> d_densityRegions;
    private final Map<PredefTag, Tag> d_predefTags;
    private final List<Tag> d_tags;
    private final Set<Tag> d_nodeTags;
    private final Set<Tag> d_attractorTags;
    private final BitSet d_occIds = new BitSet();
    private transient Map<String, List<Blockage>> d_blockageNameCache;
    private transient Map<Integer, ANode> d_animatedNodesCache = null;
    private transient Map<Integer, Obscuration> d_obscurationIdCache = null;
    private int d_nextAttracorId = 0;
    private final List<AttractorSim> d_rootAttractors;
    private final AttractorLocator d_attractorSearch;
    private final LinkedIdentityHashSet<AttractorSim> d_globalAttractors;
    private final LinkedIdentityHashSet<AttractorSim> d_trackingAttractors;
    private final LinkedIdentityHashSet<AttractorSim> d_allAttractors;
    private final ConcurrentSkipListSet<AttractorSim> d_queuedCreateAttractors;
    private final ConcurrentSkipListSet<AttractorSim> d_queuedDestroyAttractors;
    private final OccTargets d_occTargets;
    private final Random d_timeSeedGen = new Random(193004876870296L);
    private long d_timeSeed = this.d_timeSeedGen.nextLong();
    private transient MTListProcessorPool d_threadPool;
    private final List<Object> d_meta;
    private transient IProps d_dbgProps;
    private double d_simTime;
    private double d_dt;
    private double d_maxInUseVel = Double.NaN;
    private final CachedValue<Boolean> d_hasSpeedLimitedTris = new CachedValue();
    private final Set<WingedEdge> d_dirtyShrinkEdges = new LinkedIdentityHashSet<WingedEdge>();
    private final Vector3d d_gravityAccel;
    private Mesh d_geomMesh;
    private final NavigableMap<Double, EngineOp> d_events;
    private final OccStats d_occStats;
    private boolean d_forceIdle;
    private KbLink d_fdsOutputData;
    private OccEnvData d_occEnvData;
    private List<AssistedEvacTeam> d_assistedEvacuationData;
    private List<OccGroup> d_occupantGroups;
    private List<OccGroupType> d_occupantGroupTypes;
    private List<OccSource> d_occSources;
    private Map<SlopeSpeed, SlopeSpeed> d_slopeSpeedMap;
    private double d_minOccArea;
    private transient ExecutorService d_movementGroupExecutor;
    private List<String> d_scripts;
    private final Map<Function<AttractorSim, Double>, Function<AttractorSim, Double>> d_cachedAttractorSuscp;
    private static final OccProfileSim s_controlledProfile = new OccProfileSim();

    public KB(Param param) {
        this.d_param = param;
        this.d_nodes = new Vector<ANode>();
        this.d_occs = new ArrayList<Occupant>();
        this.d_agents = new ArrayList<OccAgent>();
        this.d_allAgentsEver = new LinkedHashMap<Integer, OccAgent>();
        this.d_occFinder = new OccLocator();
        this.d_gravityAccel = new Vector3d(0.0, 0.0, -9.8);
        this.d_doors = new ArrayList<DoorQueue>();
        this.d_doorNodes = new ArrayList<ANode>();
        this.d_stairNodes = new ArrayList<ANode>();
        this.d_dbgProps = new NullProps();
        this.d_pathEstimates = new Estimate(this);
        this.d_elevatorModel = new ElevatorModel();
        this.d_blockages = new ArrayList<Blockage>();
        this.d_baseQueues = new ArrayList<QBaseQueue>();
        this.d_metaQueues = new ArrayList<QMetaQueue>();
        this.d_obscurations = new ArrayList<Obscuration>();
        this.d_obscurationIds = new BitSet();
        this.d_appearanceMods = new ArrayList<AppearanceMod>();
        this.d_appModIds = new BitSet();
        this.d_cameras = new ArrayList<Camera>();
        this.d_animGeoms = new LinkedHashMap<Long, AnimatedGeom>();
        this.d_camAgents = new ArrayList<CameraAgent>();
        this.d_cycleBreaker = new CycleBreaker();
        this.d_densityRegions = new ArrayList<MeasurementRegion>();
        this.d_events = new TreeMap<Double, EngineOp>();
        this.d_occStats = new OccStats();
        this.d_queuingDoors = new LinkedIdentityHashSet<ANode>();
        this.d_forceIdle = false;
        this.d_meta = new ArrayList<Object>();
        this.d_fdsOutputData = null;
        this.d_occEnvData = new OccEnvData();
        this.d_occSources = new ArrayList<OccSource>();
        this.d_predefTags = new HashMap<PredefTag, Tag>();
        this.d_attractorSearch = new AttractorLocator();
        this.d_globalAttractors = new LinkedIdentityHashSet();
        this.d_trackingAttractors = new LinkedIdentityHashSet();
        this.d_rootAttractors = new ArrayList<AttractorSim>();
        this.d_allAttractors = new LinkedIdentityHashSet();
        this.d_queuedCreateAttractors = new ConcurrentSkipListSet(AttractorSim::compareCreateOrder);
        this.d_queuedDestroyAttractors = new ConcurrentSkipListSet(AttractorSim::compareCreateOrder);
        this.d_occTargets = new OccTargets();
        this.d_tags = new ArrayList<Tag>();
        this.d_dt = this.d_param.dt_init;
        for (PredefTag predef : PredefTag.values()) {
            Tag tag = predef.newTag.get();
            this.d_predefTags.put(predef, tag);
            this.d_tags.add(tag);
        }
        this.d_nodeTags = new LinkedIdentityHashSet<Tag>();
        this.d_attractorTags = new LinkedIdentityHashSet<Tag>();
        this.d_cachedAttractorSuscp = new HashMap<Function<AttractorSim, Double>, Function<AttractorSim, Double>>();
        this.d_slopeSpeedMap = new HashMap<SlopeSpeed, SlopeSpeed>();
        this.d_slopeSpeedMap.put(KnownFuncs.SFPE_STAIR_SPEED, KnownFuncs.SFPE_STAIR_SPEED);
        this.d_slopeSpeedMap.put(KnownFuncs.SFPE_RAMP_SPEED, KnownFuncs.SFPE_RAMP_SPEED);
        this.d_threadPool = new MTListProcessorPool();
        this.d_scripts = new ArrayList<String>();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (ANode n : this.d_nodes) {
            n.writeSelfRefData(out);
        }
        for (OccAgent agent : this.d_agents) {
            agent.writeSelfRefData(out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (ANode n : this.d_nodes) {
            n.readSelfRefData(in);
        }
        for (OccAgent agent : this.d_agents) {
            agent.readSelfRefData(in);
        }
        if (this.d_threadPool == null) {
            this.d_threadPool = new MTListProcessorPool();
        }
        this.d_dbgProps = new NullProps();
    }

    public void cleanup() {
        if (this.d_fdsOutputData != null) {
            this.d_fdsOutputData.cleanup();
        }
        this.getThreadPool().stopAndClearThreads();
    }

    public SimulationMode getSimMode() {
        return this.d_param.reactive_steering ? SimulationMode.STEERING : SimulationMode.SFPE;
    }

    public List<Tag> getTags() {
        return this.d_tags;
    }

    public void addTags(Collection<Tag> tags) {
        this.d_tags.addAll(tags);
    }

    public Tag getPredefTag(PredefTag ptag) {
        return this.d_predefTags.get((Object)ptag);
    }

    public Collection<Tag> getCompletionTags() {
        return this.d_predefTags.entrySet().stream().filter(entry -> ((PredefTag)((Object)((Object)entry.getKey()))).isCompleted).map(entry -> (Tag)entry.getValue()).collect(Collectors.toList());
    }

    public Set<Tag> getNodeOccTags() {
        return this.d_nodeTags;
    }

    public Set<Tag> getAttractorOccTags() {
        return this.d_attractorTags;
    }

    public void tag(PredefTag ptag, OccAgent occ) {
        this.tag(ptag, occ.getOcc());
    }

    public void tag(PredefTag ptag, Occupant occ) {
        this.getPredefTag(ptag).tag(this.getCurrentSimTime(), occ);
    }

    public void replaceClearableTags(Occupant occ, Set<Tag> tags) {
        ArrayList<Tag> addTags = new ArrayList<Tag>();
        ArrayList<Tag> removeTags = new ArrayList<Tag>();
        for (Tag tag2 : this.getTags()) {
            boolean shouldTag = tags.contains(tag2);
            if (tag2.isTagged(occ) == shouldTag) continue;
            if (shouldTag) {
                addTags.add(tag2);
                continue;
            }
            if (!tag2.options.contains((Object)Tag.Options.CLEARABLE)) continue;
            removeTags.add(tag2);
        }
        double t = this.getCurrentSimTime();
        addTags.forEach(tag -> tag.tag(t, occ));
        removeTags.forEach(tag -> tag.untag(t, occ));
    }

    public Set<Tag> getTags(Occupant occ) {
        return this.getTags().stream().filter(t -> t.isTagged(occ)).collect(Collectors.toCollection(() -> new LinkedIdentityHashSet()));
    }

    public List<Pair<OccAgent, Double>> getCompletedOccs() {
        Collection<Tag> complTags = this.getCompletionTags();
        return this.getAllAgentsEver().stream().map(oa -> {
            double completionTime = this.getTagTime((OccAgent)oa, complTags);
            return new Pair<OccAgent, Double>((OccAgent)oa, completionTime);
        }).filter(p -> Double.isFinite((Double)p.v2)).collect(Collectors.toList());
    }

    public double getTagTime(OccAgent agent, Collection<Tag> tags) {
        return tags.stream().mapToDouble(t -> t.getInfo((OccAgent)agent).tLastTagged).filter(Double::isFinite).min().orElse(Double.POSITIVE_INFINITY);
    }

    public List<OccTarget> getAllOccTargets() {
        return this.d_occTargets.getAll();
    }

    public OccTargets getOccTargets() {
        return this.d_occTargets;
    }

    private long generateNewResultsId(long ... influences) {
        long seed = this.d_timeSeed;
        for (long l : influences) {
            seed ^= l;
        }
        return new Random(seed).nextLong();
    }

    private long rl(int i) {
        return new Random(i).nextLong();
    }

    public void addAttractor(AttractorSim attractor) {
        attractor.setId(this.d_nextAttracorId++);
        if (attractor.type.isRoot) {
            this.d_rootAttractors.add(attractor);
        } else {
            long rid = this.generateNewResultsId(attractor.getResultsId(), this.rl(attractor.getId()), attractor.creator != null ? this.rl(attractor.creator.getId()) : 0L);
            attractor.setResultsId(rid);
        }
        if (attractor.type.isPlaced) {
            switch (attractor.awareness) {
                case LINE_OF_SIGHT: {
                    this.d_attractorSearch.insert(attractor, this.getDt());
                    break;
                }
                case ROOM_ONLY: {
                    attractor.getLocation().tri.node.addAttractor(attractor);
                    break;
                }
                case GLOBAL: {
                    this.d_globalAttractors.add(attractor);
                    break;
                }
                case ROOMS: {
                    attractor.rooms.forEach(node -> node.addAttractor(attractor));
                }
            }
            double timeOffset = attractor.influenceFrom == AttractorSim.InfluenceFrom.ATTRACTOR_CREATION ? this.getCurrentSimTime() : 0.0;
            for (Pair<Double, Double> entry : attractor.getInfluenceCurve()) {
                this.addEvent(timeOffset + (Double)entry.v1, new EngineOp.SetAttractorInfluence(attractor, (Double)entry.v2));
            }
        }
        this.d_allAttractors.add(attractor);
    }

    public void queueCreateAttractor(AttractorSim attractor) {
        this.d_queuedCreateAttractors.add(attractor);
    }

    public void queueDestroyAttractors(AttractorSim attractor) {
        this.d_queuedDestroyAttractors.add(attractor);
    }

    public List<AttractorSim> getRootAttractors() {
        return Collections.unmodifiableList(this.d_rootAttractors);
    }

    public Collection<AttractorSim> getAllAttractors() {
        return Collections.unmodifiableCollection(this.d_allAttractors);
    }

    public boolean isAttractorActive(AttractorSim attr) {
        return this.d_allAttractors.contains(attr);
    }

    public Collection<AttractorSim> getAllAttractors(Predicate<AttractorSim> predicate) {
        return this.d_allAttractors.stream().filter(predicate).collect(Collectors.toUnmodifiableList());
    }

    public Collection<AttractorSim> getGlobalAttractors() {
        return Collections.unmodifiableCollection(this.d_globalAttractors);
    }

    public List<AttractorSim> getLineOfSightAttractors() {
        ArrayList losAttractors = new ArrayList();
        this.d_attractorSearch.getAll((attr, ctmt) -> losAttractors.add(attr));
        return Collections.unmodifiableList(losAttractors);
    }

    public List<AttractorSim> findAttractors(ITest<AABox> test) {
        ArrayList<AttractorSim> attractors = new ArrayList<AttractorSim>();
        this.d_attractorSearch.find(test, (obj, ctmt) -> attractors.add((AttractorSim)obj));
        return attractors;
    }

    public Function<AttractorSim, Double> cacheAttractorSusceptibility(Function<AttractorSim, Double> suscp) {
        Function<AttractorSim, Double> existing = this.d_cachedAttractorSuscp.putIfAbsent(suscp, suscp);
        return existing == null ? suscp : existing;
    }

    public Set<AttractorSim> findPotentialAttractors(Occupant occ, boolean idling, Predicate<AttractorSim> filter) {
        if (!occ.mightBeSusceptibleToAttractors(idling)) {
            return Collections.emptySet();
        }
        LinkedIdentityHashSet<AttractorSim> attractors = new LinkedIdentityHashSet<AttractorSim>();
        Predicate<AttractorSim> ffilter = Predicates.and(filter, attr -> attr.getProbabilityOfInfluence(occ, idling) > 0.0).and(attr -> attr.creator == null || attr.creator.getOcc() != occ);
        attractors.addAll(theUtil.filter(this.d_globalAttractors, ffilter));
        this.d_attractorSearch.find(new AABoxTest(new AABox(occ.loc, occ.loc), 1.0E-6), (attr, ctmt) -> {
            if (!ffilter.test((AttractorSim)attr)) {
                return;
            }
            if (!attr.isVisible(this, occ)) {
                return;
            }
            attractors.add(attr);
        });
        if (occ.curNode != null) {
            occ.curNode.getAttractors().forEach(attr -> {
                if (ffilter.test((AttractorSim)attr)) {
                    attractors.add(attr);
                }
            });
        }
        return attractors;
    }

    public void updateDynamicAttractors() {
        for (AttractorSim attractor : this.d_queuedCreateAttractors) {
            this.addAttractor(attractor);
            if (!attractor.trackCreator) continue;
            this.d_trackingAttractors.add(attractor);
        }
        this.d_queuedCreateAttractors.clear();
        for (AttractorSim attractor : this.d_queuedDestroyAttractors) {
            this.d_allAttractors.remove(attractor);
            switch (attractor.awareness) {
                case GLOBAL: {
                    this.d_globalAttractors.remove(attractor);
                    this.d_trackingAttractors.remove(attractor);
                    break;
                }
                case LINE_OF_SIGHT: {
                    this.d_attractorSearch.remove(attractor);
                    this.d_trackingAttractors.remove(attractor);
                    break;
                }
                case ROOM_ONLY: {
                    attractor.getLocation().tri.node.removeAttractor(attractor);
                    this.d_trackingAttractors.remove(attractor);
                    break;
                }
                case ROOMS: {
                    attractor.rooms.forEach(node -> node.removeAttractor(attractor));
                    this.d_trackingAttractors.remove(attractor);
                }
            }
        }
        this.d_queuedDestroyAttractors.clear();
        boolean updateLocator = false;
        for (AttractorSim attractor : this.d_trackingAttractors) {
            TriPoint creatorLoc = attractor.creator.getLoc();
            switch (attractor.awareness) {
                case GLOBAL: 
                case ROOMS: {
                    attractor.setLocation(creatorLoc);
                    break;
                }
                case LINE_OF_SIGHT: {
                    updateLocator = updateLocator || !attractor.getLocation().tolEquals(creatorLoc, 0.0);
                    attractor.setLocation(creatorLoc);
                    break;
                }
                case ROOM_ONLY: {
                    if (attractor.getLocation().tri.node != creatorLoc.tri.node) {
                        attractor.getLocation().tri.node.removeAttractor(attractor);
                        creatorLoc.tri.node.addAttractor(attractor);
                    }
                    attractor.setLocation(creatorLoc);
                }
            }
        }
        if (updateLocator) {
            this.d_attractorSearch.update(this.getCurrentSimTime(), this.getDt());
        }
    }

    public void setFdsOutputData(KbLink dataLink) {
        this.d_fdsOutputData = dataLink;
    }

    public KbLink getFdsOutputData() {
        return this.d_fdsOutputData;
    }

    public OccEnvData getOccEnvData() {
        return this.d_occEnvData;
    }

    public boolean getForceIdle() {
        return this.d_forceIdle;
    }

    public synchronized void setForceIdle(boolean flag) {
        this.d_forceIdle = flag;
    }

    public void clearPerTimeStepCaches() {
    }

    public MTListProcessorPool getThreadPool() {
        return this.d_threadPool;
    }

    public IDoorFlowrate getDefaultFlowrate() {
        if (!this.d_param.reactive_steering) {
            if (this.d_param.door_flow_from_density) {
                return IDoorFlowrate.SFPE_FROM_DENSITY;
            }
            return IDoorFlowrate.SFPE_SPECIFIC_FLOW;
        }
        if (Double.isInfinite(this.d_param.specific_flowrate_max)) {
            return IDoorFlowrate.UNLIMITED;
        }
        return IDoorFlowrate.SPECIFIC_FLOW;
    }

    public NavigableMap<Double, EngineOp> getEvents() {
        return this.d_events;
    }

    public Random getTimeBasedRandom(Occupant occ, long behaviorSeed) {
        return new Random(occ.rseed ^ behaviorSeed ^ this.d_timeSeed);
    }

    public void addEvent(Double t, EngineOp op) {
        EngineOp existing = (EngineOp)this.d_events.get(t);
        if (existing != null) {
            if (existing instanceof EngineOp.MultiOp) {
                ((EngineOp.MultiOp)existing).ops.add(op);
            } else {
                op = new EngineOp.MultiOp(existing, op);
                this.d_events.put(t, op);
            }
        } else {
            this.d_events.put(t, op);
        }
    }

    public Estimate getPathEstimates() {
        return this.d_pathEstimates;
    }

    public synchronized void markMeshDirty() {
        this.markMeshDirty(true);
    }

    public synchronized void markMeshDirty(boolean clearEstimateCache) {
        this.getMesh().markModified(this.getCurrentSimTime());
        this.d_pathEstimates.resetDoors(I_AM_KB);
    }

    public void setPathEstimates(Estimate est) {
        this.d_pathEstimates = est;
    }

    public OccStats getOccStats() {
        return this.d_occStats;
    }

    public boolean isDebugging() {
        return !this.d_dbgProps.isNull();
    }

    public IProps getProps() {
        return this.d_dbgProps;
    }

    public IOccDbgProps getDbgProps(OccAgent agent) {
        return this.d_dbgProps.getProps(agent.getOcc());
    }

    public IOccDbgProps getDbgProps(Occupant occ) {
        return this.d_dbgProps.getProps(occ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProps(IProps props) {
        if (this.d_dbgProps.isNull() != props.isNull()) {
            Iterator<Occupant> iterator = this.getOccs().iterator();
            while (iterator.hasNext()) {
                Occupant occ;
                Occupant occupant = occ = iterator.next();
                synchronized (occupant) {
                    occ.dbgProps = props.isNull() ? null : Collections.synchronizedMap(new HashMap());
                }
            }
        }
        this.d_dbgProps = props;
    }

    public Param getParams() {
        return this.d_param;
    }

    public void setMesh(Mesh mesh) {
        assert (mesh != null);
        this.d_geomMesh = mesh;
    }

    public Mesh getMesh() {
        return this.d_geomMesh;
    }

    public Vector3d getGravityAccel() {
        return this.d_gravityAccel;
    }

    public OccLocator updateOccFinder(double dt) {
        this.d_occFinder.update(this.getActiveAgents(), this.getCurrentSimTime(), dt);
        return this.d_occFinder;
    }

    public OccLocator getOccFinder() {
        return this.d_occFinder;
    }

    public Collection<OccAgent> getActiveAgents() {
        return theUtil.filter(this.d_agents, agent -> !agent.isDone());
    }

    public Collection<OccAgent> getActiveAgents(Predicate<OccAgent> filter) {
        return theUtil.filter(this.d_agents, Predicates.and(agent -> !agent.isDone(), filter));
    }

    public Collection<OccAgent> getFinishedAgents() {
        return theUtil.filter(this.d_agents, agent -> agent.isDone());
    }

    public List<OccAgent> findOccs(ITest<AABox> test, Predicate<OccAgent> filter, boolean includePassive) {
        ArrayList<OccAgent> result = new ArrayList<OccAgent>();
        this.findOccs(test, includePassive, new CollResult(result, OccAgent.class, filter));
        return result;
    }

    public void findOccs(ITest<AABox> test, boolean includePassive, IResult<OccAgent> result) {
        if (!includePassive) {
            IResult<OccAgent> baseResult = result;
            result = (occ, ctmt) -> {
                if (!occ.getOcc().isPassive && occ.getOcc().isCollidable) {
                    baseResult.mark((OccAgent)occ, ctmt);
                }
            };
        }
        if (!this.d_occFinder.isEmpty()) {
            this.d_occFinder.find(test, (IResult<? super OccAgent>)result);
        } else {
            for (OccAgent occ2 : this.getActiveAgents()) {
                AABox bb = occ2.getOcc().getBoundingBox(true);
                Containment contain = test.test(bb);
                if (!contain.positive) continue;
                result.mark(occ2, contain);
            }
        }
    }

    public boolean occOverlapsOthers(Occupant occ, Point3d loc, double epsilon) {
        boolean[] result = new boolean[]{false};
        try {
            this.getOverlappingOccs(occ, loc, otherOcc -> {
                result[0] = true;
                throw new CancellationException();
            });
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return result[0];
    }

    public void getOverlappingOccs(Occupant occ, Point3d loc, Consumer<? super OccAgent> overlappingOccs) {
        this.updateOccFinder(this.getDt());
        if (!this.d_occFinder.isEmpty()) {
            this.d_occFinder.getOverlappingOccs(occ, loc, overlappingOccs);
        } else {
            AABox oabb = occ.getBoundingBox(loc, true);
            for (OccAgent otherOcc : this.getActiveAgents()) {
                if (occ == otherOcc.getOcc() || !oabb.intersects(otherOcc.getOcc().getBoundingBox(true)) || !Inter.shapesOverlap(occ.bodyShape, otherOcc.getOcc().bodyShape)) continue;
                overlappingOccs.accept(otherOcc);
            }
        }
    }

    public ElevatorModel getElevatorModel() {
        return this.d_elevatorModel;
    }

    public double getCurrentSimTime() {
        return this.d_simTime;
    }

    public void setCurrentSimTime(double time) {
        if (this.d_simTime != time) {
            this.d_simTime = time;
            this.d_maxInUseVel = Double.NaN;
            this.d_timeSeed = this.d_timeSeedGen.nextLong();
        }
    }

    public double getDt() {
        return this.d_dt;
    }

    public void setDt(double dt) {
        this.d_dt = dt;
    }

    private synchronized void updateMaxInUseVel() {
        if (!Double.isNaN(this.d_maxInUseVel)) {
            return;
        }
        double maxsq = 0.0;
        for (OccAgent agent : this.d_agents) {
            double velsq;
            if (agent.isDone() || !((velsq = agent.getVel().lengthSquared()) > maxsq)) continue;
            maxsq = velsq;
        }
        this.d_maxInUseVel = Math.sqrt(maxsq);
    }

    public double getMaxInUseVel() {
        this.updateMaxInUseVel();
        return this.d_maxInUseVel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markShrinkSourcesDirty(Collection<WingedEdge> edges) {
        Set<WingedEdge> set = this.d_dirtyShrinkEdges;
        synchronized (set) {
            this.d_dirtyShrinkEdges.addAll(edges);
        }
    }

    public void markTriSpeedModifierDirty(Collection<Tri> tris, boolean blockingChanged) {
        this.d_hasSpeedLimitedTris.clear();
        if (blockingChanged) {
            this.markShrinkSourcesDirty(theUtil.map(theUtil.flatMap(tris, tri -> Arrays.asList(tri.eu)), eu -> eu.wedge));
        }
    }

    public boolean hasImpedingTris() {
        return this.d_hasSpeedLimitedTris.get(() -> {
            boolean result = Stream.of(this.d_geomMesh.getTris()).anyMatch(tri -> tri.isImpeding());
            return result;
        });
    }

    public void trimMeshes(double maxDist) {
        this.trimMeshes(maxDist, new ArrayList<Double>());
    }

    public void trimMeshes(double maxDist, List<Double> allRadii) {
        if (this.d_agents.isEmpty() && this.d_occSources.isEmpty() && allRadii.isEmpty() && this.getRootAttractors().isEmpty()) {
            return;
        }
        DoubleConsumer addRadius = r -> {
            if (allRadii.isEmpty() || (Double)allRadii.get(allRadii.size() - 1) != r) {
                allRadii.add(r);
            }
        };
        for (OccAgent agent : this.d_agents) {
            agent.getAllPossibleRadii(false, addRadius);
            agent.getAllPossibleRadii(true, addRadius);
        }
        for (OccSource occSource : this.d_occSources) {
            allRadii.addAll(occSource.getAllGeomAndOccRadii());
        }
        IdentityHashSet visitedBehaviors = new IdentityHashSet();
        Consumer<BehaviorSim> addFromBehavior = behavior -> behavior.getFutureProfileValues(visitedBehaviors, OccProfileSim.PROP_SHAPE, shapeGen -> {
            shapeGen.getAllWidths(true, w -> allRadii.add(w / 2.0));
            shapeGen.getAllWidths(false, w -> allRadii.add(w / 2.0));
        });
        this.getRootAttractors().stream().map(attr -> attr.behavior).forEach(addFromBehavior);
        Collections.sort(allRadii);
        Collections.reverse(allRadii);
        ArrayList<Double> trimRadii = new ArrayList<Double>();
        double curr = allRadii.get(0);
        trimRadii.add(curr);
        for (Double next : allRadii) {
            if (!(curr - next > maxDist)) continue;
            trimRadii.add(next);
            curr = next;
        }
        LOGGER.log(Level.FINER, "Trimming meshes using " + trimRadii.size() + " radii...");
        LOGGER.log(Level.FINER, Arrays.toString(trimRadii.toArray()));
        this.getMesh().shrinkInternalEdgesFromBoundary(trimRadii);
        LOGGER.log(Level.FINER, "Done trimming meshes");
    }

    public boolean isValid() {
        for (ANode n : this.d_nodes) {
            if (n.isDoor() && !this.d_doorNodes.contains(n)) {
                assert (false);
                return false;
            }
            if (n.isDoor() && !this.d_doors.contains(n.doorQueue)) {
                assert (false);
                return false;
            }
            boolean isStair = n.stairData != null;
            if (!isStair || this.d_stairNodes.contains(n)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    protected Map<Integer, ANode> getAnimNodes() {
        if (this.d_animatedNodesCache == null) {
            this.d_animatedNodesCache = new HashMap<Integer, ANode>();
            for (ANode node : this.d_nodes) {
                if (node.getAnimationId() < 0) continue;
                this.d_animatedNodesCache.put(node.getAnimationId(), node);
            }
        }
        return this.d_animatedNodesCache;
    }

    public ANode getAnimatedNode(int animId) {
        return this.getAnimNodes().get(animId);
    }

    public void addNode(ANode n) {
        this.d_nodes.add(n);
    }

    public void registerDoor(ANode n) {
        assert (this.d_nodes.contains(n));
        assert (n.isDoor());
        this.d_doors.add(n.doorQueue);
        this.d_doorNodes.add(n);
    }

    public void registerStair(ANode n) {
        assert (this.d_nodes.contains(n));
        assert (n.stairData != null);
        this.d_stairNodes.add(n);
    }

    public List<ANode> getNodes() {
        return this.d_nodes;
    }

    public List<ANode> getDoorNodes() {
        return this.d_doorNodes;
    }

    public List<ANode> getStairNodes() {
        return this.d_stairNodes;
    }

    public void addOcc(Occupant o) {
        this.d_occs.add(o);
        this.registerOccId(o.id);
    }

    public Occupant createOcc(OccProfileSim profile, BehaviorSim behavior, Consumer<? super Occupant> modifyOcc, long seed, Point3d loc, Random rnd, String name, Predicate<Occupant> testOcc) {
        OccAdder adder = new OccAdder(this.getMesh());
        Occupant occ = adder.add(name, seed, seed, profile, behavior, loc, this);
        if (occ == null) {
            return null;
        }
        profile.applyToOcc(occ, rnd, seed, Filters.reject(OccProfileSim.PROP_NAME), this);
        modifyOcc.accept(occ);
        if (!testOcc.test(occ)) {
            return null;
        }
        adder.finish(this);
        return occ;
    }

    public void init(ITaskProgress progress) throws CancellationException {
        this.createAgents();
        progress.check();
        this.createCamAgents();
        this.initMinOccArea();
        progress.check();
        this.updateNodeArea(this.d_param.density_max);
        progress.check();
        this.initTriFlags();
        this.initTriBlockages();
        progress.check();
        if (this.getParams().smvDataEnable) {
            File smvFile;
            String smvPathInit = this.getParams().smvDataFilePath;
            File file = smvFile = smvPathInit != null ? IOUtil.resolvePath(smvPathInit, new File(this.getParams().dir), true) : null;
            if (smvFile != null) {
                if (!Objects.equals(smvPathInit, smvFile.getPath())) {
                    LOGGER.log(Level.INFO, String.format("SMV input file [%s] resolved as [%s].", smvPathInit, smvFile.getPath()));
                }
                KbLink fdsData = this.createSmvDataLink(smvFile);
                this.setFdsOutputData(fdsData);
            } else {
                LOGGER.log(Level.SEVERE, "File not found: " + smvPathInit);
                LOGGER.log(Level.SEVERE, "FDS output integration disabled.");
            }
        }
        this.d_occEnvData.init(this);
        progress.check();
        this.d_elevatorModel.init();
        progress.check();
        if (!this.d_param.reactive_steering) {
            this.d_queuingDoors.addAll(this.d_doorNodes);
            progress.check();
        } else {
            for (ANode door : this.d_doorNodes) {
                if (!door.doorQueue.isQueueable(this, DoorDir.POSITIVE) && !door.doorQueue.isQueueable(this, DoorDir.NEGATIVE)) continue;
                this.d_queuingDoors.add(door);
            }
            progress.check();
        }
        for (ANode node : this.d_nodes) {
            this.d_nodeTags.addAll(node.getOccTags());
        }
        progress.check();
        for (AttractorSim attr : this.d_allAttractors) {
            progress.check();
            Consumer<Tag> addTags = this.d_attractorTags::add;
            for (IGoal goal : attr.behavior.deepFlatten()) {
                progress.check();
                goal.getTagRefs(addTags);
            }
        }
        for (Iterator<IAnimSrc> iterator : this.d_geomMesh.getTris()) {
            ((Tri)((Object)iterator)).updateSpeedModifier(this);
        }
        progress.check();
    }

    private void initTriBlockages() {
        LinkedIdentityHashMap<Tri, Set> triBlockages = new LinkedIdentityHashMap<Tri, Set>();
        Tri[] allTris = this.d_geomMesh.getTris();
        for (Blockage blkg : this.d_blockages) {
            for (int triId : blkg.tris) {
                triBlockages.computeIfAbsent(allTris[triId], t -> new LinkedIdentityHashSet()).add(blkg);
            }
        }
        HashMap<Set, List> blkgSetCache = new HashMap<Set, List>();
        for (Map.Entry entry : triBlockages.entrySet()) {
            List blkgs = blkgSetCache.computeIfAbsent((Set)entry.getValue(), s -> s.size() == 1 ? Collections.singletonList((Blockage)s.iterator().next()) : new ArrayList(s));
            ((Tri)entry.getKey()).setBlockages(blkgs);
        }
    }

    private void initTriFlags() {
        DoubleSupplier getMaxBadTriSearchDist = () -> {
            double dist;
            double maxBadTriSearchDist = 0.0;
            double dt = this.getParams().realtime ? 1.0 : this.getParams().dt_init;
            for (OccAgent agent : this.getAgents()) {
                dist = agent.getRadiusRangeEver(true)[1];
                if (!((dist += agent.getMaxVelRangeEver()[1] * dt) > maxBadTriSearchDist)) continue;
                maxBadTriSearchDist = dist;
            }
            for (OccSource os : this.getOccSources()) {
                dist = os.getMaxGeomRadius();
                double maxVel = os.getMaxVel();
                if (!((dist += maxVel * dt) > maxBadTriSearchDist)) continue;
                maxBadTriSearchDist = dist;
            }
            return maxBadTriSearchDist;
        };
        this.d_geomMesh.initTriFlags(getMaxBadTriSearchDist);
    }

    private void initMinOccArea() {
        double minArea = Double.POSITIVE_INFINITY;
        for (OccAgent agent : this.getAgents()) {
            IAgentBodyShape shape = agent.getOcc().bodyShape;
            double area = shape.getProjectedArea();
            if (!(area > 0.0)) continue;
            minArea = Math.min(minArea, area);
        }
        for (OccSource os : this.getOccSources()) {
            for (OccProfileSim profile : os.getProfiles()) {
                OccProfileSim.IShapeGen shape = profile.getProperty(OccProfileSim.PROP_SHAPE);
                double area = shape.getProjectedArea(true, false);
                if (!(area > 0.0)) continue;
                minArea = Math.min(minArea, area);
            }
        }
        this.d_minOccArea = minArea;
    }

    private KbLink createSmvDataLink(File smvFile) {
        try {
            DataFinder.Quantity[] quantities;
            DataFinderSmvPlot3d smvDataFinder = new DataFinderSmvPlot3d(smvFile);
            DataInquisitor inquisitor = new DataInquisitor(smvDataFinder);
            KbLink smvLink = new KbLink(inquisitor);
            for (DataFinder.Quantity q : quantities = inquisitor.getQuantities()) {
                smvLink.addSensor(new KbLink.SensorInfo(q, String.format("%s (%s)", q.friendlyName, q.unit)));
            }
            return smvLink;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            return null;
        }
    }

    private void updateNodeArea(double dmax) {
        for (ANode n : this.getNodes()) {
            double area = this.getArea(n.getMesh());
            if (!this.d_param.reactive_steering && n.stairData != null) {
                area -= this.getBoundaryLayerArea(n.getMesh(), this.d_param.boundary_layer);
            }
            n.setArea(area);
            if (!this.d_param.reactive_steering) {
                n.setMaxOccDensity(dmax, false);
            }
            n.updateMaxOccCount(false);
        }
    }

    private double getArea(List<Tri> mts) {
        double area = 0.0;
        for (Tri mt : mts) {
            area += mt.getArea();
        }
        return area;
    }

    private double getBoundaryLayerArea(List<Tri> mts, double boundaryLayer) {
        double lengthBoundaryEdges = 0.0;
        for (Tri mt : mts) {
            for (WingedEdgeUse wu : mt.eu) {
                if (!wu.wedge.isBoundary()) continue;
                Point3d a = wu.wedge.base.n1.p;
                Point3d b = wu.wedge.base.n2.p;
                lengthBoundaryEdges += a.distance(b);
            }
        }
        return lengthBoundaryEdges * boundaryLayer;
    }

    public void addMetaData(Object meta) {
        this.d_meta.add(meta);
    }

    public List<Object> getMetaData() {
        return this.d_meta;
    }

    public double getMinOccArea() {
        return this.d_minOccArea;
    }

    public boolean hasQueueingDoors() {
        return !this.d_queuingDoors.isEmpty();
    }

    public Set<ANode> getQueuingDoors() {
        return this.d_queuingDoors;
    }

    public boolean isQueueingDoor(ANode door) {
        return this.d_queuingDoors.contains(door);
    }

    protected void createAgents() {
        for (Occupant o : this.d_occs) {
            this.createAgent(o, false);
        }
    }

    public OccAgent createAgent(Occupant o, boolean live) {
        if (!this.getProps().isNull()) {
            o.dbgProps = Collections.synchronizedMap(new HashMap());
        }
        OccAgent agent = new OccAgent(this, this.d_param, o);
        this.d_agents.add(agent);
        this.d_allAgentsEver.put(agent.getId(), agent);
        if (this.d_param.handle_collisions) {
            this.d_occFinder.update(agent, this.d_dt);
        }
        return agent;
    }

    public List<OccAgent> getAgents() {
        return this.d_agents;
    }

    public Collection<OccAgent> getAllAgentsEver() {
        return this.d_allAgentsEver.values();
    }

    public OccAgent getAgent(int id) {
        return this.d_allAgentsEver.get(id);
    }

    public OccAgent getAgent(Occupant occ) {
        return this.d_allAgentsEver.get(occ.id);
    }

    public void pruneFinishedAgents() {
        for (int m = this.d_agents.size() - 1; m >= 0; --m) {
            OccAgent oa = this.d_agents.get(m);
            if (!oa.isDone()) continue;
            this.d_agents.remove(m);
        }
    }

    public void invalidateAgents(Collection<OccAgent> agents) {
        this.d_agents.removeAll(agents);
        this.d_allAgentsEver.keySet().removeAll(theUtil.map(agents, a -> a.getId()));
    }

    public OccAgent addControlledAgent(String name, String modelid, Point3d addPt, double radius, double maxVel, Vector3d orientation) {
        Tri t = this.getMesh().getTri(addPt);
        if (t == null) {
            String msg = String.format("The point (%.2f, %.2f, %.2f) does not lie on the simulation mesh.", addPt.x, addPt.y, addPt.z);
            throw new IllegalArgumentException(msg);
        }
        int id = this.getNextOccId();
        ArrayList<IGoal> goals = new ArrayList<IGoal>();
        goals.add(ControlledOccGoal.INSTANCE);
        BehaviorSim behavior = new BehaviorSim("controlled", null, goals);
        Occupant occ = new Occupant(id, name, 0L, 0L, s_controlledProfile, behavior, t, addPt, this.getCurrentSimTime());
        occ.avatar = modelid;
        occ.bodyShape = new CylinderShape(addPt, radius, radius, occ.bodyShape.getHeight(), orientation, id);
        occ.maxVel = (float)maxVel;
        occ.accelFactor = 2.0f;
        ConstFunction1d fone = new ConstFunction1d(1.0);
        SlopeSpeed sone = new SlopeSpeed(fone, fone, fone, fone);
        occ.fundamental = fone;
        occ.stairSpeed = sone;
        occ.rampSpeed = sone;
        occ.obeyOnewayDoors = false;
        occ.movingTerrainPref = EscalatorPreference.WALK;
        occ.orient = orientation;
        occ.compRestrictions = new OccProfileSim.CompRestrictions();
        this.addOcc(occ);
        OccAgent agent = this.createAgent(occ, false);
        agent.init(this, this.getParams());
        return agent;
    }

    public int getNextOccId() {
        return this.d_occIds.nextClearBit(this.d_occs.size());
    }

    public int generateOccId() {
        int id = this.getNextOccId();
        this.registerOccId(id);
        return id;
    }

    public void registerOccId(int id) {
        this.d_occIds.set(id);
    }

    public List<Occupant> getOccs() {
        return Collections.unmodifiableList(this.d_occs);
    }

    public List<Blockage> getBlockages() {
        return this.d_blockages;
    }

    public Set<String> getBlockageNames() {
        return this.getBlockageMap().keySet();
    }

    public List<Blockage> getBlockages(String name) {
        List<Blockage> blockages = this.getBlockageMap().get(name);
        return blockages == null ? Collections.emptyList() : blockages;
    }

    protected Map<String, List<Blockage>> getBlockageMap() {
        if (this.d_blockageNameCache == null) {
            this.d_blockageNameCache = new LinkedHashMap<String, List<Blockage>>();
            for (Blockage blkg : this.d_blockages) {
                List<Blockage> blockages = this.d_blockageNameCache.get(blkg.name);
                if (blockages == null) {
                    blockages = new ArrayList<Blockage>();
                    this.d_blockageNameCache.put(blkg.name, blockages);
                }
                blockages.add(blkg);
            }
        }
        return this.d_blockageNameCache;
    }

    public void addBlockage(Blockage blkg) {
        this.d_blockages.add(blkg);
        this.d_blockageNameCache = null;
    }

    public List<QBaseQueue> getBaseQueues() {
        return this.d_baseQueues;
    }

    public int getBaseQueueSize() {
        return this.d_baseQueues.size();
    }

    public void addBaseQueue(QBaseQueue bq) {
        this.d_baseQueues.add(bq);
    }

    public List<QMetaQueue> getMetaQueues() {
        return this.d_metaQueues;
    }

    public void addMetaQueue(QMetaQueue mq) {
        this.d_metaQueues.add(mq);
    }

    public void updateBaseQueues(double dt) {
        for (QBaseQueue su : this.d_baseQueues) {
            su.update(this, dt);
        }
    }

    public void updateTrimmedMeshes() {
        if (this.d_dirtyShrinkEdges.isEmpty()) {
            return;
        }
        ArrayList<WingedEdge> edges = new ArrayList<WingedEdge>(this.d_dirtyShrinkEdges);
        Collections.sort(edges, (e1, e2) -> Integer.compare(e1.id, e2.id));
        this.d_geomMesh.reshrinkEdgesFromBoundary(this, edges);
        this.d_dirtyShrinkEdges.clear();
    }

    public List<Camera> getCameras() {
        return this.d_cameras;
    }

    public void addCamera(Camera camera) {
        this.d_cameras.add(camera);
    }

    protected void createCamAgents() {
        for (Camera c : this.d_cameras) {
            this.createCamAgent(c);
        }
    }

    public CameraAgent createCamAgent(Camera o) {
        CameraAgent agent = new CameraAgent(o);
        this.d_camAgents.add(agent);
        return agent;
    }

    public List<CameraAgent> getCameraAgents() {
        return this.d_camAgents;
    }

    public Map<Long, AnimatedGeom> getAnimatedGeoms() {
        return this.d_animGeoms;
    }

    public void addAnimatedGeom(AnimatedGeom geom) {
        this.d_animGeoms.put(geom.resultsId, geom);
    }

    public List<MeasurementRegion> getDensityRegions() {
        return this.d_densityRegions;
    }

    public void addDensityRegion(MeasurementRegion r) {
        this.d_densityRegions.add(r);
    }

    public int getNextAppearanceModId() {
        return this.d_appModIds.nextClearBit(0);
    }

    public void addAppearanceMod(AppearanceMod appMod) {
        this.d_appearanceMods.add(appMod);
        this.d_appModIds.set(appMod.id);
    }

    public void removeAppearanceMod(AppearanceMod appMod) {
        this.d_appearanceMods.remove(appMod);
    }

    public List<AppearanceMod> getAppearanceMods() {
        return this.d_appearanceMods;
    }

    public int getNextObscurationId() {
        return this.d_obscurationIds.nextClearBit(0);
    }

    public void addObscuration(Obscuration obsc) {
        this.d_obscurations.add(obsc);
        this.d_obscurationIds.set(obsc.id);
        if (this.d_obscurationIdCache != null) {
            this.d_obscurationIdCache.put(obsc.id, obsc);
        }
    }

    public void removeObscuration(Obscuration obsc) {
        this.d_obscurations.remove(obsc);
        if (this.d_obscurationIdCache != null) {
            this.d_obscurationIdCache.remove(obsc.id);
        }
    }

    public List<Obscuration> getObscurations() {
        return this.d_obscurations;
    }

    public Obscuration getObscuration(int id) {
        if (this.d_obscurationIdCache == null) {
            this.d_obscurationIdCache = new HashMap<Integer, Obscuration>();
            for (Obscuration obsc : this.d_obscurations) {
                this.d_obscurationIdCache.put(obsc.id, obsc);
            }
        }
        return this.d_obscurationIdCache.get(id);
    }

    public void updateDoors(double dt) {
        if (this.d_queuingDoors.isEmpty()) {
            return;
        }
        ArrayList<ANode> dqs = new ArrayList<ANode>(this.d_queuingDoors);
        while (!dqs.isEmpty()) {
            Collections.shuffle(dqs, this.Q_SHUFFLER);
            ArrayList<ANode> incompleteDoors = new ArrayList<ANode>();
            for (ANode dq : dqs) {
                boolean complete = dq.doorQueue.updateQueue(this, dt);
                if (complete) continue;
                incompleteDoors.add(dq);
            }
            dqs = incompleteDoors;
        }
    }

    public CycleBreaker getCycleBreaker() {
        return this.d_cycleBreaker;
    }

    public String toString() {
        Field[] fields;
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        for (Field fd : fields = this.getClass().getDeclaredFields()) {
            String name = fd.getName();
            fd.setAccessible(true);
            try {
                Object obj = fd.get(this);
                fieldMap.put(name, obj);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : fieldMap.entrySet()) {
            sb.append(entry.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setAssistedEvacTeams(Collection<AssistedEvacTeam> assistedEvacuationData) {
        this.d_assistedEvacuationData = new ArrayList<AssistedEvacTeam>(assistedEvacuationData);
    }

    public List<AssistedEvacTeam> getAssistedEvacTeams() {
        return this.d_assistedEvacuationData;
    }

    public void addOccupantGroups(Collection<OccGroup> occGroups) {
        if (this.d_occupantGroups == null) {
            this.d_occupantGroups = new ArrayList<OccGroup>();
        }
        this.d_occupantGroups.addAll(occGroups);
    }

    public List<OccGroup> getOccupantGroups() {
        return this.d_occupantGroups;
    }

    public void setOccupantGroupTypes(Collection<OccGroupType> occGroupTypes) {
        this.d_occupantGroupTypes = new ArrayList<OccGroupType>(occGroupTypes);
    }

    public List<OccGroupType> getOccupantGroupTypes() {
        return this.d_occupantGroupTypes;
    }

    public void addOccSource(OccSource occSource) {
        this.d_occSources.add(occSource);
    }

    public List<OccSource> getOccSources() {
        return this.d_occSources;
    }

    public Collection<OccSource> getActiveOccSources() {
        return theUtil.filter(this.d_occSources, os -> !os.isFinished(this.d_simTime));
    }

    public List<Occupant> getInvalidOccs(List<Occupant> occs, boolean checkBoundaries, boolean checkOccsOverlap) {
        ArrayList<Occupant> invalidOccs = new ArrayList<Occupant>();
        for (Occupant occ : occs) {
            if (this.isOccValid(occ, checkBoundaries, checkOccsOverlap, false)) continue;
            invalidOccs.add(occ);
        }
        return invalidOccs;
    }

    public boolean isOccValid(Occupant occ, boolean checkBoundaries, boolean checkOccsOverlap, boolean checkOccBlockage) {
        boolean[] result = new boolean[]{true};
        try {
            this.testOccLocation(occ, checkBoundaries, checkOccsOverlap, checkOccBlockage, obj -> {
                result[0] = false;
                throw new CancellationException();
            });
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return result[0];
    }

    public void testOccLocation(Occupant occ, boolean checkBoundaries, boolean checkOccsOverlap, boolean checkOccBlockage, Consumer<Object> overlappingObjs) {
        if (checkBoundaries) {
            this.getOverlappingBoundaries(occ, OccAgent.getGeomCollisionShape(occ, this, occ.loc, false, true), 0.0, overlappingObjs);
        }
        if (checkOccsOverlap) {
            this.getOverlappingOccs(occ, new Point3d(occ.loc), overlappingObjs);
        }
        if (checkOccBlockage) {
            for (Blockage b : occ.tri.getBlockages()) {
                if (!b.getPreventOccPlacement()) continue;
                overlappingObjs.accept(b);
            }
        }
    }

    public boolean clipsBoundary(Occupant occ) {
        return this.clipsBoundary(occ, OccAgent.getGeomCollisionShape(occ, this, occ.loc, false, true));
    }

    public boolean clipsBoundary(Occupant occ, IAgentBodyShape shape) {
        return this.clipsBoundary(occ, shape, 0.0);
    }

    public boolean clipsBoundary(Occupant occ, IAgentBodyShape shape, double tol) {
        boolean[] result = new boolean[]{false};
        try {
            this.getOverlappingBoundaries(occ, shape, tol, boundary -> {
                result[0] = true;
                throw new CancellationException();
            });
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return result[0];
    }

    public void getOverlappingBoundaries(Occupant occ, IAgentBodyShape shape, double tol, Consumer<? super WingedEdge> overlappingBoundaries) {
        double radius = shape.getEnclosingRadius();
        List<Mesh.EdgeDist> edges = this.getMesh().getCloseBoundaries(occ.tri, occ.loc, occ.curNode, radius, Filters.acceptAll(PathChange.class));
        if (shape instanceof CylinderShape) {
            double rsq = radius * radius;
            for (Mesh.EdgeDist ed : edges) {
                if (!theUtil.lt(ed.distSq, rsq, tol == 0.0 ? 1.0E-12 : tol)) continue;
                overlappingBoundaries.accept(ed.edge);
            }
        }
        if (shape instanceof PolygonShape) {
            Point3d[] bodyPoints = ((PolygonShape)shape).getPoints();
            for (Mesh.EdgeDist ed : edges) {
                if (!Inter.isectLineSegPoly(ed.edge.p1(), ed.edge.p2(), bodyPoints, tol)) continue;
                overlappingBoundaries.accept(ed.edge);
            }
        }
    }

    public boolean checkOccSourcesFinished() {
        for (OccSource occSource : this.d_occSources) {
            if (occSource.isFinished(this.getCurrentSimTime())) continue;
            return false;
        }
        return true;
    }

    public Map<SlopeSpeed, SlopeSpeed> getSlopeSpeedMap() {
        return this.d_slopeSpeedMap;
    }

    public synchronized ExecutorService getGroupExecutorWorker() {
        if (this.d_movementGroupExecutor == null) {
            ExecutorService executor = this.d_movementGroupExecutor = Executors.newFixedThreadPool(Engine.getNumProcThreads());
            Cleaner.create().register(this, () -> executor.shutdown());
        }
        return this.d_movementGroupExecutor;
    }

    public void addScript(String script) {
        this.d_scripts.add(script);
    }

    public List<String> getScripts() {
        return Collections.unmodifiableList(this.d_scripts);
    }

    public Integer idOfFirstOccUsing(BehaviorSim obj) {
        Optional<Integer> firstUseId = this.d_occs.stream().filter(occ -> occ.behavior == obj).map(occ -> occ.id).findFirst();
        return firstUseId.orElse(-1);
    }

    public Integer idOfFirstOccUsing(OccProfileSim obj) {
        Optional<Integer> firstUseId = this.d_occs.stream().filter(occ -> occ.parentProfile == obj).map(occ -> occ.id).findFirst();
        return firstUseId.orElse(-1);
    }

    public static class KbExclusive {
        private KbExclusive() {
        }
    }
}

