/*
 * Decompiled with CFR 0.152.
 */
package inferno.io.fdsout;

import inferno.io.fdsout.DataFinder;
import inferno.io.fdsout.QData;
import inferno.io.fdsout.XyzData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import thunderheadeng.util.SmvParseUtil;
import vtk.vtkDataObject;
import vtk.vtkFloatArray;
import vtk.vtkMultiPieceDataSet;
import vtk.vtkRectilinearGrid;

public class DataFinderSmvPlot3d
implements DataFinder,
Serializable {
    private static final long serialVersionUID = 1L;
    private File d_smvFile;
    private Float[] d_times;
    private Map<Float, List<Pl3dMeta>> d_metaAtTimes;
    private XyzData[] d_xyzForMesh;

    public DataFinderSmvPlot3d(File f) {
        this.d_smvFile = f;
        this.d_times = new Float[0];
        this.d_metaAtTimes = new HashMap<Float, List<Pl3dMeta>>();
        this.d_xyzForMesh = new XyzData[0];
    }

    @Override
    public String getSourceFile() {
        return this.d_smvFile.getPath();
    }

    @Override
    public long getLastModified() {
        return this.d_smvFile.lastModified();
    }

    public boolean hasMeshData() {
        return this.d_xyzForMesh != null && this.d_xyzForMesh.length != 0;
    }

    @Override
    public void update() throws IOException {
        Collection<SmvParseUtil.ISmvSectionData> smvSectionData = SmvParseUtil.parseSmv(this.d_smvFile.toString(), SmvParseUtil.SmvSectionType.XYZ, SmvParseUtil.SmvSectionType.PL3D);
        List xyzSections = smvSectionData.stream().filter(sec -> sec instanceof SmvParseUtil.XYZSectionData).map(sec -> (SmvParseUtil.XYZSectionData)sec).collect(Collectors.toList());
        this.d_xyzForMesh = new XyzData[xyzSections.size()];
        for (SmvParseUtil.XYZSectionData xyz : xyzSections) {
            this.d_xyzForMesh[xyz.meshId - 1] = DataFinderSmvPlot3d.loadXyz(new File(this.d_smvFile.getParentFile(), xyz.getFilename()));
        }
        List pl3dSections = smvSectionData.stream().filter(sec -> sec instanceof SmvParseUtil.Pl3dSectionData).map(sec -> (SmvParseUtil.Pl3dSectionData)sec).collect(Collectors.toList());
        this.d_metaAtTimes = new HashMap<Float, List<Pl3dMeta>>();
        for (SmvParseUtil.Pl3dSectionData pl3d : pl3dSections) {
            List metas = this.d_metaAtTimes.computeIfAbsent(Float.valueOf(pl3d.timeStep), t -> new ArrayList());
            metas.add(DataFinderSmvPlot3d.pl3dSectionInfoToPl3dMeta(pl3d));
        }
        this.d_times = new Float[this.d_metaAtTimes.size()];
        this.d_metaAtTimes.keySet().toArray(this.d_times);
        Arrays.sort((Object[])this.d_times);
    }

    private static ByteBuffer readBytes(FileChannel srcFile, int bytes) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(bytes);
        bb.order(ByteOrder.nativeOrder());
        int read = srcFile.read(bb);
        if (read != bytes) {
            throw new IOException("Unexpected end of file.");
        }
        bb.position(0);
        return bb;
    }

    private static ByteBuffer readFortBlock(FileChannel srcFile) throws IOException {
        ByteBuffer szBuff = DataFinderSmvPlot3d.readBytes(srcFile, 4);
        int sz = szBuff.getInt();
        ByteBuffer data = DataFinderSmvPlot3d.readBytes(srcFile, sz);
        ByteBuffer szTailBuff = DataFinderSmvPlot3d.readBytes(srcFile, 4);
        assert (sz == szTailBuff.getInt());
        return data;
    }

    public static XyzData loadXyz(File f) throws IOException {
        FileInputStream strm = new FileInputStream(f);
        FileChannel chn = strm.getChannel();
        ByteBuffer bb = DataFinderSmvPlot3d.readFortBlock(chn);
        assert (bb.limit() == 12);
        int ibar1 = bb.getInt();
        int jbar1 = bb.getInt();
        int kbar1 = bb.getInt();
        bb.clear();
        bb = DataFinderSmvPlot3d.readFortBlock(chn);
        float[] xs = new float[ibar1];
        for (int k = 0; k < kbar1; ++k) {
            for (int j = 0; j < jbar1; ++j) {
                for (int i = 0; i < ibar1; ++i) {
                    xs[i] = bb.getFloat();
                }
            }
        }
        float[] ys = new float[jbar1];
        float y = Float.NaN;
        for (int k = 0; k < kbar1; ++k) {
            for (int j = 0; j < jbar1; ++j) {
                for (int i = 0; i < ibar1; ++i) {
                    y = bb.getFloat();
                }
                ys[j] = y;
            }
        }
        float[] zs = new float[kbar1];
        float z = Float.NaN;
        for (int k = 0; k < kbar1; ++k) {
            for (int j = 0; j < jbar1; ++j) {
                for (int i = 0; i < ibar1; ++i) {
                    z = bb.getFloat();
                }
            }
            zs[k] = z;
        }
        int[][][] blanks = new int[ibar1][jbar1][kbar1];
        for (int k = 0; k < kbar1; ++k) {
            for (int j = 0; j < jbar1; ++j) {
                for (int i = 0; i < ibar1; ++i) {
                    blanks[i][j][k] = bb.getInt();
                }
            }
        }
        strm.close();
        return new XyzData(ibar1, jbar1, kbar1, xs, ys, zs, blanks);
    }

    public static QData loadQ(Pl3dMeta meta, XyzData xyz, File f) throws IOException {
        FileInputStream strm = new FileInputStream(f);
        FileChannel chn = strm.getChannel();
        ByteBuffer bb = DataFinderSmvPlot3d.readFortBlock(chn);
        assert (bb.limit() == 12);
        int ibar1 = bb.getInt();
        int jbar1 = bb.getInt();
        int kbar1 = bb.getInt();
        bb.clear();
        bb = DataFinderSmvPlot3d.readFortBlock(chn);
        assert (bb.limit() == 16);
        bb = DataFinderSmvPlot3d.readFortBlock(chn);
        assert (bb.limit() == ibar1 * jbar1 * kbar1 * 5 * 4);
        float[] values = new float[ibar1 * jbar1 * kbar1 * 5];
        bb.asFloatBuffer().get(values);
        strm.close();
        return new QData(ibar1, jbar1, kbar1, values);
    }

    @Override
    public DataFinder.Quantity[] getQuantities() {
        if (this.d_times.length == 0) {
            return new DataFinder.Quantity[0];
        }
        List<Pl3dMeta> metas = this.d_metaAtTimes.get(this.d_times[0]);
        if (metas.isEmpty()) {
            return new DataFinder.Quantity[0];
        }
        Pl3dMeta meta = metas.get(0);
        return meta.params.toArray(new DataFinder.Quantity[meta.params.size()]);
    }

    @Override
    public Float[] getTimes() {
        return this.d_times;
    }

    private static Pl3dMeta pl3dSectionInfoToPl3dMeta(SmvParseUtil.Pl3dSectionData section) {
        ArrayList<DataFinder.Quantity> params = new ArrayList<DataFinder.Quantity>();
        for (String[] quant : section.quantInfos) {
            params.add(new DataFinder.Quantity(quant[0], quant[1], quant[2]));
        }
        return new Pl3dMeta(section.timeStep, section.meshId, section.fileName, params);
    }

    @Override
    public vtkDataObject getVtkDataAt(int timeIndex) {
        List<Pl3dMeta> metas = this.d_metaAtTimes.get(this.d_times[timeIndex]);
        vtkMultiPieceDataSet data = new vtkMultiPieceDataSet();
        data.SetNumberOfPieces(metas.size());
        int pieceId = 0;
        for (Pl3dMeta meta : metas) {
            XyzData xyz = null;
            try {
                xyz = this.d_xyzForMesh[meta.mesh - 1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new Error("XYZ data not found. FDS parameter WRITE_XYZ=.TRUE. required.", e);
            }
            QData qdata = null;
            try {
                qdata = DataFinderSmvPlot3d.loadQ(meta, xyz, new File(this.d_smvFile.getParentFile(), meta.fn));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (qdata == null) continue;
            vtkFloatArray xCoords = new vtkFloatArray();
            xCoords.SetJavaArray(xyz.xs);
            vtkFloatArray yCoords = new vtkFloatArray();
            yCoords.SetJavaArray(xyz.ys);
            vtkFloatArray zCoords = new vtkFloatArray();
            zCoords.SetJavaArray(xyz.zs);
            vtkRectilinearGrid grid = new vtkRectilinearGrid();
            grid.SetDimensions(xyz.xs.length, xyz.ys.length, xyz.zs.length);
            grid.SetXCoordinates(xCoords);
            grid.SetYCoordinates(yCoords);
            grid.SetZCoordinates(zCoords);
            int nflat = qdata.kbar1 * qdata.jbar1 * qdata.ibar1;
            for (int iq = 0; iq < 5; ++iq) {
                DataFinder.Quantity param = meta.params.get(iq);
                vtkFloatArray q = new vtkFloatArray();
                q.SetName(String.format("%s (%s)", param.friendlyName, param.unit));
                float[] jArr = new float[nflat];
                System.arraycopy(qdata.valuesIJKQ, iq * nflat, jArr, 0, nflat);
                q.SetJavaArray(jArr);
                grid.GetPointData().AddArray(q);
            }
            vtkFloatArray q = new vtkFloatArray();
            q.SetName("Embedded Solid");
            float[] blanksFlat = new float[nflat];
            int n = 0;
            for (int k = 0; k < xyz.kbar1; ++k) {
                for (int j = 0; j < xyz.jbar1; ++j) {
                    for (int i = 0; i < xyz.ibar1; ++i) {
                        blanksFlat[n] = xyz.blanks[i][j][k];
                        ++n;
                    }
                }
            }
            q.SetJavaArray(blanksFlat);
            grid.GetPointData().AddArray(q);
            data.SetPiece(pieceId++, grid);
        }
        return data;
    }

    private static class Pl3dMeta
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final float t;
        public final int mesh;
        public final String fn;
        public final List<DataFinder.Quantity> params;

        public Pl3dMeta(float t, int mesh, String fn, List<DataFinder.Quantity> params) {
            this.t = t;
            this.mesh = mesh;
            this.fn = fn;
            this.params = params;
        }

        public String toString() {
            return String.format("Pl3dMeta[t=%s,mesh=%s,fn=%s,params=%s]", Float.valueOf(this.t), this.mesh, this.fn, this.params);
        }
    }
}

