/*
 * Decompiled with CFR 0.152.
 */
package inferno.io;

import inferno.io.InfernoOIS;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.FileChannel;

public class SerializedOutputStream
implements Serializable {
    private static final long serialVersionUID = 6915461716151805089L;
    private String d_filename;
    private transient RandomAccessFile d_raf = null;
    private transient OutputStream d_stream = null;

    public SerializedOutputStream(String filename) {
        this.d_filename = filename;
    }

    public OutputStream stream() throws FileNotFoundException {
        this.initStreams(true);
        return this.d_stream;
    }

    private void initStreams(boolean deleteExisting) throws FileNotFoundException {
        if (this.d_stream == null || this.d_raf == null) {
            File file = new File(this.d_filename);
            if (deleteExisting) {
                file.delete();
            }
            this.d_raf = new RandomAccessFile(file, "rw");
            this.d_stream = new StreamedDataOutput(this.d_raf);
        }
    }

    public FileChannel getChannel() throws FileNotFoundException {
        this.initStreams(true);
        return this.d_raf.getChannel();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.initStreams(true);
        this.d_stream.flush();
        out.writeLong(this.d_raf.getChannel().size());
        out.writeLong(this.d_raf.getChannel().position());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        long fileLen = in.readLong();
        long filePos = in.readLong();
        this.d_filename = InfernoOIS.adjustOutputPath(in, this.d_filename);
        this.initStreams(false);
        this.d_raf.getChannel().truncate(fileLen);
        this.d_raf.getChannel().position(filePos);
    }

    private static class StreamedDataOutput
    extends OutputStream {
        private final DataOutput d_output;

        public StreamedDataOutput(DataOutput output) {
            this.d_output = output;
        }

        @Override
        public void write(int b) throws IOException {
            this.d_output.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.d_output.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.d_output.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            if (this.d_output instanceof Flushable) {
                ((Flushable)((Object)this.d_output)).flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.d_output instanceof Closeable) {
                ((Closeable)((Object)this.d_output)).close();
            }
        }
    }
}

