/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.geom.IValueField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class NaiveDistanceField
implements Serializable,
IValueField<Vector3d> {
    private static final long serialVersionUID = 2533441525863686389L;
    private List<WingedEdge> d_goal;

    public NaiveDistanceField(Collection<WingedEdge> goal) {
        assert (goal != null && !goal.isEmpty());
        this.d_goal = goal.size() == 1 ? Collections.singletonList(goal.iterator().next()) : new ArrayList<WingedEdge>(goal);
    }

    @Override
    public Vector3d getValue(TriPoint tp) {
        Point3d pNear = null;
        double nearestDistSq = Double.MAX_VALUE;
        for (WingedEdge e : this.d_goal) {
            double distSq;
            Point3d epNear;
            double dx = e.base.n2.p.x - e.base.n1.p.x;
            double dy = e.base.n2.p.y - e.base.n1.p.y;
            if (theUtil.eq0(dx * dx + dy * dy, 1.0E-9)) {
                epNear = e.base.n2.p;
            } else {
                double t = Inter2D.nearestTOnLineSeg(tp.p.x, tp.p.y, e.base.n1.p.x, e.base.n1.p.y, e.base.n2.p.x, e.base.n2.p.y);
                epNear = Util3D.linesegPoint(e.base.n1.p, e.base.n2.p, t);
            }
            if (!((distSq = tp.p.distanceSquared(epNear)) < nearestDistSq)) continue;
            nearestDistSq = distSq;
            pNear = epNear;
        }
        return Util3D.vector(tp.p, pNear);
    }
}

