/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.PointSeekArea;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.PathGen;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.Shortest;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import inferno.sim.steering.locallyquickest.PointTarget;
import java.io.Serializable;
import thunderheadeng.util.theUtil;

public class PointGoal
implements ISeekGoal,
Serializable {
    static final long serialVersionUID = 1L;
    public final ITpSource ptSrc;
    public final double radius;
    private boolean useShortestPlanner = false;

    public PointGoal(ITpSource ptSrc, double radius) {
        this.ptSrc = ptSrc;
        this.radius = radius;
    }

    public PointGoal(ITpSource ptSrc, double radius, boolean useShortestPlanner) {
        this(ptSrc, radius);
        this.useShortestPlanner = useShortestPlanner;
    }

    public int hashCode() {
        return 1714717917 + this.ptSrc.getTriPoint().hashCode() + theUtil.hashCode(this.radius);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PointGoal)) {
            return false;
        }
        PointGoal pg = (PointGoal)obj;
        return this.ptSrc.getTriPoint().equals(pg.ptSrc.getTriPoint()) && this.radius == pg.radius;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public Instance begin(KB kb, OccAgent agent) {
        return new Instance(this);
    }

    public static class Instance
    implements ISeekGoalInstance {
        private static final long serialVersionUID = 1L;
        private PointGoal pointGoal;
        private transient IProgressNote d_progress;

        public Instance(PointGoal pointGoal) {
            this.pointGoal = pointGoal;
        }

        @Override
        public PointGoal getGoal() {
            return this.pointGoal;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
            IPathPlanner pathPlanner;
            if (this.pointGoal.useShortestPlanner) {
                PathGen.PointGoal pg = new PathGen.PointGoal(this.pointGoal.ptSrc);
                pathPlanner = new Shortest(pg, false);
            } else {
                pathPlanner = new LocallyQuickest(agent, new LocalTimeEstimate.QueueSizes(), new PointTarget(this.pointGoal.ptSrc));
            }
            return SteerUtil.newSeekSteer(kb, agent, pathPlanner);
        }

        @Override
        public ISeekArea end(KB kb, OccAgent agent) {
            return this.getSeekArea(kb, agent);
        }

        @Override
        public ISeekArea getSeekArea(KB kb, OccAgent occ) {
            return new PointSeekArea(this.pointGoal.ptSrc, this.pointGoal.radius, 0);
        }

        @Override
        public boolean isReached(KB kb, OccAgent agent) {
            if (this.getSeekArea(kb, agent).contains(kb, agent.getLoc())) {
                return !kb.getMesh().isPathObstructed(agent.getLoc(), this.pointGoal.ptSrc.getTriPoint(), 0.0, EdgeFilters.acceptAll());
            }
            return false;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue crossedDoor) {
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            this.d_progress = GoalUtil.getSeekProgress(kb, occ, this.d_progress);
            return this.d_progress;
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            return true;
        }
    }
}

