/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Vector3d;

public class NavigateMeshData
implements Serializable {
    private static final long serialVersionUID = -3908615441929320959L;
    private ArrayList<DirData> data = new ArrayList();
    private Collection<OccAgent> highCostOccs;
    private int bestDirIndex;

    public Collection<OccAgent> getHighCostOccs() {
        return this.highCostOccs;
    }

    public void setHighCostOccs(Collection<OccAgent> highCostOccs) {
        this.highCostOccs = highCostOccs;
    }

    public List<DirData> getData() {
        return this.data;
    }

    public void addDir(Vector3d dir) {
        this.data.add(new DirData(dir));
    }

    public void addData(Behavior behavior, double cost, double maxSpeed) {
        DirData dd = this.data.get(this.data.size() - 1);
        int ix = behavior.ordinal();
        if (behavior == Behavior.ADDITIONAL && !Double.isNaN(dd.costs[ix])) {
            int n = ix;
            dd.costs[n] = dd.costs[n] + cost;
        } else {
            dd.costs[ix] = cost;
        }
        dd.maxSpeeds[ix] = maxSpeed;
        dd.totalMaxSpeed = Math.min(dd.totalMaxSpeed, maxSpeed);
        dd.totalCost += cost;
    }

    public int getBestDirIndex() {
        return this.bestDirIndex;
    }

    public void setBestDirIndex(int m) {
        this.bestDirIndex = m;
    }

    public class DirData
    implements Serializable {
        private static final long serialVersionUID = -4973692966721874827L;
        public Vector3d dir;
        public double[] costs;
        public double[] maxSpeeds;
        public double totalCost;
        public double totalMaxSpeed = Double.POSITIVE_INFINITY;

        public DirData(Vector3d dir) {
            this.dir = dir;
            this.costs = new double[Behavior.values().length];
            this.maxSpeeds = new double[Behavior.values().length];
            Arrays.fill(this.costs, Double.NaN);
            Arrays.fill(this.maxSpeeds, Double.NaN);
        }
    }

    public static enum Behavior {
        SEEK("seek"),
        SEEKSEP("seekSep"),
        SEEKWALLSEP("seekWallSep"),
        SEP("sep"),
        SOCIALDIST("socialDist"),
        AVOIDWALLS("avoidWalls"),
        AVOIDOCCS("avoidOccs"),
        AVOIDOBSTACLES("avoidObstacles"),
        LANEBEHAVIOR("laneBehavior"),
        CORNERBEHAVIOR("cornerBehavior"),
        PASS("pass"),
        ADDITIONAL("cc");

        public final String desc;

        private Behavior(String desc) {
            this.desc = desc;
        }
    }
}

