/*
 * Decompiled with CFR 0.152.
 */
package fpserver;

import fpserver.IPacket;
import fpserver.IServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ServerTcp
implements IServer {
    private final String d_desc;
    private ServerSocket d_serverSkt;
    private List<ClientTcp> d_clients;
    private Deque<IPacket> d_msgQueue;

    public ServerTcp(int port, String desc) {
        this.d_desc = desc;
        try {
            this.d_serverSkt = new ServerSocket(port);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.d_clients = Collections.synchronizedList(new ArrayList());
        this.d_msgQueue = new ArrayDeque<IPacket>();
        String tname = String.format("[%s] Client Listener", desc);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ServerTcp.this.listenForClients();
            }
        }, tname);
        t.start();
    }

    @Override
    public Deque<IPacket> getMessageQueue() {
        return this.d_msgQueue;
    }

    private void listenForClients() {
        System.out.println("TCP Server Listening on port: " + this.d_serverSkt.getLocalPort());
        while (true) {
            try {
                while (true) {
                    Socket clientSkt = this.d_serverSkt.accept();
                    System.out.printf("Connected to: %s:%d%n", clientSkt.getInetAddress().getHostName(), clientSkt.getPort());
                    this.addClientImpl(clientSkt);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void addClient(InetSocketAddress addr) {
        try {
            Socket clientSkt = new Socket(addr.getAddress(), addr.getPort());
            System.out.printf("Connected to: %s:%d%n", clientSkt.getInetAddress().getHostName(), clientSkt.getPort());
            this.addClientImpl(clientSkt);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcast(byte[] msg, int offset, int length, Object mergeId) {
        BroadcastData bd = new BroadcastData(msg, offset, length, mergeId);
        List<ClientTcp> list = this.d_clients;
        synchronized (list) {
            for (ClientTcp client : this.d_clients) {
                client.broadcaster.broadcast(bd);
            }
        }
    }

    @Override
    public void asyncSend(IPacket recvPacket, byte[] msg, int offset, int length, Object mergeId) {
        TcpPacket packet = (TcpPacket)recvPacket;
        packet.d_sender.broadcaster.broadcast(new BroadcastData(msg, offset, length, mergeId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClientImpl(final Socket clientSocket) throws IOException {
        ClientTcp client;
        List<ClientTcp> list = this.d_clients;
        synchronized (list) {
            int clientId = this.d_clients.size();
            client = new ClientTcp(clientId, clientSocket);
            String bcName = String.format("[%s] out: %s", this.d_desc, client.name);
            client.beginBroadcast(this, bcName);
            this.d_clients.add(client);
        }
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    System.out.println("Listening to: " + client.name);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), StandardCharsets.UTF_8));
                    String line = reader.readLine();
                    while (line != null) {
                        Deque<IPacket> deque = ServerTcp.this.d_msgQueue;
                        synchronized (deque) {
                            ServerTcp.this.d_msgQueue.add(new TcpPacket(ServerTcp.this, client, line));
                            ServerTcp.this.d_msgQueue.notify();
                        }
                        line = reader.readLine();
                    }
                }
                catch (SocketException e) {
                    System.err.printf("[%s] %s%n", client.name, e.getMessage());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                client.broadcaster.stop();
                ServerTcp.this.removeClient(client);
            }
        };
        Thread t = new Thread(runner, String.format("[%s] in : %s", this.d_desc, client.name));
        t.start();
    }

    private void removeClient(ClientTcp client) {
        System.out.printf("[%s] %s%n", client.name, "<disconnected>");
        this.d_clients.remove(client);
    }

    private static class BroadcastData {
        public final byte[] data;
        public final int offset;
        public final int len;
        public final Object mergeId;

        public BroadcastData(byte[] data, int offset, int len, Object mergeId) {
            this.data = data;
            this.offset = offset;
            this.len = len;
            this.mergeId = mergeId;
        }
    }

    public static class ClientTcp {
        public final int id;
        public final String name;
        public final Socket socket;
        public Broadcaster broadcaster;

        public ClientTcp(int id, Socket socket) throws IOException {
            this.id = id;
            this.name = String.format("%s:%d", socket.getInetAddress().getHostName(), socket.getPort());
            this.socket = socket;
            socket.setTcpNoDelay(true);
        }

        public Thread beginBroadcast(ServerTcp server, String threadName) {
            this.broadcaster = new Broadcaster(server, this);
            Thread t = new Thread((Runnable)this.broadcaster, threadName);
            t.start();
            return t;
        }
    }

    private static class Broadcaster
    implements Runnable {
        private final ServerTcp d_server;
        private final ClientTcp d_client;
        private final AtomicBoolean d_running;
        private final Deque<BroadcastData> d_dataQueue;

        public Broadcaster(ServerTcp server, ClientTcp client) {
            this.d_server = server;
            this.d_client = client;
            this.d_running = new AtomicBoolean(true);
            this.d_dataQueue = new ArrayDeque<BroadcastData>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void broadcast(BroadcastData data) {
            Deque<BroadcastData> deque = this.d_dataQueue;
            synchronized (deque) {
                if (data.mergeId != null) {
                    Iterator<BroadcastData> it = this.d_dataQueue.iterator();
                    while (it.hasNext()) {
                        BroadcastData next = it.next();
                        if (next.mergeId == null || !next.mergeId.equals(data.mergeId)) continue;
                        it.remove();
                        break;
                    }
                }
                this.d_dataQueue.add(data);
                this.d_dataQueue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.d_running.set(false);
            Deque<BroadcastData> deque = this.d_dataQueue;
            synchronized (deque) {
                this.d_dataQueue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.d_running.get()) {
                BroadcastData bd = null;
                Deque<BroadcastData> deque = this.d_dataQueue;
                synchronized (deque) {
                    while (this.d_dataQueue.isEmpty()) {
                        try {
                            this.d_dataQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.d_running.get()) continue;
                        return;
                    }
                    bd = this.d_dataQueue.removeFirst();
                }
                try {
                    OutputStream strm = this.d_client.socket.getOutputStream();
                    strm.write(bd.data, bd.offset, bd.len);
                    strm.flush();
                }
                catch (IOException e) {
                    System.err.printf("Error sending to client %s:%s. Disconnecting.%n", this.d_client.socket.getInetAddress(), this.d_client.socket.getPort());
                    this.d_server.removeClient(this.d_client);
                    return;
                }
            }
        }
    }

    public class TcpPacket
    implements IPacket {
        private ClientTcp d_sender;
        private String d_msg;

        public TcpPacket(ServerTcp this$0, ClientTcp sender, String msg) {
            this.d_sender = sender;
            this.d_msg = msg;
        }

        @Override
        public String getMsg() {
            return this.d_msg;
        }

        public ClientTcp getSender() {
            return this.d_sender;
        }

        @Override
        public int getClientId() {
            return this.d_sender.id;
        }
    }
}

