/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetIteratorDirectNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;

public abstract class GetIteratorDirectNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode getNextMethodNode;

    public GetIteratorDirectNode(JSContext context) {
        this.getNextMethodNode = PropertyGetNode.create(Strings.NEXT, context);
    }

    public abstract IteratorRecord execute(Object var1);

    @Specialization
    protected IteratorRecord get(JSObject obj) {
        return this.getImpl((Object)obj);
    }

    @Specialization(guards={"isForeignObject(obj)"})
    protected IteratorRecord get(Object obj) {
        return this.getImpl(obj);
    }

    private IteratorRecord getImpl(Object obj) {
        Object nextMethod = this.getNextMethodNode.getValue(obj);
        return IteratorRecord.create(obj, nextMethod, false);
    }

    @Fallback
    public IteratorRecord unsupported(Object obj) {
        throw Errors.createTypeErrorNotAnObject(obj, this);
    }

    public static GetIteratorDirectNode create(JSContext context) {
        return GetIteratorDirectNodeGen.create(context);
    }
}

