/*
 * Decompiled with CFR 0.152.
 */
package results.nativebuffered.session;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.swing.SwingUtilities;
import results.Intl;
import results.api.Events;
import results.api.ISession;
import results.nativebuffered.data.Unknown;
import results.nativebuffered.session.Selection;
import results.nativebuffered.session.SessionMediator;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.animate.IAnimator;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.io.nativexfer.ANativeObject;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.nativexfer.NativeArrayInfo;
import thunderheadeng.io.nativexfer.NativeManager;
import thunderheadeng.scene3d.FPSTimer;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.IObject;
import thunderheadeng.scene3d.nativebuffered.nb3dUtil;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.RProp;
import thunderheadeng.util.RWProp;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;
import thunderheadeng.video.IVideoCompressor;

public class Session
extends ANativeObject
implements ISession,
IDomainObject<SessionMediator> {
    private static final long serialVersionUID = 2552868747989005314L;
    public static final RWProp<Camera> CAMERA = new RWProp<Camera>((Object)35887354, Camera.class);
    public static final RWProp<Boolean> DRAW_MATERIALS = new RWProp<Boolean>((Object)16351807, true);
    public static final RWProp<Boolean> DRAW_OUTLINES = new RWProp<Boolean>((Object)1154879, false);
    public static final RWProp<Boolean> DRAW_WIREFRAME = new RWProp<Boolean>((Object)11072298, false);
    public static final RWProp<Double> WALL_HEIGHT = new RWProp<Double>((Object)146171, 0.0);
    public static final RWProp<Double> FLOOR_SEP = new RWProp<Double>((Object)53778682, 0.0);
    public static final RWProp<VideoRecState> VIDEO_RECORD = new RWProp<VideoRecState>((Object)40879, VideoRecState.STOPPED);
    private static final int TYPE_EVENT = 0;
    private static final int TYPE_SCENEEVENT = 1;
    private static final int TYPE_TIMEEVENT = 2;
    private SessionMediator d_domain;
    private final FPSTimer d_fps;
    private final List<IAnimator> d_animators;
    private int d_pauseCounter;
    private Selection d_selection;

    public Session() {
        this.d_fps = new FPSTimer(1.0, fps -> {});
        this.d_animators = new ArrayList<IAnimator>();
        this.d_pauseCounter = 0;
        this.d_selection = new Selection(this);
        this.syncSelection();
        this.postUpdate();
    }

    public Session(Integer key, long cptr) {
        super(key, cptr);
        this.d_fps = new FPSTimer(1.0, fps -> {});
        this.d_animators = new ArrayList<IAnimator>();
        this.d_pauseCounter = 0;
        this.d_selection = new Selection(this);
    }

    @Override
    public Class<?> resolveNativeClass() {
        return Session.class;
    }

    private void exec(Methods methods, Object ... args) {
        Native.manager.execMethod(Session.class, (INativeObject)this, methods, args);
    }

    private <T> T exec(Methods methods, Function<NativeManager, T> get, Object ... args) {
        return Native.manager.exec(Session.class, (INativeObject)this, (Enum)methods, get, args);
    }

    public void pauseSessionUpdates() {
        ++this.d_pauseCounter;
    }

    public void resumeSessionUpdates() {
        --this.d_pauseCounter;
        if (this.d_pauseCounter == 0) {
            this.postUpdate();
        }
    }

    @Override
    public Selection getSelection() {
        return this.d_selection;
    }

    @Override
    public SessionMediator getDomain() {
        return this.d_domain;
    }

    @Override
    public void setDomain(SessionMediator owner) {
        this.d_domain = owner;
    }

    @Override
    public void addAnimator(IAnimator animator) {
        this.d_animators.add(animator);
    }

    @Override
    public Collection<? extends IAnimator> getAnimators() {
        return this.d_animators;
    }

    @Override
    public void removeAnimator(IAnimator animator) {
        this.d_animators.remove(animator);
    }

    public FPSTimer getFPSTimer() {
        return this.d_fps;
    }

    public void startVideoRecord(String path, IVideoCompressor compressor) throws IOException {
        try {
            Native.manager.execThrowable(Session.class, (INativeObject)this, (Enum)Methods.startVideoRecord, path, compressor);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() {
        boolean complete;
        if (this.d_pauseCounter != 0) {
            return;
        }
        this.d_fps.start();
        this.beginNative();
        try {
            this.nativeBeginUpdate(this.getKey());
            complete = this.nativeUpdateAnimators(this.getKey());
            for (IAnimator anim : new ArrayList<IAnimator>(this.d_animators)) {
                complete &= anim.update(this);
            }
            boolean done = complete;
            this.pauseUpdates();
            Native.invokeAndWait(() -> this.nativeUpdateViews(this.getKey()));
            this.resumeUpdates();
            this.nativeEndUpdate(this.getKey(), done);
        }
        finally {
            this.endNative();
        }
        this.d_fps.stop();
        if (!complete) {
            this.postUpdate();
        }
    }

    private void beginNative() {
        Native.keygen.beginReserveKeys();
    }

    private void endNative() {
        Native.keygen.endReserveKeys();
    }

    private native void nativeBeginUpdate(int var1);

    private native boolean nativeUpdateAnimators(int var1);

    private native void nativeUpdateViews(int var1);

    private native void nativeEndUpdate(int var1, boolean var2);

    @Override
    public void wakeUp() {
        this.nativeWakeUp(this.getKey());
    }

    private native void nativeWakeUp(int var1);

    private void postUpdate() {
        SwingUtilities.invokeLater(this::update);
    }

    @Override
    public <T> void set(RWProp<T> prop, T val) {
        this.exec(Methods.set, (Integer)prop.key, val);
        Native.manager.flush();
    }

    @Override
    public <T> T get(RProp<T> prop) {
        Integer key = (Integer)prop.key;
        if (prop == TIME_RANGE) {
            return (T)this.exec(Methods.get, (NativeManager m) -> m.readArray(double[].class, 2), key);
        }
        return (T)this.exec(Methods.get, (NativeManager m) -> m.read(prop.type), key);
    }

    @Override
    public double getFPS() {
        return this.d_fps.getFPS();
    }

    public Camera getPredefCamera(PredefCamera type) {
        return this.exec(Methods.getPredefCamera, (NativeManager m) -> m.read(Camera.class), new Object[]{type});
    }

    private void translateEvent(Session session, int event, NativeArrayInfo objs) {
        if (this.getDomain() != null) {
            PFEvent.values()[event].fire(session, this.getDomain().getEvents(), objs == null ? null : objs.toArray(Native.manager));
        }
    }

    protected void syncSelection() {
        List<Object> newSel;
        this.beginNative();
        try {
            NativeArrayInfo nai = this.nativeGetSelection(this.getKey());
            newSel = nai.toList(Native.manager);
        }
        finally {
            this.endNative();
        }
        this.d_selection.synced(newSel);
    }

    private native NativeArrayInfo nativeGetSelection(int var1);

    protected void setSelected(Collection<?> o, boolean selected) {
        IFilteredCollection<IObject> nobjects = theUtil.filter(o, IObject.class);
        if (nobjects.isEmpty()) {
            return;
        }
        this.exec(Methods.setSelected, selected, nobjects.size(), nobjects);
        Native.manager.flush();
    }

    static {
        nb3dUtil.registerTypes();
        NativeManager.registerWriter(Enum.class, (m, e) -> m.writeInt(e.ordinal()));
        NativeManager.registerReader(IAnimSession.State.class, m -> IAnimSession.State.values()[m.readInt()]);
        NativeManager.registerReader(VideoRecState.class, m -> VideoRecState.values()[m.readInt()]);
    }

    private static enum Methods {
        set,
        get,
        getPredefCamera,
        startVideoRecord,
        setSelected;

    }

    private static enum PFEvent {
        MT_PATHFINDER_RESULTS_ATTACHED(new Object[]{Events.PATHFINDER_RESULTS_ATTACHED}),
        MT_PATHFINDER_RESULTS_DETACHED(new Object[]{Events.PATHFINDER_RESULTS_DETACHED}),
        MT_OBJS_SELECTED(new Object[]{Events.SELECTION_CHANGED}),
        MT_OBJS_DESELECTED(new Object[]{Events.SELECTION_CHANGED}),
        MT_FDS_RESULTS_ADDED(new Object[]{Events.FDS_RESULTS_ATTACHED}),
        MT_FDS_RESULTS_REMOVED(new Object[]{Events.FDS_RESULTS_DETACHED}),
        MT_TIME_CHANGED(TIME, TIME_RANGE, TIME_LOOP),
        MT_AGENTS_ADDED(EventType.ADD),
        MT_AGENTS_REMOVED(EventType.REMOVE),
        MT_GEOM_OBJS_ADDED(EventType.ADD),
        MT_GEOM_OBJS_REMOVED(EventType.REMOVE),
        MT_FDS_PARTICLES_ADDED(EventType.ADD),
        MT_FDS_PARTICLES_REMOVED(EventType.REMOVE),
        EVT_FLOOR_LAYOUT(FLOOR_SEP),
        EVT_FLOOR_CLIPPING(WALL_HEIGHT),
        EVT_VIDEORECORD(VIDEO_RECORD),
        EVT_RENDER_PROPS(DRAW_MATERIALS, DRAW_OUTLINES, DRAW_WIREFRAME),
        EVT_RESET_CURRENT_CAM(new Object[]{Events.CAMERA_RESET}),
        EVT_RESET_ALL_CAMS(new Object[]{Events.CAMERA_RESET}),
        EVT_RESET_CAMERA(new Object[]{Events.CAMERA_RESET}),
        EVT_CAMERA_CHANGED(CAMERA),
        EVT_STATE_CHANGED(ISession.STATE),
        EVT_SPEED_CHANGED(ISession.TIME_SCALE),
        UNKNOWN;

        public final EventType type;
        public final Object[] evts;

        private PFEvent() {
            this(EventType.OTHER);
        }

        private PFEvent(Object ... evts) {
            this.type = EventType.OTHER;
            this.evts = evts;
        }

        private PFEvent(EventType type) {
            this.type = type;
            this.evts = new Object[]{this};
        }

        public void fire(Session session, thunderheadeng.util.Events events, Object ... objs) {
            Set<Session> lobjs = objs == null || objs.length == 0 ? Collections.singleton(session) : Arrays.asList(objs);
            switch (this) {
                case MT_PATHFINDER_RESULTS_ATTACHED: 
                case MT_PATHFINDER_RESULTS_DETACHED: {
                    session.syncSelection();
                    break;
                }
                case MT_OBJS_SELECTED: {
                    session.d_selection.selected(theUtil.filter(Arrays.asList(objs), new TypeFilter(Unknown.class).negate()));
                    break;
                }
                case MT_OBJS_DESELECTED: {
                    session.d_selection.deselected(theUtil.filter(Arrays.asList(objs), new TypeFilter(Unknown.class).negate()));
                }
            }
            switch (this.type) {
                case ADD: {
                    events.added(lobjs);
                    break;
                }
                case REMOVE: {
                    events.removed(lobjs);
                    break;
                }
                default: {
                    events.changed(lobjs, this.evts);
                }
            }
        }
    }

    public static enum VideoRecState {
        STOPPED,
        RECORDING,
        PAUSED,
        ERROR;

    }

    public static enum EventType {
        ADD,
        REMOVE,
        OTHER;

    }

    public static enum PredefCamera {
        PERSPECTIVE("Perspective", Intl.intl("Switch to the Perspective View"), "merlin/icons/perspective16.png"),
        ORTHO_TOP("Top", Intl.intl("Switch to the Top View"), "thunderheadeng/gui/graphics/ViewXY.gif"),
        ORTHO_FRONT("Front", Intl.intl("Switch to the Front View"), "thunderheadeng/gui/graphics/ViewXZ.gif"),
        ORTHO_LEFT("Left", Intl.intl("Switch to the Left View"), "thunderheadeng/gui/graphics/ViewYZ.gif");

        public final String name;
        public final String desc;
        public final String iconLoc;

        private PredefCamera(String name, String desc, String iconLoc) {
            this.name = name;
            this.desc = desc;
            this.iconLoc = iconLoc;
        }
    }
}

