/*
 * Decompiled with CFR 0.152.
 */
package results.nativebuffered.session;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import results.api.ISelection;
import results.nativebuffered.session.Session;

public class Selection
implements ISelection {
    private final Set<Object> d_selectionSet = new LinkedHashSet<Object>();
    private final Session d_session;

    public Selection(Session session) {
        this.d_session = session;
    }

    @Override
    public void select(Object obj) {
        this.selectAll(Collections.singleton(obj));
    }

    @Override
    public void selectAll(Collection<?> objs) {
        this.d_session.setSelected(objs, true);
    }

    @Override
    public void deselect(Object obj) {
        this.deselectAll(Collections.singleton(obj));
    }

    @Override
    public void deselectAll(Collection<?> objs) {
        this.d_session.setSelected(objs, false);
    }

    @Override
    public boolean isSelected(Object o) {
        if (o == null) {
            return this.isEmpty();
        }
        return this.d_selectionSet.contains(o);
    }

    @Override
    public Set<?> getSelection() {
        return this.d_selectionSet;
    }

    @Override
    public <T> Collection<T> flatten(Class<T> type) {
        return Collections.emptySet();
    }

    @Override
    public <T> Collection<T> flatten(Class<T> type, Predicate<T> filter) {
        return Collections.emptySet();
    }

    protected void selected(Collection<Object> objs) {
        this.d_selectionSet.addAll(objs);
    }

    protected void deselected(Collection<Object> objs) {
        this.d_selectionSet.removeAll(objs);
    }

    protected void synced(Collection<Object> newSel) {
        this.d_selectionSet.clear();
        this.d_selectionSet.addAll(newSel);
    }
}

