/*
 * Decompiled with CFR 0.152.
 */
package results.nativebuffered.mv;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.RProp;
import thunderheadeng.util.RWProp;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import thunderheadeng.video.IVideoCompressor;

public class VideoCompressorPrefs {
    private final TypedProp<String> DESCRIPTION;
    private final PrefInfo<UnitDouble> QUALITY;
    private final PrefInfo<UnitDouble> DATARATE;
    private final PrefInfo<Integer> KEYFRAME_INTERVAL;
    private final List<PrefInfo<?>> d_all;

    public VideoCompressorPrefs(String setName) {
        this.DESCRIPTION = VideoCompressorPrefs.newPref(setName, IVideoCompressor.DESCRIPTION, "compressor.name");
        this.QUALITY = VideoCompressorPrefs.newPrefInfo(setName, IVideoCompressor.QUALITY, "compressor.quality");
        this.DATARATE = VideoCompressorPrefs.newPrefInfo(setName, IVideoCompressor.DATARATE, "compressor.datarate");
        this.KEYFRAME_INTERVAL = VideoCompressorPrefs.newPrefInfo(setName, IVideoCompressor.KEYFRAME_INTERVAL, "compressor.frameinterval");
        this.d_all = Arrays.asList(this.QUALITY, this.DATARATE, this.KEYFRAME_INTERVAL);
    }

    private static <T> PrefInfo<T> newPrefInfo(String setName, RWProp<T> cprop, String prefName) {
        return new PrefInfo<T>(VideoCompressorPrefs.newPref(setName, cprop, prefName), cprop);
    }

    private static <T> TypedProp<T> newPref(String setName, RProp<T> cprop, String prefName) {
        String key = setName + "." + prefName;
        return cprop.defVal == null ? new TypedProp((Object)key, cprop.type) : new TypedProp<Object>((Object)key, cprop.defVal);
    }

    public void save(TeciProps prefs, IVideoCompressor compressor) {
        if (compressor == null) {
            prefs.remove(this.DESCRIPTION);
            return;
        }
        prefs.set(this.DESCRIPTION, compressor.get(IVideoCompressor.DESCRIPTION));
        for (PrefInfo<?> pref : this.d_all) {
            if (!compressor.isSupported(pref.cprop)) continue;
            prefs.set(pref.pref, compressor.get(pref.cprop));
        }
    }

    public IVideoCompressor load(TeciProps prefs, List<IVideoCompressor> compressors) {
        if (compressors.isEmpty()) {
            return null;
        }
        String cname = prefs.get(this.DESCRIPTION);
        if (cname == null || cname.isEmpty()) {
            return null;
        }
        Optional<IVideoCompressor> initCompressor = compressors.stream().filter(c -> c.get(IVideoCompressor.DESCRIPTION).equals(cname)).findFirst();
        initCompressor.ifPresent(c -> this.initCompressor((IVideoCompressor)c, prefs));
        return initCompressor.orElse(null);
    }

    private void initCompressor(IVideoCompressor compressor, TeciProps props) {
        for (PrefInfo<?> pref : this.d_all) {
            if (!compressor.isSupported(pref.cprop)) continue;
            compressor.set(pref.cprop, props.get(pref.pref));
        }
    }

    private static class PrefInfo<T> {
        public final TypedProp<T> pref;
        public final RWProp<T> cprop;

        public PrefInfo(TypedProp<T> pref, RWProp<T> cprop) {
            this.pref = pref;
            this.cprop = cprop;
        }
    }
}

