/*
 * Decompiled with CFR 0.152.
 */
package results.nativebuffered.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import results.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.video.VideoCompressorDlg;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.TypedProp;
import thunderheadeng.video.IVideoCompressor;
import thunderheadeng.video.IVideoCompressors;

public class MovieDlg
extends guiDialog {
    private static final long serialVersionUID = -5036518071295187830L;
    private final MoviePnl d_pnl;

    public MovieDlg(Window parent, String title, IVideoCompressors.Type videoType, List<IVideoCompressor> compressors, Supplier<Dimension> windowSize, IUnitSrc timeUnitSrc, UnitDouble minTime, UnitDouble maxTime) {
        super(parent, title, 9);
        this.d_pnl = new MoviePnl(videoType, compressors, windowSize, timeUnitSrc, minTime, maxTime);
        this.getDialogPane().setLayout(new BorderLayout());
        this.getDialogPane().add((Component)this.d_pnl, "Center");
    }

    public void load(IPropertySet props) {
        this.d_pnl.load(props);
    }

    public void save(IPropertySet props) {
        this.d_pnl.save(props);
    }

    private static int roundNearestMultipleOf4(int val) {
        if (val % 4 == 0) {
            return val;
        }
        return 4 * (val / 4 + 1);
    }

    public static class MoviePnl
    extends guiPanel {
        private static final long serialVersionUID = -3726290301854534931L;
        private static final Unit FPS_UNIT = Unit.ONE.label(Intl.intl("frames")).divide(SI.SECOND);
        public static final TypedProp<IVideoCompressor> COMPRESSOR = new TypedProp<IVideoCompressor>((Object)622474, IVideoCompressor.class);
        public static final TypedProp<Dimension> SIZE = new TypedProp<Dimension>((Object)1017850, Quality.HD_1080p30.size);
        public static final TypedProp<UnitDouble> FRAMERATE = new TypedProp<UnitDouble>((Object)11110219, new UnitDouble(30.0, FPS_UNIT));
        public static final TypedProp<Double> SPEED = new TypedProp<Double>((Object)17970303, 1.0);
        public static final TypedProp<UnitDouble[]> TRANGE = new TypedProp<UnitDouble[]>((Object)159099567, new UnitDouble[]{new UnitDouble(0.0, SI.SECOND), new UnitDouble(0.0, SI.SECOND)});
        public static final TypedProp<Boolean> LOD = new TypedProp<Boolean>((Object)4401551, false);
        public static final TypedProp<Boolean> WATCH_WHEN_FINISHED = new TypedProp<Boolean>((Object)10060794, true);
        private final List<IVideoCompressor> d_compressors;
        private final HTMLBtn d_compressorBtn;
        private final guiComboBox<Quality> d_qualityCombo;
        private final ValueField<Integer> d_widthFld;
        private final ValueField<Integer> d_heightFld;
        private final ValueField<Double> d_frameRateFld;
        private final ValueField<Double> d_speedFld;
        private final ValueField<UnitDouble> d_tmin;
        private final ValueField<UnitDouble> d_tmax;
        private final guiCheckBox d_lodCB;
        private final guiCheckBox d_watchCB;
        private IVideoCompressor d_compressor;

        public MoviePnl(IVideoCompressors.Type videoType, List<IVideoCompressor> compressors, Supplier<Dimension> windowSize, IUnitSrc timeUnitSrc, UnitDouble minTime, UnitDouble maxTime) {
            this.d_compressor = !compressors.isEmpty() ? compressors.iterator().next() : null;
            this.d_compressors = compressors;
            this.d_compressorBtn = new HTMLBtn("");
            this.d_compressorBtn.addActionListener(e -> {
                VideoCompressorDlg cdlg = new VideoCompressorDlg(SwingUtilities.getWindowAncestor(this), Intl.intl("Choose Video Compressor"), videoType, compressors, true);
                cdlg.load(this.d_compressor);
                if (cdlg.doModal() == 1) {
                    this.d_compressor = cdlg.save();
                    this.setModified(true);
                    this.syncCompressor();
                }
            });
            this.d_qualityCombo = new guiComboBox<Quality>(Quality.values());
            this.d_qualityCombo.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 3702490324781075158L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    this.setText(((Quality)((Object)value)).description);
                    return this;
                }
            });
            this.d_widthFld = MoviePnl.format(ValueFields.intFld(IntVR.above(0, false)));
            this.d_heightFld = MoviePnl.format(ValueFields.intFld(IntVR.above(0, false)));
            JButton useWindowSizeBtn = new JButton(Intl.intl("Use window size"));
            useWindowSizeBtn.addActionListener(e -> {
                Dimension d = (Dimension)windowSize.get();
                this.d_widthFld.setValue(d.width);
                this.d_heightFld.setValue(d.height);
            });
            this.d_frameRateFld = MoviePnl.format(ValueFields.doubleFld(DoubleVR.above(0.0, false)));
            this.d_qualityCombo.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.syncQuality();
            });
            this.d_speedFld = MoviePnl.format(ValueFields.doubleFld(DoubleVR.above(0.0, false)));
            this.d_tmin = MoviePnl.format(ValueFields.udFld(timeUnitSrc, UnitDoubleVR.between(minTime, maxTime, true, true)));
            this.d_tmax = MoviePnl.format(ValueFields.udFld(timeUnitSrc, UnitDoubleVR.between(minTime, maxTime, true, true)));
            this.d_lodCB = new guiCheckBox(Intl.intl("Enabled Level of Detail"));
            this.d_watchCB = new guiCheckBox(Intl.intl("Watch movie when finished"));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Compressor:"), this.d_compressorBtn, 0);
            gb.addRow(Intl.intl("Quality:"), this.d_qualityCombo, 0);
            gb.beginGroup("quality");
            gb.addRow(Intl.intl("Video Size:"), this.d_widthFld, "x", this.d_heightFld, Intl.intl("pixels"), useWindowSizeBtn);
            gb.addRow(Intl.intl("Framerate:"), this.d_frameRateFld, Intl.intl("frames/second"), 0);
            gb.endGroup();
            gb.addRow(Intl.intl("Speed:"), this.d_speedFld, "X", 0);
            gb.addRow(Intl.intl("Time Range:"), this.d_tmin, Intl.intl("to"), this.d_tmax);
            gb.addRow(this.d_lodCB, 0);
            gb.addRow(this.d_watchCB, 0);
            gb.finalizeRows();
            this.sync();
        }

        private static <T> ValueField<T> format(ValueField<T> field) {
            field.setColumns(6);
            return field;
        }

        private void sync() {
            this.syncQuality();
            this.syncCompressor();
        }

        private void syncQuality() {
            Quality res = this.d_qualityCombo.getSelectedItem();
            boolean custom = res == Quality.CUSTOM;
            this.setGroupVisible("quality", custom);
            if (!custom) {
                this.d_widthFld.setValue(res.size.width);
                this.d_heightFld.setValue(res.size.height);
                this.d_frameRateFld.setValue(res.framerate.get(Unit.ONE.divide(SI.SECOND)));
            }
            this.repack();
        }

        private void repack() {
            Window parent = SwingUtilities.getWindowAncestor(this);
            if (parent != null) {
                parent.pack();
            }
        }

        private void syncCompressor() {
            String desc = this.d_compressor != null ? this.d_compressor.get(IVideoCompressor.DESCRIPTION) : Intl.intl("<none>");
            this.d_compressorBtn.setText(desc);
            this.repack();
        }

        public void load(IPropertySet props) {
            this.d_compressor = props.get(COMPRESSOR);
            Dimension size = props.get(SIZE);
            this.d_widthFld.setValue(size.width);
            this.d_heightFld.setValue(size.height);
            UnitDouble framerate = props.get(FRAMERATE);
            this.d_frameRateFld.setValue(framerate.get(FPS_UNIT));
            UnitDouble[] trange = props.get(TRANGE);
            this.d_tmin.setValue(trange[0]);
            this.d_tmax.setValue(trange[1]);
            this.d_lodCB.setSelected(props.get(LOD));
            this.d_watchCB.setSelected(props.get(WATCH_WHEN_FINISHED));
            this.d_speedFld.setValue(props.get(SPEED));
            Quality preQual = Quality.get(size.width, size.height, framerate);
            this.d_qualityCombo.setSelectedItem((Object)preQual);
            this.sync();
        }

        public void save(IPropertySet props) {
            props.setIfNotDefault(COMPRESSOR, this.d_compressor);
            props.setIfNotDefault(SIZE, new Dimension((Integer)this.d_widthFld.getValue(), (Integer)this.d_heightFld.getValue()));
            props.setIfNotDefault(FRAMERATE, new UnitDouble((Double)this.d_frameRateFld.getValue(), FPS_UNIT));
            props.setIfNotDefault(TRANGE, new UnitDouble[]{(UnitDouble)this.d_tmin.getValue(), (UnitDouble)this.d_tmax.getValue()});
            props.setIfNotDefault(LOD, this.d_lodCB.isSelected());
            props.setIfNotDefault(WATCH_WHEN_FINISHED, this.d_watchCB.isSelected());
            props.setIfNotDefault(SPEED, (Double)this.d_speedFld.getValue());
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_compressor == null) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("A compressor must be selected."), Intl.intl("No Compressor Selected"), 0);
                }
                return false;
            }
            if (((UnitDouble)this.d_tmin.getValue()).ge((UnitDouble)this.d_tmax.getValue(), 0.0)) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("The start time must be less than the end time."), Intl.intl("Time Range Invalid"), 0);
                }
                if (allowModify) {
                    this.d_tmin.requestFocus();
                }
                return false;
            }
            if (this.d_qualityCombo.getSelectedItem() == Quality.CUSTOM) {
                int width = (Integer)this.d_widthFld.getValue();
                int height = (Integer)this.d_heightFld.getValue();
                if (width % 4 != 0 || height % 4 != 0) {
                    int sel;
                    if (showWarn) {
                        sel = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Some compressors require that the video width and/or height be a\nmultiple of 4. Do you want the width and height to be rounded up\nto the nearest multiple of 4?"), Intl.intl("Possible Size Incompatibility"), 1);
                    } else {
                        int n = sel = allowModify ? 0 : 1;
                    }
                    if (sel == 0) {
                        width = MovieDlg.roundNearestMultipleOf4(width);
                        height = MovieDlg.roundNearestMultipleOf4(height);
                        this.d_widthFld.setValue(width);
                        this.d_heightFld.setValue(height);
                        System.out.printf("Setting resolution to %d x %d%n", width, height);
                    } else if (sel != 1) {
                        return false;
                    }
                }
            }
            return true;
        }

        private static enum Quality {
            UHD_4kp60(Intl.intl("4k UHD 60fps"), 3840, 2160, 60.0),
            UHD_4kp30(Intl.intl("4k UHD 30fps"), 3840, 2160, 30.0),
            UHD_4kp24(Intl.intl("4k UHD 24fps"), 3840, 2160, 24.0),
            HD_1080p60(Intl.intl("1080p 60fps"), 1920, 1080, 60.0),
            HD_1080p30(Intl.intl("1080p 30fps"), 1920, 1080, 30.0),
            HD_1080p24(Intl.intl("1080p 24fps"), 1920, 1080, 24.0),
            HD_720p60(Intl.intl("720p 60fps"), 1280, 720, 60.0),
            HD_720p30(Intl.intl("720p 30fps"), 1280, 720, 30.0),
            HD_720p24(Intl.intl("720p 24fps"), 1280, 720, 24.0),
            SD_480p60(Intl.intl("480p 60fps"), 640, 480, 60.0),
            SD_480p30(Intl.intl("480p 30fps"), 640, 480, 30.0),
            SD_480p24(Intl.intl("480p 24fps"), 640, 480, 24.0),
            CUSTOM(Intl.intl("Custom"));

            public final String description;
            public final Dimension size;
            public final UnitDouble framerate;

            private Quality(String desc, int w, int h, double fps) {
                this.description = String.format("%s (%dx%d)", desc, w, h);
                this.size = new Dimension(w, h);
                this.framerate = new UnitDouble(fps, FPS_UNIT);
            }

            private Quality(String label) {
                this.description = label;
                this.size = null;
                this.framerate = null;
            }

            public static Quality get(int width, int height, UnitDouble framerate) {
                for (Quality q : Quality.values()) {
                    if (q.size.width != width || q.size.height != height || !q.framerate.epsilonEquals(framerate, 1.0E-9)) continue;
                    return q;
                }
                return CUSTOM;
            }
        }
    }
}

