/*
 * Decompiled with CFR 0.152.
 */
package montecarlo;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import merlin.Intl;
import montecarlo.CreateCases;
import org.fusesource.jansi.AnsiConsole;
import picocli.CommandLine;
import thunderheadeng.util.Pair;

public class Run {
    public static int run(CommandLine.ParseResult pr) {
        Integer helpExitCode = CommandLine.executeHelpRequest(pr);
        if (helpExitCode != null) {
            return helpExitCode;
        }
        File pthFile = pr.matchedPositionalValue(0, null);
        assert (pthFile != null);
        int n = pr.matchedPositionalValue(1, Integer.valueOf(0));
        assert (n > 0);
        CreateCases obj = new CreateCases(pthFile, n);
        LinkedHashMap<String, Pair<CreateCases.PathFilterType, Boolean>> filterOptions = new LinkedHashMap<String, Pair<CreateCases.PathFilterType, Boolean>>();
        filterOptions.put("--include", new Pair<CreateCases.PathFilterType, Boolean>(CreateCases.PathFilterType.INCLUDE, true));
        filterOptions.put("--exclude", new Pair<CreateCases.PathFilterType, Boolean>(CreateCases.PathFilterType.EXCLUDE, false));
        filterOptions.put("--include_pos", new Pair<CreateCases.PathFilterType, Boolean>(CreateCases.PathFilterType.INCLUDE_POS, true));
        filterOptions.put("--exclude_pos", new Pair<CreateCases.PathFilterType, Boolean>(CreateCases.PathFilterType.EXCLUDE_POS, false));
        filterOptions.put("--include_props", new Pair<CreateCases.PathFilterType, Boolean>(CreateCases.PathFilterType.INCLUDE_PROPS, true));
        filterOptions.put("--exclude_props", new Pair<CreateCases.PathFilterType, Boolean>(CreateCases.PathFilterType.EXCLUDE_PROPS, false));
        filterOptions.put("--include_profs", new Pair<CreateCases.PathFilterType, Boolean>(CreateCases.PathFilterType.INCLUDE_PROFS, true));
        filterOptions.put("--exclude_profs", new Pair<CreateCases.PathFilterType, Boolean>(CreateCases.PathFilterType.EXCLUDE_PROFS, false));
        for (Map.Entry entry : filterOptions.entrySet()) {
            String arg = (String)entry.getKey();
            CreateCases.PathFilterType ft = (CreateCases.PathFilterType)((Object)((Pair)entry.getValue()).v1);
            boolean include = (Boolean)((Pair)entry.getValue()).v2;
            if (!pr.hasMatchedOption(arg)) continue;
            String userFilter = pr.matchedOptionValue(arg, "");
            obj.filters.put(ft, new CreateCases.PathFilter(include, userFilter));
        }
        int roomRule = pr.matchedOptionValue("--room_rule", Integer.valueOf(0));
        if (0 == roomRule) {
            obj.roomRule = CreateCases.RoomRule.SAME;
        } else if (1 == roomRule) {
            obj.roomRule = CreateCases.RoomRule.UNION;
        } else if (2 == roomRule) {
            obj.roomRule = CreateCases.RoomRule.ANY;
        }
        String profRngStr = pr.matchedOptionValue("--profiles", CreateCases.ProfileRng.DEFAULT);
        if (!CreateCases.ProfileRng.DEFAULT.equals(profRngStr)) {
            obj.profRng = CreateCases.ProfileRng.parse(profRngStr);
        }
        if (pr.hasMatchedOption("--uniform_dist")) {
            obj.distPosRule = CreateCases.DistPos.UNIFORM;
        }
        obj.installFolderOverride = pr.matchedOptionValue("--install-folder", null);
        obj.d_rseed = pr.matchedOptionValue("--rseed", Long.valueOf(System.currentTimeMillis()));
        try {
            obj.generate();
            return 0;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return 1;
        }
    }

    public static void main(String[] args) {
        AnsiConsole.systemInstall();
        CommandLine.Model.CommandSpec spec = CommandLine.Model.CommandSpec.create().name("montecarlo").version("2023.3.1206").mixinStandardHelpOptions(true);
        spec.usageMessage().descriptionHeading("%n").description(Intl.intl("Create variations of a pathfinder model.%n")).optionListHeading("%n" + Intl.intl("Options:") + "%n").parameterListHeading(Intl.intl("Required Parameters:") + "%n").footerHeading("%n" + Intl.intl("Notes:") + "%n").footer("", Intl.intl("* When combining includes and excludes in the same command, includes are always processed first, followed by excludes. In addition, exclusion filter categories are processed in order from less specific to more specific (e.g. --include is processed before --include_pos)."), "", Intl.intl("* PATHSPEC arguments will match an occupant if it matches ANY part of that occupant's path."), "");
        spec.addPositional(((CommandLine.Model.PositionalParamSpec.Builder)((CommandLine.Model.PositionalParamSpec.Builder)((CommandLine.Model.PositionalParamSpec.Builder)((CommandLine.Model.PositionalParamSpec.Builder)CommandLine.Model.PositionalParamSpec.builder().required(true)).paramLabel(Intl.intl("PTHFILE"))).type(File.class)).description(Intl.intl("Input PTH file to process (will not be changed)"))).build());
        spec.addPositional(((CommandLine.Model.PositionalParamSpec.Builder)((CommandLine.Model.PositionalParamSpec.Builder)((CommandLine.Model.PositionalParamSpec.Builder)((CommandLine.Model.PositionalParamSpec.Builder)CommandLine.Model.PositionalParamSpec.builder().required(true)).paramLabel(Intl.intl("N"))).type(Integer.class)).description(Intl.intl("Number of cases to generate"))).build());
        spec.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder("--include", new String[0]).paramLabel(Intl.intl("PATHSPEC"))).type(String.class)).description(Intl.intl("Randomize position and properties of agents matched by PATHSPEC"))).build());
        spec.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder("--include_pos", new String[0]).paramLabel(Intl.intl("PATHSPEC"))).type(String.class)).description(Intl.intl("Randomize positions of agents matched by PATHSPEC"))).build());
        spec.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder("--include_props", new String[0]).paramLabel(Intl.intl("PATHSPEC"))).type(String.class)).description(Intl.intl("Randomize properties of agents matched by PATHSPEC"))).build());
        spec.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder("--include_profs", new String[0]).paramLabel(Intl.intl("PATHSPEC"))).type(String.class)).description(Intl.intl("Randomize profiles of agents matched by PATHSPEC"))).build());
        spec.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder("--exclude", new String[0]).paramLabel(Intl.intl("PATHSPEC"))).type(String.class)).description(Intl.intl("Do not randomize position and properties of agents matched by PATHSPEC"))).build());
        spec.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder("--exclude_pos", new String[0]).paramLabel(Intl.intl("PATHSPEC"))).type(String.class)).description(Intl.intl("Do not randomize position of agents matched by PATHSPEC"))).build());
        spec.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder("--exclude_props", new String[0]).paramLabel(Intl.intl("PATHSPEC"))).type(String.class)).description(Intl.intl("Do not randomize properties of agents matched by PATHSPEC"))).build());
        spec.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder("--exclude_profs", new String[0]).paramLabel(Intl.intl("PATHSPEC"))).type(String.class)).description(Intl.intl("Do not randomize profiles of agents matched by PATHSPEC"))).build());
        spec.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder("--room_rule", new String[0]).paramLabel(Intl.intl("n"))).type(Integer.class)).description(Intl.intl("When randomizing position, this parameter controls which rooms an occupant is eligible to occupy. Room selection rule options (n):%n  0 - (default) Current room only%n  1 - Any room containing a position randomized occupant%n  2 - Any non-disabled, occupiable room%n"))).build());
        spec.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder("--profiles", new String[0]).paramLabel(Intl.intl("PROFSPEC"))).type(String.class)).description(Intl.intl("When randomizing profiles, this parameter controls the probability of each profile being assigned to an occupant. Be default, no occupant profiles will be changed.%nExample PROFSPEC:%n%n  50/\"slow\":45/\"very fast\"%n%nGives:%n  50%% use profile named \"slow\"%n  45%% use profile named \"very fast\"%n   5%% (unassigned) no change to profile%n"))).build());
        spec.addOption(((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder("--uniform_dist", new String[0]).description(Intl.intl("Change the position distribution from random (default) to  uniform."))).build());
        spec.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder("--install-folder", new String[0]).paramLabel(Intl.intl("FOLDER"))).type(File.class)).description(Intl.intl("Override default install folder search when generating BAT files."))).build());
        spec.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder("--rseed", new String[0]).paramLabel(Intl.intl("S"))).type(Long.TYPE)).description(Intl.intl("Specify a random seed."))).build());
        CommandLine cli = new CommandLine(spec);
        cli.setOptionsCaseInsensitive(true);
        cli.setUnmatchedArgumentsAllowed(false);
        cli.setOverwrittenOptionsAllowed(false);
        cli.setExecutionStrategy(pr -> Run.run(pr));
        int exitCode = cli.execute(args);
        System.exit(exitCode);
    }
}

