/*
 * Decompiled with CFR 0.152.
 */
package merlin.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import merlin.Intl;
import thunderheadeng.util.Filters;

public class Tags {
    private static final RejectReservedForFutureUse REJECT_RESERVED = new RejectReservedForFutureUse();

    public static Set<String> parse(String text, boolean allowEmpty, boolean allowPredefs, Set<String> predefTags) throws ParseException {
        List tags = Stream.of(text.split("[ ,;]+")).map(s -> s.trim().toLowerCase(Locale.ROOT)).filter(s -> !s.isEmpty()).collect(Collectors.toCollection(() -> new ArrayList()));
        if (!allowEmpty && tags.isEmpty()) {
            throw new ParseException(Intl.intl("At least one tag must be specified."), 0);
        }
        if (!allowPredefs) {
            Predicate<String> filter = Filters.reject(predefTags).and(REJECT_RESERVED);
            Optional<String> badTag = tags.stream().filter(filter.negate()).findFirst();
            if (badTag.isPresent()) {
                String message = !REJECT_RESERVED.test(badTag.get()) ? REJECT_RESERVED.toString() : String.format(Intl.intl("The following tags are reserved:\n    %s"), String.join((CharSequence)"\n    ", predefTags));
                int offset = text.indexOf(badTag.get());
                throw new ParseException(message, offset);
            }
        }
        if (tags.isEmpty()) {
            return Collections.emptySet();
        }
        if (tags.size() == 1) {
            return Collections.singleton((String)tags.get(0));
        }
        return new LinkedHashSet<String>(tags);
    }

    public static String format(Set<String> val) {
        return String.join((CharSequence)" ", val);
    }

    private static final class RejectReservedForFutureUse
    implements Predicate<String> {
        private RejectReservedForFutureUse() {
        }

        @Override
        public boolean test(String t) {
            return !t.startsWith("pf_");
        }

        public String toString() {
            return String.format(Intl.intl("Tags must not start with \"%s\"."), "pf_");
        }
    }
}

