/*
 * Decompiled with CFR 0.152.
 */
package merlin.util;

import java.awt.Color;
import java.io.File;
import java.nio.file.Path;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.vecmath.Point3d;
import merlin.EntryPointFactory;
import merlin.MerlinApp;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.MerlinHierarchy;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.ChangeBehavior;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.geom.Geometry;
import merlin.unitsystem.UnitSystem;
import merlin.util.AStar;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Global;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;

public class MerlinUtil
extends theUtil {
    public static final boolean USE_ASTAR_SEARCH = false;
    private static final Random s_curveSeedGen = new Random();

    public static UnitPoint3D getUPoint3D(Point3d p) {
        Unit curlu = MerlinApp.getApp().getUnitSystem().getLength();
        return UnitPoint3D.convert(p, Geometry.LENGTH_UNIT, curlu);
    }

    public static String format(double v, Unit from, Unit to) {
        return Global.format(UnitDouble.convert(v, from, to), to);
    }

    public static String format(double v, Unit from, IUnitSrc unitType) {
        return MerlinUtil.format(v, from, unitType.getUnit());
    }

    public static String format(double v, Unit from, int unitType) {
        return MerlinUtil.format(v, from, MerlinApp.getApp().getUnitSystem().getUnit(unitType));
    }

    public static String format(UnitDouble v, Unit to) {
        return MerlinUtil.format(v.getValueNoUnit(), v.getUnit(), to);
    }

    public static String format(UnitDouble v, IUnitSrc unitType) {
        return MerlinUtil.format(v.getValueNoUnit(), v.getUnit(), unitType.getUnit());
    }

    public static String format(UnitDouble v, int unitType) {
        return MerlinUtil.format(v.getValueNoUnit(), v.getUnit(), unitType);
    }

    public static String getName(IMerlinObj obj) {
        if (obj == null) {
            return "";
        }
        MerlinData domain = (MerlinData)obj.getDomain();
        if (domain == null && (domain = MerlinApp.getAppData()) == null) {
            if (obj instanceof INamed) {
                return ((INamed)((Object)obj)).getName();
            }
            return obj.toString();
        }
        return EntryPointFactory.get(obj).tvEntryPoint.getName(domain, obj);
    }

    public static String getName(Object obj) {
        if (obj instanceof IMerlinObj) {
            return MerlinUtil.getName((IMerlinObj)obj);
        }
        if (obj instanceof INamed) {
            return ((INamed)obj).getName();
        }
        return obj == null ? "" : obj.toString();
    }

    public static String getNameWithBreadcrumbs(Object root, IMerlinObj mobj) {
        MerlinData md = MerlinApp.getApp().getData();
        Object[] path = md.hierarchy.getPath(mobj, root, false);
        StringBuilder desc = new StringBuilder();
        for (int m = 0; m < path.length; ++m) {
            String name;
            Object obj = path[m];
            if (!(obj instanceof IMerlinObj) || (name = MerlinUtil.getName((IMerlinObj)obj)) == null || name.isEmpty()) continue;
            if (desc.length() != 0) {
                desc.append("->");
            }
            desc.append(name);
        }
        return desc.toString();
    }

    public static <T> Collection<T> getEnabledMembers(MerlinData md, Composite<? extends ICompElement> root, Class<T> type, boolean deep) {
        Collection<T> base = deep ? root.getDeepMembers(type) : root.getMembers(type);
        return MerlinUtil.getEnabledMembers(md, base, type);
    }

    public static <T> Collection<T> getEnabledMembers(MerlinData md, Collection<?> objs, Class<T> type) {
        return theUtil.filter(objs, type, o -> EntryPointFactory.get(o).tvEntryPoint.isEnabled(md, o));
    }

    public static Path relativizeFile(MerlinData md, Path targetPath) {
        if (md.filename == null) {
            return targetPath;
        }
        try {
            Path pthDirPath = new File(md.filename).getParentFile().toPath();
            return pthDirPath.relativize(targetPath);
        }
        catch (IllegalArgumentException e) {
            return targetPath;
        }
    }

    public static Path relativizeFile(MerlinData md, String targetPath) {
        return MerlinUtil.relativizeFile(md, new File(targetPath).toPath());
    }

    public static Path relativizeFile(Path targetPath) {
        MerlinData md = MerlinApp.getAppData();
        return MerlinUtil.relativizeFile(md, targetPath);
    }

    public static Path relativizeFile(String absolutePath) {
        return MerlinUtil.relativizeFile(new File(absolutePath).toPath());
    }

    public static Path resolveFile(MerlinData md, Path relativePath) {
        try {
            if (md.filename == null) {
                return relativePath;
            }
            Path pthDirPath = new File(md.filename).getParentFile().toPath();
            return pthDirPath.resolve(relativePath).toAbsolutePath();
        }
        catch (Exception e) {
            return relativePath;
        }
    }

    public static Path resolveFile(MerlinData md, String relativePath) {
        return MerlinUtil.resolveFile(md, new File(relativePath).toPath());
    }

    public static Path resolveFile(Path relativePath) {
        MerlinData md = MerlinApp.getAppData();
        return MerlinUtil.resolveFile(md, relativePath);
    }

    public static Path resolveFile(String relativePath) {
        return MerlinUtil.resolveFile(new File(relativePath).toPath());
    }

    public static Collection<Object> flatten(Collection<?> objs) {
        return new DeepCollection<Object>(objs, Object.class, Filters.acceptAll());
    }

    public static <T> Collection<T> flatten(Collection<?> objs, Class<T> type) {
        return new DeepCollection<T>(objs, type, Filters.acceptAll());
    }

    public static <T> Collection<T> flatten(Collection<?> objs, Class<T> type, Predicate<? super T> filter) {
        return new DeepCollection<T>(objs, type, filter);
    }

    public static Collection<ICompElement> flattenComposites(Collection<? extends IMerlinObj> objs) {
        return MerlinUtil.flatten(objs, ICompElement.class, CompositeFilter.INSTANCE);
    }

    public static boolean test(int options, int option) {
        return (options & option) == option;
    }

    public static boolean isConnected(IEgressComp source, IEgressObj ... targets) {
        return MerlinUtil.isConnected(source, Arrays.asList(targets));
    }

    public static boolean isConnected(IEgressComp source, Collection<? extends IEgressObj> targets) {
        return MerlinUtil.isConnectedBruteForce(source, targets);
    }

    private static boolean isConnectedAStar(IEgressComp source, Collection<? extends IEgressObj> targets) {
        for (IEgressObj iEgressObj : targets) {
            if (!MerlinUtil.isConnectedAStarImpl(source, Collections.singleton(iEgressObj))) continue;
            return true;
        }
        return false;
    }

    private static boolean isConnectedAStarImpl(IEgressComp source, Collection<? extends IEgressObj> targets) {
        Set<? extends IEgressObj> targetsSet = MerlinUtil.toSet(targets);
        AStarNode start = new AStarNode(source, source.astarGetTestPoint());
        Function<AStarNode, Collection> getAdjNodes = node -> {
            if (!(node.v1 instanceof IEgressComp)) {
                return Collections.emptyList();
            }
            Collection<? extends IEgressObj> adj = ((IEgressObj)node.v1).getConnections();
            adj = theUtil.filter(adj, (? super T obj) -> !(obj instanceof AEgressComp) || ((AEgressComp)obj).isEnabled());
            return theUtil.map(adj, (InT obj) -> new AStarNode((IEgressObj)obj, obj.astarGetSharedPt((IEgressObj)node.v1)));
        };
        ToDoubleFunction<AStarNode> heuristic = node -> {
            double minDistSq = Double.POSITIVE_INFINITY;
            for (IEgressObj target : targets) {
                double distsq;
                Point3d p = target.astarProject((IEgressObj)node.v1, (Point3d)node.v2);
                if (p == null || !((distsq = ((Point3d)node.v2).distanceSquared(p)) < minDistSq)) continue;
                minDistSq = distsq;
            }
            return Double.isInfinite(minDistSq) ? minDistSq : Math.sqrt(minDistSq);
        };
        ToDoubleBiFunction<AStarNode, AStarNode> cost = (nsource, ntarget) -> ((Point3d)nsource.v2).distance((Point3d)ntarget.v2);
        Predicate<AStarNode> goalReached = node -> targetsSet.contains(node.v1);
        AStar.IAStarResult result = AStar.getPath(start, getAdjNodes, heuristic, cost, goalReached);
        return result instanceof AStar.AStarSuccess;
    }

    private static Set<? extends IEgressObj> toSet(Collection<? extends IEgressObj> objs) {
        if (objs instanceof Set) {
            return (Set)objs;
        }
        if (objs.isEmpty()) {
            return Collections.emptySet();
        }
        if (objs.size() == 1) {
            return Collections.singleton(objs.iterator().next());
        }
        return new IdentityHashSet<IEgressObj>(objs);
    }

    private static boolean isConnectedBruteForce(IEgressComp obj1, Collection<? extends IEgressObj> targets) {
        for (IEgressObj iEgressObj : targets) {
            if (!MerlinUtil.isConnectedBruteForce(obj1, iEgressObj)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConnectedBruteForce(IEgressComp obj1, IEgressObj obj2) {
        if (obj1 == obj2) {
            return true;
        }
        IdentityHashSet closed = new IdentityHashSet();
        ArrayDeque<IEgressObj> open = new ArrayDeque<IEgressObj>();
        open.push(obj1);
        closed.add(obj1);
        while (!open.isEmpty()) {
            IEgressObj comp = (IEgressObj)open.pop();
            for (IEgressObj iEgressObj : comp.getConnections()) {
                if (iEgressObj instanceof AEgressComp && !((AEgressComp)iEgressObj).isEnabled()) continue;
                if (iEgressObj == obj2) {
                    return true;
                }
                if (!(iEgressObj instanceof IEgressComp) || !closed.add(iEgressObj)) continue;
                open.push(iEgressObj);
            }
        }
        return false;
    }

    public static Color newRandomOccColor() {
        return MerlinUtil.newRandomOccColor(new Random());
    }

    public static Color newRandomOccColor(Random r) {
        return new Color(r.nextInt(256), r.nextInt(256), r.nextInt(256));
    }

    public static <T extends IMerlinObj> Comparator<T> getSorter(MerlinData md, Collection<? extends T> items) {
        Set<Object> itemSet = items instanceof Set ? (Set<Object>)items : new IdentityHashSet<T>(items);
        boolean containsHierarchy = items.stream().anyMatch(item -> {
            Object o = item;
            while (o != null) {
                Object parent = md.hierarchy.getParent(o);
                if (itemSet.contains(parent)) {
                    return true;
                }
                o = parent;
            }
            return false;
        });
        if (containsHierarchy) {
            return new MerlinHierarchy.FlattenedComparator(md.hierarchy);
        }
        return new SortByName();
    }

    public static boolean isBehaviorTerminal(Behavior seed) {
        IdentityHashSet visited = new IdentityHashSet();
        visited.add(seed);
        ArrayDeque<Behavior> open = new ArrayDeque<Behavior>();
        open.push(seed);
        while (!open.isEmpty()) {
            Behavior behavior = (Behavior)open.removeFirst();
            Optional<IBehaviorAction> lastAction = theUtil.getLast(behavior.getMembers(IBehaviorAction.class));
            if (!lastAction.isPresent()) {
                return false;
            }
            if (lastAction.get() instanceof ChangeBehavior) {
                ChangeBehavior cb = (ChangeBehavior)lastAction.get();
                for (Behavior target : cb.getAllTargetBehaviors()) {
                    if (!visited.add(target)) continue;
                    open.add(target);
                }
                continue;
            }
            if (lastAction.get().isTerminal()) continue;
            return false;
        }
        return true;
    }

    public static boolean canRandomize(ICompElement obj) {
        return obj.getPropTypes(1).contains(MerlinData.SEED);
    }

    public static long newSeed() {
        return theUtil.randomSeed(s_curveSeedGen);
    }

    public static boolean isNonRoot(IMerlinObj obj) {
        return obj.getDomain() == null || obj.getParent() != obj.getDomain();
    }

    public static UnaryOperator<Unit> getDisplayUnitSupplier(int ... unitTypeHints) {
        UnitSystem unitSystem = Optional.ofNullable(MerlinApp.getAppData()).map(d -> d.getUnitSystem()).orElse(null);
        if (unitSystem == null) {
            return u -> u;
        }
        if (unitTypeHints.length == 0) {
            return unit -> {
                int type = UnitSystem.getType(unit);
                return type != -1 ? unitSystem.getUnit(type) : unit;
            };
        }
        List unitHints = IntStream.of(unitTypeHints).mapToObj(unitSystem::getUnit).collect(Collectors.toList());
        return unit -> {
            Optional<Unit> compUnit = unitHints.stream().filter(u -> UnitDouble.areCompatible(unit, u)).findFirst();
            if (compUnit.isPresent()) {
                return compUnit.get();
            }
            int type = UnitSystem.getType(unit);
            return type != -1 ? unitSystem.getUnit(type) : unit;
        };
    }

    public static String formatTags(Set<String> tags, String sep, int maxLen) {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        String text = String.join((CharSequence)sep, tags);
        String elipses = "...";
        if (text.length() > maxLen) {
            sb.append(text.substring(0, maxLen - "...".length()));
            sb.append("...");
        } else {
            sb.append(text);
        }
        sb.append('>');
        return sb.toString();
    }

    public static PropertySet clone(PropertySet props, Function<Object, IPropertySet.Prop<?>> getProp, BiFunction<IPropertySet.Prop<?>, Object, Object> cloneValue) {
        return props.clone((key, val) -> {
            IPropertySet.Prop prop = (IPropertySet.Prop)getProp.apply(key);
            return prop != null ? cloneValue.apply(prop, val) : val;
        });
    }

    public static class DeepCollection<T>
    extends AbstractCollection<T> {
        private int d_size = -1;
        private final Class<T> d_typeFilter;
        private final Predicate<? super T> d_filter;
        private final Collection<?> d_objs;

        public DeepCollection(Object root, Class<T> typeFilter, Predicate<? super T> filter) {
            this(Collections.singleton(root), typeFilter, filter);
        }

        public DeepCollection(Collection<?> objs, Class<T> typeFilter, Predicate<? super T> filter) {
            this.d_typeFilter = typeFilter;
            this.d_filter = filter;
            this.d_objs = objs;
        }

        @Override
        public Iterator<T> iterator() {
            return new DeepIterator<T>(this.d_objs, this.d_typeFilter, this.d_filter);
        }

        @Override
        public int size() {
            if (this.d_size == -1) {
                this.d_size = 0;
                Iterator<T> it = this.iterator();
                while (it.hasNext()) {
                    ++this.d_size;
                    it.next();
                }
            }
            return this.d_size;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }
    }

    public static class CompositeFilter<T>
    implements Predicate<T> {
        public static final CompositeFilter<Object> INSTANCE = new CompositeFilter();

        @Override
        public boolean test(T o) {
            return !(o instanceof Composite);
        }
    }

    private static class AStarNode
    extends Pair<IEgressObj, Point3d> {
        private static final long serialVersionUID = 9187455415920842323L;

        public AStarNode(IEgressObj obj, Point3d pt) {
            super(obj, pt);
        }

        @Override
        public int hashCode() {
            return 0x3298FA ^ ((IEgressObj)this.v1).hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof AStarNode && ((IEgressObj)((AStarNode)obj).v1).equals(this.v1);
        }
    }

    public static class SortByName<T extends IMerlinObj>
    implements Comparator<T> {
        @Override
        public int compare(T o1, T o2) {
            String name1 = MerlinUtil.getName(o1);
            String name2 = MerlinUtil.getName(o2);
            return name1.compareToIgnoreCase(name2);
        }
    }

    private static class DeepIterator<T>
    implements Iterator<T> {
        private final Class<T> d_typeFilter;
        private final Predicate<? super T> d_filter;
        private final Stack<Iterator<?>> d_iteratorStack;
        private T d_nextObj;

        public DeepIterator(Collection<?> objs, Class<T> typeFilter, Predicate<? super T> filter) {
            this.d_typeFilter = typeFilter;
            this.d_filter = filter;
            this.d_iteratorStack = new Stack();
            this.d_iteratorStack.push(objs.iterator());
            this.prefetchNext();
        }

        private void prefetchNext() {
            while (!this.d_iteratorStack.isEmpty()) {
                Iterator<Object> curIt = this.d_iteratorStack.peek();
                while (curIt.hasNext()) {
                    Collection<? extends IMerlinObj> children;
                    boolean found = false;
                    Object next = curIt.next();
                    if (this.d_typeFilter.isInstance(next) && this.d_filter.test(next)) {
                        this.d_nextObj = next;
                        found = true;
                    }
                    if (next instanceof IMerlinObj && !(children = ((IMerlinObj)next).getChildren()).isEmpty()) {
                        curIt = children.iterator();
                        this.d_iteratorStack.push(curIt);
                    }
                    if (!found) continue;
                    return;
                }
                this.d_iteratorStack.pop();
            }
        }

        @Override
        public boolean hasNext() {
            return !this.d_iteratorStack.isEmpty();
        }

        @Override
        public T next() {
            T next = this.d_nextObj;
            this.prefetchNext();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

