/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.Delete;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.RoomUtil;
import merlin.mv.ModelView;
import merlin.mv.tools.AMerlinTool;
import merlin.mv.tools.RoomSnapConstraint;
import merlin.mv.tools.RoomToolUtil;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.scene3d.nativebuffered.GenericActor;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;

public class ThinWallTool
extends AMerlinTool {
    private final MerlinData d_data;
    private final ModelScene d_scene;
    private final GenericActor d_actor;
    private Collection<IsectInfo> d_p0Isects = null;
    private Collection<IsectInfo> d_p1Isects = null;

    public ThinWallTool(ModelView mv, MerlinData md) {
        super(mv, (IToolFunction<? extends CursorTool>)new Func());
        this.d_data = md;
        this.d_scene = mv.getMainScene();
        this.d_actor = new GenericActor();
        this.d_actor.setColor(Color.YELLOW);
        this.d_actor.setLineWidth(3.0);
        this.d_actor.setLineStipplePattern(1, (short)-256);
        this.d_actor.setPointSize(10.0);
        this.setSnapInfo(SnapMode.FILTERED_TWO_PASS, new DefaultFilter());
    }

    @Override
    public boolean cancel() {
        this.cancelPickPoints();
        return super.cancel();
    }

    @Override
    public void activate() {
        this.d_scene.addRenderableObjects(this.d_actor);
        super.activate();
    }

    @Override
    public void deactivate() {
        this.d_scene.removeRenderableObjects(this.d_actor);
        super.deactivate();
    }

    private void commitPickPoints(MouseEvent e) {
        final Collection<IsectInfo> p0Isects = this.d_p0Isects;
        final Collection<IsectInfo> p1Isects = this.d_p1Isects;
        AMerlinOp op = new AMerlinOp(this){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                ArrayList<RoomToolUtil.Projection> projections = new ArrayList<RoomToolUtil.Projection>();
                try (MerlinData.ReadLock lock = md.lockRead();){
                    RoomToolUtil.project(md, ((IsectInfo)p0Isects.iterator().next()).isectPoint, ((IsectInfo)p1Isects.iterator().next()).isectPoint, projections);
                }
                boolean modified = false;
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    Undo.begin(Intl.intl("Room Split"));
                    Map<EgressRoom, List<LineSeg>> projMap = RoomToolUtil.convertToMap(projections);
                    HashSet<EgressRoom> toDelete = new HashSet<EgressRoom>();
                    ArrayList<EgressRoom> toClean = new ArrayList<EgressRoom>();
                    for (Map.Entry<EgressRoom, List<LineSeg>> entry : projMap.entrySet()) {
                        EgressRoom geom = entry.getKey();
                        Undo.insertUndoEntry_restore(md, geom);
                        List<EgressRoom> splitGeom = geom.addBoundary((Collection<? extends ICurve>)entry.getValue(), 0.0);
                        if (splitGeom.size() > 1) {
                            Composite parent = (Composite)md.hierarchy.getParent(geom);
                            Undo.insertUndoEntry_add(md, geom);
                            parent.remove(geom);
                            toDelete.add(geom);
                            Undo.insertUndoEntry_delete(md, parent, splitGeom);
                            RoomUtil.assignSeparatedProps(splitGeom, md.roomNameGen);
                            parent.addAll(splitGeom);
                            toClean.addAll(splitGeom);
                        } else {
                            toClean.add(geom);
                        }
                        modified = true;
                    }
                    Delete.deleteAll(md, toDelete);
                    EgressRoom.cleanup(md, toClean);
                    Undo.end(md, modified);
                }
            }
        };
        UIHook.run(e.getComponent(), "ThinWallTool.commitPickPoints", op, 4);
        this.resetIsects();
    }

    private void cancelPickPoints() {
        this.resetIsects();
        this.updateGraphics();
    }

    private void resetIsects() {
        this.d_p1Isects = null;
        this.d_p0Isects = null;
    }

    private void updateGraphics() {
        this.d_actor.resetData();
        if (this.d_p0Isects != null && this.d_p1Isects != null) {
            this.d_actor.addLine(this.d_p0Isects.iterator().next().isectPoint, this.d_p1Isects.iterator().next().isectPoint);
        }
        this.d_actor.finalizeData();
    }

    protected static class Func
    extends AToolFunction<ThinWallTool> {
        protected Func() {
        }

        @Override
        public ISnapConstraint getSnapConstraint(ThinWallTool tool) {
            return new RoomSnapConstraint(tool.d_data, null, i -> i.obj instanceof EgressRoom && i.searchType.fromFace);
        }

        @Override
        public Cursor getCursor(ThinWallTool tool) {
            return null;
        }

        @Override
        public void mouseDragged(ThinWallTool tool, MouseEvent e) {
        }

        @Override
        public void mousePressed(ThinWallTool tool, MouseEvent e) {
        }

        private void updateIsects(ThinWallTool tool) {
            Collection<IsectInfo> snaps = tool.getP1().getFinalSnaps();
            if (snaps.isEmpty()) {
                return;
            }
            if (tool.d_p0Isects == null) {
                tool.d_p0Isects = snaps;
            } else {
                tool.d_p1Isects = snaps;
            }
        }

        @Override
        public void mouseMoved(ThinWallTool tool, MouseEvent e) {
            if (tool.d_p0Isects != null) {
                this.updateIsects(tool);
            }
            tool.updateGraphics();
            tool.repaintSurface();
        }

        @Override
        public void mouseReleased(ThinWallTool tool, MouseEvent e) {
            if (!tool.dragAboveTolerance(0)) {
                if (e.getButton() != 1) {
                    tool.cancelPickPoints();
                    return;
                }
                this.updateIsects(tool);
                if (tool.d_p1Isects != null) {
                    tool.commitPickPoints(e);
                    tool.finish();
                }
                tool.updateGraphics();
                tool.repaintSurface();
            }
        }

        @Override
        public String getStatusMessage(ThinWallTool tool) {
            int ptNum;
            if (!tool.getP1().isSnapped()) {
                return super.getStatusMessage(tool);
            }
            Collection<IsectInfo> isects = tool.getP1().snaps;
            int n = ptNum = tool.d_p0Isects == null ? 1 : 2;
            if (!isects.isEmpty()) {
                return String.format(Intl.intl("Point %1$d: %2$s"), ptNum, tool.toString(isects.iterator().next().isectPoint));
            }
            return "";
        }
    }
}

