/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.vecmath.Point3d;
import merlin.builders.CorridorBuilder;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.mv.ModelView;
import merlin.mv.displays.MerlinDispProps;
import merlin.mv.tools.MerlinTool;
import thunderheadeng.scene3d.nativebuffered.GenericActor;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.IRenderable;
import thunderheadeng.scene3d.nativebuffered.ISceneObject;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IsectInfo;

public class NewCorrTool2Pt<T extends CorridorBuilder>
extends MerlinTool<T> {
    private IDisplayable d_lastDisplay;

    public NewCorrTool2Pt(ModelView mv) {
        super(mv, new Func());
        this.setSnapInfo(SnapMode.FILTERED_TWO_PASS, new SnapFilter(this));
    }

    @Override
    protected void propsChanged(T props, Object arg) {
        if (((CorridorBuilder)this.props()).aPropChanged(CorridorBuilder.CANCELLED, CorridorBuilder.WIDTH_CHANGED, CorridorBuilder.POINT_SET)) {
            this.regenDisplay();
            this.repaintSurface();
        }
        if (((CorridorBuilder)this.props()).aPropChanged(CorridorBuilder.COMPLETED)) {
            this.finish();
        }
    }

    @Override
    public void deactivate() {
        this.removeLastDisplay();
        super.deactivate();
        this.repaintSurface();
    }

    @Override
    public boolean cancel() {
        ((CorridorBuilder)this.props()).cancel();
        return super.cancel();
    }

    @Override
    protected void toggleModifier() {
        ((CorridorBuilder)this.props()).setWidth(((CorridorBuilder)this.props()).getWidth().negate());
    }

    private void removeLastDisplay() {
        if (this.d_lastDisplay != null) {
            this.getModelView().getToolScenes()[0].removeObjects(this.d_lastDisplay);
            this.d_lastDisplay = null;
        }
    }

    private void regenDisplay() {
        this.removeLastDisplay();
        if (((CorridorBuilder)this.props()).getPoint(0) == null) {
            return;
        }
        EgressCorridor corr = ((CorridorBuilder)this.props()).build();
        if (corr == null) {
            Point3d[] points = ((CorridorBuilder)this.props()).getPoint(1) != null ? ((CorridorBuilder)this.props()).getStartPoints3() : ((CorridorBuilder)this.props()).getStartPoints2();
            if (points != null) {
                GenericActor actor = new GenericActor();
                actor.resetData();
                actor.setLineWidth(6.0);
                actor.setEdgeColor(MerlinDispProps.CORRIDOR_COLOR);
                actor.addLine(points[0], points[1]);
                actor.finalizeData();
                this.d_lastDisplay = actor;
                this.getModelView().getToolScenes()[0].addRenderableObjects((IRenderable)this.d_lastDisplay);
            }
        } else {
            this.d_lastDisplay = new GeomDisplay(((ModelView)this.getModelView()).getDisplayProps(), corr);
            this.getModelView().getToolScenes()[0].addSceneObjects((ISceneObject)this.d_lastDisplay);
        }
    }

    protected static class Func<PropT extends CorridorBuilder>
    extends AToolFunction<NewCorrTool2Pt<PropT>> {
        protected Func() {
        }

        @Override
        public Cursor getCursor(NewCorrTool2Pt<PropT> tool) {
            return null;
        }

        @Override
        public void mouseMoved(NewCorrTool2Pt<PropT> tool, MouseEvent e) {
            if (((CorridorBuilder)tool.props()).getCurrentStep() == 0) {
                Collection<IsectInfo> isects = tool.getP1().snaps;
                if (!isects.isEmpty()) {
                    ((CorridorBuilder)tool.props()).setPoint(0, isects.iterator().next().isectPoint, false);
                } else {
                    ((CorridorBuilder)tool.props()).setPoint(0, null, false);
                }
            } else if (((CorridorBuilder)tool.props()).getCurrentStep() == 2) {
                ((CorridorBuilder)tool.props()).pause();
                Collection<IsectInfo> isects = tool.getP1().snaps;
                boolean pointsValid = false;
                for (IsectInfo ii : isects) {
                    ((CorridorBuilder)tool.props()).setPoint(2, ii.isectPoint, false);
                    if (!((CorridorBuilder)tool.props()).isValid()) continue;
                    pointsValid = true;
                    break;
                }
                if (!pointsValid) {
                    ((CorridorBuilder)tool.props()).setPoint(2, null, false);
                }
                ((CorridorBuilder)tool.props()).resume();
            }
        }

        @Override
        public void mousePressed(NewCorrTool2Pt<PropT> tool, MouseEvent e) {
            Collection<IsectInfo> isects;
            if (e.getButton() != 1) {
                return;
            }
            if (((CorridorBuilder)tool.props()).getCurrentStep() == 0 && !(isects = tool.getP0().snaps).isEmpty()) {
                ((CorridorBuilder)tool.props()).setPoint(0, isects.iterator().next().isectPoint, true);
            }
        }

        @Override
        public void mouseDragged(NewCorrTool2Pt<PropT> tool, MouseEvent e) {
            if (!tool.isDragging(1)) {
                return;
            }
            if (((CorridorBuilder)tool.props()).getCurrentStep() == 1) {
                Collection<IsectInfo> isects = tool.getP1().snaps;
                ((CorridorBuilder)tool.props()).pause();
                boolean pointsValid = false;
                for (IsectInfo ii : isects) {
                    ((CorridorBuilder)tool.props()).setPoint(1, ii.isectPoint, false);
                    if (!((CorridorBuilder)tool.props()).areStartPointsValid3()) continue;
                    pointsValid = true;
                    break;
                }
                if (!pointsValid) {
                    ((CorridorBuilder)tool.props()).setPoint(1, null, false);
                }
                ((CorridorBuilder)tool.props()).resume();
            }
        }

        @Override
        public void mouseReleased(NewCorrTool2Pt<PropT> tool, MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            if (((CorridorBuilder)tool.props()).getCurrentStep() == 1) {
                if (!tool.dragAboveTolerance(0)) {
                    ((CorridorBuilder)tool.props()).setPoint(1, null, true);
                } else {
                    ((CorridorBuilder)tool.props()).commitLastPoint();
                }
            } else if (((CorridorBuilder)tool.props()).getCurrentStep() == 2) {
                ((CorridorBuilder)tool.props()).pause();
                Collection<IsectInfo> isects = tool.getP1().snaps;
                ((CorridorBuilder)tool.props()).setPoint(2, null, false);
                for (IsectInfo ii : isects) {
                    ((CorridorBuilder)tool.props()).setPoint(2, ii.isectPoint, false);
                    if (((CorridorBuilder)tool.props()).isValid()) {
                        ((CorridorBuilder)tool.props()).finish(e.getComponent());
                        break;
                    }
                    ((CorridorBuilder)tool.props()).setPoint(2, null, false);
                }
                ((CorridorBuilder)tool.props()).resume();
            }
            tool.repaintSurface();
        }
    }

    private class SnapFilter
    extends DefaultFilter {
        private SnapFilter(NewCorrTool2Pt newCorrTool2Pt) {
        }

        @Override
        public boolean acceptGeomType(Object source, GeomType type) {
            return type != GeomType.FACE;
        }

        @Override
        public boolean acceptPickObjType(Class type) {
            return IEgressOccupiable.class.isAssignableFrom(type) && !EgressCorridor.class.isAssignableFrom(type);
        }
    }
}

