/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.queues;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.builders.queues.QueuePathNodeBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.gui.APropEditPanel;
import merlin.mv.gui.LocationPanel;
import merlin.mv.gui.queues.NewQueueElemPnl;
import merlin.mv.gui.queues.QueueElemCreatePnl;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitPoint3D;

public class NewQueuePathNodePnl
extends APropEditPanel<QueuePathNodeBuilder> {
    private static final long serialVersionUID = -1902059516605419702L;

    public NewQueuePathNodePnl() {
        super(new Object[0]);
        guiPanel locPnl = new guiPanel();
        GridBagHelper gbh = new GridBagHelper(locPnl);
        gbh.addRow(Intl.intl("Location:"), new NodeLocationPanel());
        this.addSection(new NewQueueElemPnl());
        this.addSeparator();
        this.addSection(locPnl);
        this.addSeparator();
        this.addSection(new QueueElemCreatePnl());
    }

    private static class NodeLocationPanel
    extends LocationPanel<QueuePathNodeBuilder> {
        private static final long serialVersionUID = -7409476599751834767L;

        public NodeLocationPanel() {
            super(1, QueuePathNodeBuilder.DEST_CHANGED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateToProps(QueuePathNodeBuilder props) {
            MerlinData md = MerlinApp.getApp().getData();
            md.beginRead();
            try {
                UnitPoint3D specPoint = this.getValue();
                Point3d p1 = specPoint.getPoint3dValue(Geometry.LENGTH_UNIT);
                p1.z += 1.0E-6;
                AABox modelBounds = MerlinApp.getApp().getData().geomLocation.getBounds();
                Point3d p2 = new Point3d(p1.x, p1.y, modelBounds.getMinZ() - 1.0E-6);
                GeomUtil.FindResult findResult = GeomUtil.findRoom(MerlinApp.getApp().getData(), p1, p2, 1);
                IEgressOccupiable room = findResult != null ? findResult.room : null;
                UnitPoint3D p = findResult != null ? new UnitPoint3D(findResult.p, Geometry.LENGTH_UNIT) : specPoint;
                Vector3d norm = findResult != null ? findResult.faceNormal : GeomConstants.VEC3D_ZPOS;
                props.setDestination(p, room, norm);
            }
            finally {
                md.endRead();
            }
        }

        @Override
        protected void updateFromProps(QueuePathNodeBuilder props) {
            this.setValue(props.getDestination());
        }
    }
}

