/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.util.Collection;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.GotoWaypoint;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.mv.MerlinColors;
import merlin.mv.ModelView;
import merlin.mv.displays.AMerlinDispMgr;
import merlin.mv.displays.GotoDisplay;
import merlin.mv.displays.scenefinders.ISceneProvider;
import thunderheadeng.scene3d.nativebuffered.TextRenderer;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashSet;

public class GotoWaypointActionDispMgr
extends AMerlinDispMgr<GotoWaypoint, GotoDisplay> {
    private final ModelView d_mv;
    private final TextRenderer d_textRenderer;

    public GotoWaypointActionDispMgr(MerlinData md, ModelView mv, ISceneProvider<GotoWaypoint> sceneFinder) {
        super(md, GotoWaypoint.class, sceneFinder);
        this.d_mv = mv;
        this.d_textRenderer = new TextRenderer();
        this.d_textRenderer.setFontSize(12.0f);
        this.d_textRenderer.setLeaderEnabled(false);
        this.d_textRenderer.setMode(0);
        this.d_textRenderer.setRenderType(0);
        this.d_textRenderer.setPadding(new int[]{4, 4, 4, 4});
        this.updateColors();
    }

    private void updateColors() {
        this.d_textRenderer.setFontColor(this.d_mv.getColors().getColor(MerlinColors.AXIS_TEXT_COLOR));
    }

    @Override
    public void updateAll() {
        this.updateColors();
        super.updateAll();
    }

    @Override
    protected GotoDisplay createDisplay(GotoWaypoint obj, boolean visible, boolean selected) {
        GotoDisplay gd = new GotoDisplay(this.d_mv.getDisplayProps(), obj, this.d_textRenderer);
        gd.setVisible(visible);
        gd.setSelected(selected);
        return gd;
    }

    @Override
    public void update(Events events) {
        super.update(events);
        IEventRecord<IBehaviorAction> actionEvts = events.getEvents(IBehaviorAction.class, new Class[0]);
        if (actionEvts.hasRemovedObjs()) {
            this.updateAll();
        } else {
            IEventRecord<Behavior> behaviorEvts = events.getEvents(Behavior.class, new Class[0]);
            LinkedIdentityHashSet<Behavior> reorderedActionParents = new LinkedIdentityHashSet<Behavior>();
            this.getParents(actionEvts.getAddedObjs(), reorderedActionParents);
            reorderedActionParents.addAll(behaviorEvts.getChangedObjs(MerlinData.CHILDREN_CHANGED));
            for (Behavior behavior : reorderedActionParents) {
                this.updateDisplays(behavior.getMembers(GotoWaypoint.class));
            }
        }
    }

    private void getParents(Collection<IBehaviorAction> actions, Collection<Behavior> parents) {
        for (IBehaviorAction action : actions) {
            Object parent = this.getData().hierarchy.getParent(action);
            if (!(parent instanceof Behavior)) continue;
            parents.add((Behavior)parent);
        }
    }
}

