/*
 * Decompiled with CFR 0.152.
 */
package merlin.legacy.v0158.data.egress.elevators;

import common.data.ElevatorType;
import common.data.IElevatorTimingModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import merlin.data.GeomComposite;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorRoom;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.theUtil;

public class Elevator
extends GeomComposite<ElevatorRoom> {
    static final long serialVersionUID = 2273482934324398172L;
    private Map<ElevatorRoom, LevelData> d_roomLevelData;
    private ElevatorRoom d_dischargeRoom;
    private List<ElevatorRoom> d_levelPriority;
    private UnitDouble d_openDelay;
    private UnitDouble d_closeDelay;
    private UnitDouble d_nominalLoad;
    private boolean d_doubleDeck;
    private UnitDouble d_callDistance;
    private ElevatorRoom d_initRoom;

    private Elevator(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!(this.d_roomLevelData instanceof LinkedIdentityHashMap)) {
            this.d_roomLevelData = new LinkedIdentityHashMap<ElevatorRoom, LevelData>(this.d_roomLevelData);
        }
        for (IEgressObj obj : this.getDeepMembers(IEgressObj.class)) {
            obj.readTopology(in);
        }
        if (this.d_callDistance == null) {
            this.d_callDistance = new UnitDouble(merlin.data.egress.elevators.Elevator.DEFAULT_ELEVATOR_CALL_DIST.getRawValue(), merlin.data.egress.elevators.Elevator.DEFAULT_ELEVATOR_CALL_DIST.getUnit());
        }
        if (this.d_initRoom == null) {
            this.d_initRoom = this.d_dischargeRoom;
        }
    }

    private Object readResolve() throws ObjectStreamException {
        merlin.data.egress.elevators.Elevator elev = new merlin.data.egress.elevators.Elevator(this.getName(), ElevatorType.EVAC);
        elev.addAll(this.getMembers());
        elev.setCallDistance(this.d_callDistance);
        elev.setDischargeRoom(this.d_dischargeRoom);
        elev.setDoubleDeck(this.d_doubleDeck);
        elev.setLevelPriority(this.d_levelPriority);
        elev.setDoorDelays(this.d_openDelay, this.d_closeDelay);
        elev.setInitRoom(this.d_initRoom);
        elev.setNominalLoad(this.d_nominalLoad);
        elev.setResultsId(this.getResultsId());
        elev.setVisible(this.isVisible());
        Map<ElevatorRoom, LevelData> levelDataMap = this.d_roomLevelData;
        HashMap<Double, Double> distTimeMap = new HashMap<Double, Double>();
        ElevatorRoom dischargeRoom = this.d_dischargeRoom;
        for (ElevatorRoom room : levelDataMap.keySet()) {
            LevelData ld = levelDataMap.get(room);
            double pickupDist = elev.getDist(dischargeRoom, room);
            distTimeMap.put(pickupDist, ld.pickupTime.get(SI.SECOND));
            distTimeMap.put(-pickupDist, ld.dischargeTime.get(SI.SECOND));
        }
        double defaultVel = distTimeMap.entrySet().stream().filter(e -> (Double)e.getValue() != 0.0).mapToDouble(e -> Math.abs((Double)e.getKey()) / (Double)e.getValue()).average().orElseGet(() -> IElevatorTimingModel.DEF_MODEL.maxVel);
        IElevatorTimingModel.DistModel newTimingModel = new IElevatorTimingModel.DistModel(distTimeMap, defaultVel);
        elev.setTimingModel(newTimingModel);
        for (ElevatorRoom room : levelDataMap.keySet()) {
            LevelData oldLevelData = levelDataMap.get(room);
            elev.setLevelData(room, new Elevator.LevelData(oldLevelData.openTime, oldLevelData.closeTime, oldLevelData.delay));
        }
        return elev;
    }

    public static class LevelData
    implements Serializable {
        static final long serialVersionUID = 525324190123487L;
        private UnitDouble openTime;
        private UnitDouble closeTime;
        private UnitDouble pickupTime;
        private UnitDouble dischargeTime;
        private UnitDouble delay;

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            if (this.openTime == null) {
                try {
                    theUtil.assignFinalField(this, LevelData.class, "openTime", new UnitDouble(3.5, SI.SECOND));
                    theUtil.assignFinalField(this, LevelData.class, "closeTime", new UnitDouble(3.5, SI.SECOND));
                    UnitDouble openClose = this.openTime.add(this.closeTime);
                    UnitDouble newPickup = openClose.compareTo(this.pickupTime) <= 0 ? this.pickupTime.sub(openClose) : new UnitDouble(0.0, SI.SECOND);
                    UnitDouble newDischarge = openClose.compareTo(this.dischargeTime) <= 0 ? this.dischargeTime.sub(openClose) : new UnitDouble(0.0, SI.SECOND);
                    theUtil.assignFinalField(this, LevelData.class, "pickupTime", newPickup);
                    theUtil.assignFinalField(this, LevelData.class, "dischargeTime", newDischarge);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

