/*
 * Decompiled with CFR 0.152.
 */
package merlin.io;

import common.data.SpeedInSmoke;
import inferno.data2.ai.AssistOccupantsOrder;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.SubtractAction;
import merlin.data.AMerlinObj;
import merlin.data.AssistedEvacTeam;
import merlin.data.AssistedEvacTeamComp;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.ImportedGeom;
import merlin.data.JsonGroup;
import merlin.data.MeasurementRegions;
import merlin.data.MerlinData;
import merlin.data.MerlinHierarchy;
import merlin.data.OccGroupObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.OccSourceObj;
import merlin.data.RestorableProperties;
import merlin.data.SimParams;
import merlin.data.ViewProps;
import merlin.data.animation.AnimationDB;
import merlin.data.camera.CameraList;
import merlin.data.camera.CameraTour;
import merlin.data.egress.Floor;
import merlin.data.egress.FloorComposite;
import merlin.data.egress.FloorSort;
import merlin.data.egress.agents.ConstOccCount;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.OccArea;
import merlin.data.egress.agents.OccAreaMgr;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.OccProfileComp;
import merlin.data.egress.agents.OccTargetComp;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.agents.VehicleShapeComp;
import merlin.data.egress.blockages.EgressBlockageComp;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorDoor;
import merlin.data.egress.elevators.ElevatorRoot;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.RoomUtil;
import merlin.data.egress.scripting.AssistOccupants;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.BehaviorRoot;
import merlin.data.egress.scripting.ChangeBehavior;
import merlin.data.egress.scripting.GotoExits;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.RemoveOcc;
import merlin.data.egress.scripting.ResumePrior;
import merlin.data.egress.scripting.attractors.AttractorComp;
import merlin.data.egress.scripting.attractors.AttractorRootComp;
import merlin.data.egress.scripting.attractors.AttractorTemplateComp;
import merlin.data.egress.scripting.queues.QueueObjectComp;
import merlin.data.image.ImageGroup;
import merlin.data.material.Material;
import merlin.data.scripting.ScriptGroup;
import merlin.data.stat.DisabledCurve;
import merlin.data.value.PiecewiseFunction1d;
import merlin.io.MerlinIO;
import merlin.legacy.v0009.EgressRoom;
import merlin.legacy.v0009.OccLocation;
import merlin.legacy.v0011.thunderheadeng.util.theHashSet;
import merlin.legacy.v0011.thunderheadeng.util.theLinkedHashSet;
import merlin.legacy.v0013.data.geom.AABox;
import merlin.legacy.v0013.data.geom.AGeom;
import merlin.legacy.v0013.data.geom.AOutlinedShape;
import merlin.legacy.v0013.data.geom.Circle;
import merlin.legacy.v0013.data.geom.CircularArc;
import merlin.legacy.v0013.data.geom.ConvexPoly;
import merlin.legacy.v0013.data.geom.Ellipse;
import merlin.legacy.v0013.data.geom.EllipticalArc;
import merlin.legacy.v0013.data.geom.FaceProp;
import merlin.legacy.v0013.data.geom.FilledShape;
import merlin.legacy.v0013.data.geom.GeneralShape;
import merlin.legacy.v0013.data.geom.Geom3D;
import merlin.legacy.v0013.data.geom.GeomMeta;
import merlin.legacy.v0013.data.geom.IGeom;
import merlin.legacy.v0013.data.geom.LineSeg2d;
import merlin.legacy.v0013.data.geom.Mesh;
import merlin.legacy.v0013.data.geom.PlanarGeom;
import merlin.legacy.v0013.data.geom.Point;
import merlin.legacy.v0013.data.geom.PolyLine2d;
import merlin.legacy.v0013.data.geom.PolyLine3d;
import merlin.legacy.v0013.data.image.BGImage;
import merlin.legacy.v0013.data.image.RasterImage;
import merlin.legacy.v0015.data.BabyNameGen;
import merlin.legacy.v0023.geom.IPropsSrc;
import merlin.legacy.v0025.data.egress.agents.OccProfile;
import merlin.legacy.v0029.data.egress.geom.EgressScript;
import merlin.legacy.v0029.data.egress.geom.EgressState;
import merlin.legacy.v0029.data.egress.geom.SpeedModifier;
import merlin.legacy.v0030.data.image.Texture;
import merlin.legacy.v0100.data.material.MaterialDB;
import merlin.legacy.v0109.data.material.PlanarCoordMapper;
import merlin.legacy.v0117.inferno.data2.ai.AssistedEvacuationData;
import merlin.legacy.v0118.data.egress.agents.OccProfile;
import merlin.legacy.v0121.data.egress.geom.EgressCorridor;
import merlin.legacy.v0121.data.egress.geom.EgressDoor;
import merlin.legacy.v0121.data.egress.geom.EgressStair;
import merlin.legacy.v0147.data.egress.agents.OccLocObj;
import merlin.legacy.v0147.data.egress.agents.OccLocObjComp;
import merlin.legacy.v0147.data.egress.scripting.AbandonOccLocs;
import merlin.legacy.v0147.data.egress.scripting.GotoOccLoc;
import merlin.legacy.v0151.data.egress.elevators.ElevatorRoom;
import merlin.legacy.v0151.data.egress.geom.EgressBlockage;
import merlin.legacy.v0156.data.egress.scripting.Wait;
import merlin.legacy.v0156.data.egress.scripting.WaitForAssistance;
import merlin.legacy.v0156.data.egress.scripting.WaitUntil;
import merlin.legacy.v0156.data.egress.scripting.WaitUntilEnd;
import merlin.legacy.v0158.data.egress.elevators.Elevator;
import merlin.legacy.v0159.inferno.elevator.IElevator;
import merlin.legacy.v0160.data.egress.elevators.Elevator;
import merlin.legacy.v0160.data.egress.elevators.ITimingModel;
import merlin.legacy.v0162.data.egress.agents.OccProfile;
import merlin.unitsystem.EnglishUS;
import merlin.unitsystem.SIUS;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.TeciIO;
import thunderheadeng.geometry.AParametric2D;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg2D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.SerPathIterator;
import thunderheadeng.geometry.SerShape;
import thunderheadeng.geometry.Spline2D;
import thunderheadeng.geometry.Spline3D;
import thunderheadeng.geometry.TrimmedCurve3D;
import thunderheadeng.geometry.nmt.AModelObj;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.io.LegacyDictionary;
import thunderheadeng.legacy.v10.scene3d.geom.DefMaterial;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.ColorPool;
import thunderheadeng.util.Filters;
import thunderheadeng.util.HashPool;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.ResultsIdGen;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.InfiniteUrn;
import thunderheadeng.util.stat.LogNormCurve;
import thunderheadeng.util.stat.StdNormCurve;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class MerlinOIS
extends ObjectInputStream {
    private static final Logger LOGGER = Logger.getLogger(MerlinOIS.class.getName());
    private final int d_version;
    private String d_revision;
    private final TeciIO d_teciio;
    private final LegacyDictionary d_classLookup;
    private final HashPool<IPrimProps> d_propsPool;
    private final WarningReport<Warning> d_warnings;
    private final Consumer<TaskProgress> d_showSkippableProgress;
    private Map<EgressAgent, Set<merlin.data.egress.geom.EgressDoor>> d_pre17AgentExitMap;
    private Map<merlin.legacy.v0009.EgressDoor, merlin.data.egress.geom.EgressDoor> d_pre0009ConvertedDoors = new IdentityHashMap<merlin.legacy.v0009.EgressDoor, merlin.data.egress.geom.EgressDoor>();
    private Map<merlin.data.egress.geom.EgressRoom, merlin.legacy.v0151.data.egress.geom.EgressRoom> d_pre152Rooms = new IdentityHashMap<merlin.data.egress.geom.EgressRoom, merlin.legacy.v0151.data.egress.geom.EgressRoom>();
    private Set<merlin.data.egress.geom.EgressRoom> d_roomsNeedingCleanup = new LinkedIdentityHashSet<merlin.data.egress.geom.EgressRoom>();
    private final boolean d_resetResultsIds;
    private final Random d_pre155OccSourceSeedGen;
    public static final DecisionMaker DM_DEFAULT = new DecisionMaker();
    private static final OccProfile.Prop<?>[] PRE26_CUSTOM_PROFILE_PROPS = new OccProfile.Prop[]{OccProfile.PROP_COLOR, OccProfile.PROP_DIAMETER, OccProfile.PROP_MAXVEL, OccProfile.PROP_OCCMODEL};
    private static final IPropertySet.Prop<?>[] PRE26_NONCUSTOM_PROFILE_PROPS = new IPropertySet.Prop[]{OccProfile.PROP_NAME, OccProfile.PROP_DESC};

    public MerlinOIS(InputStream in, boolean resetResultsIds, Consumer<TaskProgress> showSkippableProgress) throws IOException {
        super(in);
        int version;
        this.d_resetResultsIds = resetResultsIds;
        this.d_version = version = this.readInt();
        this.d_propsPool = new HashPool();
        this.d_pre155OccSourceSeedGen = new Random(0L);
        this.d_warnings = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);
        if (this.d_version < MerlinIO.Version.VER_0011.num) {
            this.d_teciio = new TeciIO(1);
            this.d_revision = "";
        } else {
            int teciver = this.readInt();
            this.d_teciio = new TeciIO(teciver);
            try {
                this.d_revision = (String)this.readObject();
            }
            catch (ClassNotFoundException e) {
                assert (false);
                this.d_revision = "";
            }
        }
        this.enableResolveObject(true);
        this.d_classLookup = MerlinOIS.initLegDictionary(version);
        this.d_showSkippableProgress = showSkippableProgress;
    }

    public static int getVersion(ObjectInputStream is) {
        return is instanceof MerlinOIS ? ((MerlinOIS)is).getVersion() : Integer.MAX_VALUE;
    }

    public static boolean isPrior(ObjectInputStream is, MerlinIO.Version version) {
        return MerlinOIS.getVersion(is) < version.num;
    }

    public static boolean isVersion(ObjectInputStream is, MerlinIO.Version version) {
        return MerlinOIS.getVersion(is) == version.num;
    }

    public static boolean isLater(ObjectInputStream is, MerlinIO.Version version) {
        return MerlinOIS.getVersion(is) > version.num;
    }

    public static boolean isSameOrLater(ObjectInputStream is, MerlinIO.Version version) {
        return MerlinOIS.getVersion(is) >= version.num;
    }

    public static boolean isBetween(ObjectInputStream is, MerlinIO.Version version1Inc, MerlinIO.Version version2NInc) {
        int version = MerlinOIS.getVersion(is);
        return version1Inc.num <= version && version < version2NInc.num;
    }

    public static long nextPre155OccSourceSeed(ObjectInputStream is) {
        if (is instanceof MerlinOIS) {
            return ((MerlinOIS)is).d_pre155OccSourceSeedGen.nextLong();
        }
        return 0L;
    }

    public boolean getResetResultsIds() {
        return this.d_resetResultsIds;
    }

    public static boolean getResetResultsId(ObjectInputStream is) {
        return MerlinOIS.isPrior(is, MerlinIO.Version.VER_0153) || !(is instanceof MerlinOIS) || ((MerlinOIS)is).getResetResultsIds();
    }

    public WarningReport<Warning> getWarnings() {
        return this.d_warnings;
    }

    public boolean canOpenVersion() {
        return true;
    }

    public boolean isNewer() {
        return this.d_version > MerlinIO.Version.curr().num;
    }

    public int getVersion() {
        return this.d_version;
    }

    public String getRevision() {
        return this.d_revision;
    }

    public boolean isTopologyResetNeeded() {
        return this.d_version < MerlinIO.Version.VER_0009.num;
    }

    public MerlinData readModel(DecisionMaker decisionMaker) throws IOException, ClassNotFoundException {
        LOGGER.log(Level.FINE, "Loading model (v " + this.d_version + ") " + this.d_revision + "...");
        if (!this.canOpenVersion()) {
            throw new IOException(String.format(Intl.intl("[%s] Unsupported model version."), this.getClass().getName()));
        }
        if (this.d_version < MerlinIO.Version.VER_0017.num) {
            this.d_pre17AgentExitMap = new IdentityHashMap<EgressAgent, Set<merlin.data.egress.geom.EgressDoor>>();
        }
        MerlinData md = (MerlinData)this.readObject();
        boolean modified = false;
        md.initNameGenerators();
        if (this.d_version < MerlinIO.Version.VER_0027.num) {
            md.materials = new merlin.data.material.MaterialDB(null);
        } else if (this.d_version < MerlinIO.Version.VER_0101.num) {
            md.materials = MaterialDB.readObject(this);
            modified = true;
        }
        if (this.d_version < MerlinIO.Version.VER_0106.num) {
            md.json = new JsonGroup("");
        }
        if (this.d_version < MerlinIO.Version.VER_0113.num) {
            md.regions = new MeasurementRegions(Intl.intl("Measurement Regions"));
        }
        if (this.d_version < MerlinIO.Version.VER_0141.num) {
            md.queues = new QueueObjectComp();
        }
        if (this.d_version < MerlinIO.Version.VER_0146.num) {
            md.attractors = new AttractorComp();
        }
        if (this.d_version < MerlinIO.Version.VER_0147.num) {
            md.occTargets = new OccTargetComp();
        } else if (this.d_version == MerlinIO.Version.VER_0147.num) {
            md.occTargets = md.occLocations;
            md.occLocations = null;
            md.occTargets.setName(new OccTargetComp().getName());
        }
        if (md.viewProps == null) {
            try {
                theUtil.assignFinalField(md, MerlinData.class, "viewProps", new ViewProps());
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
        if (md.actionProps == null) {
            try {
                theUtil.assignFinalField(md, MerlinData.class, "actionProps", new RestorableProperties());
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
        if (this.d_version < MerlinIO.Version.VER_0132.num) {
            md.customScripts = new ScriptGroup("");
        }
        if (this.d_version < MerlinIO.Version.VER_0152.num) {
            md.blockages = new EgressBlockageComp();
        }
        if (this.d_version < MerlinIO.Version.VER_0162.num) {
            md.attractorTemplates = new AttractorTemplateComp();
            md.attractorsRoot = new AttractorRootComp(md.attractors, md.attractorTemplates);
        }
        if (this.d_version < MerlinIO.Version.VER_0166.num) {
            md.animations = new AnimationDB(null);
        }
        if (this.d_version < MerlinIO.Version.VER_0007.num) {
            modified |= this.checkPre7DoorsAndStairs(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0009.num) {
            this.correctPre0009LegacyRefs(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0014.num) {
            try {
                theUtil.assignFinalField(md, MerlinData.class, "floorSortOptions", new FloorSort());
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
        if (this.d_version < MerlinIO.Version.VER_0016.num) {
            modified |= this.reorganizePre16Data(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0017.num) {
            md.behaviors = new BehaviorRoot();
            this.createPre17Behaviors(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0020.num) {
            md.elevators = new ElevatorRoot();
        }
        if (this.d_version < MerlinIO.Version.VER_0023.num) {
            double globalSizeFactor = md.simParams.elevatorSizeFactor;
            for (Elevator elev : md.elevators.getDeepMembers(Elevator.class)) {
                UnitDouble area = elev.getDischargeRoom().getArea();
                double nomLoad = Elevator.getNominalLoad(area, globalSizeFactor);
                elev.setNominalLoad(new UnitDouble(nomLoad, SIUS.unit(9)));
            }
        }
        if (this.d_version < MerlinIO.Version.VER_0025.num) {
            this.convertPre25Transparency(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0026.num) {
            this.convertPre26Profiles(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0029.num) {
            modified |= this.convertPre29SimParams(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0032.num) {
            this.correctPre32Materials(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0033.num) {
            this.d_roomsNeedingCleanup.addAll(md.floors.getDeepMembers(merlin.data.egress.geom.EgressRoom.class));
        }
        if (this.d_version < MerlinIO.Version.VER_0100.num) {
            md.cameras = new CameraList(Intl.intl("Views"));
        }
        if (this.d_version < MerlinIO.Version.VER_0102.num) {
            modified |= this.fixPre102FacePlanes(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0103.num) {
            modified |= this.fixPre103FaceOrients(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0104.num) {
            modified |= this.decidePre104Defaults(md, decisionMaker);
        }
        if (this.d_version < MerlinIO.Version.VER_0110.num) {
            modified |= this.generatePre110Elements(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0111.num) {
            modified |= this.reorganizePre111UV(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0114.num) {
            modified |= this.generatePre114Elements(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0116.num) {
            modified |= this.generatePre116Elements(md);
            modified |= MerlinOIS.fixOccProfileRefs(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0123.num) {
            modified |= this.generatePre123Elements(md);
        }
        modified |= this.warnPre112OverlappingRooms(md);
        if (this.d_version < MerlinIO.Version.VER_0119.num) {
            modified |= MerlinOIS.convertPre119AssistedEvac(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0126.num) {
            modified |= MerlinOIS.fixPre126SelectionModel(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0127.num) {
            modified |= this.fixPre127ElevatorDoors(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0128.num) {
            modified |= this.fixPre128OccSources(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0129.num) {
            modified |= this.fixPre129Selection(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0130.num) {
            modified |= this.fixDoorsNullBoundary(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0131.num) {
            modified |= this.fixOccProfileMinSqueezeFactor(md);
            this.fixOccProfileReduceGeomDiam(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0134.num) {
            modified |= this.generateBehaviorColors(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0139.num) {
            modified |= MerlinOIS.promptPre139SocialDistancing(md, decisionMaker);
        }
        if (this.d_version < MerlinIO.Version.VER_0145.num) {
            modified |= this.fixPre145ElevatorInitRoom(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0146.num) {
            modified |= this.addPre146MissingTerminalActions(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0150.num) {
            modified |= this.handlePre0150VelInSmoke(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0152.num) {
            modified |= this.addPre0152Blockages(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0153.num) {
            modified |= this.regeneratePre0153ResultsIds(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0156.num) {
            modified |= this.convertSmvPathToRelative(md);
        }
        if (this.d_version < MerlinIO.Version.VER_0158.num) {
            modified |= this.warnPre0158CongestionCalculation(md);
        }
        modified |= this.cleanupRooms(md);
        this.checkForCustomScripts(md);
        this.checkForTours(md);
        if (!MerlinApp.isDev()) {
            md.simParams.showVis = false;
        }
        this.localizePersUnits(md);
        md.modified = modified;
        return md;
    }

    private void addWarning(String warning, String actionTaken) {
        this.d_warnings.addWarning(new Warning(warning, actionTaken));
    }

    private boolean cleanupRooms(MerlinData md) {
        if (this.d_roomsNeedingCleanup.isEmpty()) {
            return false;
        }
        MerlinData tempmd = new MerlinData(false);
        tempmd.loadFrom(md);
        tempmd.updateTopology();
        boolean modified = false;
        for (merlin.data.egress.geom.EgressRoom room : this.d_roomsNeedingCleanup) {
            Model m = room.cleanup(room.getModel());
            modified |= m != room.getModel();
            room.setModel(m);
        }
        tempmd.loadFrom(new MerlinData(false));
        return modified;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkPre7DoorsAndStairs(MerlinData md) {
        ArrayList<String> invalidObjs = new ArrayList<String>();
        for (merlin.data.egress.geom.EgressDoor egressDoor : md.floors.getDeepMembers(merlin.data.egress.geom.EgressDoor.class)) {
            if (egressDoor.getDoorGeom().isValid()) continue;
            egressDoor.makeGeomValid();
            invalidObjs.add(egressDoor.getName());
        }
        ArrayList<merlin.data.egress.geom.EgressStair> stairsToDel = new ArrayList<merlin.data.egress.geom.EgressStair>();
        for (merlin.data.egress.geom.EgressStair stair : md.floors.getDeepMembers(merlin.data.egress.geom.EgressStair.class)) {
            if (stair.getStairGeom().isValid()) continue;
            stairsToDel.add(stair);
            invalidObjs.add(stair.getName());
        }
        for (merlin.data.egress.geom.EgressStair stair : stairsToDel) {
            Composite<?> parent = this.findParent(md.floors, stair);
            if (parent == null) continue;
            parent.remove(stair);
        }
        if (!invalidObjs.isEmpty()) {
            void var4_8;
            String string = "";
            for (int m = 0; m < invalidObjs.size() - 1; ++m) {
                void var4_10;
                if (m > 0) {
                    String string2 = (String)var4_8 + ", ";
                }
                String string3 = (String)var4_10 + (String)invalidObjs.get(m);
            }
            String message = String.format(Intl.intl("Some objects had invalid geometry: %s"), var4_8);
            String action = Intl.intl("These objects may have been deleted.  Please check.");
            this.d_warnings.addWarning(new Warning(message, action));
            return true;
        }
        return false;
    }

    private Composite<?> findParent(Composite<?> group, merlin.data.egress.geom.EgressStair stair) {
        if (group.contains(stair)) {
            return group;
        }
        Collection<Composite> childGroups = group.getMembers(Composite.class);
        for (Composite childGroup : childGroups) {
            Composite<?> parent = this.findParent(childGroup, stair);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    private void correctPre0009LegacyRefs(MerlinData md) {
        for (EgressAgent agent : md.agents.getDeepMembers(EgressAgent.class)) {
            Object exit = agent.getAndClearPre9ExitObj();
            if (!(exit instanceof merlin.legacy.v0009.EgressDoor)) continue;
            merlin.data.egress.geom.EgressDoor cdoor = this.d_pre0009ConvertedDoors.get(exit);
            assert (cdoor != null);
            this.d_pre17AgentExitMap.put(agent, Collections.singleton(cdoor));
        }
    }

    private boolean reorganizePre16Data(MerlinData md) {
        Set<Composite<? extends ICompElement>> nonDelGroups = MerlinOIS.findEmptyGroups(md.floors);
        nonDelGroups.addAll(md.floors.getMembers(Floor.class));
        MerlinHierarchy hierarchy = MerlinOIS.constructHierarchy(md.floors);
        ArrayList<merlin.data.image.RasterImage> moveImages = new ArrayList<merlin.data.image.RasterImage>(md.floors.getDeepMembers(merlin.data.image.RasterImage.class));
        if (!moveImages.isEmpty()) {
            ImageGroup ig = new ImageGroup();
            md.sceneGeom.insert(Arrays.asList(ig), 0);
            for (merlin.data.image.RasterImage image : moveImages) {
                Composite parent = (Composite)hierarchy.getParent(image);
                parent.remove(image);
                ig.add(image);
            }
        }
        IdentityHashMap groupMap = new IdentityHashMap();
        ArrayList<ImportedGeom> moveGeom = new ArrayList<ImportedGeom>(md.floors.getDeepMembers(ImportedGeom.class));
        for (ImportedGeom geom : moveGeom) {
            Object[] path = hierarchy.getPath(geom);
            if (path.length <= 2) continue;
            assert (path[0] == md.floors && path[1] instanceof Floor);
            Object[] relpath = Arrays.copyOfRange(path, 2, path.length - 1);
            Composite<?> moveGroup = MerlinOIS.copyGroups(relpath, md.sceneGeom, groupMap);
            ((Composite)path[path.length - 2]).remove(geom);
            moveGroup.add(geom);
        }
        MerlinOIS.delEmptyGroups(md.floors, nonDelGroups);
        if (!moveImages.isEmpty() || !moveGeom.isEmpty()) {
            this.d_warnings.addWarning(new Warning(Intl.intl("All imported data is now stored in the \"Imported Geometry\" group."), Intl.intl("Imported data and background images have been moved.")));
            return true;
        }
        return false;
    }

    private static Composite<?> copyGroups(Object[] groups, Composite<?> target, Map<Composite<?>, Composite<?>> groupMap) {
        for (Object group : groups) {
            Composite comp = (Composite)group;
            Composite<?> newGroup = groupMap.get(comp);
            if (newGroup == null) {
                newGroup = new GeomComposite(comp.getName());
                groupMap.put(comp, newGroup);
                target.add(newGroup);
            }
            target = newGroup;
        }
        return target;
    }

    private static MerlinHierarchy constructHierarchy(Composite<?> root) {
        MerlinHierarchy hierarchy = new MerlinHierarchy();
        MerlinOIS.constructHierarchy(root, hierarchy);
        return hierarchy;
    }

    private static void constructHierarchy(Composite<? extends ICompElement> root, MerlinHierarchy hierarchy) {
        hierarchy.addAllToHierarchy(root, root.getMembers());
        for (Composite obj : root.getMembers(Composite.class)) {
            MerlinOIS.constructHierarchy(obj, hierarchy);
        }
    }

    private static void delEmptyGroups(Composite<? extends ICompElement> group, Set<Composite<? extends ICompElement>> nonDelGroups) {
        ArrayList<Composite> delGroups = new ArrayList<Composite>();
        for (Composite composite : group.getMembers(Composite.class)) {
            MerlinOIS.delEmptyGroups(composite, nonDelGroups);
            if (!composite.isEmpty() || nonDelGroups.contains(composite)) continue;
            delGroups.add(composite);
        }
        for (Composite<Object> composite : delGroups) {
            group.remove(composite);
        }
    }

    private static Set<Composite<? extends ICompElement>> findEmptyGroups(Composite<? extends ICompElement> root) {
        LinkedIdentityHashSet<Composite<? extends ICompElement>> empty = new LinkedIdentityHashSet<Composite<? extends ICompElement>>();
        for (Composite group : root.getDeepMembers(Composite.class)) {
            if (!group.isEmpty()) continue;
            empty.add(group);
        }
        return empty;
    }

    private void createPre17Behaviors(MerlinData md) {
        if (this.d_version >= MerlinIO.Version.VER_0009.num) {
            for (EgressAgent egressAgent : md.agents.getDeepMembers(EgressAgent.class)) {
                Set<merlin.data.egress.geom.EgressDoor> exits = egressAgent.getAndClearPre17Exits();
                this.d_pre17AgentExitMap.put(egressAgent, exits);
            }
        }
        HashMap<BehaviorKey, Behavior> map = new HashMap<BehaviorKey, Behavior>();
        for (Behavior behavior : md.behaviors.getDeepMembers(Behavior.class)) {
            Set<merlin.data.egress.geom.EgressDoor> exits = Collections.emptySet();
            for (GotoExits ge : behavior.flatten(GotoExits.class)) {
                exits = ge.get(GotoExits.PROP_EXITS);
            }
            BehaviorKey bk = new BehaviorKey(exits, behavior.getInitialDelay());
            map.putIfAbsent(bk, behavior);
        }
        Random random = new Random(2851616818L);
        for (EgressAgent agent : md.agents.getDeepMembers(EgressAgent.class)) {
            ICurve iniDelay;
            BehaviorKey bk;
            Behavior behavior;
            Set exits = this.d_pre17AgentExitMap.get(agent);
            if (exits == null) {
                exits = Collections.EMPTY_SET;
            }
            if ((behavior = (Behavior)map.get(bk = new BehaviorKey(exits, iniDelay = agent.getProfile().getProperty(merlin.legacy.v0025.data.egress.agents.OccProfile.PROP_INI_DELAY)))) == null) {
                String name = exits.isEmpty() ? Intl.intl("Goto Any Exit") : (exits.size() == 1 ? String.format(Intl.intl("Goto %s"), ((merlin.data.egress.geom.EgressDoor)exits.iterator().next()).getName()) : Intl.intl("Goto Exits"));
                behavior = new Behavior(name, iniDelay, new GotoExits(exits));
                behavior.setColor(MerlinUtil.newRandomOccColor(random));
                map.put(bk, behavior);
                md.behaviors.add(behavior);
            }
            agent.setBehavior(behavior);
        }
    }

    private void convertPre25Transparency(MerlinData md) {
        Composite[] groups;
        for (Composite group : groups = new Composite[]{md.floors, md.elevators}) {
            float[] comps = new float[4];
            for (IEgressComp comp : group.getDeepMembers(IEgressComp.class)) {
                Color c = comp.getColor();
                float alpha = 1.0f;
                if (c != null) {
                    c.getComponents(comps);
                    alpha = comps[3];
                    comp.setColor(ColorPool.get(new Color(comps[0], comps[1], comps[2])));
                }
                comp.setOpacity(alpha);
            }
        }
    }

    private void convertPre26Profiles(MerlinData md) {
        for (OccProfile prof : md.profiles.getDeepMembers(OccProfile.class)) {
            prof.remove(merlin.legacy.v0025.data.egress.agents.OccProfile.PROP_INI_DELAY);
        }
        for (EgressAgent agent : md.agents.getDeepMembers(EgressAgent.class)) {
            OccProfile profile = agent.getProfile();
            profile.remove(merlin.legacy.v0025.data.egress.agents.OccProfile.PROP_INI_DELAY);
        }
        Random rnd = new Random();
        for (EgressAgent agent : md.agents.getDeepMembers(EgressAgent.class)) {
            OccProfile profile = agent.getProfile();
            assert (profile.getProfParent() == null);
            if (md.profiles.containsDeep(profile)) {
                agent.setProfile(new OccProfile(profile));
                continue;
            }
            profile = profile.clone();
            OccProfile bestMatch = MerlinOIS.getBestPre26ProfileMatch(md, agent, profile);
            profile.setProfParent(bestMatch);
            for (IPropertySet.Prop<?> prop : PRE26_NONCUSTOM_PROFILE_PROPS) {
                profile.remove(prop);
            }
            for (IPropertySet.Prop<?> prop : PRE26_CUSTOM_PROFILE_PROPS) {
                Object val = profile.getProperty(prop);
                if (!(val instanceof IDistributedVal)) continue;
                val = profile.getDistVal(prop, rnd, agent.getProfileSeed());
                profile.setProperty(prop, ((OccProfile.Prop)prop).newDistConstant(val));
            }
            agent.setProfile(profile);
        }
    }

    private static OccProfile getBestPre26ProfileMatch(MerlinData md, EgressAgent agent, OccProfile agentProf) {
        Collection<OccProfile> available = md.profiles.getDeepMembers(OccProfile.class);
        if (available.size() == 1) {
            return available.iterator().next();
        }
        int mostMatches = -1;
        OccProfile bestMatch = null;
        for (OccProfile base : md.profiles.getDeepMembers(OccProfile.class)) {
            int numMatches = 0;
            for (OccProfile.Prop<?> prop : PRE26_CUSTOM_PROFILE_PROPS) {
                if (!MerlinOIS.isMatch(agent, agentProf, base, prop)) continue;
                ++numMatches;
            }
            if (numMatches <= mostMatches) continue;
            mostMatches = numMatches;
            bestMatch = base;
        }
        return bestMatch;
    }

    private static boolean isMatch(EgressAgent agent, OccProfile agentProf, OccProfile baseProf, OccProfile.Prop prop) {
        Object baseVal;
        Object agentVal = agentProf.getProperty(prop);
        if (agentVal.equals(baseVal = baseProf.getProperty(prop))) {
            return true;
        }
        if (baseVal instanceof IDistributedVal) {
            Object v2;
            assert (baseVal instanceof IDistributedVal);
            Object v1 = agentProf.getDistVal(prop, new Random(), agent.getProfileSeed());
            if (v1.equals(v2 = baseProf.getDistVal(prop, new Random(), agent.getProfileSeed()))) {
                return true;
            }
        }
        return false;
    }

    private boolean convertPre29SimParams(MerlinData md) {
        SimParams sp = md.simParams;
        sp.specificFlowrateMax = SIUS.newud(1.32, 12);
        sp.specificFlowSteering = SIUS.newud(1.32, 12);
        if (sp.reactiveSteering) {
            sp.useDoorQueues = false;
            if (!sp.inertia) {
                sp.inertia = true;
                this.addWarning(Intl.intl("[Sim Params->Behavior] Steering mode no longer allows inertia to be turned off."), Intl.intl("Inertia is turned on."));
                return true;
            }
        } else if (sp.handleCollisions) {
            this.addWarning(Intl.intl("[Sim Params->Behavior] Collisions are no longer supported in SFPE mode."), Intl.intl("Switched to Steering mode with imposed SFPE maximum door flowrates."));
            sp.reactiveSteering = true;
            sp.inertia = true;
            return true;
        }
        return false;
    }

    private void correctPre32Materials(MerlinData md) {
        LinkedIdentityHashMap<DefMaterial, Material> matMap = new LinkedIdentityHashMap<DefMaterial, Material>();
        for (Material mat : md.materials.flatten(Material.class)) {
            if (!(mat.getAttributes() instanceof DefMaterial)) continue;
            matMap.put((DefMaterial)mat.getAttributes(), mat);
        }
        for (ImportedGeom ig : md.sceneGeom.getDeepMembers(ImportedGeom.class)) {
            int ucount;
            int numPrims = ig.getGeom().getNumPrims(7);
            PropsBuilder pbuilder = new PropsBuilder();
            IPropsSrc props = ig.getDisplayProps();
            for (int offset = 0; offset < numPrims; offset += ucount) {
                IPrimProps pprops = props.get(offset);
                if (pprops.getMaterial() != null) {
                    IMaterial mat = pprops.getMaterial();
                    assert (mat instanceof DefMaterial);
                    mat = (IMaterial)matMap.get(mat);
                    assert (mat != null);
                    pprops = pprops.setMaterial(mat);
                }
                ucount = props.getUniformCount(offset, numPrims - offset);
                pbuilder.add(pprops, ucount);
            }
            ig.setDisplayProps(pbuilder.finalizeProps());
        }
        for (Material mat : matMap.values()) {
            IMatAttrs attrs = mat.getAttributes();
            attrs = ((DefMaterial)attrs).toMatAttrs();
            mat.setAttributes(attrs);
        }
    }

    private boolean fixPre102FacePlanes(MerlinData md) {
        for (merlin.data.egress.geom.EgressRoom room : md.floors.flatten(merlin.data.egress.geom.EgressRoom.class)) {
            Model model = room.getModel();
            boolean modified = false;
            for (Face face : model.getFaces()) {
                Plane3d oldPlane = face.plane;
                face.calcPlane();
                if (oldPlane.epsilonEquals(face.plane, 1.0E-9)) {
                    face.plane = oldPlane;
                    continue;
                }
                modified = true;
                LOGGER.log(Level.WARNING, String.format("Corrected face: room=%s, oldPlane=%s, newPlane=%s%n", room.getName(), oldPlane, face.plane));
            }
            if (!modified || !RoomUtil.ensureProperFaceOrient(model)) continue;
            room.setModel(model);
            String msg = String.format(Intl.intl("Room \"%s\" contained inconsistent geometry that may have caused occupants to be omitted from the simulation."), room.getName());
            String fix = Intl.intl("Fixed the room's geometry.");
            this.d_warnings.addWarning(new Warning(msg, fix));
            return true;
        }
        return false;
    }

    private boolean fixPre103FaceOrients(MerlinData md) {
        for (merlin.data.egress.geom.EgressRoom room : md.floors.flatten(merlin.data.egress.geom.EgressRoom.class)) {
            Model model = room.getModel();
            if (!RoomUtil.ensureProperFaceOrient(model)) continue;
            room.setModel(model);
            String msg = String.format(Intl.intl("Room \"%s\" contained inconsistent geometry that may have prevented occupants from moving through one-way doors properly."), room.getName());
            String fix = Intl.intl("Fixed the room's geometry.");
            this.d_warnings.addWarning(new Warning(msg, fix));
            return true;
        }
        return false;
    }

    private void localizePersUnits(MerlinData md) {
        QuadConsumer<String, Integer, Supplier, Consumer> fix = (name, unit, getter, setter) -> {
            UnitDouble old = (UnitDouble)getter.get();
            UnitDouble si = old.convert(SIUS.unit(unit));
            UnitDouble en = old.convert(EnglishUS.unit(unit));
            if (old.getValueNoUnit() == en.getValueNoUnit()) {
                setter.accept(en);
            } else if (old.getValueNoUnit() == si.getValueNoUnit()) {
                setter.accept(si);
            } else {
                throw new RuntimeException(String.format("Unable to localize %s: %s", name, old.getUnit().toString()));
            }
        };
        fix.accept("simParams.specificFlowSteering", 12, () -> md.simParams.specificFlowSteering, v -> {
            md.simParams.specificFlowSteering = v;
        });
        fix.accept("simParams.densityMax", 3, () -> md.simParams.densityMax, v -> {
            md.simParams.densityMax = v;
        });
    }

    private boolean decidePre104Defaults(MerlinData md, DecisionMaker decisions) {
        LinkedIdentityHashMap<IPropertySet.Prop, Serializable> oldDefaults = new LinkedIdentityHashMap<IPropertySet.Prop, Serializable>();
        oldDefaults.put(OccProfile.PROP_SPACING, new OccProfile.Spacing(OccProfile.SpacingType.COMFORT_DIST, new ConstantCurve(new UnitDouble(1.0, NonSI.FOOT))));
        oldDefaults.put(OccProfile.PROP_BOUNDARY_LAYER, new ConstantCurve(new UnitDouble(0.0, SI.METER)));
        oldDefaults.put(OccProfile.PROP_FUNDAMENTAL, new PiecewiseFunction1d(new PiecewiseFunction1d.Entry(SIUS.newud(0.0, 3), new UnitDouble(1.0, Unit.ONE)), new PiecewiseFunction1d.Entry(SIUS.newud(1.0, 3), new UnitDouble(1.0, Unit.ONE))));
        Boolean useNewDefault = null;
        boolean modified = false;
        for (OccProfile profile : md.profiles.flatten(OccProfile.class)) {
            for (Map.Entry entry : oldDefaults.entrySet()) {
                IPropertySet.Prop key = (IPropertySet.Prop)entry.getKey();
                Object oldDefault = entry.getValue();
                if (profile.isDefinedLocally(key) && !Objects.equals(profile.getProperty(key), oldDefault)) continue;
                if (useNewDefault == null) {
                    useNewDefault = decisions.pre104UseNewDefaults.getAsBoolean();
                }
                if (useNewDefault.booleanValue()) {
                    profile.remove(key);
                    modified = true;
                    continue;
                }
                profile.setProperty((Object)key, oldDefault);
            }
        }
        return modified;
    }

    private boolean generatePre110Elements(MerlinData md) {
        Collection<ImportedGeom> importedGeom = md.sceneGeom.flatten(ImportedGeom.class);
        if (importedGeom.isEmpty()) {
            return false;
        }
        LOGGER.log(Level.FINE, "Generating creases for imported geometry...");
        theTimer timer = new theTimer();
        boolean modified = false;
        LinkedHashMap<thunderheadeng.geometry.objs.IGeom, IElemSource> creases = new LinkedHashMap<thunderheadeng.geometry.objs.IGeom, IElemSource>();
        for (ImportedGeom ig : importedGeom) {
            IElemSource<Boolean> creaseSrc;
            IGeomNode node = ig.getGeom();
            if (node.getLocalGeom() != EmptyGeom.INSTANCE && node.isLeaf()) {
                creaseSrc = creases.computeIfAbsent(node.getLocalGeom(), g -> Elements.generateCreasesFromFacets(g, (IElemSource)((Object)node.getLocalElements().get(Elements.ORIENT))));
            } else {
                IGeomNode fnode = node.flatten(2);
                creaseSrc = Elements.generateCreasesFromFacets(fnode.getLocalGeom(), (IElemSource)((Object)fnode.getLocalElements().get(Elements.ORIENT)));
            }
            if (creaseSrc == Elements.ALL_CREASE) continue;
            IGeomNode newNode = node.applyElements(Elements.CREASE, (pix, oldCrease) -> creaseSrc.getPrimSource((int)pix));
            modified |= newNode != node;
            ig.setGeom(newNode);
        }
        LOGGER.log(Level.FINE, String.format("Creases complete (%g s)%n", timer.curr()));
        return modified;
    }

    private boolean generatePre114Elements(MerlinData md) {
        md.vehicleShapes = new VehicleShapeComp();
        md.assistedEvacTeams = new AssistedEvacTeamComp();
        return true;
    }

    private boolean generatePre116Elements(MerlinData md) {
        md.occSources = new OccSourceObj.OccSourceComp();
        return true;
    }

    private boolean generatePre123Elements(MerlinData md) {
        md.occGroups = new OccGroupObj.OccGroupComp();
        md.occGroupTypes = new OccGroupTypeObj.OccGroupTypeComp();
        return true;
    }

    private boolean fixPre127ElevatorDoors(MerlinData md) {
        MerlinData tempmd = new MerlinData(false);
        tempmd.loadFrom(md);
        ArrayList<ElevatorDoor> disabledDoors = new ArrayList<ElevatorDoor>(tempmd.elevators.flatten(ElevatorDoor.class, d -> !d.isEnabled()));
        if (!disabledDoors.isEmpty()) {
            for (ElevatorDoor elevatorDoor : disabledDoors) {
                elevatorDoor.setEnabled(true);
            }
            tempmd.updateTopology();
            for (ElevatorDoor elevatorDoor : disabledDoors) {
                elevatorDoor.setEnabled(false);
            }
        }
        tempmd.loadFrom(new MerlinData(false));
        return !disabledDoors.isEmpty();
    }

    private boolean fixPre128OccSources(MerlinData md) {
        md.occGroupTypes.initNoGroupType();
        for (OccSourceObj source : md.occSources.flatten(OccSourceObj.class)) {
            double groupProportion = 0.01 * source.get(OccSourceObj.PROP_GROUP_PROPORTION).get(NonSI.PERCENT);
            if (theUtil.gt0(groupProportion, 1.0E-6)) {
                Map<OccGroupTypeObj, Double> groupTemplates = source.get(OccSourceObj.PROP_GROUP_TEMPLATE_DIST).getWeights();
                IdentityHashMap<OccGroupTypeObj, Double> newGroupTemplates = new IdentityHashMap<OccGroupTypeObj, Double>(groupTemplates.size());
                groupTemplates.forEach((k, v) -> newGroupTemplates.put((OccGroupTypeObj)k, v * groupProportion));
                newGroupTemplates.put(md.occGroupTypes.NO_GROUP_TYPE, 1.0 - groupProportion);
                source.set(OccSourceObj.PROP_GROUP_PROPORTION, new UnitDouble(0.0, NonSI.PERCENT));
                source.set(OccSourceObj.PROP_GROUP_TEMPLATE_DIST, UrnUtil.newUrn(newGroupTemplates));
                continue;
            }
            source.set(OccSourceObj.PROP_GROUP_TEMPLATE_DIST, UrnUtil.newUrn(Collections.singletonMap(md.occGroupTypes.NO_GROUP_TYPE, 1.0)));
        }
        return true;
    }

    private boolean fixPre129Selection(MerlinData md) {
        IFilteredCollection<ICompElement> selectedObjs = md.selection.flatten(ICompElement.class);
        Collection<? extends IMerlinObj> composites = md.getChildren();
        HashSet<ICompElement> toDeselect = new HashSet<ICompElement>();
        for (ICompElement obj : selectedObjs) {
            boolean exists = false;
            for (IMerlinObj iMerlinObj : composites) {
                if (!(iMerlinObj instanceof Composite) || !((Composite)iMerlinObj).containsDeep(obj)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            toDeselect.add(obj);
        }
        md.selection.deselectAll(toDeselect);
        return !toDeselect.isEmpty();
    }

    private boolean fixDoorsNullBoundary(MerlinData md) {
        boolean modified = false;
        for (merlin.data.egress.geom.EgressDoor door : md.floors.flatten(merlin.data.egress.geom.EgressDoor.class)) {
            Point3d[] bounds = door.getBoundary();
            if (bounds != null) continue;
            Point3d p = door.getEdge1().getMidpoint();
            bounds = new Point3d[]{new Point3d(p), new Point3d(p)};
            EgressDoor.DoorGeom geom = door.getDoorGeom();
            door.setGeom(new EgressDoor.DoorGeom(geom.d_room1, geom.d_room2, geom.d_attachedEdge1, geom.d_attachedEdge2, bounds, geom.d_dirVec, geom.d_allowManip), true);
            this.addWarning(String.format(Intl.intl("Door \"%s\" has invalid boundary."), door.getName()), Intl.intl("Boundary was collapsed to the middle of the door."));
            modified = true;
        }
        return modified;
    }

    private boolean fixOccProfileMinSqueezeFactor(MerlinData md) {
        boolean modified = false;
        for (OccProfile prof : md.profiles.flatten(OccProfile.class)) {
            if (!prof.isDefinedLocally(OccProfile.PROP_MIN_SQUEEZE_FACTOR)) continue;
            ICurve redFactor = prof.getProperty(OccProfile.PROP_MIN_SQUEEZE_FACTOR);
            prof.setProperty(OccProfile.PROP_MIN_SQUEEZE_FACTOR_CONST, Double.valueOf(redFactor.getAvg().get(Unit.ONE)));
            if (redFactor instanceof ConstantCurve) continue;
            this.addWarning(String.format(Intl.intl("Profile \"%s\" has distributed reduction factor, which is no longer supported."), prof.getName()), Intl.intl("Reduction factor was set to the average of the distribution."));
            modified = true;
        }
        for (EgressAgent agent : md.agents.flatten(EgressAgent.class)) {
            OccProfile prof = agent.getProfile();
            if (!prof.isDefinedLocally(OccProfile.PROP_MIN_SQUEEZE_FACTOR)) continue;
            ICurve redFactor = prof.getProperty(OccProfile.PROP_MIN_SQUEEZE_FACTOR);
            prof.setProperty(OccProfile.PROP_MIN_SQUEEZE_FACTOR_CONST, Double.valueOf(redFactor.getAvg().get(Unit.ONE)));
        }
        return modified;
    }

    private boolean generateBehaviorColors(MerlinData md) {
        Random crand = new Random(10492479479715L);
        for (Behavior behavior : md.behaviors.flatten(Behavior.class)) {
            behavior.setColor(MerlinUtil.newRandomOccColor(crand));
        }
        return true;
    }

    private void fixOccProfileReduceGeomDiam(MerlinData md) {
        for (OccProfile prof : md.profiles.flatten(OccProfile.class)) {
            if (prof.getProperty(OccProfile.PROP_SHAPE).type.equals((Object)VehicleShape.ShapeType.POLYGON)) continue;
            prof.setProperty(OccProfile.PROP_GEOM_DIAMETER, null);
        }
    }

    private boolean reorganizePre111UV(MerlinData md) {
        boolean modified = true;
        Collection<ImportedGeom> importedGeom = md.sceneGeom.flatten(ImportedGeom.class);
        if (importedGeom.isEmpty()) {
            return false;
        }
        IdentityHashMap<IPropertySet, IPropertySet> elMap = new IdentityHashMap<IPropertySet, IPropertySet>();
        for (ImportedGeom ig : importedGeom) {
            IGeomNode node = ig.getGeom();
            IGeomNode newNode = MerlinOIS.fixPre111NodeUV(node, elMap);
            modified |= newNode != node;
            ig.setGeom(newNode);
        }
        return modified;
    }

    private static IGeomNode fixPre111NodeUV(IGeomNode node, Map<IPropertySet, IPropertySet> elMap) {
        IPropertySet newElements;
        IPropertySet elements = node.getLocalElements();
        if (elements == (newElements = elMap.computeIfAbsent(elements, e -> Elements.fixLegacy(e))) && node.getChildren().isEmpty()) {
            return node;
        }
        elements = newElements;
        Collection<? extends IGeomNode> children = node.getChildren();
        ArrayList<? extends IGeomNode> newChildren = null;
        int ix = 0;
        for (IGeomNode iGeomNode : children) {
            IGeomNode newChild = MerlinOIS.fixPre111NodeUV(iGeomNode, elMap);
            if (newChild != iGeomNode) {
                if (newChildren == null) {
                    newChildren = new ArrayList<IGeomNode>(node.getChildren());
                }
                newChildren.set(ix, newChild);
            }
            ++ix;
        }
        if (newChildren != null) {
            children = newChildren;
        }
        return GeomNodeUtil.newNode(node.getLocalTransform(), node.getLocalGeom(), elements, children);
    }

    private boolean warnPre112OverlappingRooms(MerlinData md) {
        final MerlinData tempmd = new MerlinData(false, false);
        tempmd.loadFrom(md);
        final TaskProgress progress = new TaskProgress();
        progress.setMessage(Intl.intl("Checking for errors..."));
        this.d_showSkippableProgress.accept(progress);
        final LinkedHashMap conflicts = new LinkedHashMap();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int progressCounter = 0;
                progress.setProgress(progressCounter);
                Collection<merlin.data.egress.geom.EgressRoom> rooms = tempmd.floors.getDeepMembers(merlin.data.egress.geom.EgressRoom.class);
                for (merlin.data.egress.geom.EgressRoom room : rooms) {
                    Map<merlin.data.egress.geom.EgressRoom, List<merlin.data.egress.geom.EgressRoom>> subMap = SubtractAction.getReplaceMap(MerlinApp.getApp(), tempmd, 4, Arrays.asList(room));
                    for (Map.Entry<merlin.data.egress.geom.EgressRoom, List<merlin.data.egress.geom.EgressRoom>> entry : subMap.entrySet()) {
                        merlin.data.egress.geom.EgressRoom potSubtractor = entry.getKey();
                        if (!potSubtractor.getModificationsAllowed()) continue;
                        for (merlin.data.egress.geom.EgressRoom subtract : entry.getValue()) {
                            List<Face> commonFaces;
                            if (!progress.isRunning()) {
                                return;
                            }
                            UnorderedPair<merlin.data.egress.geom.EgressRoom, merlin.data.egress.geom.EgressRoom> up = new UnorderedPair<merlin.data.egress.geom.EgressRoom, merlin.data.egress.geom.EgressRoom>(potSubtractor, subtract);
                            if (conflicts.containsKey(up) || (commonFaces = potSubtractor.haveCommonFaces(subtract.getModel(), false)).isEmpty()) continue;
                            thunderheadeng.geometry.AABox bounds = new thunderheadeng.geometry.AABox();
                            for (Face f : commonFaces) {
                                bounds.add(f.getBounds());
                            }
                            conflicts.put(up, bounds);
                        }
                    }
                    progress.setProgress((int)Math.round(100.0 * (double)(++progressCounter) / (double)rooms.size()));
                }
            }
        };
        task.run();
        progress.cancel();
        for (Map.Entry entry : conflicts.entrySet()) {
            this.d_warnings.addWarning(new Warning(guiUtil.escapeHTML(String.format(Intl.intl("Overlap detected between rooms %s and %s {%s -> %s}"), ((merlin.data.egress.geom.EgressRoom)((UnorderedPair)entry.getKey()).v1).getName(), ((merlin.data.egress.geom.EgressRoom)((UnorderedPair)entry.getKey()).v2).getName(), ((thunderheadeng.geometry.AABox)entry.getValue()).getMin().toString(), ((thunderheadeng.geometry.AABox)entry.getValue()).getMax().toString())), Intl.intl("Manual fix recommended.")));
        }
        tempmd.loadFrom(new MerlinData(false));
        return false;
    }

    private static boolean convertPre119AssistedEvac(MerlinData md) {
        boolean modified = false;
        LinkedIdentityHashSet agentsNeedingAssistance = new LinkedIdentityHashSet();
        LinkedIdentityHashMap<EgressAgent, AssistedEvacTeam> assistantTeams = new LinkedIdentityHashMap<EgressAgent, AssistedEvacTeam>();
        block10: for (EgressAgent agent : md.agents.flatten(EgressAgent.class)) {
            boolean definedLocally = agent.getProfile().isDefinedLocally(OccProfile.PROP_ASSISTED_EVAC_ROLE);
            OccProfile.AssistedEvacRole role = agent.getProfile().getProperty(OccProfile.PROP_ASSISTED_EVAC_ROLE);
            agent.getProfile().remove(OccProfile.PROP_ASSISTED_EVAC_ROLE);
            switch (role.type) {
                case NONE: {
                    continue block10;
                }
                case ASSISTING: {
                    assistantTeams.put(agent, role.d_assistWithTeam);
                    break;
                }
                case NEEDS_ASSISTANCE: {
                    assert (role.d_requiresAssistance.booleanValue());
                    agentsNeedingAssistance.add(agent);
                }
            }
            if (!definedLocally) continue;
            agent.getProfile().setProperty(OccProfile.PROP_REQUIRES_ASSISTANCE, new Urn<Boolean>(role.d_requiresAssistance));
        }
        LinkedIdentityHashMap<EgressAgent, Set> clientTeams = new LinkedIdentityHashMap<EgressAgent, Set>();
        Function<EgressAgent, Set> newClientTeamSet = a -> new LinkedIdentityHashSet();
        IdentityHashSet assistAllTeams = new IdentityHashSet();
        Collection<AssistedEvacTeam> allTeams = md.assistedEvacTeams.flatten(AssistedEvacTeam.class);
        for (AssistedEvacTeam team : allTeams) {
            boolean assistAll = team.removeProperty(AssistedEvacTeam.PROP_ASSIST_ALL);
            AssistOccupantsOrder order = team.removeProperty(AssistedEvacTeam.PROP_ASSIST_ORDER);
            List<EgressAgent> toAssist = team.removeProperty(AssistedEvacTeam.PROP_OCCS_TO_ASSIST);
            Collection<Object> assist = assistAll ? agentsNeedingAssistance : toAssist;
            for (EgressAgent egressAgent : assist) {
                clientTeams.computeIfAbsent(egressAgent, newClientTeamSet).add(team);
            }
            if (order == AssistOccupantsOrder.INPUT_PREFERENCE) {
                team.setProperty(AssistedEvacTeam.PROP_OCC_ASSIST_ORDER, toAssist);
            }
            if (assistAll) {
                assistAllTeams.add(team);
            }
            modified = true;
        }
        for (Set clientTeam : clientTeams.values()) {
            if (clientTeam.size() != allTeams.size()) continue;
            clientTeam.clear();
        }
        if (assistAllTeams.size() == allTeams.size()) {
            assistAllTeams.clear();
        }
        IdentityHashSet oldBehaviors = new IdentityHashSet();
        ArrayList newBehaviors = new ArrayList();
        Random crand = new Random(8688608595224859195L);
        BiFunction<Behavior, IBehaviorAction, Behavior> convertBehavior = (oldBehavior, assistAction) -> {
            IDistributedVal<UnitDouble> initDelay = oldBehavior.getInitialDelay();
            Behavior newBehavior = new Behavior(oldBehavior.getName());
            newBehavior.setColor(MerlinUtil.newRandomOccColor(crand));
            newBehavior.add((ICompElement)assistAction);
            if (!(initDelay instanceof ConstantCurve) || ((ConstantCurve)initDelay).getValue().getRawValue() != 0.0) {
                newBehavior.add(new merlin.data.egress.scripting.Wait(initDelay));
            }
            newBehavior.addAll(oldBehavior.getMembers());
            newBehaviors.add(newBehavior);
            return newBehavior;
        };
        HashMap<Pair, Behavior> newClientBehaviors = new HashMap<Pair, Behavior>();
        Function<Pair, Behavior> convertClientBehavior = pair -> {
            Set teams = (Set)pair.v1;
            Behavior oldBehavior = (Behavior)pair.v2;
            return (Behavior)convertBehavior.apply(oldBehavior, new merlin.data.egress.scripting.WaitForAssistance(teams));
        };
        for (Map.Entry entry : clientTeams.entrySet()) {
            EgressAgent agent = (EgressAgent)entry.getKey();
            Behavior behavior = agent.getBehavior();
            Behavior behavior2 = newClientBehaviors.computeIfAbsent(new Pair<Set, Behavior>((Set)entry.getValue(), behavior), convertClientBehavior);
            oldBehaviors.add(behavior);
            agent.setBehavior(behavior2);
            modified = true;
        }
        HashMap<Pair, Behavior> newAssistantBehaviors = new HashMap<Pair, Behavior>();
        Function<Pair, Behavior> function = pair -> {
            AssistedEvacTeam team = (AssistedEvacTeam)pair.v1;
            Behavior oldBehavior = (Behavior)pair.v2;
            return (Behavior)convertBehavior.apply(oldBehavior, new AssistOccupants(team));
        };
        for (Map.Entry entry : assistantTeams.entrySet()) {
            EgressAgent egressAgent = (EgressAgent)entry.getKey();
            Behavior oldBehavior3 = egressAgent.getBehavior();
            Behavior newBehavior = newAssistantBehaviors.computeIfAbsent(new Pair<AssistedEvacTeam, Behavior>((AssistedEvacTeam)entry.getValue(), oldBehavior3), function);
            oldBehaviors.add(oldBehavior3);
            egressAgent.setBehavior(newBehavior);
            modified = true;
        }
        BiFunction<Double, Double, Double> addDbls = (v1, v2) -> v1 + v2;
        for (OccSourceObj occSourceObj : md.occSources.flatten(OccSourceObj.class)) {
            Map<Behavior, Double> behaviors = occSourceObj.get(OccSourceObj.PROP_BEHAVIOR_DIST).getWeights();
            Map<OccProfile, Double> profiles = occSourceObj.get(OccSourceObj.PROP_PROFILE_DIST).getWeights();
            IdentityHashMap<Behavior, Double> newBehaviorWeights = new IdentityHashMap<Behavior, Double>();
            boolean osModified = false;
            block17: for (Map.Entry<OccProfile, Double> pentry : profiles.entrySet()) {
                OccProfile profile = pentry.getKey();
                OccProfile.AssistedEvacRole role = profile.getProperty(OccProfile.PROP_ASSISTED_EVAC_ROLE);
                double pfactor = pentry.getValue();
                switch (role.type) {
                    case NONE: {
                        double newFactor;
                        double bfactor;
                        for (Map.Entry<Behavior, Double> bentry : behaviors.entrySet()) {
                            bfactor = bentry.getValue();
                            newFactor = pfactor * bfactor;
                            newBehaviorWeights.merge(bentry.getKey(), newFactor, addDbls);
                        }
                        continue block17;
                    }
                    case ASSISTING: {
                        Behavior newBehavior;
                        double newFactor;
                        double bfactor;
                        for (Map.Entry<Behavior, Double> bentry : behaviors.entrySet()) {
                            bfactor = bentry.getValue();
                            newFactor = pfactor * bfactor;
                            newBehavior = newAssistantBehaviors.computeIfAbsent(new Pair<AssistedEvacTeam, Behavior>(role.d_assistWithTeam, bentry.getKey()), function);
                            newBehaviorWeights.merge(newBehavior, newFactor, addDbls);
                        }
                        osModified = true;
                        break;
                    }
                    case NEEDS_ASSISTANCE: {
                        Behavior newBehavior;
                        double newFactor;
                        double bfactor;
                        for (Map.Entry<Behavior, Double> bentry : behaviors.entrySet()) {
                            bfactor = bentry.getValue();
                            newFactor = pfactor * bfactor;
                            newBehavior = newClientBehaviors.computeIfAbsent(new Pair(assistAllTeams, bentry.getKey()), convertClientBehavior);
                            newBehaviorWeights.merge(newBehavior, newFactor, addDbls);
                        }
                        osModified = true;
                    }
                }
            }
            if (!osModified) continue;
            IUrn newBehaviorDist = UrnUtil.newUrn(newBehaviorWeights);
            occSourceObj.set(OccSourceObj.PROP_BEHAVIOR_DIST, newBehaviorDist);
            modified = true;
        }
        for (OccProfile occProfile : md.profiles.flatten(OccProfile.class)) {
            OccProfile.AssistedEvacRole role = occProfile.remove(OccProfile.PROP_ASSISTED_EVAC_ROLE);
            if (role != null && role.d_requiresAssistance.booleanValue()) {
                occProfile.setProperty(OccProfile.PROP_REQUIRES_ASSISTANCE, new Urn<Boolean>(true));
            }
            modified |= role != null;
        }
        LinkedIdentityHashSet<IMerlinObj> linkedIdentityHashSet = Dependencies.getObjReferences(md, Behavior.class, Filters.accept(oldBehaviors, IMerlinObj.class));
        oldBehaviors.removeAll(linkedIdentityHashSet);
        for (Behavior behavior : oldBehaviors) {
            Composite<Behavior> parent = Composite.findParent(md.behaviors, behavior);
            assert (parent != null);
            if (parent == null) continue;
            parent.remove(behavior);
            modified = true;
        }
        NameGenerator nameGenerator = new NameGenerator(Intl.intl("Behavior"), 2, false);
        nameGenerator.registerNames(theUtil.map(md.behaviors.flatten(Behavior.class), b -> b.getName()));
        for (Behavior behavior : newBehaviors) {
            String newName = nameGenerator.generateValidName(behavior.getName());
            behavior.setName(newName);
            nameGenerator.registerName(newName);
            md.behaviors.add(behavior);
        }
        return modified;
    }

    private static boolean fixPre126SelectionModel(MerlinData md) {
        int numPrevSelected = md.selection.getSelectionCount();
        md.selection.clear();
        return numPrevSelected > 0;
    }

    private static boolean checkProfileForDeprecatedSeparation(OccProfile occProfile) {
        return occProfile.isDefinedLocally(OccProfile.PROP_SPACING) && !occProfile.getProperty(OccProfile.PROP_SPACING).equals(OccProfile.PROP_SPACING.defVal);
    }

    private static boolean promptPre139SocialDistancing(MerlinData md, DecisionMaker dm) throws CancellationException {
        boolean distancingParamsConflict = false;
        if (md.simParams.forceSeparation) {
            boolean bl = distancingParamsConflict = md.profiles.flatten(OccProfile.class).stream().anyMatch(MerlinOIS::checkProfileForDeprecatedSeparation) || md.agents.flatten(EgressAgent.class).stream().map(a -> a.getProfile()).anyMatch(MerlinOIS::checkProfileForDeprecatedSeparation);
        }
        if (distancingParamsConflict && dm.pre139ConvertToSocialDistance.getAsBoolean()) {
            int[] nconverted = MerlinOIS.convertPost139SocialDistancing(md);
            LOGGER.info(String.format("Converted %d profiles, %d agents", nconverted[0], nconverted[1]));
            return true;
        }
        return false;
    }

    private static int[] convertPost139SocialDistancing(MerlinData md) {
        md.simParams.forceSeparation = false;
        Function<OccProfile, Boolean> convertProfile = occProfile -> {
            if (!MerlinOIS.checkProfileForDeprecatedSeparation(occProfile)) {
                return false;
            }
            OccProfile.Spacing spacing = occProfile.getProperty(OccProfile.PROP_SPACING);
            UnitDouble diameter = occProfile.getProperty(OccProfile.PROP_DIAMETER).getAvg();
            if (spacing.val instanceof UniformCurve) {
                switch (spacing.type) {
                    case AREA: {
                        occProfile.setProperty(OccProfile.PROP_SOCIAL_DIST, MerlinOIS.getUniformSocialDistanceArea(spacing, diameter));
                        break;
                    }
                    case DENSITY: {
                        occProfile.setProperty(OccProfile.PROP_SOCIAL_DIST, MerlinOIS.getUniformSocialDistanceDensity(spacing, diameter));
                        break;
                    }
                    default: {
                        occProfile.setProperty(OccProfile.PROP_SOCIAL_DIST, MerlinOIS.getUniformSocialDistance(spacing, diameter));
                        break;
                    }
                }
            } else if (spacing.val instanceof StdNormCurve) {
                switch (spacing.type) {
                    case AREA: {
                        occProfile.setProperty(OccProfile.PROP_SOCIAL_DIST, MerlinOIS.getStdNormSocialDistanceArea(spacing, diameter));
                        break;
                    }
                    case DENSITY: {
                        occProfile.setProperty(OccProfile.PROP_SOCIAL_DIST, MerlinOIS.getStdNormSocialDistanceDensity(spacing, diameter));
                        break;
                    }
                    default: {
                        occProfile.setProperty(OccProfile.PROP_SOCIAL_DIST, MerlinOIS.getStdNormSocialDistance(spacing, diameter));
                        break;
                    }
                }
            } else if (spacing.val instanceof LogNormCurve) {
                switch (spacing.type) {
                    case AREA: {
                        occProfile.setProperty(OccProfile.PROP_SOCIAL_DIST, MerlinOIS.getLogNormSocialDistanceArea(spacing, diameter));
                        break;
                    }
                    case DENSITY: {
                        occProfile.setProperty(OccProfile.PROP_SOCIAL_DIST, MerlinOIS.getLogNormSocialDistanceDensity(spacing, diameter));
                        break;
                    }
                    default: {
                        occProfile.setProperty(OccProfile.PROP_SOCIAL_DIST, MerlinOIS.getLogNormSocialDistance(spacing, diameter));
                        break;
                    }
                }
            } else {
                switch (spacing.type) {
                    case AREA: {
                        occProfile.setProperty(OccProfile.PROP_SOCIAL_DIST, MerlinOIS.getConstantSocialDistanceArea(spacing, diameter));
                        break;
                    }
                    case DENSITY: {
                        occProfile.setProperty(OccProfile.PROP_SOCIAL_DIST, MerlinOIS.getConstantSocialDistanceDensity(spacing, diameter));
                        break;
                    }
                    default: {
                        occProfile.setProperty(OccProfile.PROP_SOCIAL_DIST, MerlinOIS.getConstantSocialDistance(spacing, diameter));
                    }
                }
            }
            occProfile.remove(OccProfile.PROP_SPACING);
            return true;
        };
        int nProfiles = 0;
        for (OccProfile profile : md.profiles.flatten(OccProfile.class)) {
            if (!convertProfile.apply(profile).booleanValue()) continue;
            ++nProfiles;
        }
        int nOccs = 0;
        for (EgressAgent agent : md.agents.flatten(EgressAgent.class)) {
            OccProfile occProfile2 = agent.getProfile();
            boolean isLocal = occProfile2.isDefinedLocally(OccProfile.PROP_SPACING);
            if (!isLocal) continue;
            if (convertProfile.apply(occProfile2).booleanValue()) {
                ++nOccs;
                continue;
            }
            if (!occProfile2.getProfParent().isDefinedLocally(OccProfile.PROP_SOCIAL_DIST)) continue;
            occProfile2.setProperty(OccProfile.PROP_SOCIAL_DIST, new DisabledCurve(SI.METER));
            ++nOccs;
        }
        return new int[]{nProfiles, nOccs};
    }

    private static Unit getSocialDistanceUnit(OccProfile.Spacing spacing) {
        if (spacing.type.equals((Object)OccProfile.SpacingType.DENSITY)) {
            return Unit.ONE.divide(SI.METER.pow(2));
        }
        if (spacing.type.equals((Object)OccProfile.SpacingType.AREA)) {
            return SI.METER.pow(2);
        }
        return SI.METER;
    }

    private static ConstantCurve getConstantSocialDistance(OccProfile.Spacing spacing, UnitDouble diameter) {
        return new ConstantCurve(new UnitDouble(spacing.val.getAvg().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), SI.METER).add(diameter));
    }

    private static ConstantCurve getConstantSocialDistanceDensity(OccProfile.Spacing spacing, UnitDouble diameter) {
        return new ConstantCurve(new UnitDouble(OccProfile.getComfortDistanceFromDensity(spacing.val.getAvg().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER));
    }

    private static ConstantCurve getConstantSocialDistanceArea(OccProfile.Spacing spacing, UnitDouble diameter) {
        return new ConstantCurve(new UnitDouble(OccProfile.getComfortDistanceFromDensity(1.0 / spacing.val.getAvg().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER));
    }

    private static UniformCurve getUniformSocialDistance(OccProfile.Spacing spacing, UnitDouble diameter) {
        return new UniformCurve(new UnitDouble(spacing.val.getMin().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), SI.METER).add(diameter), new UnitDouble(spacing.val.getMax().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), SI.METER).add(diameter));
    }

    private static UniformCurve getUniformSocialDistanceArea(OccProfile.Spacing spacing, UnitDouble diameter) {
        return new UniformCurve(new UnitDouble(OccProfile.getComfortDistanceFromDensity(1.0 / spacing.val.getMin().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER), new UnitDouble(OccProfile.getComfortDistanceFromDensity(1.0 / spacing.val.getMax().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER));
    }

    private static UniformCurve getUniformSocialDistanceDensity(OccProfile.Spacing spacing, UnitDouble diameter) {
        return new UniformCurve(new UnitDouble(OccProfile.getComfortDistanceFromDensity(spacing.val.getMax().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER), new UnitDouble(OccProfile.getComfortDistanceFromDensity(spacing.val.getMin().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER));
    }

    private static StdNormCurve getStdNormSocialDistance(OccProfile.Spacing spacing, UnitDouble diameter) {
        return new StdNormCurve(new UnitDouble(spacing.val.getMin().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), SI.METER).add(diameter), new UnitDouble(spacing.val.getMax().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), SI.METER).add(diameter), new UnitDouble(spacing.val.getAvg().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), SI.METER).add(diameter), new UnitDouble(((StdNormCurve)spacing.val).getStdDev().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), SI.METER).add(diameter));
    }

    private static StdNormCurve getStdNormSocialDistanceArea(OccProfile.Spacing spacing, UnitDouble diameter) {
        return new StdNormCurve(new UnitDouble(OccProfile.getComfortDistanceFromDensity(1.0 / spacing.val.getMin().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER), new UnitDouble(OccProfile.getComfortDistanceFromDensity(1.0 / spacing.val.getMax().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER), new UnitDouble(OccProfile.getComfortDistanceFromDensity(1.0 / spacing.val.getAvg().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER), new UnitDouble(OccProfile.getComfortDistanceFromDensity(1.0 / ((StdNormCurve)spacing.val).getStdDev().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER));
    }

    private static StdNormCurve getStdNormSocialDistanceDensity(OccProfile.Spacing spacing, UnitDouble diameter) {
        return new StdNormCurve(new UnitDouble(OccProfile.getComfortDistanceFromDensity(spacing.val.getMax().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER), new UnitDouble(OccProfile.getComfortDistanceFromDensity(spacing.val.getMin().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER), new UnitDouble(OccProfile.getComfortDistanceFromDensity(spacing.val.getAvg().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER), new UnitDouble(OccProfile.getComfortDistanceFromDensity(((StdNormCurve)spacing.val).getStdDev().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER));
    }

    private static LogNormCurve getLogNormSocialDistance(OccProfile.Spacing spacing, UnitDouble diameter) {
        return new LogNormCurve(new UnitDouble(spacing.val.getMin().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), SI.METER).add(diameter), new UnitDouble(spacing.val.getMax().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), SI.METER).add(diameter), new UnitDouble(spacing.val.getAvg().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), SI.METER).add(diameter), new UnitDouble(((LogNormCurve)spacing.val).getStdDev().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), SI.METER).add(diameter));
    }

    private static LogNormCurve getLogNormSocialDistanceArea(OccProfile.Spacing spacing, UnitDouble diameter) {
        return new LogNormCurve(new UnitDouble(OccProfile.getComfortDistanceFromDensity(1.0 / spacing.val.getMin().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER), new UnitDouble(OccProfile.getComfortDistanceFromDensity(1.0 / spacing.val.getMax().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER), new UnitDouble(OccProfile.getComfortDistanceFromDensity(1.0 / spacing.val.getAvg().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER), new UnitDouble(OccProfile.getComfortDistanceFromDensity(1.0 / ((LogNormCurve)spacing.val).getStdDev().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER));
    }

    private static LogNormCurve getLogNormSocialDistanceDensity(OccProfile.Spacing spacing, UnitDouble diameter) {
        return new LogNormCurve(new UnitDouble(OccProfile.getComfortDistanceFromDensity(spacing.val.getMax().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER), new UnitDouble(OccProfile.getComfortDistanceFromDensity(spacing.val.getMin().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER), new UnitDouble(OccProfile.getComfortDistanceFromDensity(spacing.val.getAvg().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER), new UnitDouble(OccProfile.getComfortDistanceFromDensity(((LogNormCurve)spacing.val).getStdDev().getValue(MerlinOIS.getSocialDistanceUnit(spacing)), 0.0), SI.METER));
    }

    private boolean fixPre145ElevatorInitRoom(MerlinData md) {
        boolean modified = false;
        for (Elevator elev : md.elevators.flatten(Elevator.class)) {
            merlin.data.egress.elevators.ElevatorRoom room;
            if (elev.contains(room = elev.getInitRoom())) continue;
            elev.setInitRoom(elev.getDischargeRoom());
            this.addWarning(String.format(Intl.intl("Elevator \"%1$s\" referenced an invalid initial floor."), elev.getName()), Intl.intl("Reset the initial floor to the discharge floor."));
            modified = true;
        }
        return modified;
    }

    private static boolean fixOccProfileRefs(MerlinData md) {
        HashMap<OccProfile.PropHasher, OccProfile> profileHash = null;
        IdentityHashMap<OccProfile, OccProfile> replacementProfs = new IdentityHashMap<OccProfile, OccProfile>();
        LinkedIdentityHashSet newProfiles = new LinkedIdentityHashSet();
        boolean modified = false;
        for (EgressAgent agent : md.agents.flatten(EgressAgent.class)) {
            OccProfile profile;
            OccProfile parent = agent.getProfile().getProfParent();
            if (md.profiles.containsDeep(parent)) continue;
            if (profileHash == null) {
                profileHash = new HashMap<OccProfile.PropHasher, OccProfile>();
                for (OccProfile profile2 : md.profiles.flatten(OccProfile.class)) {
                    profileHash.put(profile2.getHasher(), profile2);
                }
            }
            if ((profile = (OccProfile)replacementProfs.get(parent)) == null && !replacementProfs.containsKey(parent)) {
                profile = (OccProfile)profileHash.get(parent.getHasher());
                replacementProfs.put(parent, profile);
                if (profile == null) {
                    newProfiles.add(parent);
                }
            }
            if (profile == null) continue;
            agent.getProfile().setProfParent(profile);
            modified = true;
        }
        modified |= !newProfiles.isEmpty();
        if (!newProfiles.isEmpty()) {
            NameGenerator names = new NameGenerator(md.profNameGen.getBaseName(), md.profNameGen.getMinNumWidth(), false);
            for (OccProfile existing : md.profiles.flatten(OccProfile.class)) {
                names.registerName(existing.getName());
            }
            for (OccProfile newProf : newProfiles) {
                String newName = names.generateValidName(newProf.getName());
                newProf.setName(newName);
                names.registerName(newName);
            }
            md.profiles.addAll(newProfiles);
        }
        return modified;
    }

    private boolean addPre146MissingTerminalActions(MerlinData md) {
        boolean modified = false;
        IdentityHashSet behaviorsRefedByOccs = new IdentityHashSet();
        md.agents.flatten(EgressAgent.class).stream().map(agent -> agent.getBehavior()).forEach(b -> behaviorsRefedByOccs.add(b));
        md.occSources.flatten(OccSourceObj.class).stream().flatMap(source -> source.get(OccSourceObj.PROP_BEHAVIOR_DIST).getWeights().keySet().stream()).forEach(b -> behaviorsRefedByOccs.add(b));
        IdentityHashSet behaviorsRefedByBehaviors = new IdentityHashSet();
        md.behaviors.flatten(Behavior.class).stream().flatMap(behavior -> behavior.getMembers(ChangeBehavior.class).stream()).forEach(cb -> behaviorsRefedByBehaviors.addAll(cb.getAllTargetBehaviors()));
        for (Behavior behavior2 : md.behaviors.flatten(Behavior.class)) {
            Optional<IBehaviorAction> lastAction = behavior2.getLastAction();
            if (lastAction.isPresent() && (lastAction.get().mustBeLast() || MerlinUtil.isBehaviorTerminal(behavior2))) continue;
            if (!behaviorsRefedByOccs.contains(behavior2) && behaviorsRefedByBehaviors.contains(behavior2)) {
                behavior2.add(new ResumePrior());
                modified = true;
                continue;
            }
            if (!behaviorsRefedByOccs.contains(behavior2) || behaviorsRefedByBehaviors.contains(behavior2)) continue;
            behavior2.add(new RemoveOcc());
            modified = true;
        }
        return modified;
    }

    private boolean handlePre0150VelInSmoke(MerlinData md) {
        boolean legacyUsingSmv = md.simParams.smvDataEnable;
        boolean legacyCheckboxEnabled = md.simParams.smvSmokeSlowEnable;
        boolean modified = false;
        for (OccProfile prof : md.profiles.flatten(OccProfile.class)) {
            if (legacyUsingSmv && legacyCheckboxEnabled) {
                prof.setProp(OccProfile.PROP_SPEED_IN_SMOKE, new OccProfile.SpeedInSmokeConfig(SpeedInSmoke.Data.LEGACY_DEFAULT));
                modified = true;
                continue;
            }
            if (!legacyUsingSmv || legacyCheckboxEnabled) continue;
            prof.setProp(OccProfile.PROP_SPEED_IN_SMOKE, new OccProfile.SpeedInSmokeConfig(SpeedInSmoke.Data.DISABLED));
            modified = true;
        }
        return modified;
    }

    public void addPre152Room(merlin.legacy.v0151.data.egress.geom.EgressRoom legRoom, merlin.data.egress.geom.EgressRoom currRoom, boolean geomNeedsCleanup) {
        if (geomNeedsCleanup) {
            this.d_roomsNeedingCleanup.add(currRoom);
        }
        if (legRoom.d_blockages.isEmpty()) {
            return;
        }
        this.d_pre152Rooms.put(currRoom, legRoom);
    }

    public void readPre152BlockageTopology(merlin.data.egress.geom.EgressRoom room) throws IOException, ClassNotFoundException {
        merlin.legacy.v0151.data.egress.geom.EgressRoom legRoom = this.d_pre152Rooms.get(room);
        if (legRoom != null) {
            for (EgressBlockage legBlkg : legRoom.d_blockages.values()) {
                legBlkg.readTopology(this);
            }
        }
    }

    private boolean addPre0152Blockages(MerlinData md) {
        for (Map.Entry<merlin.data.egress.geom.EgressRoom, merlin.legacy.v0151.data.egress.geom.EgressRoom> entry : this.d_pre152Rooms.entrySet()) {
            for (EgressBlockage lblkg : entry.getValue().d_blockages.values()) {
                merlin.data.egress.blockages.EgressBlockage blkg = lblkg.fromLegacy(entry.getValue());
                md.blockages.add(blkg);
            }
        }
        List legSelBlkgs = md.selection.flatten(EgressBlockage.class).stream().collect(Collectors.toList());
        md.selection.deselectAll(legSelBlkgs);
        return !md.blockages.isEmpty();
    }

    private boolean regeneratePre0153ResultsIds(MerlinData md) {
        int modelHash = md.getChildren().stream().filter(child -> Composite.class.isInstance(child)).map(child -> (Composite)child).map(child -> Integer.toString(child.flatten().size())).collect(Collectors.joining("-")).hashCode();
        ResultsIdGen ids = new ResultsIdGen(modelHash);
        boolean modified = false;
        for (AMerlinObj obj : MerlinUtil.flatten(md.getChildren(), AMerlinObj.class)) {
            obj.generateResultsIds(ids);
            modified = true;
        }
        md.selection.generateResultsIds(ids);
        md.json.generateResultsIds(ids);
        md.customScripts.generateResultsIds(ids);
        md.floorSortOptions.generateResultsIds(ids);
        md.viewProps.generateResultsIds(ids);
        md.actionProps.generateResultsIds(ids);
        return modified;
    }

    private boolean convertSmvPathToRelative(MerlinData md) {
        if (!md.simParams.smvDataEnable) {
            return false;
        }
        File relFile = MerlinUtil.relativizeFile(md, md.simParams.smvDataFileName).toFile();
        if (relFile.exists()) {
            md.simParams.smvDataFileName = MerlinUtil.relativizeFile(md, md.simParams.smvDataFileName).toString();
            return true;
        }
        return false;
    }

    private boolean warnPre0158CongestionCalculation(MerlinData md) {
        this.addWarning(Intl.intl("Congestion (formerly \"jam time\") is no longer calculated using current occupant velocity. Congestion outputs will differ from prior versions."), Intl.intl("Congestion is now calculated using the average speed over a time interval set in [Sim Params->Output]. This prevents resetting congestion values after small movements."));
        return false;
    }

    private void checkForTours(MerlinData md) {
        Collection<CameraTour> tours = md.cameras.flatten(CameraTour.class);
        if (!tours.isEmpty()) {
            this.addWarning(String.format(Intl.intl("Model contains %d tour(s) created in a previous version."), tours.size()), Intl.intl("Tours will still be accessible in the Results, but are not editable in Pathfinder."));
        }
    }

    private void checkForCustomScripts(MerlinData md) {
        if (!md.customScripts.isEmpty() && System.getProperty("ex_enable_scripting") == null) {
            this.addWarning("Model contains custom scripts but ex_enable_scripting is not enabled.", "Scripts will be run by the simulator and cannot be edited.");
        }
    }

    private static LegacyDictionary initLegDictionary(int version) {
        LegacyDictionary ld = new LegacyDictionary(version);
        TriConsumer<MerlinIO.Version, String, Class> addc = (v, legName, newClazz) -> ld.addLegClass(v.num, (String)legName, (Class)newClazz);
        TriConsumer<MerlinIO.Version, String, String> addn = (v, legName, newClazzName) -> {
            try {
                Class<?> clazz = Class.forName(newClazzName);
                ld.addLegClass(v.num, (String)legName, clazz);
            }
            catch (ClassNotFoundException e) {
                assert (false);
                throw new RuntimeException(e);
            }
        };
        ld.addLegClass(MerlinIO.Version.VER_0001.num, "merlin.data.MerlinData", merlin.legacy.valpha.MerlinData.class);
        ld.addLegClass(MerlinIO.Version.VER_0009.num, "merlin.data.OccLocation", OccLocation.class);
        ld.addLegClass(MerlinIO.Version.VER_0009.num, "merlin.data.AEgressComp", merlin.legacy.v0009.AEgressComp.class);
        ld.addLegClass(MerlinIO.Version.VER_0009.num, "merlin.data.EgressDoor", merlin.legacy.v0009.EgressDoor.class);
        ld.addLegClass(MerlinIO.Version.VER_0009.num, "merlin.data.EgressRoom", EgressRoom.class);
        ld.addLegClass(MerlinIO.Version.VER_0009.num, "merlin.data.EgressStair", merlin.legacy.v0009.EgressStair.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.AParametric2D", AParametric2D.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.IParametric2D", IParametric2D.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.IParametric3D", IParametric3D.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.LineSeg2D", LineSeg2D.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.LineSeg3D", LineSeg3D.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.data.geom.SerPathIterator", SerPathIterator.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.data.geom.SerPathIterator$PathSegment", SerPathIterator.PathSegment.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.data.geom.SerShape", SerShape.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.Spline2D", Spline2D.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.Spline2D$Cubic", Spline2D.Cubic.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.Spline2D$Quadratic", Spline2D.Quadratic.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.Spline3D", Spline3D.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.Spline3D$Cubic", Spline3D.Cubic.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.Spline3D$Quadratic", Spline3D.Quadratic.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.TrimmedCurve3D", TrimmedCurve3D.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.nmt.AModelObj", AModelObj.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.nmt.Edge", Edge.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.nmt.EdgeUse", EdgeUse.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.nmt.Face", Face.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.nmt.FaceLoop", FaceLoop.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.nmt.Model", thunderheadeng.legacy.v17.geometry.nmt.Model.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.nmt.Model$Group", Model.Group.class);
        ld.addLegClass(MerlinIO.Version.VER_0010.num, "merlin.geom.nmt.Vertex", Vertex.class);
        ld.addLegClass(MerlinIO.Version.VER_0011.num, "thunderheadeng.util.theHashSet", theHashSet.class);
        ld.addLegClass(MerlinIO.Version.VER_0011.num, "thunderheadeng.util.theLinkedHashSet", theLinkedHashSet.class);
        ld.addLegClass(MerlinIO.Version.VER_0011.num, "thunderheadeng.util.LinkedIdentityHashSet", merlin.legacy.v0011.thunderheadeng.util.LinkedIdentityHashSet.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.AABox", AABox.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.AGeom", AGeom.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.AOutlinedShape", AOutlinedShape.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.Circle", Circle.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.CircularArc", CircularArc.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.ConvexPoly", ConvexPoly.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.Ellipse", Ellipse.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.EllipticalArc", EllipticalArc.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.FaceProp", FaceProp.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.FilledShape", FilledShape.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.GeneralShape", GeneralShape.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.Geom3D", Geom3D.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.GeomMeta", GeomMeta.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.LineSeg2d", LineSeg2d.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.Mesh", Mesh.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.Mesh$FaceSet", Mesh.FaceSet.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.PlanarGeom", PlanarGeom.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.Point", Point.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.PolyLine2d", PolyLine2d.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.geom.PolyLine3d", PolyLine3d.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.image.BGImage", BGImage.class);
        ld.addLegClass(MerlinIO.Version.VER_0013.num, "merlin.data.image.RasterImage", RasterImage.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.Floor", Floor.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.FloorComposite", FloorComposite.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.FloorSort", FloorSort.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.ConstOccCount", ConstOccCount.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.EgressAgent", EgressAgent.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.EgressAgentComp", EgressAgentComp.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.OccArea", OccArea.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.OccAreaMgr", OccAreaMgr.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.OccLocation", merlin.data.egress.agents.OccLocation.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.OccProfile", merlin.legacy.v0025.data.egress.agents.OccProfile.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.OccProfile$Custom", OccProfile.Custom.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.OccProfileComp", OccProfileComp.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.AEgressComp", AEgressComp.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.EgressDoor", merlin.data.egress.geom.EgressDoor.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.EgressRoom", merlin.data.egress.geom.EgressRoom.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.EgressStair", merlin.legacy.v0015.data.EgressStair.class);
        ld.addLegClass(MerlinIO.Version.VER_0015.num, "merlin.data.BabyNameGen", BabyNameGen.class);
        ld.addLegClass(MerlinIO.Version.VER_0024.num, "merlin.geom.IPropsSrc$Flattened", IPropsSrc.Flattened.class);
        ld.addLegClass(MerlinIO.Version.VER_0024.num, "merlin.geom.IPropsSrc$Uniform", IPropsSrc.Uniform.class);
        ld.addLegClass(MerlinIO.Version.VER_0024.num, "merlin.geom.IPropsSrc$Builder", IPropsSrc.Builder.class);
        ld.addLegClass(MerlinIO.Version.VER_0024.num, "merlin.geom.IPropsSrc$Builder$RangeEntry", IPropsSrc.Builder.RangeEntry.class);
        ld.addLegClass(MerlinIO.Version.VER_0024.num, "merlin.geom.IPrimProps", IPrimProps.class);
        ld.addLegClass(MerlinIO.Version.VER_0024.num, "merlin.geom.IPrimProps$AProps", IPrimProps.AProps.class);
        ld.addLegClass(MerlinIO.Version.VER_0024.num, "merlin.geom.IPrimProps$GenericProps", IPrimProps.GenericProps.class);
        ld.addLegClass(MerlinIO.Version.VER_0024.num, "merlin.geom.IPrimProps$Face", IPrimProps.Face.class);
        ld.addLegClass(MerlinIO.Version.VER_0024.num, "merlin.geom.IPrimProps$Edge", IPrimProps.Edge.class);
        ld.addLegClass(MerlinIO.Version.VER_0024.num, "merlin.geom.IPrimProps$Vertex", IPrimProps.Vertex.class);
        ld.addLegClass(MerlinIO.Version.VER_0026.num, "merlin.data.egress.agents.OccProfile", merlin.legacy.v0025.data.egress.agents.OccProfile.class);
        ld.addLegClass(MerlinIO.Version.VER_0026.num, "merlin.data.egress.agents.OccProfile$Custom", OccProfile.Custom.class);
        ld.addLegClass(MerlinIO.Version.VER_0030.num, "merlin.data.egress.geom.EgressScript$EventType", EgressScript.EventType.class);
        ld.addLegClass(MerlinIO.Version.VER_0030.num, "merlin.data.egress.geom.EgressScript$TimeBasedEvent", EgressScript.TimeBasedEvent.class);
        ld.addLegClass(MerlinIO.Version.VER_0030.num, "merlin.data.egress.geom.EgressState", EgressState.class);
        ld.addLegClass(MerlinIO.Version.VER_0030.num, "merlin.data.egress.geom.EgressBlockage", merlin.legacy.v0029.data.egress.geom.EgressBlockage.class);
        ld.addLegClass(MerlinIO.Version.VER_0030.num, "merlin.data.egress.geom.SpeedModifier", SpeedModifier.class);
        ld.addLegClass(MerlinIO.Version.VER_0031.num, "merlin.data.image.Texture", Texture.class);
        ld.addLegClass(MerlinIO.Version.VER_0110.num, "merlin.data.material.PlanarCoordMapper", PlanarCoordMapper.class);
        addc.accept(MerlinIO.Version.VER_0115, "merlin.data.stat.ConstantCurve", ConstantCurve.class);
        addc.accept(MerlinIO.Version.VER_0115, "merlin.data.stat.InfiniteUrn", InfiniteUrn.class);
        addn.accept(MerlinIO.Version.VER_0115, "merlin.data.stat.InfiniteUrn$Entry", "thunderheadeng.util.stat.InfiniteUrn$Entry");
        addc.accept(MerlinIO.Version.VER_0115, "merlin.data.stat.LogNormCurve", LogNormCurve.class);
        addc.accept(MerlinIO.Version.VER_0115, "merlin.data.stat.StdNormCurve", StdNormCurve.class);
        addc.accept(MerlinIO.Version.VER_0115, "merlin.data.stat.UniformCurve", UniformCurve.class);
        addc.accept(MerlinIO.Version.VER_0115, "merlin.data.stat.Urn", Urn.class);
        addc.accept(MerlinIO.Version.VER_0117, "merlin.data.egress.scripting.Behavior", merlin.legacy.v0116.data.egress.scripting.Behavior.class);
        addc.accept(MerlinIO.Version.VER_0118, "inferno.data2.ai.AssistedEvacuationData$AssistedEvacuationRoleType", AssistedEvacuationData.AssistedEvacuationRoleType.class);
        addc.accept(MerlinIO.Version.VER_0119, "merlin.data.egress.agents.OccProfile$AssistedEvacRole", OccProfile.AssistedEvacRole.class);
        addc.accept(MerlinIO.Version.VER_0122, "merlin.data.egress.geom.EgressCorridor", EgressCorridor.class);
        addc.accept(MerlinIO.Version.VER_0122, "merlin.data.egress.geom.EgressCorridor$DoorInfo", EgressCorridor.DoorInfo.class);
        addc.accept(MerlinIO.Version.VER_0122, "merlin.data.egress.geom.EgressStair", EgressStair.class);
        addc.accept(MerlinIO.Version.VER_0122, "merlin.data.egress.geom.EgressDoor", EgressDoor.class);
        addc.accept(MerlinIO.Version.VER_0122, "merlin.data.egress.elevators.ElevatorDoor", merlin.legacy.v0121.data.egress.elevators.ElevatorDoor.class);
        addc.accept(MerlinIO.Version.VER_0142, "merlin.data.egress.scripting.QueueObjectComp", QueueObjectComp.class);
        addc.accept(MerlinIO.Version.VER_0148, "merlin.data.egress.agents.OccLocObj", OccLocObj.class);
        addc.accept(MerlinIO.Version.VER_0148, "merlin.data.egress.agents.OccLocObjComp", OccLocObjComp.class);
        addc.accept(MerlinIO.Version.VER_0148, "merlin.data.egress.scripting.AbandonOccLocs", AbandonOccLocs.class);
        addc.accept(MerlinIO.Version.VER_0148, "merlin.data.egress.scripting.AbandonOccLocs$Which", AbandonOccLocs.Which.class);
        addc.accept(MerlinIO.Version.VER_0148, "merlin.data.egress.scripting.GotoOccLoc", GotoOccLoc.class);
        addc.accept(MerlinIO.Version.VER_0148, "merlin.data.egress.scripting.GotoOccLoc$Choice", GotoOccLoc.Choice.class);
        addc.accept(MerlinIO.Version.VER_0152, "merlin.data.egress.geom.EgressRoom", merlin.legacy.v0151.data.egress.geom.EgressRoom.class);
        addc.accept(MerlinIO.Version.VER_0152, "merlin.data.egress.geom.EgressBlockage", EgressBlockage.class);
        addc.accept(MerlinIO.Version.VER_0152, "merlin.data.egress.elevators.ElevatorRoom", ElevatorRoom.class);
        addc.accept(MerlinIO.Version.VER_0157, "merlin.data.egress.scripting.Wait", Wait.class);
        addc.accept(MerlinIO.Version.VER_0157, "merlin.data.egress.scripting.WaitForAssistance", WaitForAssistance.class);
        addc.accept(MerlinIO.Version.VER_0157, "merlin.data.egress.scripting.WaitUntil", WaitUntil.class);
        addc.accept(MerlinIO.Version.VER_0157, "merlin.data.egress.scripting.WaitUntilEnd", WaitUntilEnd.class);
        addc.accept(MerlinIO.Version.VER_0159, "merlin.data.egress.elevators.Elevator", merlin.legacy.v0158.data.egress.elevators.Elevator.class);
        addc.accept(MerlinIO.Version.VER_0159, "merlin.data.egress.elevators.Elevator$LevelData", Elevator.LevelData.class);
        addc.accept(MerlinIO.Version.VER_0160, "inferno.elevator.IElevator$Type", IElevator.Type.class);
        addc.accept(MerlinIO.Version.VER_0161, "merlin.data.egress.elevators.Elevator", merlin.legacy.v0160.data.egress.elevators.Elevator.class);
        addc.accept(MerlinIO.Version.VER_0161, "merlin.data.egress.elevators.Elevator$LevelData", Elevator.LevelData.class);
        addc.accept(MerlinIO.Version.VER_0161, "merlin.data.egress.elevators.ITimingModel", ITimingModel.class);
        addc.accept(MerlinIO.Version.VER_0161, "merlin.data.egress.elevators.ITimingModel$AccelModel", ITimingModel.AccelModel.class);
        addc.accept(MerlinIO.Version.VER_0161, "merlin.data.egress.elevators.ITimingModel$VelModel", ITimingModel.VelModel.class);
        addc.accept(MerlinIO.Version.VER_0161, "merlin.data.egress.elevators.ITimingModel$LegacyModel", ITimingModel.LegacyModel.class);
        addc.accept(MerlinIO.Version.VER_0163, "merlin.data.egress.agents.OccProfile$AttractorRestrictions", OccProfile.AttractorRestrictions.class);
        addc.accept(MerlinIO.Version.VER_0163, "merlin.data.egress.agents.OccProfile$AttractorRestrictions$Mode", OccProfile.AttractorRestrictions.Mode.class);
        return ld;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        String name = osc.getName();
        TriConsumer<String, Long, Long> fixSUID = (cname, oldId, newId) -> {
            if (name.equals(cname) && osc.getSerialVersionUID() == oldId.longValue()) {
                try {
                    theUtil.assignFinalField(osc, ObjectStreamClass.class, "suid", newId);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, t.toString(), t);
                }
            }
        };
        fixSUID.accept("merlin.data.image.ImageGroup", -4652532199843815353L, 9212342643049677319L);
        fixSUID.accept("merlin.data.egress.agents.OccProfile$AssistedEvacRole", 1541259293717479369L, -2393726934323289716L);
        Class clazz = this.d_classLookup.resolveClass(name);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.d_teciio.resolveClass(osc);
        if (clazz != null) {
            return clazz;
        }
        return super.resolveClass(osc);
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        if (obj instanceof merlin.legacy.v0009.AEgressComp) {
            IEgressComp comp = ((merlin.legacy.v0009.AEgressComp)obj).fromLegacy();
            if (obj instanceof merlin.legacy.v0009.EgressDoor) {
                this.d_pre0009ConvertedDoors.put((merlin.legacy.v0009.EgressDoor)obj, (merlin.data.egress.geom.EgressDoor)comp);
            }
            return comp;
        }
        if (obj instanceof IGeom) {
            return ((IGeom)obj).fromLegacy(this.d_propsPool);
        }
        if (this.d_version < MerlinIO.Version.VER_0019.num && obj instanceof thunderheadeng.geometry.objs.Mesh) {
            thunderheadeng.geometry.objs.Mesh old = (thunderheadeng.geometry.objs.Mesh)obj;
            thunderheadeng.geometry.objs.Mesh fixed = old.fix();
            if (old.getNumPrims(7) == fixed.getNumPrims(7)) {
                return fixed;
            }
            LOGGER.log(Level.WARNING, "Could not apply Mesh fix.");
        }
        if (obj instanceof AssistedEvacuationData.AssistedEvacuationRoleType) {
            return ((AssistedEvacuationData.AssistedEvacuationRoleType)((Object)obj)).convert();
        }
        if (obj instanceof IElevator.Type) {
            return ((IElevator.Type)((Object)obj)).readResolve();
        }
        return this.d_teciio.resolveObject(obj);
    }

    public static class DecisionMaker {
        public BooleanSupplier pre104UseNewDefaults = () -> true;
        public BooleanSupplier pre139ConvertToSocialDistance = () -> false;
    }

    private static class BehaviorKey {
        public final Set<merlin.data.egress.geom.EgressDoor> exits;
        public final IDistributedVal<UnitDouble> delay;

        public BehaviorKey(Set<merlin.data.egress.geom.EgressDoor> exits, IDistributedVal<UnitDouble> delay) {
            this.exits = exits;
            this.delay = delay;
        }

        public int hashCode() {
            return 2244410 + this.exits.hashCode() + this.delay.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BehaviorKey)) {
                return false;
            }
            BehaviorKey bk = (BehaviorKey)obj;
            return this.exits.equals(bk.exits) && this.delay.equals(bk.delay);
        }
    }

    private static interface QuadConsumer<T1, T2, T3, T4> {
        public void accept(T1 var1, T2 var2, T3 var3, T4 var4);
    }
}

