/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.stream.Collectors;
import merlin.data.MerlinData;
import merlin.data.property.INamedProp;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.KnownPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;

public class PropertySetEditor
extends AValEditor<PropertySet> {
    private static final long serialVersionUID = 1L;
    private final List<Pair<INamedProp, IValEditor>> d_props;

    public PropertySetEditor(MerlinData md, List<INamedProp<?>> props) {
        super(PropertySet.class);
        assert (props.stream().allMatch(p -> p.getValEditorSupplier() != null));
        assert (props.stream().allMatch(p -> p instanceof IPropertySet.Prop));
        this.d_props = props.stream().map(prop -> new Pair((INamedProp)prop, prop.newValueEditor(md, true).get())).collect(Collectors.toList());
        PropertyChangeListener listener = e -> this.updateValue();
        for (Pair<INamedProp, IValEditor> prop2 : this.d_props) {
            ((IValEditor)prop2.v2).addValueListener(listener);
        }
        GridBagHelper gb = new GridBagHelper(this);
        this.add(gb);
        gb.finalizeRows();
        this.setValue(this.newPropertySet());
    }

    private KnownPropertySet newPropertySet() {
        return new KnownPropertySet(this.d_props.stream().map(entry -> (IPropertySet.Prop)entry.v1).collect(Collectors.toSet()));
    }

    @Override
    public void add(GridBagHelper gb) {
        for (Pair<INamedProp, IValEditor> entry : this.d_props) {
            INamedProp prop = (INamedProp)entry.v1;
            gb.add(guiUtil.lbl(prop.getDisplayName(), prop.getDisplayDesc()));
            ((IValEditor)entry.v2).add(gb);
            gb.nextRow();
        }
    }

    @Override
    protected void loadValue(PropertySet props) {
        for (Pair<INamedProp, IValEditor> entry : this.d_props) {
            Object val = props == null ? null : (Object)props.get((IPropertySet.Prop)entry.v1);
            ((IValEditor)entry.v2).setValue(val);
        }
    }

    @Override
    protected PropertySet saveValue() {
        if (this.d_props.stream().anyMatch(entry -> ((IValEditor)entry.v2).getValue() == null)) {
            return null;
        }
        KnownPropertySet props = this.newPropertySet();
        for (Pair<INamedProp, IValEditor> entry2 : this.d_props) {
            props.setIfNotDefault((IPropertySet.Prop)entry2.v1, ((IValEditor)entry2.v2).getValue());
        }
        return props;
    }
}

