/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.geom.Geometry;
import merlin.gui.guiUtil;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.units.UnitDouble;

public class Point3dListEditor
extends AValEditor<List<Point3d>> {
    private static final long serialVersionUID = 1L;
    private final guiTable d_table;
    private final Semaphore d_valLock = new Semaphore(1);
    private boolean d_valueDirty = true;

    public Point3dListEditor(Unit lenUnit, String emptyRowLbl) {
        super(List.class);
        String[] headers = new String[]{Intl.intl("X"), Intl.intl("Y"), Intl.intl("Z")};
        guiTableEditor ed = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, new Class[]{UnitDouble.class, UnitDouble.class, UnitDouble.class}), 94);
        this.d_table = ed.getTable();
        this.d_table.setNullValuesAllowed(true);
        for (int m = 0; m < 3; ++m) {
            this.d_table.getColumnModel().getColumn(m).setCellRenderer(new guiTable.UnitDoubleRenderer(lenUnit));
            this.d_table.getColumnModel().getColumn(m).setCellEditor(new guiTable.UnitDoubleEditor(lenUnit));
            this.d_table.getColumnModel().getColumn(m).setPreferredWidth(75);
        }
        this.d_table.setPreferredScrollableViewportSize(new Dimension(this.d_table.getPreferredSize().width, Math.max(300, this.d_table.getPreferredSize().height)));
        this.d_table.getModel().addTableModelListener(e -> {
            this.d_valueDirty = true;
        });
        this.d_table.setPasteAction(new guiTable.PasteAction(this){

            @Override
            protected void tryPaste(guiTable t) {
                super.tryPaste(t);
                if (!this.getEmptyRows(t).findAny().isPresent()) {
                    return;
                }
                int opt = JOptionPane.showConfirmDialog(guiUtil.getWindow(t), "<html>" + Intl.intl("Do you want to keep empty rows in the table? Empty rows will generate a<br>random location for the occupant."), Intl.intl("Keep Empty Rows?"), 0);
                if (opt == 0) {
                    return;
                }
                guiDefaultTableModel model = (guiDefaultTableModel)t.getModel();
                List emptyRows = this.getEmptyRows(t).mapToObj(i -> i).collect(Collectors.toList());
                for (int m = emptyRows.size() - 1; m >= 0; --m) {
                    model.removeRow((Integer)emptyRows.get(m));
                }
            }

            private IntStream getEmptyRows(guiTable t) {
                guiDefaultTableModel m = (guiDefaultTableModel)t.getModel();
                int nRows = m.getRowCount();
                return IntStream.range(0, nRows).filter(row -> IntStream.range(0, 3).anyMatch(col -> m.getValueAt(row, col) == null));
            }
        });
        MultiLineLabel infoLbl = new MultiLineLabel(emptyRowLbl);
        infoLbl.setForeground(Color.BLUE);
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(ed, new double[]{1.0, 1.0}, new int[]{1, 1});
        gb.addFilledRow(infoLbl);
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.addRow(this, 1.0);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        return super.validateData(showWarn, allowModify);
    }

    @Override
    public List<Point3d> getValue() {
        if (this.d_valueDirty && this.d_valLock.tryAcquire()) {
            this.updateValue();
            this.d_valueDirty = false;
            this.d_valLock.release();
        }
        return (List)super.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadValue(List<Point3d> value) {
        if (!this.d_valLock.tryAcquire()) {
            return;
        }
        try {
            this.d_table.clearRows();
            guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
            model.setNumRows(value.size());
            Unit u = Geometry.LENGTH_UNIT;
            int row = 0;
            for (Point3d p : value) {
                if (p == null) {
                    model.setValueAt(null, row, 0);
                    model.setValueAt(null, row, 1);
                    model.setValueAt(null, row, 2);
                } else {
                    model.setValueAt(new UnitDouble(p.x, u), row, 0);
                    model.setValueAt(new UnitDouble(p.y, u), row, 1);
                    model.setValueAt(new UnitDouble(p.z, u), row, 2);
                }
                ++row;
            }
            super.setValue(value);
            this.setModified(false);
        }
        finally {
            this.d_valLock.release();
        }
    }

    @Override
    protected List<Point3d> saveValue() {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        int rows = model.getRowCount();
        Unit u = Geometry.LENGTH_UNIT;
        ArrayList<Point3d> result = new ArrayList<Point3d>();
        for (int m = 0; m < rows; ++m) {
            UnitDouble x = (UnitDouble)model.getValueAt(m, 0);
            UnitDouble y = (UnitDouble)model.getValueAt(m, 1);
            UnitDouble z = (UnitDouble)model.getValueAt(m, 2);
            if (x == null || y == null || z == null) {
                result.add(null);
                continue;
            }
            result.add(new Point3d(x.get(u), y.get(u), z.get(u)));
        }
        result.trimToSize();
        return result;
    }
}

