/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import merlin.Intl;
import merlin.gui.value.DiscreteValEditor;
import thunderheadeng.util.Pair;

public class BooleanValEditor
extends DiscreteValEditor<Boolean> {
    private static final long serialVersionUID = 1L;
    private final boolean d_inverted;

    public BooleanValEditor() {
        this(false);
    }

    public BooleanValEditor(boolean inverted) {
        this(inverted, Intl.intl("Yes"), Intl.intl("No"));
    }

    public BooleanValEditor(boolean inverted, String trueDesc, String falseDesc) {
        super(Boolean.class, (T v) -> {
            String name = v != false ? trueDesc : falseDesc;
            return new Pair<String, Object>(name, null);
        }, true, false);
        this.d_inverted = inverted;
    }

    @Override
    protected void loadValue(Boolean value) {
        if (value == null) {
            super.loadValue(value);
        } else {
            super.loadValue(value ^ this.d_inverted);
        }
    }

    @Override
    protected Boolean saveValue() {
        Boolean val = (Boolean)super.saveValue();
        return val == null ? null : Boolean.valueOf(val ^ this.d_inverted);
    }
}

