/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.data.stat.AutoCurve;
import merlin.data.stat.CurveUtil;
import merlin.data.stat.DisabledCurve;
import merlin.gui.stat.ConstantEditor;
import merlin.gui.stat.DiscreteCurveEditor;
import merlin.gui.stat.LogNormEditor;
import merlin.gui.stat.NormEditor;
import merlin.gui.stat.UniformEditor;
import merlin.gui.stat.guiCurveUtil;
import merlin.gui.value.AutoCurveEditor;
import merlin.gui.value.DisabledCurveEditor;
import merlin.gui.value.MultiValEditor;
import merlin.gui.value.PopupValEditor;
import merlin.unitsystem.SIUS;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.LogNormCurve;
import thunderheadeng.util.stat.StdNormCurve;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.theUtil;

public class VerboseDistributedValEditor
extends MultiValEditor<IDistributedVal<UnitDouble>> {
    private static final long serialVersionUID = -2729712180348926416L;
    public static final EnumSet<Type> OPT_ALL = theUtil.filterEnum(Type.class, e -> !e.placeholder);

    public static Collection<MultiValEditor.Entry<IDistributedVal<UnitDouble>, ? extends IDistributedVal<UnitDouble>>> getEntries(int unit, Predicate<? super Class<? extends IDistributedVal<UnitDouble>>> typeTest, boolean inline, UnitDoubleVR range) {
        AValEditor discreteEditor;
        AValEditor logNormEditor;
        AValEditor uniformEditor;
        AValEditor NormEditor2;
        ArrayList<MultiValEditor.Entry<IDistributedVal<UnitDouble>, ? extends IDistributedVal<UnitDouble>>> entries = new ArrayList<MultiValEditor.Entry<IDistributedVal<UnitDouble>, ? extends IDistributedVal<UnitDouble>>>();
        ConstantEditor constEditor = new ConstantEditor(unit, range);
        if (typeTest.test(DisabledCurve.class)) {
            entries.add(new MultiValEditor.Entry<IDistributedVal, DisabledCurve>(Intl.intl("<disabled>"), "", new DisabledCurveEditor(SIUS.unit(unit)), curve -> curve != null, () -> true, curve -> new DisabledCurve(SIUS.unit(unit))));
        }
        if (typeTest.test(AutoCurve.class)) {
            entries.add(new MultiValEditor.Entry<IDistributedVal, AutoCurve>(Intl.intl("<automatic>"), Intl.intl("The value is determined automatically."), new AutoCurveEditor(SIUS.unit(unit)), curve -> curve != null, () -> true, curve -> new AutoCurve(SIUS.unit(unit))));
        }
        if (typeTest.test(ConstantCurve.class)) {
            entries.add(new MultiValEditor.Entry<IDistributedVal, ConstantCurve>(Intl.intl("Constant"), Intl.intl("Enter a constant value."), constEditor, curve -> curve != null, () -> true, curve -> CurveUtil.toConstantCurve(curve, unit)));
        }
        BooleanSupplier NormFunc = () -> true;
        BooleanSupplier uniformFunc = () -> true;
        BooleanSupplier logNormFunc = () -> true;
        BooleanSupplier discreteFunc = () -> true;
        if (inline) {
            NormEditor2 = new NormEditor(unit, range);
            uniformEditor = new UniformEditor(unit, range);
            logNormEditor = new LogNormEditor(unit, range);
            discreteEditor = new DiscreteCurveEditor(unit);
        } else {
            DlgCurveEditor<StdNormCurve> dlgStdNormEditor = new DlgCurveEditor<StdNormCurve>(StdNormCurve.class, () -> new NormEditor(unit, range), Intl.intl("Normal Distribution"));
            DlgCurveEditor<UniformCurve> dlgUniformEditor = new DlgCurveEditor<UniformCurve>(UniformCurve.class, () -> new UniformEditor(unit, range), Intl.intl("Uniform Distribution"));
            DlgCurveEditor<LogNormCurve> dlgLogNormEditor = new DlgCurveEditor<LogNormCurve>(LogNormCurve.class, () -> new LogNormEditor(unit, range), Intl.intl("Log Normal Distribution"));
            DlgCurveEditor<IUrn> dlgDiscreteCurveEditor = new DlgCurveEditor<IUrn>(IUrn.class, () -> new DiscreteCurveEditor(unit), Intl.intl("Discrete Distribution"));
            NormFunc = () -> dlgStdNormEditor.editValue();
            uniformFunc = () -> dlgUniformEditor.editValue();
            logNormFunc = () -> dlgLogNormEditor.editValue();
            discreteFunc = () -> dlgDiscreteCurveEditor.editValue();
            NormEditor2 = dlgStdNormEditor;
            uniformEditor = dlgUniformEditor;
            logNormEditor = dlgLogNormEditor;
            discreteEditor = dlgDiscreteCurveEditor;
        }
        if (typeTest.test(UniformCurve.class)) {
            entries.add(new MultiValEditor.Entry<IDistributedVal, UniformCurve>(Intl.intl("Uniform"), Intl.intl("Enter a uniform distribution."), uniformEditor, curve -> curve != null, uniformFunc, curve -> CurveUtil.toUniformCurve(curve, unit)));
        }
        if (typeTest.test(StdNormCurve.class)) {
            entries.add(new MultiValEditor.Entry<IDistributedVal, StdNormCurve>(Intl.intl("Normal"), Intl.intl("Enter a normal distribution."), NormEditor2, curve -> curve != null, NormFunc, curve -> CurveUtil.toStdNormCurve(curve, unit)));
        }
        if (typeTest.test(LogNormCurve.class)) {
            entries.add(new MultiValEditor.Entry<IDistributedVal, LogNormCurve>(Intl.intl("Log-normal"), Intl.intl("Enter a log normal distribution."), logNormEditor, curve -> curve != null, logNormFunc, curve -> CurveUtil.toLogNormCurve(curve, unit)));
        }
        if (typeTest.test(UnitDoubleUrn.class)) {
            entries.add(new MultiValEditor.Entry<IDistributedVal, IUrn>(Intl.intl("Discrete"), Intl.intl("Enter a discrete distribution."), discreteEditor, curve -> curve != null, discreteFunc, curve -> CurveUtil.toDiscreteCurve(curve, unit)));
        }
        return entries;
    }

    public VerboseDistributedValEditor(int unit, boolean inline) {
        this(unit, inline, UnitDoubleVR.above(0.0, SIUS.unit(unit), true));
    }

    public VerboseDistributedValEditor(int unit, boolean inline, UnitDoubleVR range) {
        this(unit, inline, OPT_ALL, range);
    }

    public VerboseDistributedValEditor(int unit, boolean inline, EnumSet<Type> options) {
        this(unit, inline, options, UnitDoubleVR.above(0.0, SIUS.unit(unit), true));
    }

    public VerboseDistributedValEditor(int unit, boolean inline, EnumSet<Type> options, UnitDoubleVR range) {
        this(unit, inline, VerboseDistributedValEditor.getTypeTest(options), range);
    }

    public VerboseDistributedValEditor(int unit, boolean inline, Predicate<? super Class<? extends IDistributedVal<UnitDouble>>> typeTest, UnitDoubleVR range) {
        super(IDistributedVal.class, VerboseDistributedValEditor.getEntries(unit, typeTest, inline, range), false);
    }

    public static Predicate<? super Class<? extends IDistributedVal<UnitDouble>>> getTypeTest(EnumSet<Type> types) {
        return Predicates.or(theUtil.toArray(types.stream().map(t -> t.typeTest).collect(Collectors.toList()), Predicate.class));
    }

    private static class DlgCurveEditor<T extends IDistributedVal<UnitDouble>>
    extends PopupValEditor<T> {
        private static final long serialVersionUID = 1104839981710285898L;

        public DlgCurveEditor(Class<T> type, Supplier<? extends IValEditor<T>> editor, String desc) {
            super(PopupValEditor.Mode.BUTTON, type, desc, editor, curve -> guiCurveUtil.format(curve));
        }
    }

    private static interface UnitDoubleUrn
    extends IUrn<UnitDouble> {
    }

    public static enum Type {
        DISABLED(true, t -> t.equals(DisabledCurve.class)),
        AUTO(true, t -> t.equals(AutoCurve.class)),
        CONSTANT(false, t -> t.equals(ConstantCurve.class)),
        UNIFORM(false, t -> t.equals(UniformCurve.class)),
        NORM(false, t -> t.equals(StdNormCurve.class)),
        LOGNORM(false, t -> t.equals(LogNormCurve.class)),
        DISCRETE(false, t -> IUrn.class.isAssignableFrom((Class<?>)t));

        public final boolean placeholder;
        public final Predicate<? super Class<? extends IDistributedVal<UnitDouble>>> typeTest;

        private Type(boolean placeholder, Predicate<? super Class<? extends IDistributedVal<UnitDouble>>> typeTest) {
            this.placeholder = placeholder;
            this.typeTest = typeTest;
        }
    }
}

