/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import merlin.Intl;
import merlin.data.stat.AutoCurve;
import merlin.data.stat.CurveUtil;
import merlin.data.stat.DisabledCurve;
import merlin.gui.stat.ConstantEditor;
import merlin.gui.stat.LogNormEditor;
import merlin.gui.stat.NormEditor;
import merlin.gui.stat.UniformEditor;
import merlin.gui.stat.guiCurveUtil;
import merlin.gui.value.AutoCurveEditor;
import merlin.gui.value.DisabledCurveEditor;
import merlin.gui.value.MultiValEditor;
import merlin.gui.value.PopupValEditor;
import merlin.unitsystem.SIUS;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.LogNormCurve;
import thunderheadeng.util.stat.StdNormCurve;
import thunderheadeng.util.stat.UniformCurve;

public class VerboseCurveEditor
extends MultiValEditor<ICurve> {
    private static final long serialVersionUID = -6412345981723113656L;
    public static final int OPT_CONSTANT = 1;
    public static final int OPT_UNIFORM = 2;
    public static final int OPT_NORM = 4;
    public static final int OPT_LOGNORM = 8;
    public static final int OPT_DISABLED = 16;
    public static final int OPT_AUTO = 32;
    public static final int OPT_ALL = 15;

    public static Collection<MultiValEditor.Entry<ICurve, ? extends ICurve>> getEntries(int unit, int options, boolean inline, UnitDoubleVR range) {
        AValEditor logNormEditor;
        AValEditor uniformEditor;
        AValEditor NormEditor2;
        BooleanSupplier noneFunc;
        AValEditor noneEditor;
        ArrayList<MultiValEditor.Entry<ICurve, ? extends ICurve>> entries = new ArrayList<MultiValEditor.Entry<ICurve, ? extends ICurve>>();
        IntPredicate opt = i -> (i & options) == i;
        if (opt.test(16)) {
            noneEditor = new DisabledCurveEditor(SIUS.unit(unit));
            noneFunc = () -> true;
            entries.add(new MultiValEditor.Entry<ICurve, DisabledCurve>(Intl.intl("<disabled>"), "", noneEditor, curve -> curve != null, noneFunc, curve -> new DisabledCurve(SIUS.unit(unit))));
        }
        if (opt.test(32)) {
            noneEditor = new AutoCurveEditor(SIUS.unit(unit));
            noneFunc = () -> true;
            entries.add(new MultiValEditor.Entry<ICurve, AutoCurve>(Intl.intl("<automatic>"), "", noneEditor, curve -> curve != null, noneFunc, curve -> new AutoCurve(SIUS.unit(unit))));
        }
        ConstantEditor constEditor = new ConstantEditor(unit, range);
        if (opt.test(1)) {
            entries.add(new MultiValEditor.Entry<ICurve, ConstantCurve>(Intl.intl("Constant"), Intl.intl("Enter a constant value."), constEditor, curve -> curve != null, () -> true, curve -> CurveUtil.toConstantCurve(curve, unit)));
        }
        BooleanSupplier NormFunc = () -> true;
        BooleanSupplier uniformFunc = () -> true;
        BooleanSupplier logNormFunc = () -> true;
        if (inline) {
            NormEditor2 = new NormEditor(unit, range);
            uniformEditor = new UniformEditor(unit, range);
            logNormEditor = new LogNormEditor(unit, range);
        } else {
            DlgCurveEditor<StdNormCurve> dlgStdNormEditor = new DlgCurveEditor<StdNormCurve>(StdNormCurve.class, () -> new NormEditor(unit, range), Intl.intl("Normal Distribution"));
            DlgCurveEditor<UniformCurve> dlgUniformEditor = new DlgCurveEditor<UniformCurve>(UniformCurve.class, () -> new UniformEditor(unit, range), Intl.intl("Uniform Distribution"));
            DlgCurveEditor<LogNormCurve> dlgLogNormEditor = new DlgCurveEditor<LogNormCurve>(LogNormCurve.class, () -> new LogNormEditor(unit, range), Intl.intl("Log Normal Distribution"));
            NormFunc = () -> dlgStdNormEditor.editValue();
            uniformFunc = () -> dlgUniformEditor.editValue();
            logNormFunc = () -> dlgLogNormEditor.editValue();
            NormEditor2 = dlgStdNormEditor;
            uniformEditor = dlgUniformEditor;
            logNormEditor = dlgLogNormEditor;
        }
        if (opt.test(2)) {
            entries.add(new MultiValEditor.Entry<ICurve, UniformCurve>(Intl.intl("Uniform"), Intl.intl("Enter a uniform distribution."), uniformEditor, curve -> curve != null, uniformFunc, curve -> CurveUtil.toUniformCurve(curve, unit)));
        }
        if (opt.test(4)) {
            entries.add(new MultiValEditor.Entry<ICurve, StdNormCurve>(Intl.intl("Normal"), Intl.intl("Enter a normal distribution."), NormEditor2, curve -> curve != null, NormFunc, curve -> CurveUtil.toStdNormCurve(curve, unit)));
        }
        if (opt.test(8)) {
            entries.add(new MultiValEditor.Entry<ICurve, LogNormCurve>(Intl.intl("Log-normal"), Intl.intl("Enter a log normal distribution."), logNormEditor, curve -> curve != null, logNormFunc, curve -> CurveUtil.toLogNormCurve(curve, unit)));
        }
        return entries;
    }

    public VerboseCurveEditor(int unit, boolean inline) {
        this(unit, inline, UnitDoubleVR.above(0.0, SIUS.unit(unit), true));
    }

    public VerboseCurveEditor(int unit, boolean inline, UnitDoubleVR range) {
        this(unit, inline, 15, range);
    }

    public VerboseCurveEditor(int unit, boolean inline, int options) {
        this(unit, inline, options, UnitDoubleVR.above(0.0, SIUS.unit(unit), true));
    }

    public VerboseCurveEditor(int unit, boolean inline, int options, UnitDoubleVR range) {
        super(ICurve.class, VerboseCurveEditor.getEntries(unit, options, inline, range), false);
    }

    private static class DlgCurveEditor<T extends ICurve>
    extends PopupValEditor<T> {
        private static final long serialVersionUID = 5537386820022245425L;

        public DlgCurveEditor(Class<T> type, Supplier<? extends IValEditor<T>> editor, String desc) {
            super(PopupValEditor.Mode.BUTTON, type, desc, editor, curve -> guiCurveUtil.format(curve));
        }
    }
}

