/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.filter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.gui.SetChooser;
import merlin.gui.guiUtil;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.Comm;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.util.Pair;

public class ObjRestrictionEditorComponents<ModeT, ObjT> {
    public final Class<ObjT> clazz;
    public final guiLabel d_compLbl;
    public final guiComboBox<ModeT> d_modeCB;
    public final IValEditor<Set<ObjT>> d_chooser;
    public final guiComboBox<Boolean> d_acceptCB;
    public final ModeT d_fromListMode;
    private final Comm d_comm;

    public static <DataT extends IMerlinObj> SetChooser<DataT> newChooser(MerlinData md, String chooserLbl, Class<DataT> objType, Composite<?> objRoot, Predicate<? super DataT> allowedObjs) {
        return new SetChooser<DataT>(md, chooserLbl, Intl.intl("none"), 1, objRoot, objType, allowedObjs);
    }

    public ObjRestrictionEditorComponents(String compLbl, Class<ObjT> objType, IValEditor<Set<ObjT>> objsChooser, Function<ModeT, Pair<String, String>> restrFormat, ModeT fromListMode, ModeT ... allowedModes) {
        this.clazz = objType;
        this.d_fromListMode = fromListMode;
        this.d_compLbl = compLbl != null ? new guiLabel(compLbl) : null;
        this.d_modeCB = guiUtil.newCombo(mode -> mode == null ? new Pair<String, Object>("<mixed>", null) : (Pair)restrFormat.apply(mode), allowedModes);
        this.d_chooser = objsChooser;
        this.d_acceptCB = guiUtil.newCombo(Boolean.valueOf(true), Intl.intl("Accept"), false, Intl.intl("Reject"));
        Runnable updateVis = () -> {
            boolean visible = this.d_modeCB.getSelectedItem() == this.d_fromListMode;
            this.d_acceptCB.setVisible(visible);
            this.d_chooser.getComponent().setVisible(visible);
        };
        this.d_modeCB.addItemListener(e -> updateVis.run());
        updateVis.run();
        this.d_comm = new Comm();
        ItemListener comboListener = e -> {
            if (e.getStateChange() == 1) {
                this.d_comm.itemStateChanged(e);
            }
        };
        this.d_modeCB.addItemListener(comboListener);
        this.d_acceptCB.addItemListener(comboListener);
        this.d_chooser.addValueListener(e -> this.d_comm.touch(e));
    }

    public Comm getComm() {
        return this.d_comm;
    }

    public void addToLayout(GridBagHelper gb) {
        Dimension d = new Dimension(220, 24);
        guiPanel doorPlaceHolder = new guiPanel();
        doorPlaceHolder.setPreferredSize(d);
        GridBagHelper tempGB = new GridBagHelper(doorPlaceHolder);
        tempGB.addRow(this.d_acceptCB, this.d_chooser.getComponent(), new double[]{1.0, 0.0});
        if (this.d_compLbl != null) {
            gb.addRow(this.d_compLbl, this.d_modeCB, doorPlaceHolder, new double[]{1.0, 0.0});
        } else {
            gb.addRow(this.d_modeCB, doorPlaceHolder, new double[]{1.0, 0.0});
        }
    }

    public void addToLayout(guiPanel basePanel) {
        Dimension d = new Dimension(220, 24);
        guiPanel doorPlaceHolder = new guiPanel();
        doorPlaceHolder.setPreferredSize(d);
        GridBagHelper tempGB = new GridBagHelper(doorPlaceHolder);
        tempGB.addRow(this.d_acceptCB, this.d_chooser.getComponent(), new double[]{1.0, 0.0});
        if (!basePanel.getLayout().getClass().equals(MigLayout.class)) {
            basePanel.setLayout(new MigLayout("insets 0"));
        }
        if (this.d_compLbl != null) {
            basePanel.add((Component)this.d_compLbl, "grow");
            basePanel.add(this.d_modeCB, "grow");
            basePanel.add((Component)doorPlaceHolder, "grow, span, wrap");
        } else {
            basePanel.add(this.d_modeCB, "grow");
            basePanel.add((Component)doorPlaceHolder, "grow, span, wrap");
        }
    }

    public boolean validateData(Component parent, boolean allowWarn, boolean allowEdit) {
        if (this.d_modeCB.getSelectedItem() == null) {
            if (allowWarn) {
                JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(parent), Intl.intl("An empty selection is not allowed."), Intl.intl("Invalid data"), 0);
            }
            return false;
        }
        return true;
    }

    public void load(ModeT mode, boolean accepted, Set<ObjT> fromListObjs) {
        if (mode == null) {
            this.d_modeCB.setSelectedIndex(-1);
        } else {
            this.d_modeCB.setSelectedItem(mode);
        }
        this.d_acceptCB.setSelectedItem(accepted);
        this.d_chooser.setValue(fromListObjs);
    }

    public Data save() {
        ModeT mode = this.d_modeCB.getSelectedItem();
        if (mode == this.d_fromListMode) {
            return new Data(this, mode, this.d_acceptCB.getSelectedItem(), this.d_chooser.getValue());
        }
        return new Data(this, mode, true, Collections.emptySet());
    }

    protected class Data {
        public final ModeT mode;
        public final boolean accepted;
        public final Set<ObjT> objs;

        public Data(ObjRestrictionEditorComponents this$0, ModeT mode, boolean accepted, Set<ObjT> objs) {
            this.mode = mode;
            this.accepted = accepted;
            this.objs = objs;
        }
    }
}

