/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.agents;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Objects;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.EditProps;
import merlin.actions.UIHook;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.VehicleShape;
import merlin.gui.MerlinComboBox;
import merlin.gui.MerlinUDF;
import merlin.gui.UnitUpdator;
import merlin.gui.guiUtil;
import merlin.gui.stat.VerboseCurveEditor;
import merlin.unitsystem.UnitUpdatableComponent;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.theUtil;

public class ShapeEditor
extends HTMLBtn
implements Modifiable,
IValEditor<OccProfile.OccShape>,
UnitUpdatableComponent {
    private static final long serialVersionUID = 1L;
    private OccProfile.OccShape d_shape;
    private boolean d_modified = false;
    private ShapePnl d_pnl;

    public ShapeEditor(int options) {
        super("");
        if (options == 1) {
            UnitUpdator.addComp(this);
        }
        this.addActionListener(e -> {
            OccProfile.OccShape newShape;
            guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Shape"), 9);
            dlg.setResizable(true);
            this.d_pnl = new ShapePnl(options);
            this.d_pnl.load(this.d_shape);
            dlg.getDialogPane().add(this.d_pnl);
            dlg.setResizable(false);
            if (dlg.doModal() == 1 && !Objects.equals(newShape = this.d_pnl.save(), this.d_shape)) {
                this.setValue(newShape);
            }
        });
        this.update();
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.add(this, 1.0);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Class<OccProfile.OccShape> getType() {
        return OccProfile.OccShape.class;
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
    }

    @Override
    public void setValue(OccProfile.OccShape shape) {
        if (Objects.equals(shape, this.d_shape)) {
            return;
        }
        OccProfile.OccShape prevShape = this.d_shape;
        this.d_shape = shape;
        this.update();
        this.setModified(true);
        this.firePropertyChange("value", prevShape, this.d_shape);
    }

    @Override
    public OccProfile.OccShape getValue() {
        return this.d_shape;
    }

    public void update() {
        this.setText(this.d_shape != null ? this.d_shape.format() : Intl.intl("&lt;mixed&gt;"));
    }

    @Override
    public void update(Unit newUnit) {
        this.update();
    }

    @Override
    public Unit getDisplayUnit() {
        return SI.CENTI(SI.METER);
    }

    public static class ShapePnl
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private MerlinComboBox<VehicleShape> d_cbVehicleShape;
        private VerboseCurveEditor d_shoulderWidth;
        private VerboseCurveEditor d_height;
        private final guiPanel d_cardPanel;
        private final guiComboBox<ShapeTypeEnum> d_cbShapeType;
        private final guiCheckBox d_reduceDiamOccsCyl;
        private final guiCheckBox d_reduceDiamOccsPol;
        private final guiCheckBox d_reduceDiamGeom;
        private final guiDoubleField d_redFactorOccsCyl;
        private final guiDoubleField d_redFactorOccsPol;
        private final MerlinUDF d_minDiamGeom;
        private Component d_parent;

        public ShapePnl(int curveOpts) {
            guiLabel shoulderWidthLbl = guiUtil.lblHtml(Intl.intl("Diameter:"), OccProfile.PROP_DIAMETER.description);
            this.d_shoulderWidth = new VerboseCurveEditor(6, false, curveOpts);
            guiLabel heightLbl = guiUtil.lblHtml(Intl.intl("Height:"), OccProfile.PROP_HEIGHT.description);
            this.d_height = new VerboseCurveEditor(0, false, curveOpts);
            if (curveOpts == 1) {
                this.d_shoulderWidth.getComboBox().setEnabled(false);
                this.d_height.getComboBox().setEnabled(false);
            }
            guiLabel vehicleShapeLbl = guiUtil.lblHtml(Intl.intl("Vehicle Shape:"), OccProfile.PROP_SHAPE.description);
            this.d_cbVehicleShape = new MerlinComboBox(MerlinApp.getApp().getData(), VehicleShape.class, (IMerlinObj[])new VehicleShape[0]);
            this.d_cbVehicleShape.setPreferredSize(new Dimension(150, this.d_cbVehicleShape.getPreferredSize().height));
            String reduceDiamOccs = Intl.intl("Reduce diameter to resolve congestion");
            guiLabel squeezeLblCyl = guiUtil.lblHtml(Intl.intl("Reduction Factor:"), OccProfile.PROP_MIN_SQUEEZE_FACTOR_CONST.description);
            guiLabel squeezeLblPol = guiUtil.lblHtml(Intl.intl("Reduction Factor:"), OccProfile.PROP_MIN_SQUEEZE_FACTOR_CONST.description);
            guiLabel minDiamLbl = guiUtil.lblHtml(Intl.intl("Minimum Diameter:"), OccProfile.PROP_GEOM_DIAMETER.description);
            this.d_reduceDiamOccsCyl = new guiCheckBox(reduceDiamOccs);
            this.d_reduceDiamOccsPol = new guiCheckBox(reduceDiamOccs);
            this.d_reduceDiamGeom = new guiCheckBox(Intl.intl("Reduce diameter to move through narrow geometry"));
            this.d_reduceDiamGeom.setToolTipText(Intl.intl("Reduced diameter applies only to steering-mode simulations and is not used by SFPE-mode simulations."));
            this.d_redFactorOccsCyl = new guiDoubleField(DoubleVR.between(0.0, 1.0, true, true));
            this.d_redFactorOccsPol = new guiDoubleField(DoubleVR.between(0.0, 1.0, true, true));
            this.d_minDiamGeom = new MerlinUDF(SI.CENTI(SI.METER));
            int prefWidth = 90;
            this.d_redFactorOccsCyl.setPreferredSize(new Dimension(prefWidth, this.d_redFactorOccsCyl.getPreferredSize().height));
            this.d_redFactorOccsPol.setPreferredSize(new Dimension(prefWidth, this.d_redFactorOccsPol.getPreferredSize().height));
            this.d_minDiamGeom.setPreferredSize(new Dimension(prefWidth, this.d_minDiamGeom.getPreferredSize().height));
            HTMLBtn editVehicleShape = new HTMLBtn(Intl.intl("Edit..."));
            editVehicleShape.addActionListener(e -> {
                AMerlinOp op = new AMerlinOp(){

                    @Override
                    public void run(MerlinApp app, MerlinData md) {
                        EditProps.editVehicleShapes(MerlinApp.getApp(), MerlinApp.getApp().getData(), Optional.of((VehicleShape)d_cbVehicleShape.getSelectedItem()));
                    }
                };
                UIHook.run(this, "Edit Vehicle Shapes", op, 0);
            });
            LinkStatus.link((AbstractButton)this.d_reduceDiamOccsCyl, this.d_redFactorOccsCyl, squeezeLblCyl);
            LinkStatus.link((AbstractButton)this.d_reduceDiamOccsPol, this.d_redFactorOccsPol, squeezeLblPol);
            LinkStatus.link((AbstractButton)this.d_reduceDiamGeom, this.d_minDiamGeom, minDiamLbl);
            guiPanel cylinderPnl = new guiPanel();
            GridBagHelper gb = new GridBagHelper(cylinderPnl);
            gb.add(shoulderWidthLbl);
            this.d_shoulderWidth.addTwoComps(gb, false);
            gb.add(heightLbl);
            this.d_height.addTwoComps(gb, false);
            gb.addRow(this.d_reduceDiamOccsCyl, GridBagHelper.REMAINING);
            gb.addIdentRow(squeezeLblCyl, 2, this.d_redFactorOccsCyl);
            gb.addRow(this.d_reduceDiamGeom, GridBagHelper.REMAINING);
            gb.addIdentRow(minDiamLbl, 2, this.d_minDiamGeom);
            gb.finalizeRows();
            guiPanel polygonPnl = new guiPanel();
            gb = new GridBagHelper(polygonPnl);
            gb.addRow(new Object[]{vehicleShapeLbl, this.d_cbVehicleShape, GridBagHelper.Fill.HORIZONTAL, editVehicleShape});
            gb.addRow(this.d_reduceDiamOccsPol, GridBagHelper.REMAINING);
            gb.addIdentRow(squeezeLblPol, this.d_redFactorOccsPol);
            gb.finalizeRows();
            this.d_cbShapeType = new guiComboBox<ShapeTypeEnum>(ShapeTypeEnum.values());
            this.d_cbShapeType.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    ShapeTypeEnum p = (ShapeTypeEnum)((Object)value);
                    this.setText(p.name);
                    this.setToolTipText(p.tt);
                    return this;
                }
            });
            this.d_cbShapeType.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.d_cbShapeType.setToolTipText(this.d_cbShapeType.getSelectedItem().tt);
            });
            CardLayout cardLayout = new CardLayout();
            this.d_cardPanel = new guiPanel(cardLayout);
            this.d_cardPanel.add((Component)cylinderPnl, ShapeTypeEnum.CYLINDER.name);
            this.d_cardPanel.add((Component)polygonPnl, ShapeTypeEnum.POLYGON.name);
            this.d_cbShapeType.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                ShapeTypeEnum selItem = this.d_cbShapeType.getSelectedItem();
                cardLayout.show(this.d_cardPanel, selItem.name);
            });
            gb = new GridBagHelper(this);
            this.add(gb, (Component)this);
            this.loadDefaults();
        }

        public void add(GridBagHelper gb, Component parent) {
            gb.addRow(new Object[]{Intl.intl("Shape:"), this.d_cbShapeType, GridBagHelper.Fill.HORIZONTAL});
            gb.addIdentRow(this.d_cardPanel, 1.0, 5);
            this.d_parent = parent;
        }

        public void load(OccProfile.OccShape shape) {
            this.loadDefaults();
            if (shape == null) {
                return;
            }
            if (shape.shoulderWidth != null) {
                this.d_shoulderWidth.setValue(shape.shoulderWidth);
            }
            if (shape.geomShoulderWidth != null) {
                this.d_minDiamGeom.setValue(shape.geomShoulderWidth);
            }
            if (shape.height != null) {
                this.d_height.setValue(shape.height);
            }
            if (shape.minSqueezeFactor != null) {
                this.d_redFactorOccsCyl.setValue(shape.minSqueezeFactor);
                this.d_redFactorOccsPol.setValue(shape.minSqueezeFactor);
            }
            switch (shape.type) {
                case CYLINDER: {
                    this.d_cbShapeType.setSelectedItem((Object)ShapeTypeEnum.CYLINDER);
                    this.d_reduceDiamGeom.setSelected(shape.geomShoulderWidth != null);
                    this.d_reduceDiamOccsCyl.setSelected(shape.minSqueezeFactor != null);
                    break;
                }
                case POLYGON: {
                    this.d_cbShapeType.setSelectedItem((Object)ShapeTypeEnum.POLYGON);
                    this.d_cbVehicleShape.setSelectedItem(shape.vehicleShape);
                    this.d_reduceDiamOccsPol.setSelected(shape.minSqueezeFactor != null);
                }
            }
        }

        private void loadDefaults() {
            this.d_shoulderWidth.setValue((ICurve)OccProfile.PROP_DIAMETER.defVal);
            this.d_height.setValue((ICurve)OccProfile.PROP_HEIGHT.defVal);
            this.d_redFactorOccsCyl.setValue((Double)OccProfile.PROP_MIN_SQUEEZE_FACTOR_CONST.defVal);
            this.d_redFactorOccsPol.setValue((Double)OccProfile.PROP_MIN_SQUEEZE_FACTOR_CONST.defVal);
            this.d_minDiamGeom.setValue(OccProfile.PROP_GEOM_DIAMETER.defVal != null ? (UnitDouble)OccProfile.PROP_GEOM_DIAMETER.defVal : new UnitDouble(33.0, SI.CENTI(SI.METER)));
            this.d_reduceDiamOccsCyl.setSelected(OccProfile.PROP_MIN_SQUEEZE_FACTOR_CONST.defVal != null);
            this.d_reduceDiamOccsPol.setSelected(OccProfile.PROP_MIN_SQUEEZE_FACTOR_CONST.defVal != null);
            this.d_reduceDiamGeom.setSelected(OccProfile.PROP_GEOM_DIAMETER.defVal != null);
            this.d_cbVehicleShape.setSelectedIndex(0);
            this.d_cbShapeType.setSelectedItem((Object)ShapeTypeEnum.CYLINDER);
        }

        public OccProfile.OccShape save() {
            VehicleShape vehicleShape = null;
            ICurve shoulderWidth = null;
            UnitDouble minDiamGeom = null;
            ICurve height = null;
            Double minSqueezeFactor = null;
            ShapeTypeEnum selection = this.d_cbShapeType.getSelectedItem();
            boolean isSelectedCylinder = selection.equals((Object)ShapeTypeEnum.CYLINDER);
            boolean isSelectedPolygon = selection.equals((Object)ShapeTypeEnum.POLYGON);
            if (isSelectedCylinder) {
                shoulderWidth = (ICurve)this.d_shoulderWidth.getValue();
                minDiamGeom = this.d_reduceDiamGeom.isSelected() ? (UnitDouble)this.d_minDiamGeom.getValue() : null;
                height = (ICurve)this.d_height.getValue();
                minSqueezeFactor = this.d_reduceDiamOccsCyl.isSelected() ? (Double)this.d_redFactorOccsCyl.getValue() : null;
            } else if (isSelectedPolygon) {
                vehicleShape = (VehicleShape)this.d_cbVehicleShape.getSelectedItem();
                minSqueezeFactor = this.d_reduceDiamOccsPol.isSelected() ? (Double)this.d_redFactorOccsPol.getValue() : null;
            }
            return new OccProfile.OccShape(vehicleShape, shoulderWidth, minDiamGeom, height, minSqueezeFactor);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            OccProfile.OccShape shape = this.save();
            if (shape.type == VehicleShape.ShapeType.CYLINDER && shape.geomShoulderWidth != null && theUtil.ge(shape.geomShoulderWidth.get(SI.METER), shape.shoulderWidth.getMin().get(SI.METER), 0.0)) {
                if (showWarn) {
                    String msg = Intl.intl("Minimum diameter for movement through narrow geometry must be smaller than the regular diameter.");
                    JOptionPane.showMessageDialog(this.d_parent, msg, Intl.intl("Invalid Minimum Diameter"), 0);
                }
                return false;
            }
            return true;
        }
    }

    private static enum ShapeTypeEnum {
        CYLINDER(Intl.intl("Cylinder"), Intl.intl("A shape of a regular occupant.")),
        POLYGON(Intl.intl("Polygon"), Intl.intl("A shape of a vehicle occupant."));

        public final String name;
        public final String tt;

        private ShapeTypeEnum(String name, String tt) {
            this.name = name;
            this.tt = tt;
        }
    }
}

