/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.gui.SearchField;
import merlin.gui.guiUtil;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class SetChooser<T extends IMerlinObj>
extends AValEditor<Set<T>>
implements IEventObserver {
    private static final long serialVersionUID = 1L;
    public static final int OPT_SHOW_GROUPS = 1;
    public static final int OPT_SHOW_GROUPS_BY_DEFAULT = 2;
    public static final int OPT_ALLOW_ANY = 4;
    public static final int OPT_REQUIRE_NONEMPTY = 8;
    private static final int SHOW_SEL_CROSSOVER = 10;
    protected final MerlinData d_data;
    private final JEditorPane d_editor;
    protected final String d_desc;
    private final String d_emptyDesc;
    protected final Composite<? extends ICompElement> d_root;
    protected final Class<T> d_clazz;
    protected Predicate<? super T> d_filter;
    private Comparator<T> d_sorter;
    private final Map<Integer, String> d_buttonLabels = new HashMap<Integer, String>();
    protected List<T> d_availObjs;
    private int d_options;

    public SetChooser(MerlinData md, String desc, String emptyDesc, int options, Composite<? extends ICompElement> root, Class<T> clazz, Predicate<? super T> availFilter) {
        super(Set.class);
        this.d_data = md;
        this.d_desc = desc;
        this.d_emptyDesc = emptyDesc;
        this.d_options = options;
        this.d_root = root;
        this.d_clazz = clazz;
        this.d_sorter = new MerlinUtil.SortByName();
        this.d_filter = availFilter == null ? Filters.acceptAll(clazz) : availFilter;
        this.d_editor = guiUtil.newHTMLLabel();
        this.d_editor.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && this.d_editor.isEnabled()) {
                this.edit();
            }
        });
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(this.d_editor, 1.0);
        gb.finalizeRows();
        this.d_data.getEvents().addObserver(this);
        this.updateAvailable();
        this.setValue(Collections.emptySet());
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.add(this, 1.0);
    }

    public void setSorter(Comparator<T> sorter) {
        if (Objects.equals(this.d_sorter, sorter)) {
            return;
        }
        this.d_sorter = sorter;
        this.updateAvailable();
    }

    public void setButtonLabel(int button, String label) {
        if (label != null) {
            this.d_buttonLabels.put(button, label);
        } else {
            this.d_buttonLabels.remove(button);
        }
    }

    public String getButtonLabel(int button) {
        return this.d_buttonLabels.get(button);
    }

    public boolean edit() {
        Window parent = guiUtil.getWindow(this);
        this.updateAvailable();
        boolean showSelDef = this.d_availObjs.size() > 10 && this.getValue() != null && !((Set)this.getValue()).isEmpty();
        ObjDlg<T> dlg = new ObjDlg<T>(parent, this.d_desc, this.d_root, this.d_options, showSelDef);
        this.applyButtonLabels(dlg);
        dlg.setAvailObjs(this.d_availObjs);
        dlg.setObjs((Set)this.getValue());
        if (dlg.doModal() != 1) {
            this.firePropertyChange("edit", true, false);
            return false;
        }
        this.setValue(dlg.getObjs(this.d_clazz));
        this.firePropertyChange("edit", false, true);
        return true;
    }

    protected void applyButtonLabels(guiDialog dlg) {
        this.d_buttonLabels.forEach((i, lbl) -> dlg.getButton((int)i).setText((String)lbl));
    }

    @Override
    public void update(Events events) {
        if (events.isAffected(this.d_clazz)) {
            this.updateAvailable();
        }
    }

    protected void updateAvailable() {
        this.d_availObjs = this.getAllAvailableObjs();
        LinkedIdentityHashSet objs = (LinkedIdentityHashSet)this.getValue();
        if (objs != null && !objs.isEmpty()) {
            objs = new LinkedIdentityHashSet(objs);
            objs.retainAll(this.d_availObjs);
            this.setValue(objs);
        }
        this.updateDesc();
    }

    protected List<T> getAllAvailableObjs() {
        ArrayList<IMerlinObj> all = new ArrayList<IMerlinObj>();
        for (IMerlinObj obj : this.d_root.getDeepMembers(this.d_clazz)) {
            if (!this.d_filter.test(obj)) continue;
            all.add(obj);
        }
        Collections.sort(all, this.d_sorter != null ? this.d_sorter : MerlinUtil.getSorter(this.d_data, all));
        return all;
    }

    public void setFilter(Predicate<? super T> filter) {
        if (Objects.equals(this.d_filter, filter)) {
            return;
        }
        this.d_filter = filter;
        this.updateAvailable();
    }

    public Predicate<? super T> getFilter() {
        return this.d_filter;
    }

    public void setAnyAllowed(boolean anyAllowed) {
        this.d_options = anyAllowed ? (this.d_options |= 4) : (this.d_options &= 0xFFFFFFFB);
        this.updateDesc();
    }

    public void setObjs(Set<T> objs) {
        this.setValue(objs);
        this.setModified(false);
    }

    @Override
    protected void loadValue(Set<T> value) {
        this.updateDesc();
    }

    @Override
    protected Set<T> saveValue() {
        return (Set)this.getValue();
    }

    public void setUnselectedObjs(Set<T> objs) {
        this.setValue(this.invert(objs));
    }

    public Set<T> getObjs() {
        return (Set)this.getValue();
    }

    public Set<T> getUnselectedObjs() {
        return this.invert((Set)this.getValue());
    }

    private Set<T> invert(Set<T> objs) {
        if (objs == null) {
            return null;
        }
        return this.d_availObjs.stream().filter(Filters.reject(objs)).collect(Collectors.toCollection(() -> new LinkedIdentityHashSet()));
    }

    protected boolean getOption(int option) {
        return (this.d_options & option) == option;
    }

    protected void updateDesc() {
        boolean isShortened;
        Object desc = null;
        Set val = (Set)this.getValue();
        if (val == null) {
            desc = Intl.intl("[mixed]");
        } else if (val.isEmpty()) {
            String emptyDesc = this.getOption(4) ? Intl.intl("any") : this.d_emptyDesc;
            desc = "[" + emptyDesc + "]";
        } else {
            ArrayList objs = new ArrayList(val);
            Collections.sort(objs, ObjSorter.INSTANCE);
            desc = "";
            for (IMerlinObj obj : objs) {
                if (!((String)desc).isEmpty()) {
                    desc = (String)desc + "; ";
                }
                desc = (String)desc + MerlinUtil.getName(obj);
            }
        }
        FontMetrics fm = this.d_editor.getFontMetrics(this.d_editor.getFont());
        Object displayDesc = guiUtil.shorten((String)desc, 100, fm);
        boolean bl = isShortened = !((String)displayDesc).equals(desc);
        if (!this.d_availObjs.isEmpty()) {
            displayDesc = "<html><a href=\"blank\">" + (String)displayDesc + "</a></html>";
        }
        this.d_editor.setText((String)displayDesc);
        if (isShortened) {
            this.d_editor.setToolTipText((String)desc);
        } else {
            this.d_editor.setToolTipText(null);
        }
    }

    public Class getObjClass() {
        return this.d_clazz;
    }

    private static class ObjDlg<T extends IMerlinObj>
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private final SearchField<T> d_filter;
        private final guiRadioButton d_anyBtn;
        private final guiRadioButton d_chooseBtn;
        private final guiTable d_table;
        private final BooleanRenderer d_enabledRend;
        private final Composite<? extends ICompElement> d_root;
        private final JButton d_clearSelBtn;
        private final guiLabel d_countLbl;
        private final Semaphore d_lock;
        private final guiCheckBox d_showOnlySelected;
        private final guiCheckBox d_showPathBox;
        private final HTMLBtn d_showingCountLbl;
        private int d_options;
        private List<T> d_availObjs = Collections.emptyList();

        public ObjDlg(Window parent, String desc, Composite<? extends ICompElement> root, int options, boolean showSelDef) {
            super(parent, desc, 9);
            this.d_options = options;
            this.d_root = root;
            this.d_filter = new SearchField<IMerlinObj>(() -> this.d_availObjs.stream(), obj -> this.format(obj));
            this.d_anyBtn = new guiRadioButton(Intl.intl("Any"));
            this.d_chooseBtn = new guiRadioButton(Intl.intl("Choose"));
            this.d_showOnlySelected = new guiCheckBox(Intl.intl("Display only selected rows"));
            this.d_showOnlySelected.setToolTipText(Intl.intl("If checked, only selected rows are displayed in the list. Uncheck to display all available rows."));
            this.d_showingCountLbl = new HTMLBtn("");
            this.d_showingCountLbl.addActionListener(e -> {
                this.d_filter.clear();
                this.d_showOnlySelected.setSelected(false);
                this.updateTable();
            });
            this.d_clearSelBtn = new JButton(Intl.intl("Clear"));
            this.d_clearSelBtn.setToolTipText(Intl.intl("Clears the entire selection, including hidden rows."));
            this.d_clearSelBtn.addActionListener(e -> this.getModel().setSelObjs(Collections.emptySet()));
            if (showSelDef) {
                this.d_showOnlySelected.setSelected(true);
            }
            this.d_showOnlySelected.addActionListener(e -> {
                if (this.d_showOnlySelected.isSelected() && !this.d_filter.isEmpty()) {
                    this.d_filter.clear();
                } else {
                    this.updateTable();
                }
            });
            this.d_filter.addObserver((fld, evt) -> {
                if (evt == SearchField.SHOW_ALL_MATCHES) {
                    this.d_showOnlySelected.setSelected(false);
                }
                this.updateTable();
            }, false);
            this.d_showPathBox = new guiCheckBox(Intl.intl("Show group labels"), (this.d_options & 2) != 0);
            this.d_showPathBox.setToolTipText(Intl.intl("If checked, group labels are shown with the names of the objects."));
            this.d_lock = new Semaphore(1);
            this.d_countLbl = new guiLabel("test");
            this.d_countLbl.setFont(this.d_countLbl.getFont().deriveFont(1));
            guiButtonGroup btnGroup = new guiButtonGroup(this.d_anyBtn, this.d_chooseBtn);
            if ((this.d_options & 4) == 0) {
                this.d_anyBtn.setVisible(false);
                this.d_chooseBtn.setVisible(false);
                this.d_chooseBtn.setSelected(true);
            } else {
                this.d_anyBtn.setVisible(true);
                this.d_chooseBtn.setVisible(true);
                this.d_chooseBtn.setSelected(false);
            }
            ObjTableModel tm = new ObjTableModel();
            this.d_table = new guiTable(tm, 0);
            this.d_table.setRowSelectionAllowed(true);
            this.d_table.setColumnSelectionAllowed(false);
            this.d_table.setShowVerticalLines(false);
            this.d_enabledRend = new BooleanRenderer();
            TableColumn enabledCol = this.d_table.getColumnModel().getColumn(0);
            enabledCol.setHeaderValue(Boolean.FALSE);
            enabledCol.setHeaderRenderer(this.d_enabledRend);
            enabledCol.setCellRenderer(this.d_table.getDefaultRenderer(Boolean.class));
            enabledCol.setCellEditor(this.d_table.getDefaultEditor(Boolean.class));
            TableColumn objCol = this.d_table.getColumnModel().getColumn(1);
            objCol.setHeaderValue(desc);
            MouseAdapter selColList = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int col;
                    if (SwingUtilities.isLeftMouseButton(e) && (col = d_table.columnAtPoint(e.getPoint())) == 1) {
                        int row = d_table.rowAtPoint(e.getPoint());
                        Boolean val = (Boolean)d_table.getValueAt(row, 0);
                        val = val != null ? !val.booleanValue() : true;
                        d_table.setValueAt(val, row, 0);
                    }
                }
            };
            this.d_table.addMouseListener(selColList);
            objCol.setCellRenderer(new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.setText(this.format((IMerlinObj)value));
                    return comp;
                }
            });
            this.d_enabledRend.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!d_lock.tryAcquire()) {
                        return;
                    }
                    IListenerStripper listeners = this.stripModelListeners(d_table);
                    LinkedIdentityHashSet allSel = new LinkedIdentityHashSet(this.getModel().getSelObjs());
                    List shownObjs = this.getModel().getAvailObjs();
                    if (d_enabledRend.isSelected()) {
                        allSel.addAll(shownObjs);
                    } else {
                        allSel.removeAll(shownObjs);
                    }
                    this.getModel().setSelObjs(allSel);
                    d_lock.release();
                    listeners.restore();
                    this.handleTableChanged();
                }
            });
            this.d_table.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    this.handleTableChanged();
                }
            });
            this.d_showPathBox.addItemListener(e -> {
                if (this.d_filter.isEmpty()) {
                    this.d_table.repaint();
                } else {
                    this.updateTable();
                }
            });
            LinkStatus.link((AbstractButton)this.d_chooseBtn, this.d_table, this.d_countLbl, this.d_showPathBox, this.d_showOnlySelected, this.d_filter, this.d_showingCountLbl);
            ItemListener btnListener = e -> {
                if (e.getStateChange() == 1) {
                    this.handleTableChanged();
                }
            };
            btnGroup.stream().forEach(btn -> btn.addItemListener(btnListener));
            JScrollPane sp = new JScrollPane(this.d_table);
            if (this.d_showPathBox.isSelected()) {
                sp.setPreferredSize(new Dimension(300, 150));
            } else {
                sp.setPreferredSize(new Dimension(200, 120));
            }
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.addRow(this.d_anyBtn);
            gb.addRow(this.d_chooseBtn);
            gb.indent();
            gb.addFilledRow(this.d_filter);
            gb.addRow(sp, new double[]{1.0, 1.0});
            guiPanel gbpnl = new guiPanel();
            GridBagHelper gbcount = new GridBagHelper(gbpnl);
            gbcount.addRow(this.d_countLbl, this.d_clearSelBtn);
            gb.addRow(new Object[]{gbpnl, GridBagHelper.Anchor.CENTER, 0});
            gb.addFilledRow(this.d_showingCountLbl);
            gb.addRow(this.d_showOnlySelected);
            if ((this.d_options & 1) != 0) {
                gb.addRow(this.d_showPathBox);
            }
            enabledCol.sizeWidthToFit();
            this.setResizable(true);
        }

        private void handleTableChanged() {
            int count = this.getModel().getEnabledCount();
            String text = count == 1 ? Intl.intl("1 row selected") : String.format(Intl.intl("%d rows selected"), count);
            this.d_countLbl.setText(text);
            if (this.getModel().getAvailObjs().size() < this.d_availObjs.size()) {
                this.d_showingCountLbl.setText(String.format(Intl.intl("Displaying %1$d/%2$d rows"), this.getModel().getAvailObjs().size(), this.d_availObjs.size()));
                this.d_showingCountLbl.setVisible(true);
                this.d_showingCountLbl.setToolTipText(Intl.intl("Click to display all rows"));
            } else {
                this.d_showingCountLbl.setVisible(false);
            }
            this.d_clearSelBtn.setEnabled(this.d_chooseBtn.isSelected() && !this.getModel().getSelObjs().isEmpty());
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            boolean allEnabled = this.getModel().areAllEnabled();
            this.d_enabledRend.setSelected(allEnabled);
            this.d_table.getTableHeader().repaint();
            this.d_table.repaint();
            this.d_lock.release();
        }

        private String format(T mobj) {
            if (this.d_showPathBox.isSelected()) {
                return MerlinUtil.getNameWithBreadcrumbs(this.d_root, mobj);
            }
            return MerlinUtil.getName(mobj);
        }

        private IListenerStripper stripModelListeners(JTable table) {
            ObjTableModel<T> model = this.getModel();
            return guiUtil.stripListeners(model::addTableModelListener, model::getTableModelListeners, model::removeTableModelListener);
        }

        public void setAvailObjs(List<T> availObjs) {
            this.d_availObjs = availObjs;
            this.updateTable();
        }

        public void setObjs(Set<T> objs) {
            boolean anyAllowed;
            this.updateTable(objs);
            boolean bl = anyAllowed = (this.d_options & 4) != 0;
            if (objs == null) {
                this.d_anyBtn.setSelected(false);
                this.d_chooseBtn.setSelected(false);
            } else if (objs.isEmpty() && anyAllowed) {
                this.d_anyBtn.setSelected(true);
            } else {
                this.d_chooseBtn.setSelected(true);
            }
        }

        private void updateTable() {
            Set<T> objs = this.getModel().getSelObjs();
            this.updateTable(objs);
        }

        private void updateTable(Set<T> objs) {
            Predicate filter = this.d_showOnlySelected.isSelected() && objs != null ? Filters.accept(objs) : Predicates.alwaysTrue();
            filter = Predicates.and(filter, this.d_filter.getFilter());
            IFilteredCollection<T> availObjs = theUtil.filter(this.d_availObjs, filter);
            ObjTableModel<T> model = this.getModel();
            model.setAvailObjs(new ArrayList<T>(availObjs), objs != null ? objs : Collections.emptySet());
            this.handleTableChanged();
        }

        public <T2> Set<T2> getObjs(Class<T2> clazz) {
            if (this.d_anyBtn.isSelected()) {
                return Collections.EMPTY_SET;
            }
            if (this.d_chooseBtn.isSelected()) {
                return new LinkedIdentityHashSet<T2>(theUtil.filter(this.getModel().getSelObjs(), clazz));
            }
            return null;
        }

        private ObjTableModel<T> getModel() {
            return (ObjTableModel)this.d_table.getModel();
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if ((this.d_options & 8) != 0 && this.getModel().getSelObjs().isEmpty()) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(this, Intl.intl("At least one object must be selected."), Intl.intl("Invalid Selection"), 0);
                }
                return false;
            }
            if (showWarn && this.d_chooseBtn.isSelected() && this.getModel().getAvailObjs().size() != this.d_availObjs.size()) {
                IdentityHashSet listedObjs = new IdentityHashSet(this.getModel().getAvailObjs());
                if (this.getModel().getSelObjs().stream().anyMatch(o -> !listedObjs.contains(o))) {
                    int option = JOptionPane.showConfirmDialog(this, Intl.intl("Some selected rows are not displayed in the list. Do you want to continue anyway?\nClick No to cancel and see the entire selection for review."), Intl.intl("Hidden Selected Rows"), 1);
                    if (option == 1) {
                        if (allowModify) {
                            this.d_filter.clear();
                            this.d_showOnlySelected.setSelected(true);
                            this.updateTable();
                        }
                        return false;
                    }
                    if (option != 0) {
                        return false;
                    }
                }
            }
            return true;
        }

        private static class ObjTableModel<T>
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;
            private List<T> d_availObjs;
            private Set<T> d_selObjs;

            public ObjTableModel() {
                this(Collections.emptyList(), Collections.emptySet());
            }

            public ObjTableModel(List<T> availObjs, Collection<T> initSelObjs) {
                this.d_availObjs = availObjs;
                this.d_selObjs = new LinkedIdentityHashSet<T>(initSelObjs);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return Object.class;
                    }
                }
                return super.getColumnClass(columnIndex);
            }

            public void setAvailObjs(List<T> objs, Collection<T> selObjs) {
                this.d_availObjs = objs;
                if (selObjs != this.d_selObjs) {
                    this.d_selObjs = new LinkedIdentityHashSet<T>(selObjs);
                }
                this.fireTableDataChanged();
            }

            public List<T> getAvailObjs() {
                return Collections.unmodifiableList(this.d_availObjs);
            }

            public Set<T> getSelObjs() {
                return Collections.unmodifiableSet(this.d_selObjs);
            }

            public void setSelObjs(Collection<T> selObjs) {
                this.d_selObjs = new LinkedIdentityHashSet<T>(selObjs);
                if (!this.d_availObjs.isEmpty()) {
                    this.fireTableRowsUpdated(0, this.d_availObjs.size() - 1);
                }
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }

            @Override
            public int getRowCount() {
                return this.d_availObjs.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return this.d_selObjs.contains(this.d_availObjs.get(rowIndex));
                    }
                    case 1: {
                        return this.d_availObjs.get(rowIndex);
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        Boolean bval = (Boolean)aValue;
                        if (bval != null && bval.booleanValue()) {
                            this.d_selObjs.add(this.d_availObjs.get(rowIndex));
                        } else {
                            this.d_selObjs.remove(this.d_availObjs.get(rowIndex));
                        }
                        this.fireTableCellUpdated(rowIndex, columnIndex);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }

            public boolean areAllEnabled() {
                return !this.d_availObjs.isEmpty() && this.d_availObjs.stream().allMatch(o -> this.d_selObjs.contains(o));
            }

            public int getEnabledCount() {
                return this.d_selObjs.size();
            }
        }
    }

    protected static class ObjSorter<T extends IMerlinObj>
    implements Comparator<T> {
        public static final ObjSorter<IMerlinObj> INSTANCE = new ObjSorter();

        protected ObjSorter() {
        }

        @Override
        public int compare(T o1, T o2) {
            return MerlinUtil.getName(o1).compareToIgnoreCase(MerlinUtil.getName(o2));
        }
    }

    private static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    MouseListener {
        private static final long serialVersionUID = 1L;

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table != null) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    header.removeMouseListener(this);
                    header.addMouseListener(this);
                }
                this.setEnabled(table.isEnabled());
            }
            return this;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.doClick(0);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

