/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.gui.ScrollingConsole;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiField;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class RunSimDlg
extends guiDialog {
    private static final long serialVersionUID = 8942847620837494893L;
    public static final String PREF_SHOW_RESULTS = "RunSimDlg_show_results";
    public static final String PREF_PAUSE_IF_STUCK = "RunSimDlg_pause_if_stuck";
    public static final int SIM_PRE = 0;
    public static final int SIM_RUNNING = 1;
    public static final int SIM_PAUSED = 2;
    public static final int SIM_COMPLETE = 3;
    private static final String STR_PAUSE = Intl.intl(" Pause ");
    private static final String STR_RESUME = Intl.intl("Resume");
    private static final String STR_OK = Intl.intl("OK");
    private static final String STR_CANCEL = Intl.intl("Cancel");
    private static final String STR_RESULTS = Intl.intl("Results");
    private static final String STR_LOG = Intl.intl("Save Log...");
    private static final String STR_SHOW_VIS = Intl.intl("Debug");
    private static final DecimalFormat FMT_DBL = new DecimalFormat("#######0.0");
    private JButton d_btOK;
    private JButton d_btPause;
    private JButton d_btResults;
    private JButton d_btSaveLog;
    private JButton d_btShowVis;
    private guiLabel d_labSimTime;
    private guiLabel d_labRunTime;
    private guiLabel d_labOccsRem;
    private guiLabel d_labOccsTotal;
    private guiLabel d_labDTGMax;
    private guiLabel d_labDTGAvg;
    private guiField d_fldSimTime;
    private guiField d_fldRunTime;
    private guiField d_fldOccsRem;
    private guiField d_fldOccsTotal;
    private guiField d_fldDTGMax;
    private guiField d_fldDTGAvg;
    private guiCheckBox d_ckShowResults;
    private guiCheckBox d_ckPauseIfStuck;
    private guiLabel d_stuckLbl;
    private Timer d_runTime;
    private ScrollingConsole d_log;
    private List<DlgListener> d_listeners;
    private boolean d_canceled;
    private int d_state = -1;
    private boolean d_lastStuckStatus = false;

    public RunSimDlg(JFrame parent) {
        super((Window)parent, Intl.intl("Run Simulation"), 1);
        this.setResizable(true);
        this.d_canceled = false;
        this.d_btOK = this.getButton(1);
        this.d_btOK.setText(STR_OK);
        this.d_btPause = new JButton(STR_PAUSE);
        this.d_btResults = new JButton(STR_RESULTS);
        this.d_btSaveLog = new JButton(STR_LOG);
        this.d_btShowVis = new JButton(STR_SHOW_VIS);
        JComponent[] buttons = new JButton[]{this.d_btShowVis, this.d_btResults, this.d_btPause, this.d_btOK};
        this.setButtons(buttons);
        this.d_log = new ScrollingConsole();
        this.d_log.setPreferredSize(new Dimension(450, 150));
        this.getDialogPane().setLayout(new BorderLayout());
        this.getDialogPane().add((Component)this.getFieldPanel(), "North");
        this.getDialogPane().add((Component)this.d_log, "Center");
        this.getDialogPane().add((Component)this.getLowerPanel(), "South");
        this.d_listeners = new Vector<DlgListener>();
        this.connectToEvent(this.d_btOK, new EventOK());
        this.connectToEvent(this.d_btSaveLog, new EventLog());
        this.connectToEvent(this.d_btResults, new EventResults());
        this.connectToEvent(this.d_btShowVis, new ShowVisAction());
        this.d_btPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunSimDlg.this.d_btPause.setEnabled(false);
                if (RunSimDlg.this.d_btPause.getText().equals(STR_PAUSE)) {
                    RunSimDlg.this.fireEvent(new EventPause());
                } else if (RunSimDlg.this.d_btPause.getText().equals(STR_RESUME)) {
                    RunSimDlg.this.fireEvent(new EventResume());
                } else assert (false);
            }
        });
        final WallClockTimerListener wctl = new WallClockTimerListener();
        this.d_runTime = new Timer(100, wctl){
            private static final long serialVersionUID = -8329484171124712280L;

            @Override
            public void start() {
                super.start();
                wctl.start();
            }

            @Override
            public void stop() {
                super.stop();
                wctl.stop();
            }
        };
        this.d_runTime.setInitialDelay(1000);
        this.setSimTime(0.0);
        this.setRunTime(0.0);
        this.setOccsRem(0);
        this.setOccsTotal(0);
        this.setDTGMax(0.0);
        this.setDTGAvg(0.0);
    }

    public void setTitleFromPath(String pthFilePath) {
        this.setTitle(String.format(Intl.intl("Run Simulation - %s"), RunSimDlg.getName(pthFilePath)));
    }

    private static String getName(String filename) {
        return new File(filename).getName();
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.isVisible() && !this.okCancel()) {
            return;
        }
        super.setVisible(visible);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean okCancel() {
        if (this.d_btOK.getText().equals(STR_OK)) {
            this.fireEvent(new EventOK());
            return true;
        } else if (this.d_btOK.getText().equals(STR_CANCEL)) {
            String msg = Intl.intl("Save simulation progress (enables resume)?");
            int choice = JOptionPane.showConfirmDialog(this, msg, Intl.intl("Cancel"), 1);
            if (choice == 1) {
                this.fireEvent(new EventCancel());
                this.d_canceled = true;
                this.d_runTime.stop();
                return true;
            } else {
                if (choice != 0) return false;
                this.fireEvent(new EventStop());
                this.d_runTime.stop();
            }
            return true;
        } else {
            assert (false);
            return true;
        }
    }

    private void connectToEvent(JButton bt, final EventOp op) {
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunSimDlg.this.fireEvent(op);
            }
        });
    }

    public void writeLogText(PrintStream ps) {
        this.d_log.writeText(ps);
    }

    private guiPanel getFieldPanel() {
        guiPanel fields = new guiPanel(new GridBagLayout());
        this.d_labSimTime = new guiLabel(Intl.intl("Sim Time (s):"));
        this.d_labRunTime = new guiLabel(Intl.intl("Run Time (s):"));
        this.d_labOccsRem = new guiLabel(Intl.intl("Occs Rem:"));
        this.d_labOccsTotal = new guiLabel(Intl.intl("Occs Total:"));
        this.d_labDTGMax = new guiLabel(Intl.intl("DTG Max (m):"));
        this.d_labDTGAvg = new guiLabel(Intl.intl("DTG Avg (m):"));
        this.d_fldSimTime = new guiTextField();
        this.d_fldRunTime = new guiTextField();
        this.d_fldOccsRem = new guiIntField();
        this.d_fldOccsTotal = new guiIntField();
        this.d_fldDTGMax = new guiTextField();
        this.d_fldDTGAvg = new guiTextField();
        this.fixField(this.d_fldSimTime);
        this.fixField(this.d_fldRunTime);
        this.fixField(this.d_fldOccsRem);
        this.fixField(this.d_fldOccsTotal);
        this.fixField(this.d_fldDTGMax);
        this.fixField(this.d_fldDTGAvg);
        GridBagUtil.add(fields, this.d_labSimTime, 0, 0, 1, 1, 0, 0, 12, 12);
        GridBagUtil.add(fields, this.d_fldSimTime, 1, 0, 1, 1, 0, 0, 12, 24);
        GridBagUtil.add(fields, this.d_labRunTime, 2, 0, 1, 1, 0, 0, 12, 12);
        GridBagUtil.add(fields, this.d_fldRunTime, 3, 0, 1, 1, 0, 0, 12, 0);
        GridBagUtil.add(fields, this.d_labOccsRem, 0, 1, 1, 1, 0, 0, 12, 12);
        GridBagUtil.add(fields, this.d_fldOccsRem, 1, 1, 1, 1, 0, 0, 12, 24);
        GridBagUtil.add(fields, this.d_labOccsTotal, 2, 1, 1, 1, 0, 0, 12, 12);
        GridBagUtil.add(fields, this.d_fldOccsTotal, 3, 1, 1, 1, 0, 0, 12, 0);
        GridBagUtil.add(fields, this.d_labDTGMax, 0, 2, 1, 1, 0, 0, 12, 12);
        GridBagUtil.add(fields, this.d_fldDTGMax, 1, 2, 1, 1, 0, 0, 12, 24);
        GridBagUtil.add(fields, this.d_labDTGAvg, 2, 2, 1, 1, 0, 0, 12, 12);
        GridBagUtil.add(fields, this.d_fldDTGAvg, 3, 2, 1, 1, 0, 0, 12, 0);
        GridBagUtil.addGlue(fields);
        return fields;
    }

    public guiPanel getLowerPanel() {
        guiPanel panel = new guiPanel(new GridBagLayout());
        this.d_ckShowResults = new guiCheckBox(Intl.intl("Show results when finished"));
        RunSimDlg.bindToPref(this.d_ckShowResults, PREF_SHOW_RESULTS, true);
        this.d_ckPauseIfStuck = new guiCheckBox(Intl.intl("Pause if occupants appear to be stuck"));
        this.d_ckPauseIfStuck.setSelected(true);
        this.d_stuckLbl = new guiLabel(Intl.intl("Warning: Occupants appear to be stuck."));
        this.d_stuckLbl.setForeground(Color.RED);
        GridBagUtil.add(panel, this.d_ckShowResults, 0, 0, 4, 1, 12, 0, 0, 0);
        GridBagUtil.add(panel, this.d_ckPauseIfStuck, 0, 1, 4, 1, 6, 0, 0, 0);
        GridBagUtil.add(panel, this.d_stuckLbl, 0, 2, 4, 1, 6, 0, 0, 0);
        GridBagUtil.addGlue(panel);
        panel.setPreferredSize(panel.getPreferredSize());
        this.d_stuckLbl.setVisible(false);
        return panel;
    }

    public static void bindToPref(final JToggleButton bt, final String prefKey, boolean def) {
        if (Application.getApp() == null) {
            bt.setSelected(def);
            return;
        }
        String strPref = Application.getApp().getPreference(prefKey);
        boolean initState = strPref == null ? def : Boolean.parseBoolean(strPref);
        Application.getApp().setPreference(prefKey, Boolean.toString(initState));
        bt.setSelected(initState);
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Application.getApp().setPreference(prefKey, Boolean.toString(bt.isSelected()));
            }
        });
    }

    public boolean isCanceled() {
        return this.d_canceled;
    }

    public void setCancelled(boolean cancel) {
        this.d_canceled = cancel;
    }

    public boolean getResultsOnFinish() {
        return this.d_ckShowResults.isSelected();
    }

    public void setState(int state) {
        if (state == this.d_state) {
            return;
        }
        this.d_state = state;
        switch (state) {
            case 0: {
                this.d_btResults.setEnabled(false);
                this.d_btPause.setText(STR_PAUSE);
                this.d_btPause.setEnabled(false);
                this.d_btOK.setText(STR_CANCEL);
                this.d_runTime.stop();
                break;
            }
            case 1: {
                this.d_btResults.setEnabled(true);
                this.d_btPause.setText(STR_PAUSE);
                this.d_btPause.setEnabled(true);
                this.d_btOK.setText(STR_CANCEL);
                this.d_runTime.start();
                break;
            }
            case 2: {
                this.d_btResults.setEnabled(true);
                this.d_btPause.setText(STR_RESUME);
                this.d_btPause.setEnabled(true);
                this.d_btOK.setText(STR_CANCEL);
                this.d_runTime.stop();
                break;
            }
            case 3: {
                this.d_btResults.setEnabled(true);
                this.d_btPause.setText(STR_PAUSE);
                this.d_btPause.setEnabled(false);
                this.d_btShowVis.setEnabled(false);
                this.d_btOK.setText(STR_OK);
                this.d_runTime.stop();
            }
        }
    }

    private void fixField(guiField gf) {
        gf.setEditable(false);
        gf.setHorizontalAlignment(4);
        gf.setFocusable(false);
    }

    public void printToLog(String str) {
        this.d_log.addLine(str);
    }

    public Handler createLogHandler() {
        return new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (record.getLevel().intValue() < this.getLevel().intValue()) {
                    return;
                }
                AttributeSet style = record.getLevel().intValue() >= Level.WARNING.intValue() ? ScrollingConsole.STYLE_WARN : ScrollingConsole.STYLE_DEFAULT;
                RunSimDlg.this.d_log.addLine(style, record.getMessage());
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
    }

    public void setSimTime(double val) {
        this.d_fldSimTime.setText(FMT_DBL.format(val));
    }

    public void setStuckStatus(boolean stuck) {
        this.d_stuckLbl.setVisible(stuck);
        if (!this.d_lastStuckStatus && stuck && this.d_ckPauseIfStuck.isSelected()) {
            this.fireEvent(new EventPause());
            JOptionPane.showMessageDialog(MerlinApp.getApp().getMainFrame(), Intl.intl("The occupants appear to be stuck. Simulation paused.\n\nPlease help us prevent this problem in the future by\ncontacting support@thunderheadeng.com and explaining\nthe situation prior to this error or sharing your model."), Intl.intl("Simulation Stuck"), 2);
        }
        this.d_lastStuckStatus = stuck;
    }

    public void setRunTime(double val) {
        this.d_fldRunTime.setText(FMT_DBL.format(val));
    }

    public void setOccsRem(int val) {
        this.d_fldOccsRem.setText(Integer.toString(val));
    }

    public void setOccsTotal(int val) {
        this.d_fldOccsTotal.setText(Integer.toString(val));
    }

    public void setDTGMax(double val) {
        this.d_fldDTGMax.setText(FMT_DBL.format(val));
    }

    public void setDTGAvg(double val) {
        this.d_fldDTGAvg.setText(FMT_DBL.format(val));
    }

    public void setDTGMin(double val) {
    }

    private void fireEvent(EventOp op) {
        for (DlgListener dl : this.d_listeners) {
            op.fire(dl);
        }
    }

    public void deleteListener(DlgListener listener) {
        this.d_listeners.remove(listener);
    }

    public void addListener(DlgListener listener) {
        this.d_listeners.add(listener);
    }

    private class EventOK
    implements EventOp {
        private EventOK() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionOK(RunSimDlg.this);
        }
    }

    private static interface EventOp {
        public void fire(DlgListener var1);
    }

    private class EventLog
    implements EventOp {
        private EventLog() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionLog(RunSimDlg.this);
        }
    }

    private class EventResults
    implements EventOp {
        private EventResults() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionResults(RunSimDlg.this);
        }
    }

    private class ShowVisAction
    implements EventOp {
        private ShowVisAction() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionShowVis(RunSimDlg.this);
        }
    }

    private class WallClockTimerListener
    implements ActionListener {
        private long totalTime = 0L;
        private long lastStart = System.currentTimeMillis();

        private WallClockTimerListener() {
        }

        public void start() {
            this.lastStart = System.currentTimeMillis();
        }

        public void stop() {
            this.totalTime += System.currentTimeMillis() - this.lastStart;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            long t = System.currentTimeMillis() - this.lastStart + this.totalTime;
            double runTime = (double)t / 1000.0;
            RunSimDlg.this.setRunTime(runTime);
        }
    }

    private class EventCancel
    implements EventOp {
        private EventCancel() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionCancel(RunSimDlg.this);
        }
    }

    private class EventStop
    implements EventOp {
        private EventStop() {
        }

        @Override
        public void fire(DlgListener listener) {
            listener.actionStop(RunSimDlg.this);
        }
    }

    private class EventPause
    implements EventOp {
        private EventPause() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionPause(RunSimDlg.this);
        }
    }

    public static interface DlgListener {
        public void actionOK(RunSimDlg var1);

        public void actionCancel(RunSimDlg var1);

        public void actionStop(RunSimDlg var1);

        public void actionPause(RunSimDlg var1);

        public void actionResume(RunSimDlg var1);

        public void actionResults(RunSimDlg var1);

        public void actionLog(RunSimDlg var1);

        public void actionShowVis(RunSimDlg var1);

        public void changeState(RunSimDlg var1, int var2);
    }

    private class EventState
    implements EventOp {
        int d_newState;

        public EventState(int newState) {
            this.d_newState = newState;
        }

        @Override
        public void fire(DlgListener dl) {
            dl.changeState(RunSimDlg.this, this.d_newState);
        }
    }

    private class EventResume
    implements EventOp {
        private EventResume() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionResume(RunSimDlg.this);
        }
    }
}

