/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import inferno.sim.output.DoorUsageWriter;
import inferno.sim.output.LegacyCsvHeaders;
import inferno.sim.output.MeasurementRegionWriter;
import inferno.sim.output.RoomUsageWriter;
import inferno.sim.output.WriterIntl;
import java.awt.Color;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntToDoubleFunction;
import java.util.function.Supplier;
import java.util.function.ToDoubleBiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.InfernoUtil;
import merlin.actions.UIHook;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.gui.guiUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.CkBoxListPanel;
import thunderheadeng.gui.Graph;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ISeries;
import thunderheadeng.gui.LWSeries;
import thunderheadeng.gui.MenuBuilder;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiFrame;
import thunderheadeng.gui.guiInputDlg;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.CSVLineParser;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.ImageTransferrable;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.filters.EQBiquadFilter;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class Plot2dDlg
extends guiFrame
implements Observer {
    private static final long serialVersionUID = 2061555054401005077L;
    private static final double SAMPLE_FREQ_FACTOR = 2.0;
    private static final double Q = 0.5;
    private Graph d_graph;
    private CkBoxListPanel d_list;
    private final Function<File, Optional<Charset>> d_charsetMap;
    private String d_dataFile;
    private List<List<String>> d_rawHeaders;
    private List<List<String>> d_translatedHeaders;
    private List<double[]> d_rawData;
    private int d_timeSeries = 0;
    private List<LWSeries> d_transformedData;
    private boolean d_autoRange;
    private IFilterType d_filter;
    private int d_smoothSteps;
    private IMode d_lastMode;
    private final FlowRateMode d_flowrateMode;
    private final SpecificFlowMode d_specificFlowMode;
    private final CountMode d_countMode;
    private final VelocityMode d_velocityMode;
    private final DensityMode d_densityMode;
    private final DenVsVelMode d_denVsvelMode;
    private final AgentMode d_agentMode;
    private JRadioButtonMenuItem d_rbmiUsage;
    private JRadioButtonMenuItem d_rbmiCumulative;
    private JRadioButtonMenuItem d_rbmiFlowRate;
    private JRadioButtonMenuItem d_rbmiSpFlow;
    private JRadioButtonMenuItem d_rbmiVelocityRate;
    private JRadioButtonMenuItem d_rbmiDensityRate;
    private JRadioButtonMenuItem d_rbmiDenVsvelRate;
    private JRadioButtonMenuItem d_rbmiAgentCount;
    private BooleanAction d_unfiltered;
    private BooleanAction d_lpFilter;
    private BooleanAction d_movingAvgFilter;
    private BooleanAction d_showDoorDirDataAction;
    private boolean d_showDoorDirData = false;
    private AnnotateObjPathsAction d_annotateObjPathsAction;
    private boolean d_annotateObjPaths = false;
    private boolean d_containsPathsAnnotations = false;
    private static final String ANNOTATION_MARK = "->";
    private static final Color[] SERIES_COLORS = new Color[]{new Color(0, 176, 80), new Color(112, 48, 160), new Color(192, 0, 0), new Color(255, 192, 0), new Color(1, 176, 240), new Color(146, 208, 80), new Color(0, 112, 192), new Color(0, 32, 96)};
    private static final int[] SERIES_LINESTYLES = new int[]{0, 1, 2, 3, 4};
    private static final int[] SERIES_MARKSTYLES = new int[]{6, 7, 8, 9, 10, 11, 12, 13};

    public Plot2dDlg(Function<File, Optional<Charset>> charsetMap) {
        super(Intl.intl("Time History Data"));
        this.d_charsetMap = charsetMap;
        this.d_list = new CkBoxListPanel();
        this.d_list.addObserver(this);
        this.d_graph = new Graph();
        this.d_graph.setLegendVisible(true);
        this.d_autoRange = true;
        this.d_filter = new LPF(0.05);
        this.d_smoothSteps = 5;
        this.d_lastMode = null;
        this.d_flowrateMode = new FlowRateMode(this.d_filter, header -> this.isColumnVisible((String)header));
        this.d_specificFlowMode = new SpecificFlowMode(this, this.d_filter, header -> this.isColumnVisible((String)header));
        this.d_velocityMode = new VelocityMode(this.d_filter, header -> this.isColumnVisible((String)header));
        this.d_densityMode = new DensityMode(this.d_filter, header -> this.isColumnVisible((String)header));
        this.d_denVsvelMode = new DenVsVelMode(this.d_filter, header -> this.isColumnVisible((String)header));
        this.d_agentMode = new AgentMode(header -> this.isColumnVisible((String)header));
        this.d_countMode = new CountMode(header -> this.isColumnVisibleCount((String)header));
        new MouseHandler(this.d_graph);
        this.d_rawData = Collections.EMPTY_LIST;
        this.d_timeSeries = 0;
        this.d_transformedData = Collections.EMPTY_LIST;
        this.d_dataFile = null;
        this.d_rawHeaders = Collections.EMPTY_LIST;
        this.d_translatedHeaders = Collections.EMPTY_LIST;
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        JSplitPane splitter = new JSplitPane(1, true);
        splitter.setLeftComponent(this.d_list);
        splitter.setRightComponent(this.d_graph);
        GridBagUtil.add(c, splitter, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
        this.d_unfiltered = new NoFilterAction(Intl.intl("Show Raw Data"));
        this.d_lpFilter = new LPFAction(Intl.intl("Use Low-pass Filter..."));
        this.d_movingAvgFilter = new MovingAvgAction(Intl.intl("Use Moving-average Filter..."));
        this.d_showDoorDirDataAction = new ShowDirDataAction();
        this.d_annotateObjPathsAction = new AnnotateObjPathsAction();
        this.setJMenuBar(this.createMenus());
        this.d_rbmiUsage.setSelected(true);
    }

    @Override
    public boolean close() {
        boolean result = super.close();
        if (result) {
            this.d_rawData = Collections.EMPTY_LIST;
            this.d_timeSeries = 0;
            for (LWSeries series : this.d_transformedData) {
                this.d_graph.removeSeries(series);
            }
            this.d_transformedData = Collections.EMPTY_LIST;
            this.d_rawHeaders = Collections.EMPTY_LIST;
            this.d_translatedHeaders = Collections.EMPTY_LIST;
        }
        return result;
    }

    public IMode getFlowRateMode() {
        return this.d_flowrateMode;
    }

    public IMode getSpecificFlowMode() {
        return this.d_specificFlowMode;
    }

    public IMode getCountMode() {
        return this.d_countMode;
    }

    public IMode getVelocityMode() {
        return this.d_velocityMode;
    }

    public IMode getDensityMode() {
        return this.d_densityMode;
    }

    public IMode getDenVsVelMode() {
        return this.d_denVsvelMode;
    }

    public IMode getAgentMode() {
        return this.d_agentMode;
    }

    private JMenuBar createMenus() {
        JMenu fileMenu = new JMenu(Intl.intl("File"));
        fileMenu.add(new UIHook(new OpenAction(), Intl.intl("Open...,O,Open File,Open a 2D results file")).getMenuItem());
        fileMenu.addSeparator();
        fileMenu.add(new CloseAction());
        JMenu editMenu = new JMenu(Intl.intl("Edit"));
        editMenu.add(new SelectAll());
        editMenu.add(new ClearSelection());
        editMenu.addSeparator();
        editMenu.add(new CopyGraphImage());
        MenuBuilder viewMenuBuilder = new MenuBuilder();
        viewMenuBuilder.add(new AutoRangeAction());
        viewMenuBuilder.add(new ShowLegendAction());
        viewMenuBuilder.addSeparator();
        viewMenuBuilder.add("<html><b>" + Intl.intl("Data Filter") + "</b></html>");
        viewMenuBuilder.addMutuallyExclusive(this.d_unfiltered, this.d_lpFilter, this.d_movingAvgFilter);
        viewMenuBuilder.addSeparator();
        viewMenuBuilder.add(this.d_showDoorDirDataAction);
        viewMenuBuilder.add(this.d_annotateObjPathsAction);
        JMenu viewMenu = viewMenuBuilder.buildMenu(Intl.intl("View"));
        AccumulateMode accumulateMode = new AccumulateMode(header -> this.isColumnVisible((String)header));
        IMode flowRateMode = this.getFlowRateMode();
        IMode specificFlowMode = this.getSpecificFlowMode();
        IMode velocityMode = this.getVelocityMode();
        IMode densityMode = this.getDensityMode();
        IMode denVsvelMode = this.getDenVsVelMode();
        IMode agentMode = this.getAgentMode();
        this.d_rbmiUsage = new JRadioButtonMenuItem(new ModeSelectorAction(this.d_countMode.getModeName(), this.d_countMode));
        this.d_rbmiCumulative = new JRadioButtonMenuItem(new ModeSelectorAction(accumulateMode.getModeName(), accumulateMode));
        this.d_rbmiFlowRate = new JRadioButtonMenuItem(new ModeSelectorAction(flowRateMode.getModeName(), flowRateMode));
        this.d_rbmiSpFlow = new JRadioButtonMenuItem(new ModeSelectorAction(specificFlowMode.getModeName(), specificFlowMode));
        this.d_rbmiVelocityRate = new JRadioButtonMenuItem(new ModeSelectorAction(velocityMode.getModeName(), velocityMode));
        this.d_rbmiDensityRate = new JRadioButtonMenuItem(new ModeSelectorAction(densityMode.getModeName(), densityMode));
        this.d_rbmiDenVsvelRate = new JRadioButtonMenuItem(new ModeSelectorAction(denVsvelMode.getModeName(), denVsvelMode));
        this.d_rbmiAgentCount = new JRadioButtonMenuItem(new ModeSelectorAction(agentMode.getModeName(), agentMode));
        new guiButtonGroup(this.d_rbmiUsage, this.d_rbmiCumulative, this.d_rbmiFlowRate, this.d_rbmiSpFlow, this.d_rbmiVelocityRate, this.d_rbmiDensityRate, this.d_rbmiDenVsvelRate, this.d_rbmiAgentCount);
        JMenu modeMenu = new JMenu(Intl.intl("Mode"));
        modeMenu.add(this.d_rbmiUsage);
        modeMenu.add(this.d_rbmiCumulative);
        modeMenu.add(this.d_rbmiFlowRate);
        modeMenu.add(this.d_rbmiSpFlow);
        modeMenu.add(this.d_rbmiVelocityRate);
        modeMenu.add(this.d_rbmiDensityRate);
        modeMenu.add(this.d_rbmiDenVsvelRate);
        modeMenu.add(this.d_rbmiAgentCount);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(viewMenu);
        menuBar.add(modeMenu);
        return menuBar;
    }

    private void repaintGraph() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Plot2dDlg.this.d_graph.repaint();
            }
        });
    }

    public void setMode(IMode mode) {
        boolean averaging = mode.supportsAveraging();
        this.d_unfiltered.setEnabled(averaging);
        this.d_lpFilter.setEnabled(averaging);
        this.d_movingAvgFilter.setEnabled(averaging);
        if (!averaging) {
            this.d_unfiltered.setSelected(true);
        } else {
            this.updateFilterFromData();
        }
        this.d_graph.reset();
        this.d_graph.setAutoRangeX(false);
        this.d_graph.setAutoRangeY(false);
        this.d_graph.setRangeX(0.0, 1.0);
        this.d_graph.setRangeY(0.0, 1.0);
        this.setTitle(String.format("%s: %s", mode.getModeName(), this.d_dataFile));
        this.d_graph.setTitle(mode.getGraphTitle());
        this.d_graph.setXTitle(mode.getAxisTitleX());
        this.d_graph.setYTitle(mode.getAxisTitleY());
        this.d_list.setItems(new Object[0]);
        this.repaintGraph();
        this.d_lastMode = mode;
    }

    public void setFilterType(IFilterType type) {
        if (!this.d_filter.equals(type)) {
            Consumer<IFilterType> applyFilter = f -> {
                this.d_filter = type;
                this.d_flowrateMode.setFilter(type);
                this.d_specificFlowMode.setFilter(type);
                this.d_velocityMode.setFilter(type);
                this.d_densityMode.setFilter(type);
            };
            IFilterType oldFilter = this.d_filter;
            applyFilter.accept(type);
            try {
                this.refreshData();
            }
            catch (IOException e) {
                e.printStackTrace();
                applyFilter.accept(oldFilter);
            }
        }
    }

    private void updateFilterFromData() {
        if (this.d_filter instanceof Unfiltered) {
            this.d_unfiltered.setSelected(true);
        } else if (this.d_filter instanceof LPF) {
            this.d_lpFilter.setSelected(true);
        } else {
            this.d_movingAvgFilter.setSelected(true);
        }
    }

    public void setDataFile(String fn) {
        this.d_dataFile = fn;
    }

    public void setAxisUnitY(String str) {
        this.d_graph.setYTitle(str);
    }

    public void setPlotTitle(String str) {
        this.d_graph.setTitle(str);
    }

    private BufferedReader newReader() throws IOException {
        Optional<Charset> charset = this.d_charsetMap.apply(new File(this.d_dataFile));
        if (charset.isPresent()) {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.d_dataFile), charset.get()));
        }
        return new BufferedReader(new FileReader(this.d_dataFile));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int parseCsvVersion() throws IOException {
        try (BufferedReader s = this.newReader();){
            String firstLine = s.readLine();
            if (firstLine.startsWith("\"\"\"TeciVersion")) {
                int numStart = firstLine.indexOf(61) + 1;
                int numEnd = firstLine.indexOf(34, numStart);
                if (numStart != -1 && numEnd != -1 && numEnd > numStart) {
                    String split = firstLine.substring(numStart, numEnd);
                    int n2 = Integer.parseInt(split);
                    return n2;
                }
            }
            int n = 0;
            return n;
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        catch (IOException | CancellationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    public void loadCsvData(MerlinData md, TaskProgress progress, int numHeaders, int timeSeries, IMode defaultMode) throws IOException {
        int n;
        theTimer timer = new theTimer();
        progress.setMessage(Intl.intl("Determining number of time steps"));
        ArrayList<List<String>> headers = new ArrayList<List<String>>();
        boolean continaspathAnnotations = false;
        try (BufferedReader s = this.newReader();){
            for (int i2 = 0; i2 < numHeaders; ++i2) {
                headers.add(CSVLineParser.parse(s.readLine(), ",", " ", "\"", null, null, 4));
            }
            if (((List)headers.get(0)).isEmpty()) {
                throw new IOException(Intl.intl("Unable to read column headers."));
            }
            boolean sameLength = headers.stream().mapToInt(l -> l.size()).allMatch(i -> i == ((List)headers.get(0)).size());
            if (!sameLength) {
                throw new IOException(Intl.intl("The number of read in column headers should be equal."));
            }
            timer.reset();
            long numLines = s.lines().filter(line -> !line.isEmpty()).count();
            System.out.printf("done header (%g s): num_lines=%d, num_columns=%d%n", timer.curr(), numLines, ((List)headers.get(0)).size());
            block21: for (List list : headers) {
                for (Object h : list) {
                    if (!((String)h).contains(ANNOTATION_MARK)) continue;
                    continaspathAnnotations = true;
                    continue block21;
                }
            }
            if (numLines > Integer.MAX_VALUE) {
                throw new IOException(String.format(Intl.intl("Line count exceeds maximum: %1$d > %2$d"), numLines, Integer.MAX_VALUE));
            }
            n = (int)numLines;
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        catch (IOException | CancellationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        progress.check();
        timer.reset();
        ArrayList<double[]> data = new ArrayList<double[]>();
        try {
            for (int i2 = 0; i2 < ((List)headers.get(0)).size(); ++i2) {
                double[] arr = new double[n];
                Arrays.fill(arr, Double.NaN);
                data.add(new double[n]);
            }
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        System.out.printf("done data alloc (%g s)%n", timer.curr());
        progress.check();
        progress.setMessage(Intl.intl("Reading time steps"));
        progress.setMax(n);
        progress.setProgress(0);
        timer.reset();
        try (BufferedReader s = this.newReader();){
            for (int i3 = 0; i3 < numHeaders; ++i3) {
                s.readLine();
            }
            int procCount = Runtime.getRuntime().availableProcessors();
            ExecutorService exec = Executors.newFixedThreadPool(procCount);
            int parallelLineLimit = procCount * 2;
            ArrayDeque arrayDeque = new ArrayDeque(parallelLineLimit);
            int[] i4 = new int[]{0};
            s.lines().filter(line -> i4[0] < n && !line.isEmpty()).forEachOrdered(line -> {
                int row = i4[0];
                if (parallelLineLimit == queuedTasks.size()) {
                    try {
                        ((Future)queuedTasks.removeFirst()).get();
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                }
                progress.check();
                progress.setProgress(row + 1);
                Future<?> future = exec.submit(() -> {
                    List<String> toks = CSVLineParser.parse(line, ",", " ", "\"", null, null, 4);
                    for (int col = 0; col < ((List)headers.get(0)).size(); ++col) {
                        String tokVal = toks.get(col);
                        double[] dataCol = (double[])data.get(col);
                        try {
                            double val;
                            dataCol[row] = val = Double.parseDouble(tokVal);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            dataCol[row] = Double.NaN;
                        }
                    }
                });
                queuedTasks.add(future);
                i[0] = i4[0] + 1;
            });
            for (Future task : arrayDeque) {
                task.get();
            }
            exec.shutdown();
            exec.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            this.d_rawData = data;
            this.d_timeSeries = timeSeries;
            this.d_containsPathsAnnotations = continaspathAnnotations;
            this.d_rawHeaders = numHeaders == 5 ? Plot2dDlg.compressFiveRowHeaders(md, headers) : headers;
            ArrayList<List<String>> translatedHeaders = new ArrayList<List<String>>();
            for (List<String> rawHeaders : this.d_rawHeaders) {
                translatedHeaders.add(Plot2dDlg.translateHeaders(rawHeaders));
            }
            this.d_translatedHeaders = translatedHeaders;
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        catch (IOException | CancellationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        System.out.printf("data read (%g s)%n", timer.curr());
    }

    private static List<List<String>> compressFiveRowHeaders(MerlinData md, List<List<String>> headers) {
        List<String> descriptionHeader = headers.get(0);
        List<String> objectNameHeader = headers.get(1);
        List<String> resultsIdHeader = headers.get(2);
        HashMap<Long, ICompElement> objects = new HashMap<Long, ICompElement>();
        for (ICompElement elem : md.floors.flatten()) {
            objects.put(elem.getResultsId(), elem);
        }
        ArrayList<String> compressed = new ArrayList<String>(descriptionHeader.size());
        for (int i = 0; i < descriptionHeader.size(); ++i) {
            try {
                long resultsId = Long.parseLong(resultsIdHeader.get(i));
                StringBuilder objName = new StringBuilder();
                ICompElement elem = (ICompElement)objects.get(resultsId);
                if (elem != null) {
                    objName.append(InfernoUtil.getPathName(md, md.floors, objects.get(resultsId), true));
                } else {
                    objName.append(objectNameHeader.get(i));
                }
                objName.append(descriptionHeader.get(i).replace(DoorUsageWriter.Header.TIME_STEP_USAGE.desc.fileStr, "").replace(RoomUsageWriter.Header.OCCUPANT_COUNT.desc.fileStr, ""));
                compressed.add(objName.toString());
                continue;
            }
            catch (NumberFormatException e) {
                compressed.add(descriptionHeader.get(i));
            }
        }
        return new ArrayList<List<String>>(Collections.singleton(compressed));
    }

    private static List<String> translateHeaders(List<String> headers) {
        HashMap<String, String> map = new HashMap<String, String>();
        Consumer<Collection> headerFuncColl = colHeaders -> {
            for (WriterIntl.IColHeader colHeader : colHeaders) {
                if (colHeader == null) continue;
                colHeader.all().forEach(header -> {
                    if (!header.fileStr.equals(header.intlStr)) {
                        map.put(header.fileStr, header.intlStr);
                    }
                });
            }
        };
        Consumer<WriterIntl.IColHeader[]> headerFunc = colHeaders -> headerFuncColl.accept(Arrays.asList(colHeaders));
        headerFunc.accept(DoorUsageWriter.Header.values());
        headerFunc.accept(LegacyCsvHeaders.LegacyDoorHeader.values());
        headerFunc.accept(RoomUsageWriter.Header.values());
        headerFunc.accept(LegacyCsvHeaders.LegacyRoomHeader.values());
        headerFunc.accept(MeasurementRegionWriter.Header.values());
        ArrayList<String> translated = new ArrayList<String>(headers.size());
        for (String header : headers) {
            translated.add(Plot2dDlg.translateHeader(map, header));
        }
        return translated;
    }

    private static String translateHeader(Map<String, String> map, String header) {
        String theader = map.get(header);
        if (theader != null) {
            return theader;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String fileStr = entry.getKey();
            int ix = header.lastIndexOf(fileStr);
            if (ix == -1 || ix != header.length() - fileStr.length()) continue;
            return header.substring(0, ix) + entry.getValue();
        }
        return header;
    }

    public void updateAutoRange(boolean useOnlySelectedData) {
        if (this.d_transformedData == null || this.d_transformedData.isEmpty()) {
            return;
        }
        LWSeries series0 = this.d_transformedData.get(0);
        try {
            series0.makeBoundsValid();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        double xmax = series0.getMaxX();
        this.d_graph.setRangeX(0.0, xmax * 1.05);
        double ymax = 0.0;
        int i = 0;
        for (LWSeries s : this.d_transformedData) {
            if (!this.d_list.isSelected(i++) && useOnlySelectedData) continue;
            try {
                s.makeBoundsValid();
            }
            catch (Throwable t) {
                return;
            }
            ymax = Math.max(ymax, s.getMaxY());
        }
        ymax = (int)(ymax + 1.0);
        this.d_graph.setRangeY(0.0, ymax);
    }

    public void updateListBox() {
        Object[] names = new String[this.d_transformedData.size()];
        for (int i = 0; i < this.d_transformedData.size(); ++i) {
            names[i] = this.d_transformedData.get(i).getName();
        }
        this.d_list.setItems(names);
    }

    public void selectItem(int row) {
        if (0 <= row && row < this.d_transformedData.size()) {
            this.d_list.setSelected(row, true);
        }
    }

    public static List<LWSeries> toSeries(List<double[]> xvals, List<String> displayHeaders, List<double[]> yvals, BitSet skipData, Function<double[], IntToDoubleFunction> dataMap, boolean sortXVals, ToDoubleBiFunction<Double, double[]> resolveDuplicates, boolean isLineStyle) {
        ArrayList<LWSeries> seriesList = new ArrayList<LWSeries>(yvals.size() - skipData.cardinality() - 1);
        for (int m = 1; m < displayHeaders.size(); ++m) {
            Supplier<IntStream> xIxesSrc;
            if (skipData.get(m)) continue;
            double[] x = xvals.get(m);
            IntToDoubleFunction xData = Plot2dDlg.toIntFunction(x);
            Supplier<IntToDoubleFunction> xDataSrc = () -> xData;
            double[] y = yvals.get(m);
            Supplier<IntToDoubleFunction> yDataSrc = () -> (IntToDoubleFunction)dataMap.apply(y);
            if (!sortXVals) {
                xIxesSrc = () -> IntStream.range(0, x.length);
            } else {
                int[] ixes = theUtil.sequentialList(0, x.length);
                theUtil.sort(ixes, (i1, i2) -> Double.compare(x[i1], x[i2]));
                xIxesSrc = () -> IntStream.of(ixes);
            }
            if (resolveDuplicates != null) {
                IntToDoubleFunction xs = xDataSrc.get();
                IntToDoubleFunction ys = yDataSrc.get();
                IntStream sixes = xIxesSrc.get();
                List ixes = sixes.boxed().collect(Collectors.toList());
                if (!ixes.isEmpty()) {
                    BitSet delIxes = new BitSet();
                    HashMap<Integer, Double> resolvedVals = new HashMap<Integer, Double>();
                    ArrayList<Double> duplicateYs = new ArrayList<Double>();
                    for (int n = 0; n < ixes.size(); ++n) {
                        int next;
                        double xnext;
                        int curr = (Integer)ixes.get(n);
                        double xcurr = xs.applyAsDouble(curr);
                        int o = n + 1;
                        while (o < ixes.size() && xcurr == (xnext = xs.applyAsDouble(next = ((Integer)ixes.get(o)).intValue()))) {
                            delIxes.set(o);
                            if (duplicateYs.isEmpty()) {
                                duplicateYs.add(ys.applyAsDouble(curr));
                            }
                            duplicateYs.add(ys.applyAsDouble(next));
                            n = o++;
                        }
                        if (duplicateYs.isEmpty()) continue;
                        double ry = resolveDuplicates.applyAsDouble(xs.applyAsDouble(curr), theUtil.toDoubleArray(duplicateYs));
                        resolvedVals.put(curr, ry);
                        duplicateYs.clear();
                    }
                    int nIxesRemoved = delIxes.cardinality();
                    if (nIxesRemoved > 0) {
                        int[] newIxes = new int[ixes.size() - nIxesRemoved];
                        int ixCounter = 0;
                        for (int n = 0; n < ixes.size(); ++n) {
                            if (delIxes.get(n)) continue;
                            newIxes[ixCounter++] = (Integer)ixes.get(n);
                        }
                        xIxesSrc = () -> IntStream.of(newIxes);
                        IntToDoubleFunction yFunc = yDataSrc.get();
                        IntToDoubleFunction ryFunc = ix -> {
                            Double rval = (Double)resolvedVals.get(ix);
                            if (rval != null) {
                                return rval;
                            }
                            return yFunc.applyAsDouble(ix);
                        };
                        yDataSrc = () -> ryFunc;
                    }
                }
            }
            int col = seriesList.size();
            String header = displayHeaders.get(m);
            int ixColor = col % SERIES_COLORS.length;
            int ixStyleLine = col / SERIES_COLORS.length % SERIES_LINESTYLES.length;
            int ixStyleMark = col / SERIES_COLORS.length % SERIES_MARKSTYLES.length;
            LWSeries s = new LWSeries(xIxesSrc, xDataSrc, yDataSrc, header, SERIES_COLORS[ixColor], isLineStyle ? 14 : SERIES_MARKSTYLES[ixStyleMark], isLineStyle ? SERIES_LINESTYLES[ixStyleLine] : 5, 2);
            seriesList.add(s);
        }
        return seriesList;
    }

    public void showSeries(int row) {
        LWSeries s = this.d_transformedData.get(row);
        try {
            s.open();
        }
        catch (Throwable t) {
            guiUtil.showError(this, Intl.intl("Error"), Intl.intl("Could not show results"), t);
            s.close();
            return;
        }
        this.d_graph.addSeries(s);
        if (this.d_autoRange) {
            this.updateAutoRange(true);
        }
        this.repaintGraph();
    }

    public void hideSeries(int row) {
        LWSeries s = this.d_transformedData.get(row);
        this.d_graph.removeSeries(s);
        EventQueue.invokeLater(() -> s.close());
        if (this.d_autoRange) {
            this.updateAutoRange(true);
        }
        this.repaintGraph();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof CkBoxListPanel.EvtMessage) {
            CkBoxListPanel.EvtMessage msg = (CkBoxListPanel.EvtMessage)arg;
            if (msg.type == 0) {
                this.showSeries(msg.row);
            } else if (msg.type == 1) {
                this.hideSeries(msg.row);
            }
        }
    }

    public void loadDataFile(MerlinData md, File f, IMode modeIfFail, Optional<TaskProgress> progress) throws IOException {
        TaskProgress prog = progress.orElse(new TaskProgress());
        int numHeaders = 1;
        int timeSeries = 0;
        try {
            IMode defaultMode;
            if (f == null) {
                this.setMode(modeIfFail);
                return;
            }
            this.setDataFile(f.getPath());
            int version = this.parseCsvVersion();
            if (f.getPath().endsWith("_doors.csv")) {
                if (version <= 0) {
                    numHeaders = 1;
                    timeSeries = 0;
                } else {
                    numHeaders = 5;
                    timeSeries = 1;
                }
                defaultMode = this.getFlowRateMode();
                this.d_rbmiCumulative.setEnabled(true);
                this.d_rbmiFlowRate.setEnabled(true);
                this.d_rbmiFlowRate.setSelected(true);
                this.d_rbmiSpFlow.setEnabled(true);
                this.d_showDoorDirDataAction.setEnabled(true);
                this.d_rbmiVelocityRate.setEnabled(false);
                this.d_rbmiDensityRate.setEnabled(false);
                this.d_rbmiDenVsvelRate.setEnabled(false);
                this.d_rbmiAgentCount.setEnabled(false);
            } else if (f.getPath().endsWith("_rooms.csv")) {
                if (version <= 0) {
                    numHeaders = 1;
                    timeSeries = 0;
                } else {
                    numHeaders = 5;
                    timeSeries = 1;
                }
                defaultMode = this.getCountMode();
                this.d_rbmiCumulative.setEnabled(false);
                this.d_rbmiFlowRate.setEnabled(false);
                this.d_rbmiSpFlow.setEnabled(false);
                this.d_rbmiUsage.setSelected(true);
                this.d_showDoorDirDataAction.setEnabled(false);
                this.d_rbmiVelocityRate.setEnabled(false);
                this.d_rbmiDensityRate.setEnabled(false);
                this.d_rbmiDenVsvelRate.setEnabled(false);
                this.d_rbmiAgentCount.setEnabled(false);
            } else if (f.getPath().endsWith("_measurement-regions.csv")) {
                defaultMode = this.getVelocityMode();
                numHeaders = 3;
                this.d_rbmiCumulative.setEnabled(false);
                this.d_rbmiFlowRate.setEnabled(false);
                this.d_rbmiVelocityRate.setEnabled(true);
                this.d_rbmiVelocityRate.setSelected(true);
                this.d_rbmiDensityRate.setEnabled(true);
                this.d_rbmiDenVsvelRate.setEnabled(true);
                this.d_rbmiAgentCount.setEnabled(true);
                this.d_rbmiSpFlow.setEnabled(false);
                this.d_rbmiUsage.setEnabled(false);
                this.d_showDoorDirDataAction.setEnabled(false);
            } else {
                defaultMode = this.getCountMode();
                this.d_rbmiCumulative.setEnabled(false);
                this.d_rbmiFlowRate.setEnabled(false);
                this.d_rbmiSpFlow.setEnabled(false);
                this.d_rbmiUsage.setSelected(true);
                this.d_showDoorDirDataAction.setEnabled(false);
                this.d_rbmiVelocityRate.setEnabled(false);
                this.d_rbmiDensityRate.setEnabled(false);
                this.d_rbmiDenVsvelRate.setEnabled(false);
                this.d_rbmiAgentCount.setEnabled(false);
            }
            this.loadCsvData(md, prog, numHeaders, timeSeries, defaultMode);
            this.d_annotateObjPathsAction.reset();
            this.d_annotateObjPathsAction.setEnabled(this.d_containsPathsAnnotations);
            this.d_annotateObjPathsAction.setSelected(this.d_containsPathsAnnotations);
            this.loadData(defaultMode);
        }
        catch (IOException | CancellationException e) {
            this.setMode(modeIfFail);
            throw e;
        }
        catch (Throwable t) {
            this.setMode(modeIfFail);
            throw new IOException(t);
        }
    }

    private void loadData(IMode mode) throws IOException {
        List<Object> xformed = Collections.emptyList();
        try {
            xformed = this.getTransformedData(mode);
        }
        catch (IOException t) {
            throw new IOException(t);
        }
        this.setMode(mode);
        if (!this.isDataValid()) {
            return;
        }
        this.d_transformedData = xformed;
        this.updateAutoRange(false);
        this.updateListBox();
        this.selectItem(0);
        this.d_graph.repaint();
    }

    private void refreshData() throws IOException {
        if (!this.isDataValid()) {
            return;
        }
        List<LWSeries> newData = this.getTransformedData(this.d_lastMode);
        if (newData.size() == this.d_transformedData.size()) {
            for (int i = 0; i < this.d_transformedData.size(); ++i) {
                LWSeries oldSeries = this.d_transformedData.get(i);
                LWSeries newSeries = newData.get(i);
                oldSeries.setData(newSeries.getIndexesSrc(), newSeries.getXSrc(), newSeries.getYSrc());
                oldSeries.setName(newSeries.getName());
            }
        } else {
            this.loadNewData(newData);
        }
        this.updateAutoRange(true);
        this.repaintGraph();
    }

    private void loadNewData(List<LWSeries> newData) {
        LinkedHashMap<LWSeries, LWSeries> oldToNew = new LinkedHashMap<LWSeries, LWSeries>();
        LinkedHashMap<LWSeries, Integer> oldToNewID = new LinkedHashMap<LWSeries, Integer>();
        ArrayList<Integer> selected = new ArrayList<Integer>();
        int runningIndex = 0;
        for (int i = 0; i < this.d_transformedData.size(); ++i) {
            this.hideSeries(i);
            LWSeries oldSeries = this.d_transformedData.get(i);
            String dataName = oldSeries.getName();
            for (int j = runningIndex; j < newData.size(); ++j) {
                if (!newData.get(j).getName().equals(dataName)) continue;
                oldToNew.put(oldSeries, newData.get(j));
                oldToNewID.put(oldSeries, j);
                runningIndex = j + 1;
                break;
            }
            if (!this.d_list.isSelected(i) || !oldToNewID.containsKey(oldSeries)) continue;
            selected.add((Integer)oldToNewID.get(this.d_transformedData.get(i)));
        }
        for (LWSeries old : oldToNew.keySet()) {
            LWSeries newSeries = (LWSeries)oldToNew.get(old);
            int index = (Integer)oldToNewID.get(old);
            old.setData(newSeries.getIndexesSrc(), newSeries.getXSrc(), newSeries.getYSrc());
            if (!old.isOpen()) {
                old.open();
            }
            newData.remove(index);
            newData.add(index, old);
            ++index;
        }
        this.d_transformedData = newData;
        this.updateListBox();
        Iterator<Object> iterator = selected.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.selectItem(i);
            this.showSeries(i);
        }
    }

    private boolean isDataValid() {
        return this.d_rawHeaders != null && this.d_rawData != null;
    }

    private List<LWSeries> getTransformedData(IMode mode) throws IOException {
        if (!this.isDataValid()) {
            return Collections.emptyList();
        }
        try {
            return mode.getTransformedData(this.d_rawHeaders, this.d_translatedHeaders, this.d_rawData, this.d_timeSeries);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(MerlinApp app, MerlinData md, File f) {
        Plot2dDlg dlg = this;
        JFrame msgWindow = dlg.isShowing() ? dlg : app.getActiveFrame();
        TaskProgress progress = new TaskProgress();
        guiProgressMonitor monitor = new guiProgressMonitor(msgWindow, Intl.intl("Loading Results"), true, progress);
        monitor.begin();
        try {
            dlg.loadDataFile(md, f, this.getCountMode(), Optional.of(progress));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            monitor.end();
            guiUtil.showError(msgWindow, Intl.intl("File Error"), Intl.intl("Unable to load file"), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (CancellationException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            monitor.end();
        }
    }

    private static IntToDoubleFunction toIntFunction(double[] arr) {
        return i -> arr[i];
    }

    private boolean isColumnVisible(String header) {
        return !header.endsWith(DoorUsageWriter.Header.EXITED_TOTAL.desc.fileStr) && !header.endsWith(DoorUsageWriter.Header.REMAINING_TOTAL.desc.fileStr) && !header.endsWith(LegacyCsvHeaders.LegacyDoorHeader.EXITED_TOTAL.desc.fileStr) && !header.endsWith(LegacyCsvHeaders.LegacyDoorHeader.REMAINING_TOTAL.desc.fileStr) && !header.endsWith(RoomUsageWriter.Header.EXITED_TOTAL.desc.fileStr) && !header.endsWith(RoomUsageWriter.Header.REMAINING_TOTAL.desc.fileStr) && !header.endsWith(LegacyCsvHeaders.LegacyRoomHeader.EXITED_TOTAL.desc.fileStr) && !header.endsWith(LegacyCsvHeaders.LegacyRoomHeader.REMAINING_TOTAL.desc.fileStr) && this.isColumnVisibleCount(header) && this.isColumnVisibleDirections(header);
    }

    private boolean isColumnVisibleCount(String header) {
        return !header.endsWith(DoorUsageWriter.Header.VERSION.desc.fileStr) && !header.endsWith(DoorUsageWriter.Header.TIME.desc.fileStr) && !header.endsWith(DoorUsageWriter.Header.WIDTH.desc.fileStr) && !header.endsWith(DoorUsageWriter.Header.TOTAL_BOUNDARY.desc.fileStr) && !header.endsWith(DoorUsageWriter.Header.Q.desc.fileStr) && !header.endsWith(LegacyCsvHeaders.LegacyDoorHeader.TIME.desc.fileStr) && !header.endsWith(LegacyCsvHeaders.LegacyDoorHeader.WIDTH.desc.fileStr) && !header.endsWith(LegacyCsvHeaders.LegacyDoorHeader.TOTAL_BOUNDARY.desc.fileStr) && !header.endsWith(LegacyCsvHeaders.LegacyDoorHeader.Q.desc.fileStr) && !header.endsWith(RoomUsageWriter.Header.TIME.desc.fileStr) && !header.endsWith(RoomUsageWriter.Header.VERSION.desc.fileStr) && !header.endsWith(LegacyCsvHeaders.LegacyRoomHeader.TIME.desc.fileStr) && this.isColumnVisibleDirections(header);
    }

    private boolean isColumnVisibleDirections(String header) {
        return !(!this.d_showDoorDirData && header.endsWith(DoorUsageWriter.Header.YP.desc.intlStr) || !this.d_showDoorDirData && header.endsWith(DoorUsageWriter.Header.YN.desc.intlStr) || !this.d_showDoorDirData && header.endsWith(DoorUsageWriter.Header.XP.desc.intlStr) || !this.d_showDoorDirData && header.endsWith(DoorUsageWriter.Header.XN.desc.intlStr));
    }

    private static Pair<double[], Function<double[], IntToDoubleFunction>> newEmptySeries() {
        return new Pair<double[], Function<double[], IntToDoubleFunction>>(new double[0], series -> i -> Double.NaN);
    }

    private static class LPF
    implements IFilterType {
        public final double f0;

        public LPF(double f0) {
            this.f0 = f0;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof LPF && ((LPF)obj).f0 == this.f0;
        }

        @Override
        public Pair<double[], Function<double[], IntToDoubleFunction>> getSeries(double[] rawTs) {
            if (rawTs.length < 2) {
                return Plot2dDlg.newEmptySeries();
            }
            double avgDt = 0.0;
            for (int i = 1; i < rawTs.length; ++i) {
                double dt = rawTs[i] - rawTs[i - 1];
                avgDt += dt;
            }
            double maxt = rawTs[rawTs.length - 1];
            double mint = rawTs[0];
            double fs = 2.0 / (avgDt /= (double)(rawTs.length - 1));
            double sampleDT = 1.0 / fs;
            int numT = (int)Math.floor((maxt - mint) / sampleDT);
            if (numT == 0) {
                return Plot2dDlg.newEmptySeries();
            }
            double[] sampleTs = new double[numT];
            for (int m = 0; m < numT; ++m) {
                sampleTs[m] = mint + (double)m * sampleDT;
            }
            Function<double[], IntToDoubleFunction> map = rawDataCol -> {
                double[] sampleDataCol = new double[sampleTs.length];
                EQBiquadFilter filter = EQBiquadFilter.lfp(this.f0, fs, 0.5, 0.0);
                int rawIx = 1;
                sampleDataCol[0] = 0.0;
                int sampleIx = 1;
                while (sampleIx < sampleTs.length) {
                    double sampleT = sampleTs[sampleIx];
                    double rawT = rawTs[rawIx];
                    if (rawIx < ((double[])rawDataCol).length - 1 && theUtil.ge(sampleT, rawT, 1.0E-9)) {
                        ++rawIx;
                        continue;
                    }
                    double rawOccCount = rawDataCol[rawIx - 1];
                    double rawDt = rawTs[rawIx] - rawTs[rawIx - 1];
                    double flowrate = rawOccCount / rawDt;
                    sampleDataCol[sampleIx++] = filter.filter(flowrate);
                }
                return ix -> sampleDataCol[ix];
            };
            return new Pair<double[], Function<double[], IntToDoubleFunction>>(sampleTs, map);
        }
    }

    private static interface IFilterType {
        public Pair<double[], Function<double[], IntToDoubleFunction>> getSeries(double[] var1);
    }

    public static interface IMode {
        public List<LWSeries> getTransformedData(List<List<String>> var1, List<List<String>> var2, List<double[]> var3, int var4);

        public String getModeName();

        public String getGraphTitle();

        public String getAxisTitleY();

        public String getAxisTitleX();

        public boolean supportsAveraging();
    }

    public static class FlowRateMode
    implements IMode {
        private IFilterType d_filter;
        private Function<String, Boolean> d_isColumnVisible;

        private FlowRateMode(IFilterType filter, Function<String, Boolean> isColumnVisible) {
            this.d_filter = filter;
            this.d_isColumnVisible = isColumnVisible;
        }

        public void setFilter(IFilterType filter) {
            this.d_filter = filter;
        }

        public IFilterType getFilter() {
            return this.d_filter;
        }

        @Override
        public String getGraphTitle() {
            return Intl.intl("Flow Rates for Selected Doors");
        }

        @Override
        public String getModeName() {
            return Intl.intl("Flow Rates");
        }

        @Override
        public String getAxisTitleY() {
            return Intl.intl("Flow Rate (pers/s)");
        }

        @Override
        public String getAxisTitleX() {
            return Intl.intl("Time in Seconds");
        }

        @Override
        public List<LWSeries> getTransformedData(List<List<String>> rawHeaders, List<List<String>> displayHeaders, List<double[]> rawData, int timeSeries) {
            if (rawHeaders.get(0).size() < 2 || rawData.size() != rawHeaders.get(0).size()) {
                return Collections.EMPTY_LIST;
            }
            BitSet removals = new BitSet();
            for (int i = 0; i < rawHeaders.get(0).size(); ++i) {
                String header = rawHeaders.get(0).get(i);
                if (this.d_isColumnVisible.apply(header).booleanValue()) continue;
                removals.set(i);
            }
            int numRemovals = removals.cardinality();
            if (numRemovals >= rawHeaders.get(0).size() - 1) {
                return Collections.EMPTY_LIST;
            }
            double[] rawTs = rawData.get(timeSeries);
            Pair<double[], Function<double[], IntToDoubleFunction>> series = this.d_filter.getSeries(rawTs);
            ArrayList<double[]> ts = new ArrayList<double[]>();
            for (int i = 0; i < displayHeaders.get(0).size(); ++i) {
                ts.add((double[])series.v1);
            }
            return Plot2dDlg.toSeries(ts, displayHeaders.get(0), rawData, removals, (Function)series.v2, false, null, true);
        }

        @Override
        public boolean supportsAveraging() {
            return true;
        }
    }

    public class SpecificFlowMode
    extends FlowRateMode {
        private SpecificFlowMode(Plot2dDlg this$0, IFilterType filter, Function<String, Boolean> isColumnVisible) {
            super(filter, isColumnVisible);
        }

        @Override
        public String getGraphTitle() {
            return Intl.intl("Specific Flow for Selected Doors");
        }

        @Override
        public String getModeName() {
            return Intl.intl("Specific Flow");
        }

        @Override
        public String getAxisTitleY() {
            return Intl.intl("Specific Flow (pers/s-m)");
        }

        @Override
        public String getAxisTitleX() {
            return Intl.intl("Time in Seconds");
        }

        @Override
        public List<LWSeries> getTransformedData(List<List<String>> rawHeaders, List<List<String>> displayHeaders, List<double[]> rawData, int timeSeries) {
            if (rawHeaders.get(0).size() != rawData.size()) {
                return Collections.emptyList();
            }
            List<LWSeries> flowRates = super.getTransformedData(rawHeaders, displayHeaders, rawData, timeSeries);
            if (flowRates.isEmpty()) {
                return flowRates;
            }
            ArrayList<Double> widths = new ArrayList<Double>();
            ArrayList<Double> totalBoundaries = new ArrayList<Double>();
            for (int i = 0; i < rawHeaders.get(0).size(); ++i) {
                double width;
                double[] rowData = rawData.get(i);
                String colTitle = rawHeaders.get(0).get(i);
                if (colTitle.endsWith(DoorUsageWriter.Header.WIDTH.desc.fileStr) || colTitle.endsWith(DoorUsageWriter.Header.WIDTH.desc.fileStr)) {
                    width = rowData.length == 0 ? 0.0 : rowData[0];
                    widths.add(width);
                }
                if (!colTitle.endsWith(DoorUsageWriter.Header.TOTAL_BOUNDARY.desc.fileStr) && !colTitle.endsWith(DoorUsageWriter.Header.TOTAL_BOUNDARY.desc.fileStr)) continue;
                width = rowData.length == 0 ? 0.0 : rowData[0];
                totalBoundaries.add(width);
            }
            assert (widths.size() == totalBoundaries.size());
            if (widths.size() != totalBoundaries.size()) {
                return Collections.emptyList();
            }
            int effWidthIndex = -1;
            for (int i = 0; i < flowRates.size(); ++i) {
                LWSeries flowRateSeries = flowRates.get(i);
                String sname = flowRateSeries.getName();
                if (!(sname.endsWith(DoorUsageWriter.Header.YP.desc.intlStr) || sname.endsWith(DoorUsageWriter.Header.YN.desc.intlStr) || sname.endsWith(DoorUsageWriter.Header.XP.desc.intlStr) || sname.endsWith(DoorUsageWriter.Header.XN.desc.intlStr))) {
                    ++effWidthIndex;
                }
                double width = (Double)widths.get(effWidthIndex);
                double boundary = (Double)totalBoundaries.get(effWidthIndex);
                double effWidth = width - boundary;
                double iEffWidth = 1.0 / effWidth;
                Supplier<IntToDoubleFunction> ySrc = flowRateSeries.getYSrc();
                Supplier<IntToDoubleFunction> newYSrc = () -> {
                    IntToDoubleFunction baseFunc = (IntToDoubleFunction)ySrc.get();
                    return ix -> baseFunc.applyAsDouble(ix) * iEffWidth;
                };
                flowRateSeries.setData(flowRateSeries.getIndexesSrc(), flowRateSeries.getXSrc(), newYSrc);
            }
            return flowRates;
        }
    }

    public static class VelocityMode
    implements IMode {
        private IFilterType d_filter;
        private Function<String, Boolean> d_isColumnVisible;

        private VelocityMode(IFilterType filter, Function<String, Boolean> isColumnVisible) {
            this.d_filter = filter;
            this.d_isColumnVisible = isColumnVisible;
        }

        public void setFilter(IFilterType filter) {
            this.d_filter = filter;
        }

        public IFilterType getFilter() {
            return this.d_filter;
        }

        @Override
        public String getGraphTitle() {
            return Intl.intl("Velocity for Selected Measurement Regions");
        }

        @Override
        public String getModeName() {
            return Intl.intl("Velocity");
        }

        @Override
        public String getAxisTitleY() {
            return Intl.intl("Velocity (m/s)");
        }

        @Override
        public String getAxisTitleX() {
            return Intl.intl("Time in Seconds");
        }

        @Override
        public List<LWSeries> getTransformedData(List<List<String>> rawHeaders, List<List<String>> displayHeaders, List<double[]> rawData, int timeSeries) {
            BitSet removals = new BitSet();
            for (int i = 0; i < rawHeaders.get(1).size(); ++i) {
                String h = rawHeaders.get(1).get(i);
                if (h.equals(MeasurementRegionWriter.Header.VELOCITY.quantity.fileStr)) continue;
                removals.set(i);
            }
            double[] rawTs = rawData.get(timeSeries);
            Pair<double[], Function<double[], IntToDoubleFunction>> series = this.d_filter.getSeries(rawTs);
            ArrayList<double[]> ts = new ArrayList<double[]>();
            for (int i = 0; i < displayHeaders.get(0).size(); ++i) {
                ts.add((double[])series.v1);
            }
            return Plot2dDlg.toSeries(ts, displayHeaders.get(0), rawData, removals, (Function)series.v2, false, null, true);
        }

        @Override
        public boolean supportsAveraging() {
            return true;
        }
    }

    public static class DensityMode
    implements IMode {
        private IFilterType d_filter;
        private Function<String, Boolean> d_isColumnVisible;

        private DensityMode(IFilterType filter, Function<String, Boolean> isColumnVisible) {
            this.d_filter = filter;
            this.d_isColumnVisible = isColumnVisible;
        }

        public void setFilter(IFilterType filter) {
            this.d_filter = filter;
        }

        public IFilterType getFilter() {
            return this.d_filter;
        }

        @Override
        public String getGraphTitle() {
            return Intl.intl("Density for Selected Measurement Regions");
        }

        @Override
        public String getModeName() {
            return Intl.intl("Density");
        }

        @Override
        public String getAxisTitleY() {
            return Intl.intl("Density (pers/m\u00b2)");
        }

        @Override
        public String getAxisTitleX() {
            return Intl.intl("Time in Seconds");
        }

        @Override
        public List<LWSeries> getTransformedData(List<List<String>> rawHeaders, List<List<String>> displayHeaders, List<double[]> rawData, int timeSeries) {
            BitSet removals = new BitSet();
            for (int i = 0; i < rawHeaders.get(1).size(); ++i) {
                String h = rawHeaders.get(1).get(i);
                if (h.equals(MeasurementRegionWriter.Header.DENSITY.quantity.fileStr)) continue;
                removals.set(i);
            }
            double[] rawTs = rawData.get(timeSeries);
            Pair<double[], Function<double[], IntToDoubleFunction>> series = this.d_filter.getSeries(rawTs);
            ArrayList<double[]> ts = new ArrayList<double[]>();
            for (int i = 0; i < displayHeaders.get(0).size(); ++i) {
                ts.add((double[])series.v1);
            }
            return Plot2dDlg.toSeries(ts, displayHeaders.get(0), rawData, removals, (Function)series.v2, false, null, true);
        }

        @Override
        public boolean supportsAveraging() {
            return true;
        }
    }

    public static class DenVsVelMode
    implements IMode {
        private IFilterType d_filter;
        private Function<String, Boolean> d_isColumnVisible;

        private DenVsVelMode(IFilterType filter, Function<String, Boolean> isColumnVisible) {
            this.d_filter = filter;
            this.d_isColumnVisible = isColumnVisible;
        }

        public void setFilter(IFilterType filter) {
            this.d_filter = filter;
        }

        public IFilterType getFilter() {
            return this.d_filter;
        }

        @Override
        public String getGraphTitle() {
            return Intl.intl("Speed vs Density for Selected Measurement Regions");
        }

        @Override
        public String getModeName() {
            return Intl.intl("Speed vs Density");
        }

        @Override
        public String getAxisTitleY() {
            return Intl.intl("Speed (m/s)");
        }

        @Override
        public String getAxisTitleX() {
            return Intl.intl("Density (pers/m\u00b2)");
        }

        @Override
        public List<LWSeries> getTransformedData(List<List<String>> rawHeaders, List<List<String>> displayHeaders, List<double[]> rawData, int timeSeries) {
            String h;
            BitSet removals = new BitSet();
            ArrayList<double[]> xvals = new ArrayList<double[]>();
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            int velocityIndex = 0;
            int densityIndex = 0;
            int counter = 0;
            for (int i = 0; i < rawHeaders.get(1).size(); ++i) {
                h = rawHeaders.get(1).get(i);
                if (h.equals(MeasurementRegionWriter.Header.DENSITY.quantity.fileStr)) {
                    densityIndex = i;
                    ++counter;
                }
                if (h.equals(MeasurementRegionWriter.Header.VELOCITY.quantity.fileStr)) {
                    velocityIndex = i;
                    ++counter;
                }
                if (counter != 2) continue;
                map.put(velocityIndex, densityIndex);
                counter = 0;
            }
            for (int n = 0; n < rawHeaders.get(1).size(); ++n) {
                h = rawHeaders.get(1).get(n);
                if (h.equals(MeasurementRegionWriter.Header.VELOCITY.quantity.fileStr)) {
                    if (!map.containsKey(n)) continue;
                    xvals.add(rawData.get((Integer)map.get(n)));
                    continue;
                }
                xvals.add(null);
                removals.set(n);
            }
            return Plot2dDlg.toSeries(xvals, displayHeaders.get(0), rawData, removals, datacol -> Plot2dDlg.toIntFunction(datacol), false, null, false);
        }

        @Override
        public boolean supportsAveraging() {
            return false;
        }
    }

    public static class AgentMode
    implements IMode {
        private Function<String, Boolean> d_isColumnVisible;

        private AgentMode(Function<String, Boolean> isColumnVisible) {
            this.d_isColumnVisible = isColumnVisible;
        }

        @Override
        public String getGraphTitle() {
            return Intl.intl("Occupant Count for Selected Measurement Regions");
        }

        @Override
        public String getModeName() {
            return Intl.intl("Occupants in Region");
        }

        @Override
        public String getAxisTitleY() {
            return Intl.intl("Occupants (pers)");
        }

        @Override
        public String getAxisTitleX() {
            return Intl.intl("Time in Seconds");
        }

        @Override
        public List<LWSeries> getTransformedData(List<List<String>> rawHeaders, List<List<String>> displayHeaders, List<double[]> rawData, int timeSeries) {
            BitSet removals = new BitSet();
            for (int i = 0; i < rawHeaders.get(1).size(); ++i) {
                String h = rawHeaders.get(1).get(i);
                if (h.equals(MeasurementRegionWriter.Header.COUNT.quantity.fileStr)) continue;
                removals.set(i);
            }
            double[] rawTs = rawData.get(timeSeries);
            ArrayList<double[]> ts = new ArrayList<double[]>();
            for (int i = 0; i < displayHeaders.get(0).size(); ++i) {
                ts.add(rawData.get(0));
            }
            return Plot2dDlg.toSeries(ts, displayHeaders.get(0), rawData, removals, datacol -> Plot2dDlg.toIntFunction(datacol), false, null, true);
        }

        @Override
        public boolean supportsAveraging() {
            return false;
        }
    }

    public static class CountMode
    implements IMode {
        private final Function<String, Boolean> d_isColumnVisible;

        public CountMode(Function<String, Boolean> isColumnVisible) {
            this.d_isColumnVisible = isColumnVisible;
        }

        @Override
        public String getGraphTitle() {
            return Intl.intl("Number of Occupants in Selected Rooms");
        }

        @Override
        public String getModeName() {
            return Intl.intl("Occupant Counts");
        }

        @Override
        public String getAxisTitleY() {
            return Intl.intl("Number of Occupants");
        }

        @Override
        public String getAxisTitleX() {
            return Intl.intl("Time in Seconds");
        }

        @Override
        public List<LWSeries> getTransformedData(List<List<String>> rawHeaders, List<List<String>> displayHeaders, List<double[]> rawData, int timeSeries) {
            BitSet removals = new BitSet();
            for (int i = 0; i < rawHeaders.get(0).size(); ++i) {
                String header = rawHeaders.get(0).get(i);
                if (this.d_isColumnVisible.apply(header).booleanValue()) continue;
                removals.set(i);
            }
            ArrayList<double[]> ts = new ArrayList<double[]>();
            for (int i = 0; i < displayHeaders.get(0).size(); ++i) {
                ts.add(rawData.get(timeSeries));
            }
            return Plot2dDlg.toSeries(ts, displayHeaders.get(0), rawData, removals, datacol -> Plot2dDlg.toIntFunction(datacol), false, null, true);
        }

        @Override
        public boolean supportsAveraging() {
            return false;
        }
    }

    private static class MouseHandler
    extends MouseAdapter {
        private Graph d_graph;
        private Graph.Annotation d_annotation;
        private NumberFormat d_format;
        private final char d_separator;

        public MouseHandler(Graph g) {
            g.addMouseListener(this);
            g.addMouseMotionListener(this);
            this.d_graph = g;
            this.d_annotation = null;
            this.d_format = new DecimalFormat("######0.##");
            DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
            DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
            char localeSep = symbols.getDecimalSeparator();
            this.d_separator = (char)(localeSep != ',' ? 44 : 59);
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            if (this.d_annotation != null && this.d_graph.removeAnnotation(this.d_annotation)) {
                this.d_graph.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            boolean needRepaint = false;
            if (this.d_annotation != null) {
                needRepaint |= this.d_graph.removeAnnotation(this.d_annotation);
            }
            Graph.PickPointVal pickVal = new Graph.PickPointVal();
            boolean onPoint = this.d_graph.pickPoint(evt.getX(), evt.getY(), 50, pickVal);
            if (onPoint) {
                ISeries s = pickVal.series;
                double x = s.getX().applyAsDouble(pickVal.i);
                double y = s.getY().applyAsDouble(pickVal.i);
                this.d_annotation = new Graph.Annotation("(" + this.d_format.format(x) + this.d_separator + this.d_format.format(y) + ")", new Point2D.Double(x, y), s.getColor());
                needRepaint |= this.d_graph.addAnnotation(this.d_annotation);
            }
            if (needRepaint) {
                this.d_graph.repaint();
            }
        }
    }

    private class NoFilterAction
    extends BooleanAction {
        private static final long serialVersionUID = -6595300492933046939L;

        public NoFilterAction(String name) {
            super(name, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            Plot2dDlg.this.setFilterType(new Unfiltered());
        }
    }

    private class LPFAction
    extends BooleanAction {
        private static final long serialVersionUID = 3824525388564404003L;
        private double d_f0;

        public LPFAction(String name) {
            super(name, false);
            this.d_f0 = 0.05;
            Object tt = Intl.intl("Filters the flowrate using a biquad low-pass filter.");
            tt = "<html>" + (String)tt + "</html>";
            this.putValue("ShortDescription", tt);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            String title = Intl.intl("Enter Cutoff Frequency");
            String msg = "<html>" + Intl.intl("Enter the cutoff frequency<br>(lower values produce smoother graphs):") + "</html>";
            Double f0 = guiInputDlg.getDouble(Plot2dDlg.this, title, msg, DoubleVR.above(0.0, false), this.d_f0);
            if (f0 == null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Plot2dDlg.this.updateFilterFromData();
                    }
                });
                return;
            }
            this.d_f0 = f0;
            Plot2dDlg.this.setFilterType(new LPF(f0));
        }
    }

    private class MovingAvgAction
    extends BooleanAction {
        private static final long serialVersionUID = -5812970800561262598L;
        private UnitDouble d_avgPeriod;

        public MovingAvgAction(String name) {
            super(name, false);
            this.d_avgPeriod = new UnitDouble(10.0, SI.SECOND);
            Object tt = Intl.intl("Filters the flowrate using a sliding time average.");
            tt = "<html>" + (String)tt + "</html>";
            this.putValue("ShortDescription", tt);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            String title = Intl.intl("Enter Averaging Period");
            String msg = Intl.intl("Enter the averaging period:");
            UnitDouble period = guiInputDlg.getUnitDouble(Plot2dDlg.this, title, msg, UnitDoubleVR.above(0.0, SI.SECOND, false), this.d_avgPeriod);
            if (period == null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Plot2dDlg.this.updateFilterFromData();
                    }
                });
                return;
            }
            this.d_avgPeriod = period;
            Plot2dDlg.this.setFilterType(new MovingAvg(period.getValue(SI.SECOND)));
        }
    }

    private class ShowDirDataAction
    extends BooleanAction {
        private static final long serialVersionUID = -7198301948753900448L;

        public ShowDirDataAction() {
            super(Intl.intl("Include Directional Data"), Plot2dDlg.this.d_showDoorDirData);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            Plot2dDlg.this.d_showDoorDirData = this.isSelected();
            try {
                Plot2dDlg.this.refreshData();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class AnnotateObjPathsAction
    extends BooleanAction {
        private static final long serialVersionUID = 4392472341570717399L;
        private List<List<String>> shortenedHeaders;
        private List<List<String>> shortenedTranslatedHeaders;
        private List<List<String>> originalHeaders;
        private List<List<String>> originalTranslatedHeaders;

        public AnnotateObjPathsAction() {
            super(Intl.intl("Show Group Names"), Plot2dDlg.this.d_annotateObjPaths);
            this.shortenedHeaders = new ArrayList<List<String>>();
            this.shortenedTranslatedHeaders = new ArrayList<List<String>>();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            Plot2dDlg.this.d_annotateObjPaths = this.isSelected();
            ArrayList<Integer> selected = new ArrayList<Integer>();
            this.calculateShortenedHeaders();
            if (Plot2dDlg.this.d_annotateObjPaths) {
                Plot2dDlg.this.d_rawHeaders = this.originalHeaders;
                Plot2dDlg.this.d_translatedHeaders = this.originalTranslatedHeaders;
            } else {
                Plot2dDlg.this.d_rawHeaders = this.shortenedHeaders;
                Plot2dDlg.this.d_translatedHeaders = this.shortenedTranslatedHeaders;
            }
            try {
                Plot2dDlg.this.refreshData();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < Plot2dDlg.this.d_transformedData.size(); ++i) {
                if (!Plot2dDlg.this.d_list.isSelected(i)) continue;
                selected.add(i);
            }
            Plot2dDlg.this.updateListBox();
            for (Integer i : selected) {
                Plot2dDlg.this.d_list.setSelected(i, true);
            }
        }

        private void calculateShortenedHeaders() {
            this.shortenedHeaders.clear();
            this.shortenedTranslatedHeaders.clear();
            if (!Plot2dDlg.this.d_annotateObjPaths && this.shortenedHeaders.isEmpty()) {
                for (int i = 0; i < Plot2dDlg.this.d_rawHeaders.size(); ++i) {
                    ArrayList<String> sheaders = new ArrayList<String>();
                    ArrayList<String> stheaders = new ArrayList<String>();
                    for (int j = 0; j < Plot2dDlg.this.d_rawHeaders.get(i).size(); ++j) {
                        String rawName = Plot2dDlg.this.d_rawHeaders.get(i).get(j);
                        String translatedName = Plot2dDlg.this.d_translatedHeaders.get(i).get(j);
                        int ix = rawName.lastIndexOf(Plot2dDlg.ANNOTATION_MARK);
                        String newRawName = ix == -1 ? rawName : rawName.substring(ix + Plot2dDlg.ANNOTATION_MARK.length());
                        int ix2 = translatedName.lastIndexOf(Plot2dDlg.ANNOTATION_MARK);
                        String newTranslatedName = ix2 == -1 ? translatedName : translatedName.substring(ix + Plot2dDlg.ANNOTATION_MARK.length());
                        sheaders.add(newRawName);
                        stheaders.add(newTranslatedName);
                    }
                    this.shortenedHeaders.add(sheaders);
                    this.shortenedTranslatedHeaders.add(stheaders);
                }
            }
        }

        public void reset() {
            this.shortenedHeaders.clear();
            this.shortenedTranslatedHeaders.clear();
            this.originalHeaders = Plot2dDlg.this.d_rawHeaders;
            this.originalTranslatedHeaders = Plot2dDlg.this.d_translatedHeaders;
        }
    }

    public class OpenAction
    extends AMerlinOp {
        @Override
        public void run(MerlinApp app, MerlinData md) {
            guiJFXFileChooser chooser = new guiJFXFileChooser(null, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_CSV);
            File f = chooser.showOpenDialog();
            if (f == null) {
                return;
            }
            MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
            Plot2dDlg.this.open(app, md, f);
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = -3248981735199571843L;

        public CloseAction() {
            super(Intl.intl("Close"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, 2));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Plot2dDlg.this.setVisible(false);
            Plot2dDlg.this.close();
        }
    }

    private class SelectAll
    extends AbstractAction {
        private static final long serialVersionUID = -8671097449597703831L;

        public SelectAll() {
            super(Intl.intl("Select All"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 2));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Plot2dDlg.this.d_list.setSelectedAll(false);
            Plot2dDlg.this.d_list.setSelectedAll(true);
            Plot2dDlg.this.d_list.repaint();
        }
    }

    private class ClearSelection
    extends AbstractAction {
        private static final long serialVersionUID = 8369531407147046327L;

        public ClearSelection() {
            super(Intl.intl("Clear Selection"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 3));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Plot2dDlg.this.d_list.setSelectedAll(false);
            Plot2dDlg.this.d_list.repaint();
        }
    }

    private class CopyGraphImage
    extends AbstractAction {
        private static final long serialVersionUID = -2688794358456913913L;

        public CopyGraphImage() {
            super(Intl.intl("Copy Graph Image"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Clipboard sysClip = Plot2dDlg.this.getToolkit().getSystemClipboard();
            int scale = 2;
            BufferedImage img = new BufferedImage(Plot2dDlg.this.d_graph.getWidth() * scale, Plot2dDlg.this.d_graph.getHeight() * scale, 2);
            Graphics2D g = (Graphics2D)img.getGraphics();
            g.scale(scale, scale);
            Plot2dDlg.this.d_graph.paint(g);
            try {
                sysClip.setContents(new ImageTransferrable(img), null);
            }
            catch (IllegalStateException e) {
                guiUtil.showError(Application.getApp(), Intl.intl("Clipboard Unavailable"), Intl.intl("The clipboard is unavailable."), (Throwable)e);
            }
        }
    }

    private class AutoRangeAction
    extends BooleanAction {
        private static final long serialVersionUID = -2164553495549344984L;

        public AutoRangeAction() {
            super(Intl.intl("Auto Range"), true);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            Plot2dDlg.this.d_autoRange = this.isSelected();
            if (Plot2dDlg.this.d_autoRange) {
                Plot2dDlg.this.updateAutoRange(true);
                Plot2dDlg.this.d_graph.repaint();
            }
        }
    }

    private class ShowLegendAction
    extends BooleanAction {
        private static final long serialVersionUID = 6830048070776657580L;

        public ShowLegendAction() {
            super(Intl.intl("Show Legend"), Plot2dDlg.this.d_autoRange);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            Plot2dDlg.this.d_graph.setLegendVisible(this.isSelected());
            Plot2dDlg.this.d_graph.repaint();
        }
    }

    public static class AccumulateMode
    implements IMode {
        private final Function<String, Boolean> d_isColumnVisible;

        public AccumulateMode(Function<String, Boolean> isColumnVisible) {
            this.d_isColumnVisible = isColumnVisible;
        }

        @Override
        public String getGraphTitle() {
            return Intl.intl("Total Number of Occupants to Use Selected Doors");
        }

        @Override
        public String getModeName() {
            return Intl.intl("Cumulative Occupant Counts");
        }

        @Override
        public String getAxisTitleY() {
            return Intl.intl("Cumulative Number of Occupants");
        }

        @Override
        public String getAxisTitleX() {
            return Intl.intl("Time in Seconds");
        }

        @Override
        public List<LWSeries> getTransformedData(List<List<String>> rawHeaders, List<List<String>> displayHeaders, List<double[]> rawData, int timeSeries) {
            BitSet removals = new BitSet();
            for (int i = 0; i < rawHeaders.get(0).size(); ++i) {
                String header = rawHeaders.get(0).get(i);
                if (this.d_isColumnVisible.apply(header).booleanValue()) continue;
                removals.set(i);
            }
            ArrayList<double[]> ts = new ArrayList<double[]>();
            for (int i = 0; i < displayHeaders.get(0).size(); ++i) {
                ts.add(rawData.get(timeSeries));
            }
            Function<double[], IntToDoubleFunction> dataFilter = datacol -> {
                double[] data = Arrays.copyOf(datacol, ((double[])datacol).length);
                for (int i = 1; i < data.length; ++i) {
                    data[i] = data[i] + data[i - 1];
                }
                return Plot2dDlg.toIntFunction(data);
            };
            return Plot2dDlg.toSeries(ts, displayHeaders.get(0), rawData, removals, dataFilter, false, null, true);
        }

        @Override
        public boolean supportsAveraging() {
            return false;
        }
    }

    private class ModeSelectorAction
    extends AbstractAction {
        private static final long serialVersionUID = 7462894863188459135L;
        private IMode d_mode;

        public ModeSelectorAction(String actionName, IMode mode) {
            super(actionName);
            this.d_mode = mode;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                Plot2dDlg.this.loadData(this.d_mode);
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(Plot2dDlg.this, Intl.intl("Could not change mode"), Intl.intl("Mode Error"), 0);
            }
        }
    }

    private static class Unfiltered
    implements IFilterType {
        private Unfiltered() {
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Unfiltered;
        }

        @Override
        public Pair<double[], Function<double[], IntToDoubleFunction>> getSeries(double[] rawTs) {
            double[] ts = rawTs;
            Function<double[], IntToDoubleFunction> map = rawdatacol -> i -> {
                if (i == 0) {
                    return 0.0;
                }
                double dt = ts[i] - ts[i - 1];
                return rawdatacol[i] / dt;
            };
            return new Pair<double[], Function<double[], IntToDoubleFunction>>(rawTs, map);
        }
    }

    private static class MovingAvg
    implements IFilterType {
        public final double period;

        public MovingAvg(double period) {
            this.period = period;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof MovingAvg && ((MovingAvg)obj).period == this.period;
        }

        @Override
        public Pair<double[], Function<double[], IntToDoubleFunction>> getSeries(double[] rawTs) {
            double avgPeriod = this.period;
            Function<double[], IntToDoubleFunction> map = rawDataCol -> {
                double[] sampleDataCol = new double[((double[])rawDataCol).length];
                for (int i = 0; i < ((double[])rawDataCol).length; ++i) {
                    double tAccum = 0.0;
                    double avgFlowrate = 0.0;
                    for (int i2 = i; i2 > 0; --i2) {
                        double dt = rawTs[i2] - rawTs[i2 - 1];
                        double count = rawDataCol[i2];
                        double flowrate = dt > 0.0 ? count / dt : 0.0;
                        double dtPeriod = Math.min(dt, avgPeriod - tAccum);
                        double flowratePeriod = flowrate * dtPeriod / avgPeriod;
                        avgFlowrate += flowratePeriod;
                        if (theUtil.ge(tAccum += dtPeriod, avgPeriod, 1.0E-9)) break;
                    }
                    sampleDataCol[i] = avgFlowrate;
                }
                return ix -> sampleDataCol[ix];
            };
            return new Pair<double[], Function<double[], IntToDoubleFunction>>(rawTs, map);
        }
    }
}

