/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Window;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.FloorSort;
import merlin.gui.MerlinUDF;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.units.UnitDouble;

public class NewFloorDlg
extends guiDialog {
    private static final long serialVersionUID = -867758707452381313L;
    private final MerlinUDF d_zlocFld = new MerlinUDF(0);
    private final guiCheckBox d_setActiveCB;
    private final guiCheckBox d_sortCompsCB;

    public NewFloorDlg(JFrame parent) {
        super((Window)parent, Intl.intl("New Floor"), 9);
        this.d_zlocFld.setValue(this.predictNextFloorLoc());
        this.d_setActiveCB = new guiCheckBox(Intl.intl("Set as active floor."));
        this.d_sortCompsCB = new guiCheckBox(Intl.intl("Resort existing egress components into new floor."));
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.addRow(Intl.intl("Enter Floor Location:"), this.d_zlocFld);
        gb.addRow(this.d_setActiveCB, 2);
        gb.addRow(this.d_sortCompsCB, 2);
        gb.finalizeRows();
    }

    private UnitDouble predictNextFloorLoc() {
        MerlinData md = MerlinApp.getApp().getData();
        UnitDouble defDist = md.floorSortOptions.get(FloorSort.MIN_AUTO_FLOOR_DIST);
        if (md.floors.getMembers().size() == 1) {
            Floor existing = (Floor)md.floors.getMembers().iterator().next();
            UnitDouble loc = existing.getWorkingZ();
            return loc.add(defDist);
        }
        assert (md.floors.getMembers().size() > 1);
        Floor[] floors = md.floors.getMembers().toArray(new Floor[md.floors.getMembers().size()]);
        Arrays.sort(floors, new Comparator<Floor>(this){

            @Override
            public int compare(Floor o1, Floor o2) {
                return o1.getWorkingZ().compareTo(o2.getWorkingZ());
            }
        });
        UnitDouble lastloc = floors[floors.length - 1].getWorkingZ();
        UnitDouble nextLastLoc = floors[floors.length - 2].getWorkingZ();
        UnitDouble newloc = lastloc.add(lastloc.sub(nextLastLoc));
        if (newloc.equals(lastloc)) {
            return lastloc.add(defDist);
        }
        return newloc;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        MerlinData md = MerlinApp.getApp().getData();
        UnitDouble loc = (UnitDouble)this.d_zlocFld.getValue();
        for (Floor floor : md.floors.getDeepMembers(Floor.class)) {
            if (!floor.getWorkingZ().equals(loc)) continue;
            if (showWarn) {
                String msg = String.format(Intl.intl("A floor already exists at Z=%s."), MerlinUtil.format(loc, 0));
                String title = Intl.intl("Invalid Location");
                JOptionPane.showMessageDialog(this, msg, title, 0);
            }
            return false;
        }
        return true;
    }

    public void setFloorLoc(UnitDouble loc) {
        this.d_zlocFld.setValue(loc);
    }

    public void setAutoResort(boolean autoResort) {
        this.d_sortCompsCB.setSelected(autoResort);
    }

    public boolean setActive() {
        return this.d_setActiveCB.isSelected();
    }

    public UnitDouble getFloorLoc() {
        return (UnitDouble)this.d_zlocFld.getValue();
    }

    public boolean getAutoResort() {
        return this.d_sortCompsCB.isSelected();
    }
}

