/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.Delete;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.material.Material;
import merlin.data.material.MaterialDB;
import merlin.gui.ImageBtnListener;
import merlin.gui.guiUtil;
import merlin.unitsystem.UnitSystem;
import merlin.util.Dependencies;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.scene3d.gui.materialdlg.AMaterialDialog;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;

public class MaterialDlg
extends AMaterialDialog<Material, MaterialDB> {
    private static final long serialVersionUID = 1L;

    public MaterialDlg(JFrame parent, MaterialDB texDB, Material init, boolean includeNull) {
        super(parent, Intl.intl("Materials"), MerlinApp.getApp().getData().getEvents(), Material.class, texDB, init, includeNull);
    }

    @Override
    public void actionNew(ActionEvent e) {
        if (!this.preSave()) {
            return;
        }
        final ArrayList exceptions = new ArrayList();
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                String name = JOptionPane.showInputDialog(MaterialDlg.this, (Object)Intl.intl("Enter material name:"));
                if (name == null) {
                    return;
                }
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    Undo.insertEntry_breakChain(md);
                    if (name.equals("")) {
                        name = Intl.intl("untitled");
                    }
                    MatAttrs matAttrs = MaterialDlg.newAttrs(null);
                    Material newMat = new Material(name, matAttrs);
                    ((MaterialDB)MaterialDlg.this.d_texDB).add(newMat);
                    ((MaterialDB)MaterialDlg.this.d_texDB).importToDB(newMat);
                    MaterialDlg.this.setChoice(newMat);
                }
                catch (Exception ioe) {
                    exceptions.add(ioe);
                }
            }
        };
        UIHook.run(UIHook.getComponent(e), Intl.intl("Create New Materials"), op, 2);
        if (!exceptions.isEmpty()) {
            this.showException((Exception)exceptions.get(0), Intl.intl("Error creating material."));
        }
    }

    @Override
    public void actionImport(ActionEvent e) {
        if (!this.preSave()) {
            return;
        }
        guiJFXFileChooser chooser = new guiJFXFileChooser(null, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)true, (Boolean)true, (Boolean)false, ((MaterialDB)this.d_texDB).getFileFilters());
        final List<File> texfiles = chooser.showOpenMultipleDialog();
        if (texfiles == null || texfiles.isEmpty()) {
            return;
        }
        final ArrayList newMaterials = new ArrayList(texfiles.size());
        final ArrayList exceptions = new ArrayList();
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                File newDefaultDir = null;
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    Undo.insertEntry_breakChain(md);
                    boolean selected = false;
                    for (File texFile : texfiles) {
                        IImage img = ImageManager.getImage(texFile.getAbsolutePath(), 3, 0);
                        String name = FilenameManager.splitFilename(texFile.getName())[0];
                        Texture diffTex = Texture.repeated(img, "uvset");
                        MatAttrs matAttrs = MaterialDlg.newAttrs(diffTex);
                        Material newMat = new Material(name, matAttrs);
                        ((MaterialDB)MaterialDlg.this.d_texDB).add(newMat);
                        ((MaterialDB)MaterialDlg.this.d_texDB).importToDB(newMat);
                        newMaterials.add(newMat);
                        if (selected) continue;
                        MaterialDlg.this.setChoice(newMat);
                        selected = true;
                        newDefaultDir = texFile;
                    }
                }
                catch (Exception ioe) {
                    exceptions.add(ioe);
                }
                if (newDefaultDir != null) {
                    File dir = newDefaultDir;
                    md.uiLater(() -> MaterialDlg.this.getImageBtnListener().setDefaultFile(dir));
                }
            }
        };
        UIHook.run(UIHook.getComponent(e), Intl.intl("Import Materials"), op, 2);
        if (!exceptions.isEmpty()) {
            this.showException((Exception)exceptions.get(0), Intl.intl("Error importing material."));
        }
    }

    @Override
    public void actionRemoveUnused(ActionEvent e) {
        AMerlinOp op = new AMerlinOp(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(MerlinApp app, MerlinData md) {
                ArrayList<Object> unused = new ArrayList();
                md.beginRead();
                try {
                    Set<Material> inuse = md.getMaterialsInUse();
                    Predicate<Material> filter = Filters.reject(inuse).and(mat -> md.materials.isLocal((Material)mat));
                    unused = new ArrayList<Material>(md.materials.flatten(Material.class, filter));
                }
                finally {
                    md.endRead();
                }
                if (unused.isEmpty()) {
                    JOptionPane.showMessageDialog(MaterialDlg.this, Intl.intl("All unused materials are stored in the global database and will not be deleted."), Intl.intl("Delete Warning"), 2);
                    return;
                }
                Delete.uiDelete(app, md, unused, true);
            }
        };
        UIHook.run(UIHook.getComponent(e), "MaterialDlg.RemoveUnusedAction.actionPerformed", op, 0);
    }

    @Override
    public void actionRemove(ActionEvent e) {
        if (this.d_choice == null) {
            return;
        }
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                Material toRemove = (Material)MaterialDlg.this.d_choice;
                Delete.uiDelete(app, md, Arrays.asList(toRemove), true);
            }
        };
        UIHook.run(UIHook.getComponent(e), "MaterialDlg.RemoveAction.actionPerformed", op, 0);
    }

    @Override
    protected void commitMaterial(final Material entry, final UnitDouble width, final UnitDouble height, final IMatAttrs previewAttrs, final Component source) {
        AMerlinOp op = new AMerlinOp(this){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                md.beginWrite();
                Undo.insertEntry_breakChain(md);
                try {
                    entry.setSize(width, height);
                    MatAttrs attrs = (MatAttrs)entry.getAttributes();
                    attrs = attrs.mergeWith(previewAttrs, IMatAttrs.ALL);
                    entry.setAttributes(attrs);
                    LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
                    Dependencies.getObjReferences(md, o -> o == entry, (r, e) -> referencing.add(r));
                    for (IMerlinObj ref : referencing) {
                        ref.changedEvt(new Object[0]);
                    }
                    md.materials.updateFile(entry);
                }
                catch (Exception exp) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            guiUtil.showError(source, Intl.intl("Error"), Intl.intl("Error saving material to file."), (Throwable)exp);
                        }
                    });
                }
                md.endWrite();
            }
        };
        UIHook.run(this, Intl.intl("Edit Material"), op, 2);
    }

    @Override
    protected ImageBtnListener getImageBtnListener() {
        return ImageBtnListener.INSTANCE;
    }

    @Override
    protected IUnitSrc getLengthUnit() {
        return UnitSystem.getType(0, false);
    }

    @Override
    protected IUnitSrc getPercentageUnit() {
        return UnitSystem.getType(10, false);
    }

    @Override
    protected IUnitSrc getUnitlessUnit() {
        return UnitSystem.getType(11, false);
    }
}

