/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.elevators.Elevator;
import merlin.gui.MerlinComboBox;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class ElevatorFloorComboBox
extends MerlinComboBox<Floor> {
    private Collection<Elevator> elevators;

    public ElevatorFloorComboBox(MerlinData md, Collection<Elevator> elevators) {
        super(md, Floor.class, (IMerlinObj[])new Floor[0]);
        this.setNullName(Intl.intl("Discharge Floor"));
        this.setElevators(elevators);
    }

    @Override
    protected List<Floor> getItems(MerlinData md) {
        HashSet<Floor> floors = new HashSet<Floor>();
        for (Elevator e : md.elevators.flatten(Elevator.class)) {
            floors.addAll(e.getFloorLevelMap().keySet());
        }
        ArrayList<Object> sortedFloors = new ArrayList<Object>(floors);
        Collections.sort(sortedFloors, new Comparator<Floor>(this){

            @Override
            public int compare(Floor f1, Floor f2) {
                return f1.getWorkingZ().compareTo(f2.getWorkingZ(), 1.0E-6);
            }
        });
        sortedFloors.add(0, null);
        return new ArrayList<Floor>(theUtil.filter(sortedFloors, this.getFilter()));
    }

    public void setElevators(Collection<Elevator> elevators) {
        this.elevators = elevators;
        this.setFilter(this.getFilter());
    }

    private Predicate<Floor> getFilter() {
        if (this.elevators == null || this.elevators.size() == 0) {
            return Predicates.alwaysTrue();
        }
        return new Predicate<Floor>(){

            @Override
            public boolean test(Floor floor) {
                ArrayList<Floor> floors = new ArrayList<Floor>();
                for (Elevator e : ElevatorFloorComboBox.this.elevators) {
                    floors.addAll(e.getFloorLevelMap().keySet());
                }
                return floors.contains(floor) || floor == null;
            }
        };
    }
}

